/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.action;

import com.ibm.team.enterprise.metadata.ui.query.action.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SetStreamScanningWizard;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class SetStreamScanningAction
extends Action
implements IObjectActionDelegate {
    private IWorkbenchPart part;
    private final IProjectAreaHandle projectArea;
    private List<IWorkspace> initialSelectedStreams;

    public SetStreamScanningAction() {
        this(null);
    }

    public SetStreamScanningAction(IProjectAreaHandle projectArea) {
        this.setText(Messages.SetStreamsForScanning_LABEL);
        this.projectArea = projectArea;
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.part = part;
    }

    public void run() {
        SetStreamScanningWizard wizard = new SetStreamScanningWizard();
        if (this.initialSelectedStreams != null) {
            wizard.setInitialSelectedStreams(this.initialSelectedStreams);
        }
        if (this.projectArea == null && this.initialSelectedStreams != null && this.initialSelectedStreams.size() > 0) {
            wizard.init((IProcessAreaHandle)this.initialSelectedStreams.get(0).getOwner());
        } else {
            wizard.init((IProcessAreaHandle)this.projectArea);
        }
        WizardDialog dialog = new WizardDialog(this.part.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IProcessAreaHandle processAreaHandle = null;
        this.initialSelectedStreams = new ArrayList<IWorkspace>();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            for (Object nextObj : ssel) {
                IWorkspace aStream;
                if (!(nextObj instanceof IAdaptable) || (aStream = (IWorkspace)((IAdaptable)nextObj).getAdapter(IWorkspace.class)) == null) continue;
                if (processAreaHandle == null) {
                    this.initialSelectedStreams.add(aStream);
                    processAreaHandle = (IProcessAreaHandle)aStream.getOwner();
                    continue;
                }
                if (!processAreaHandle.sameItemId((IItemHandle)aStream.getOwner())) continue;
                this.initialSelectedStreams.add(aStream);
            }
        }
        action.setEnabled(this.initialSelectedStreams != null && this.initialSelectedStreams.size() > 0);
    }
}

