/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.action;

import com.ibm.team.enterprise.metadata.client.query.IMetadataQueryClient;
import com.ibm.team.enterprise.metadata.common.query.IScdQueryDescriptor;
import com.ibm.team.enterprise.metadata.common.query.IScdQueryDescriptorHandle;
import com.ibm.team.enterprise.metadata.common.query.util.AttributeProviderFactory;
import com.ibm.team.enterprise.metadata.common.query.util.MetadataQueryValidator;
import com.ibm.team.enterprise.metadata.common.query.util.RdfXmlConverter2;
import com.ibm.team.enterprise.metadata.query.common.AttributeExpression;
import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.IMetadataQuery;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import com.ibm.team.enterprise.metadata.query.common.StreamScope;
import com.ibm.team.enterprise.metadata.query.common.Term;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.QueryResult;
import com.ibm.team.enterprise.metadata.ui.query.action.Messages;
import com.ibm.team.enterprise.metadata.ui.query.navigator.QueryNodeEE;
import com.ibm.team.enterprise.metadata.ui.query.util.SCMUtil;
import com.ibm.team.enterprise.metadata.ui.query.util.Utils;
import com.ibm.team.enterprise.metadata.ui.query.view.QueryView;
import com.ibm.team.enterprise.metadata.ui.query.view.ViewUtil;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResultFeedParser;
import com.ibm.team.enterprise.scd.internal.client.IScdClient;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IVersionablePermissionsReport;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class RunAction
extends Action {
    private IMetadataQuery query;
    private ITeamRepository teamRepository;
    private IProjectAreaHandle projectArea = null;
    private QueryNodeEE queryNode;
    private IScdQueryDescriptor queryDescriptor;
    private Shell shell;
    QueryResult results;
    int limit;

    public RunAction() {
        this.setText(Messages.RunAction_LABEL);
    }

    public void run() {
        this.results = new QueryResult();
        this.results.result = new ArrayList<SelectResult>(0);
        if (this.shell == null) {
            this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        final Job runQueryJob = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (RunAction.this.teamRepository == null && RunAction.this.queryNode != null) {
                        RunAction.this.teamRepository = (ITeamRepository)RunAction.this.queryNode.getProjectAreaHandle().getOrigin();
                    }
                    if (RunAction.this.projectArea == null && RunAction.this.queryNode != null) {
                        RunAction.this.projectArea = RunAction.this.queryNode.getProjectAreaHandle();
                    }
                    IMetadataQueryClient client = null;
                    if (RunAction.this.teamRepository != null) {
                        client = (IMetadataQueryClient)RunAction.this.teamRepository.getClientLibrary(IMetadataQueryClient.class);
                    }
                    if (RunAction.this.queryNode != null) {
                        RunAction.this.query = client.getMetadataQuery(RunAction.this.queryNode.getProjectAreaHandle(), RunAction.this.queryNode.getLabel(), monitor);
                    } else if (RunAction.this.queryDescriptor != null) {
                        RunAction.this.projectArea = RunAction.this.queryDescriptor.getProjectArea();
                        RunAction.this.query = client.getMetadataQuery(RunAction.this.queryDescriptor.getProjectArea(), RunAction.this.queryDescriptor.getName(), monitor);
                    }
                    RunAction.this.limit = client.getMaxReturnedResults();
                    this.setName(String.valueOf(Messages.RunQueryDialog_TITLE) + " - " + RunAction.this.query.getName());
                    RunAction.this.results = RunAction.this.runQuery(monitor);
                    Status status = new Status(0, "com.ibm.team.enterprise.metadata.ui", 0, null, null);
                    return status;
                }
                catch (TeamRepositoryException e) {
                    Status status = new Status(0, "com.ibm.team.enterprise.metadata.ui", -1, e.getLocalizedMessage(), null);
                    return status;
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        };
        runQueryJob.schedule();
        runQueryJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                RunAction.this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        QueryView view = ViewUtil.openQueryView();
                        if (runQueryJob.getResult().getCode() == -1) {
                            view.setColumns(null);
                            view.setInput(runQueryJob.getResult());
                            MessageDialog.openError((Shell)RunAction.this.shell, (String)Messages.RunQueryDialog_TITLE, (String)Messages.bind((String)Messages.RunQuery_ERROR, (Object)runQueryJob.getResult().getMessage()));
                        } else {
                            view.setColumns(RunAction.this.query.getStatement().getSelectClause().getColumns());
                            view.setInput((this).RunAction.this.results, (this).RunAction.this.limit);
                        }
                    }
                });
            }
        });
    }

    public void setActivePart(IWorkbenchPart part) {
        this.shell = part.getSite().getShell();
    }

    protected QueryResult runQuery(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspace stream;
        QueryResult queryResult = new QueryResult();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.worked(10);
        MetadataQueryValidator validator = new MetadataQueryValidator();
        IStatus status = validator.validate((Object)this.query);
        if (!status.isOK()) {
            throw new TeamRepositoryException(status.getMessage());
        }
        progress.worked(20);
        List<IWorkspace> streams = this.getAllStreams();
        StreamScope scope = this.query.getStatement().getStreamScope();
        IStatus streamStateStatus = scope.isAllStreams() ? this.areStreamsLocked(streams) : ((stream = SCMUtil.getStream(streams, scope.getStreamUUID())) != null ? this.isStreamLocked(stream) : Status.OK_STATUS);
        progress.worked(30);
        if (streamStateStatus.getSeverity() == 4) {
            throw new TeamRepositoryException(streamStateStatus.getMessage());
        }
        List<IComponent> components = this.getAllComponents();
        if (streams == null || streams.size() == 0 || components == null || components.size() == 0) {
            queryResult.result = new ArrayList<SelectResult>(0);
            return queryResult;
        }
        try {
            IScdClient scdClient = (IScdClient)this.teamRepository.getClientLibrary(IScdClient.class);
            SelectResultFeedParser parser = new SelectResultFeedParser();
            List<SelectResult> results = null;
            String queryXML = RdfXmlConverter2.toRdfXml((IMetadataQuery)this.query);
            results = parser.parse((InputStream)new ByteArrayInputStream(scdClient.executeScdQuery(queryXML, this.limit, monitor).getBytes("UTF-8")));
            progress.worked(30);
            results = this.removeInvalidResults(results, streams, components);
            for (SelectResult result : results) {
                result.add(new Binding("repositoryId", this.teamRepository.getId().getUuidValue()));
            }
            if (this.containStreamNameInColumn()) {
                SCMUtil.addStreamNameBinding(streams, results);
            }
            if (this.containComponentNameInColumn()) {
                SCMUtil.addComponentNameBinding(components, results);
            }
            progress.worked(20);
            queryResult.result = results;
            queryResult.totalResults = parser.getTotalResults();
            return queryResult;
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private void handleComponentConditions(Term term, List<IComponent> components) throws TeamRepositoryException {
        if (components != null && term != null) {
            List expressions = term.getExpressions();
            for (Expression expression : expressions) {
                boolean isCurrentProjectArea;
                List expreValueList;
                IAttribute attribute;
                if (!(expression instanceof AttributeExpression) || IAttribute.AttributeType.COMPONENT_TREE != (attribute = ((AttributeExpression)expression).getAttribute()).getType()) continue;
                Object expreValue = expression.getValue();
                if (!(expreValue instanceof List) || (expreValueList = (List)expreValue).size() != 2 || !(isCurrentProjectArea = Boolean.valueOf((String)expreValueList.get(1)).booleanValue())) break;
                ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>();
                for (IComponent component : components) {
                    componentHandles.add((IComponentHandle)component);
                }
                Map<String, String> compOwnerUUIDMap = SCMUtil.getComponentOwnerMap(this.teamRepository, componentHandles);
                Map<String, String> paOwnerUUIDandNameMap = SCMUtil.getComponentOwnerUUIDAndNameMap(this.projectArea);
                if (compOwnerUUIDMap == null || paOwnerUUIDandNameMap == null) break;
                List currentPaComps = attribute.getPredefinedValues();
                if (currentPaComps == null) continue;
                currentPaComps.clear();
                currentPaComps.add("false");
                currentPaComps.add("true");
                Set<String> compUUIDs = compOwnerUUIDMap.keySet();
                for (String compUUID : compUUIDs) {
                    String ownerUUID = compOwnerUUIDMap.get(compUUID);
                    if (!paOwnerUUIDandNameMap.containsKey(ownerUUID)) continue;
                    currentPaComps.add(compUUID);
                }
            }
        }
    }

    protected List<SelectResult> removeInvalidResults(List<SelectResult> results, List<IWorkspace> streams, List<IComponent> components) {
        String fileId;
        Statement queryS;
        ArrayList<SelectResult> returnedResults = new ArrayList<SelectResult>();
        HashMap<String, Map<String, SelectResult>> temp = new HashMap<String, Map<String, SelectResult>>();
        LinkedHashMap<String, SelectResult> fileIdMap = null;
        HashMap<String, HashSet<String>> componentFileMap = null;
        boolean needFilter = false;
        if (this.query != null && (queryS = this.query.getStatement()) != null && queryS.getStreamScope() != null && queryS.getStreamScope().isAllStreams()) {
            needFilter = true;
            fileIdMap = new LinkedHashMap<String, SelectResult>();
            componentFileMap = new HashMap<String, HashSet<String>>();
        }
        for (SelectResult result : results) {
            String[] idArray = this.getFileIdComponentIdStreamId(result);
            String streamId = idArray[2];
            String componentId = idArray[1];
            fileId = idArray[0];
            if (streamId != null && SCMUtil.getStream(streams, streamId) == null || componentId != null && SCMUtil.getComponent(components, componentId) == null) continue;
            SelectResult sameResult = this.getDuplicateResult(temp, result);
            if (sameResult == null) {
                if (needFilter) {
                    fileIdMap.put(String.valueOf(fileId) + ":" + streamId, result);
                    HashSet<String> files = (HashSet<String>)componentFileMap.get(componentId);
                    if (files == null) {
                        files = new HashSet<String>();
                        componentFileMap.put(componentId, files);
                    }
                    files.add(fileId);
                    continue;
                }
                returnedResults.add(result);
                continue;
            }
            this.handleComplexResult(sameResult, result);
        }
        if (needFilter) {
            Set<String> filterFiles = this.getFiles(componentFileMap);
            Set fileSet = fileIdMap.keySet();
            for (String file : fileSet) {
                SelectResult result;
                String[] files = file.split(":");
                if (files == null || files.length != 2 || filterFiles.contains(fileId = files[0]) || (result = (SelectResult)fileIdMap.get(file)) == null) continue;
                returnedResults.add(result);
            }
        }
        return returnedResults;
    }

    private Set<String> getFiles(Map<String, Set<String>> componentFileMap) {
        HashSet<String> result = null;
        if (componentFileMap == null || componentFileMap.size() == 0) {
            return result;
        }
        ArrayList<IVersionableHandle> fileHandles = new ArrayList<IVersionableHandle>();
        Set<String> components = componentFileMap.keySet();
        result = new HashSet<String>();
        for (String component : components) {
            Set<String> fileIds = componentFileMap.get(component);
            fileHandles.clear();
            for (String fileId : fileIds) {
                IVersionableHandle fileHandle = (IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)fileId), UUID.valueOf((String)fileId));
                fileHandles.add(fileHandle);
            }
            try {
                IVersionablePermissionsReport[] permissionReports = SCMPlatform.getWorkspaceManager((ITeamRepository)this.teamRepository).getPermissions(fileHandles.toArray(new IVersionableHandle[fileHandles.size()]), (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)component), null), null);
                if (permissionReports == null || permissionReports.length <= 0) continue;
                IVersionablePermissionsReport[] iVersionablePermissionsReportArray = permissionReports;
                int n = permissionReports.length;
                int n2 = 0;
                while (n2 < n) {
                    List items;
                    IVersionablePermissionsReport permissionReport = iVersionablePermissionsReportArray[n2];
                    if (permissionReport != null && permissionReport.isReportOfInaccessible() && (items = permissionReport.getItemsIds()) != null) {
                        for (UUID item : items) {
                            result.add(item.getUuidValue());
                        }
                    }
                    ++n2;
                }
            }
            catch (TeamRepositoryException e) {
                MetadataUIPlugin.getDefault().logError(e.getLocalizedMessage());
            }
        }
        return result;
    }

    private void handleComplexResult(SelectResult result1, SelectResult result2) {
        for (Binding binding2 : result2.getBindings()) {
            if (!AttributeProviderFactory.getInstance().isParentComplexAttribute(binding2.getName())) continue;
            String value2 = binding2.getValue();
            Binding binding1 = Utils.getBinding(result1.getBindings(), binding2.getName());
            if (binding1 == null || Utils.hasValue(binding1, value2)) continue;
            String value1 = binding1.getValue();
            if (value1 == null || value1.length() == 0) {
                binding1.setValue(value2);
                continue;
            }
            binding1.setValue(String.valueOf(value1) + ", " + value2);
        }
    }

    private SelectResult getDuplicateResult(Map<String, Map<String, SelectResult>> results, SelectResult aResult) {
        Binding idxB = Utils.getBinding(aResult.getBindings(), "index");
        if (idxB == null) {
            return null;
        }
        Binding streamB = Utils.getBinding(aResult.getBindings(), "streamId");
        if (streamB == null) {
            return null;
        }
        String idx = idxB.getValue();
        String stream = streamB.getValue();
        Map<String, SelectResult> m = results.get(idx);
        if (m == null) {
            m = new HashMap<String, SelectResult>();
            results.put(idx, m);
        }
        if (m.containsKey(stream)) {
            return m.get(stream);
        }
        m.put(stream, aResult);
        return null;
    }

    public void selectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof QueryNodeEE) {
                this.queryNode = (QueryNodeEE)((Object)object);
                this.queryDescriptor = (IScdQueryDescriptor)this.queryNode.getItem();
            } else if (object instanceof IMetadataQuery) {
                this.query = (IMetadataQuery)object;
            } else if (object instanceof ITeamRepository) {
                this.teamRepository = (ITeamRepository)object;
            } else if (object instanceof IProjectAreaHandle) {
                this.projectArea = (IProjectAreaHandle)object;
            } else {
                boolean cfr_ignored_0 = object instanceof String;
            }
        }
    }

    public void runWithQueryDescriptor(final IScdQueryDescriptorHandle queryDescriptorHandle, ITeamRepository repository) {
        this.teamRepository = repository;
        Job getQueryDescriptor = new Job("Get Query Descriptor"){

            protected IStatus run(IProgressMonitor monitor) {
                if (RunAction.this.teamRepository != null) {
                    try {
                        IItem itemFetched = RunAction.this.teamRepository.itemManager().fetchCompleteItem((IItemHandle)queryDescriptorHandle, 0, monitor);
                        if (itemFetched instanceof IScdQueryDescriptor) {
                            RunAction.this.queryDescriptor = (IScdQueryDescriptor)itemFetched;
                        }
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(4, "com.ibm.team.enterprise.metadata.ui", 0, Messages.ERROR_FETCHING_ISCDQUERYDESCRIPTOR, (Throwable)e);
                    }
                }
                return new Status(0, "com.ibm.team.enterprise.metadata.ui", 0, null, null);
            }
        };
        getQueryDescriptor.schedule();
        getQueryDescriptor.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                RunAction.this.run();
            }
        });
    }

    protected boolean containStreamNameInColumn() {
        return this.query.getStatement().getSelectClause().getColumnByName("streamName") != null;
    }

    protected List<IWorkspace> getAllStreams() {
        return SCMUtil.getAllStreams(this.teamRepository);
    }

    protected IStatus isStreamLocked(IWorkspace stream) {
        if (stream.getProperties().get("team.enterprise.scan.key") != null) {
            return new Status(4, "com.ibm.team.enterprise.metadata.ui", Messages.bind((String)Messages.RunQuery_STREAMS_LOCKED_ERROR, (Object)stream.getName()));
        }
        return Status.OK_STATUS;
    }

    protected IStatus areStreamsLocked(List<IWorkspace> streams) {
        int count = 0;
        StringBuffer lockedStreams = new StringBuffer();
        for (IWorkspace stream : streams) {
            IStatus status = this.isStreamLocked(stream);
            if (status.isOK()) continue;
            if (count > 0) {
                lockedStreams.append(", ");
            }
            lockedStreams.append(stream.getName());
            ++count;
        }
        if (count > 0) {
            if (count == streams.size()) {
                return new Status(4, "com.ibm.team.enterprise.metadata.ui", Messages.RunQuery_STREAMS_LOCKED_ERROR_2);
            }
            return new Status(2, "com.ibm.team.enterprise.metadata.ui", Messages.bind((String)Messages.RunQuery_STREAMS_LOCKED_WARNING, (Object)lockedStreams.toString()));
        }
        return Status.OK_STATUS;
    }

    protected boolean containComponentNameInColumn() {
        return this.query.getStatement().getSelectClause().getColumnByName("componentName") != null;
    }

    protected List<IComponent> getAllComponents() {
        return SCMUtil.getAllComponents(this.teamRepository);
    }

    private String[] getFileIdComponentIdStreamId(SelectResult selectResult) {
        String[] result = new String[3];
        for (Binding binding : selectResult.getBindings()) {
            if ("streamId".equals(binding.getName())) {
                result[2] = binding.getValue();
                continue;
            }
            if ("componentId".equals(binding.getName())) {
                result[1] = binding.getValue();
                continue;
            }
            if (!"fileItemId".equals(binding.getName())) continue;
            result[0] = binding.getValue();
        }
        return result;
    }
}

