/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.action;

import com.ibm.team.enterprise.metadata.client.collection.ClientFactory;
import com.ibm.team.enterprise.metadata.client.collection.IMetadataCollectionClient;
import com.ibm.team.enterprise.metadata.ui.query.action.Messages;
import com.ibm.team.enterprise.metadata.ui.query.job.QueryJob;
import com.ibm.team.enterprise.metadata.ui.query.wizard.StreamScanningResetWizard;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ResetMetadataAction
extends Action
implements IObjectActionDelegate {
    private IWorkbenchPart part;
    private final IProjectAreaHandle projectArea;

    public ResetMetadataAction() {
        this(null);
    }

    public ResetMetadataAction(IProjectAreaHandle projectArea) {
        this.setText(Messages.ResetMetadataAction_LABEL);
        this.projectArea = projectArea;
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.part = part;
    }

    public void run() {
        StreamScanningResetWizard wizard = new StreamScanningResetWizard();
        wizard.init(this.projectArea);
        WizardDialog dialog = new WizardDialog(this.part.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            final String[] streamIds = wizard.getStreamUUIDs();
            final int resetType = wizard.getResetType();
            QueryJob op = new QueryJob(Messages.ResetMetadataAction_RescanOperation_LABEL){

                public IStatus run(IProgressMonitor monitor) {
                    String resetId = null;
                    try {
                        IMetadataCollectionClient client = ClientFactory.getMetadataCollectionClient((ITeamRepository)((ITeamRepository)ResetMetadataAction.this.projectArea.getOrigin()));
                        resetId = client.reset2(streamIds, resetType, monitor);
                        boolean updateComplete = false;
                        while (!updateComplete) {
                            String[] results = client.getResetOrUpdateStatus(resetId, monitor);
                            if (results.length <= 0 || !results[0].equals("COMPLETE")) continue;
                            updateComplete = true;
                            if (results.length <= 1) continue;
                            this.setMessages(ResetMetadataAction.this.copyActualMessages(results));
                        }
                    }
                    catch (Exception e) {
                        this.setMessages(new String[]{e.getMessage()});
                    }
                    if (this.getMessages() != null && this.getMessages().length > 0) {
                        final StringBuffer buf = new StringBuffer();
                        String[] stringArray = this.getMessages();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String message = stringArray[n2];
                            buf.append(String.valueOf(message) + "\n");
                            ++n2;
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)ResetMetadataAction.this.part.getSite().getShell(), (String)com.ibm.team.enterprise.metadata.ui.query.wizard.Messages.StreamScanningResetWizardPageTitle, (String)NLS.bind((String)Messages.ResetMetadataAction_RescanOperation_ERROR, (Object)buf.toString()));
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            progressService.showInDialog(this.part.getSite().getShell(), (Job)op);
            op.scheduleJob();
        }
    }

    private String[] copyActualMessages(String[] messages) {
        if (messages == null || messages.length == 0 || messages.length == 1) {
            return messages;
        }
        String[] actualMessages = new String[messages.length - 1];
        int i = 1;
        while (i < messages.length) {
            actualMessages[i - 1] = messages[i];
            ++i;
        }
        return actualMessages;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

