/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.action;

import com.ibm.team.enterprise.metadata.client.query.IMetadataQueryClient;
import com.ibm.team.enterprise.metadata.common.query.util.Util;
import com.ibm.team.enterprise.metadata.ui.query.action.Messages;
import com.ibm.team.enterprise.metadata.ui.query.navigator.QueryNodeEE;
import com.ibm.team.enterprise.metadata.ui.query.view.ViewUtil;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class RenameMetadataQueryAction
extends Action {
    private IWorkbenchPart part;
    private IStructuredSelection selection;

    public RenameMetadataQueryAction() {
        this.setText(Messages.RenameMetadataQueryAction_LABEL);
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public void run() {
        if (this.selection == null || this.selection.size() != 1) {
            return;
        }
        final QueryNodeEE queryNode = (QueryNodeEE)((Object)this.selection.getFirstElement());
        RenameQueryDialog dialog = new RenameQueryDialog(this.part.getSite().getShell(), queryNode.getLabel());
        if (dialog.open() == 0) {
            final String newName = dialog.getName();
            if (newName.equals(queryNode.getLabel())) {
                MessageDialog.openError((Shell)this.part.getSite().getShell(), (String)Messages.RenameQueryDialog_TITLE, (String)Messages.RenameMetadataQueryAction_ERROR1);
                return;
            }
            try {
                new ProgressMonitorDialog(this.part.getSite().getShell()).run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            IProjectAreaHandle projectArea = queryNode.getProjectAreaHandle();
                            ITeamRepository repository = (ITeamRepository)queryNode.getProjectAreaHandle().getOrigin();
                            IMetadataQueryClient client = (IMetadataQueryClient)repository.getClientLibrary(IMetadataQueryClient.class);
                            client.renameMetadataQuery(projectArea, queryNode.getLabel(), newName, monitor);
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                return;
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.part.getSite().getShell(), (String)Messages.SourceCodeData_ERROR_TITLE, (String)NLS.bind((String)Messages.RenameMetadataQueryAction_ERROR2, (Object)queryNode.getLabel(), (Object)e.getTargetException().getMessage()));
                return;
            }
            ViewUtil.refreshTeamArtifacts();
        }
    }

    public void setActivePart(IWorkbenchPart part) {
        this.part = part;
    }

    class RenameQueryDialog
    extends SelectionStatusDialog {
        private Text text;
        private final IStatus OK_STATUS;

        public RenameQueryDialog(Shell shell, String name) {
            super(shell);
            this.OK_STATUS = new Status(0, "com.ibm.team.enterprise.metadata.ui", "");
            this.setTitle(Messages.RenameQueryDialog_TITLE);
            this.setMessage(Messages.RenameQueryDialog_MESSAGE);
            this.setName(name);
            this.setStatusLineAboveButtons(true);
        }

        protected void computeResult() {
        }

        protected Control createDialogArea(Composite parent) {
            Composite contents = (Composite)super.createDialogArea(parent);
            this.createMessageArea(contents);
            this.createInputArea(contents);
            this.validateName();
            return contents;
        }

        protected void createInputArea(Composite parent) {
            this.text = new Text(parent, 2048);
            this.text.setText(this.getName());
            GridDataFactory.fillDefaults().grab(true, false).hint(300, -1).applyTo((Control)this.text);
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RenameQueryDialog.this.setSelectionResult(new Object[]{RenameQueryDialog.this.text.getText()});
                    RenameQueryDialog.this.validateName();
                }
            });
        }

        private void setName(String name) {
            if (name != null) {
                this.setSelectionResult(new Object[]{name});
            }
        }

        public String getName() {
            return (String)this.getFirstResult();
        }

        private void validateName() {
            String result = this.getName();
            IStatus status = Util.verifyQueryName((String)result);
            if (!status.isOK()) {
                this.updateStatus(status);
            } else {
                this.updateStatus(this.OK_STATUS);
            }
        }
    }
}

