/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.action;

import com.ibm.team.enterprise.common.ui.TransportFileEditorInput;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportFile;
import com.ibm.team.enterprise.metadata.ui.query.action.Messages;
import com.ibm.team.enterprise.metadata.ui.query.util.Utils;
import com.ibm.team.enterprise.metadata.ui.query.view.ViewUtil;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;

public class OpenDependencyEditorAction
extends Action
implements IObjectActionDelegate {
    private IStructuredSelection selection;

    public OpenDependencyEditorAction() {
        super(Messages.OpenDependencyEditorAction_LABEL);
    }

    public void run() {
        if (this.selection != null && !this.selection.isEmpty()) {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            IWorkbenchPage page = win.getActivePage();
            IFile file = this.getFileFromSelection();
            try {
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("com.ibm.team.enterprise.metadata.collection.ui.collectionEditor");
                Object editorInput = null;
                editorInput = file != null ? new FileEditorInput(file) : this.createTransportFileEditorInput();
                this.openEditor((IEditorInput)editorInput, desc, page);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void openEditor(final IEditorInput editorInput, final IEditorDescriptor editorDescriptor, final IWorkbenchPage page) throws Exception {
        if (editorInput instanceof TransportFileEditorInput) {
            Job job = new Job(""){

                protected IStatus run(IProgressMonitor monitor) {
                    String errorMessage = null;
                    TransportFileEditorInput tfEditorInput = (TransportFileEditorInput)editorInput;
                    UUID fileItemUUID = UUID.valueOf((String)tfEditorInput.getFileItemId());
                    UUID componentUUID = UUID.valueOf((String)tfEditorInput.getComponentId());
                    ITeamRepository repository = tfEditorInput.getTeamRepository();
                    IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                    IVersionableHandle versionableHandle = (IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(fileItemUUID, null);
                    IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentUUID, null);
                    try {
                        wm.getPermissions(versionableHandle, componentHandle, null);
                    }
                    catch (VersionablePermissionDeniedException e) {
                        errorMessage = e.getLocalizedMessage();
                    }
                    catch (TeamRepositoryException e) {
                        errorMessage = e.getLocalizedMessage();
                    }
                    final String error = errorMessage;
                    UIJob updateUIJob = new UIJob(""){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (error != null) {
                                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.SourceCodeData_ERROR_TITLE, (String)Messages.SourceCodeData_NO_READ_PERMISSION);
                            } else {
                                try {
                                    page.openEditor(editorInput, editorDescriptor.getId(), true, 3);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    updateUIJob.schedule();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            page.openEditor(editorInput, editorDescriptor.getId(), true, 3);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart workbench) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = (IStructuredSelection)selection;
        this.setEnabled(this.selection != null && this.selection.size() == 1);
    }

    private IFile getFileFromSelection() {
        Object context;
        if (this.selection != null && !this.selection.isEmpty() && (context = this.selection.getFirstElement()) instanceof IFile) {
            return (IFile)context;
        }
        return null;
    }

    private TransportFileEditorInput createTransportFileEditorInput() throws TeamRepositoryException {
        Object context;
        if (this.selection != null && !this.selection.isEmpty() && (context = this.selection.getFirstElement()) instanceof SelectResult) {
            SelectResult selectResult = (SelectResult)context;
            String repoId = ViewUtil.getBindingValue(selectResult, "repositoryId");
            String streamId = ViewUtil.getBindingValue(selectResult, "streamId");
            String componentId = ViewUtil.getBindingValue(selectResult, "componentId");
            String fileItemId = ViewUtil.getBindingValue(selectResult, "fileItemId");
            ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            boolean foundIt = false;
            ITeamRepository repo = null;
            int i = 0;
            while (i < repos.length && !foundIt) {
                if (repoId.equals(repos[i].getId().getUuidValue())) {
                    repo = repos[i];
                    foundIt = true;
                }
                ++i;
            }
            TransportFile file = Utils.getSourceFileMetadata(repo, streamId, componentId, fileItemId, (IProgressMonitor)new NullProgressMonitor());
            return new TransportFileEditorInput(file, repo, streamId);
        }
        return null;
    }
}

