/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.action;

import com.ibm.team.enterprise.build.ui.actions.OpenRemoteFileAction;
import com.ibm.team.enterprise.metadata.ui.query.action.Messages;
import com.ibm.team.enterprise.metadata.ui.query.view.ViewUtil;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class OpenDefaultEditorAction
extends Action
implements IObjectActionDelegate {
    protected IStructuredSelection selection;

    public OpenDefaultEditorAction() {
        super(Messages.OpenDefaultEditorAction_LABEL);
    }

    public OpenDefaultEditorAction(String label) {
        super(label);
    }

    public void run() {
        if (this.selection != null && !this.selection.isEmpty()) {
            this.openFileFromSelection(true);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart workbench) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = (IStructuredSelection)selection;
        this.setEnabled(this.selection != null && this.selection.size() == 1);
    }

    protected void openFileFromSelection(boolean local) {
        if (this.selection != null && !this.selection.isEmpty()) {
            String path;
            Object context = this.selection.getFirstElement();
            IFile file = null;
            if (context instanceof IFile) {
                file = (IFile)context;
                this.openLocalFile(file);
            } else if (context instanceof SelectResult && (path = ViewUtil.getBindingValue((SelectResult)context, "filePath")) != null && path.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(path, "/", true);
                if (path.startsWith("/")) {
                    tokenizer.nextToken();
                }
                String projectName = tokenizer.nextToken();
                StringBuffer projectRelativePath = new StringBuffer();
                while (tokenizer.hasMoreTokens()) {
                    projectRelativePath.append(tokenizer.nextToken());
                }
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject project = root.getProject(projectName);
                if (project != null) {
                    file = project.getFile((IPath)new Path(projectRelativePath.toString()));
                }
                if (local) {
                    if (file != null && file.exists()) {
                        this.openLocalFile(file);
                    } else {
                        MessageDialogFactory.showMessage((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (int)4, (String)Messages.OpenDefaultEditorAction_NoLocalFile_Title, (String)NLS.bind((String)Messages.OpenDefaultEditorAction_NoLocalFile_Message, (Object)file.getName()));
                    }
                } else {
                    String repositoryId = ViewUtil.getBindingValue((SelectResult)context, "repositoryId");
                    String fileItemId = ViewUtil.getBindingValue((SelectResult)context, "fileItemId");
                    String streamId = ViewUtil.getBindingValue((SelectResult)context, "streamId");
                    String componentId = ViewUtil.getBindingValue((SelectResult)context, "componentId");
                    this.openRemoteFile(repositoryId, streamId, fileItemId, componentId, file.getFullPath().toString());
                }
            }
        }
    }

    private void openRemoteFile(String repositoryId, String streamId, String fileItemId, String componentId, String filePathString) {
        if (repositoryId == null || streamId == null || fileItemId == null || componentId == null) {
            System.out.println("OpenDefaultEditorAction.openRemoteFile repositoryId[" + repositoryId + "] streamId[" + streamId + "] componentId[" + componentId + "] fileItemId[" + fileItemId + "]");
            return;
        }
        ITeamRepository repo = null;
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        UUID repoId = UUID.valueOf((String)repositoryId);
        int i = 0;
        while (i < repos.length) {
            if (repoId.equals((Object)repos[i].getId())) {
                repo = repos[i];
            }
            ++i;
        }
        if (repo == null) {
            MessageDialogFactory.showMessage((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (int)4, (String)Messages.OpenDefaultEditorAction_NoRepositoryConnection_Title, (String)Messages.OpenDefaultEditorAction_NoRepositoryConnection_Message);
            return;
        }
        IWorkspaceHandle streamHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)streamId), null);
        try {
            IWorkspaceConnection streamConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(streamHandle, null);
            IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)componentId), null);
            IConfiguration configuration = streamConnection.configuration(componentHandle);
            IFileItemHandle fileItemHandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)fileItemId), null);
            IFileItem fileItem = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)fileItemHandle, null);
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            OpenRemoteFileAction action = new OpenRemoteFileAction(repo, UUID.valueOf((String)fileItemId), fileItem.getStateId(), win.getActivePage().getActivePart(), filePathString);
            action.run();
        }
        catch (TeamRepositoryException e) {
            MessageDialogFactory.showMessage((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (int)4, (String)Messages.OpenDefaultEditorAction_RepositoryFileError_Title, (String)NLS.bind((String)Messages.OpenDefaultEditorAction_RepositoryFileError_Message, (Object)e.getLocalizedMessage()));
        }
    }

    private void openLocalFile(IFile file) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        if (desc == null) {
            desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            IWorkbenchPage page = win.getActivePage();
            page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.getStackTrace());
        }
    }
}

