/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.action;

import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.IRemoteFileDescriptor;
import com.ibm.team.enterprise.metadata.ui.query.action.Messages;
import com.ibm.team.enterprise.metadata.ui.query.util.ImpactAnalysisUtils;
import com.ibm.team.enterprise.metadata.ui.query.util.SparseLoadUtils;
import com.ibm.team.enterprise.metadata.ui.query.util.UIUtils;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadWizard;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.ide.ui.internal.actions.load.LoadAction;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.StatusCollector;
import com.ibm.team.scm.common.IWorkspace;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

abstract class LoadActionBase
extends Action
implements IObjectActionDelegate {
    private ISelection selection;

    protected abstract boolean loadDependencies();

    public LoadActionBase(String text) {
        super(text);
    }

    public void run(IAction action) {
        this.run();
    }

    private static ITeamRepository getRepository(Object[] selection, IProgressMonitor monitor) throws FileSystemException {
        if (selection[0] instanceof SelectResult) {
            Map<String, String> bindingMap = SparseLoadUtils.parseSelectResult((SelectResult)selection[0]);
            String repoUUID = bindingMap.get("repositoryId");
            ITeamRepository repo = null;
            if (repoUUID != null) {
                repo = ImpactAnalysisUtils.lookupRepository(UUID.valueOf((String)repoUUID));
            }
            if (repo == null) {
                UIUtils.showError(com.ibm.team.enterprise.metadata.ui.query.wizard.Messages.SparseLoadWizard_Error, Messages.LoadActionBase_ErrorFindingRepo, null);
            }
            return repo;
        }
        ITeamRepository foundRepo = null;
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object sel = objectArray[n2];
            ITeamRepository thisRepo = null;
            if (sel instanceof IAdaptable) {
                IShare thisShare;
                IShareable thisShareable = ImpactAnalysisUtils.getSharable((IAdaptable)sel);
                if (thisShareable != null && (thisShare = thisShareable.getShare(monitor)) == null) {
                    UIUtils.showError(com.ibm.team.enterprise.metadata.ui.query.wizard.Messages.SparseLoadWizard_Error, NLS.bind((String)Messages.LoadActionBase_FileUnshared, (Object)thisShareable.getLocalPath().toString()), null);
                    return null;
                }
                thisRepo = ImpactAnalysisUtils.getTeamRepository(thisShareable);
            } else if (sel instanceof IRemoteFileDescriptor) {
                thisRepo = ImpactAnalysisUtils.lookupRepository(((IRemoteFileDescriptor)sel).getRepoUUID());
            }
            if (foundRepo == null) {
                foundRepo = thisRepo;
            } else if (thisRepo != null && !foundRepo.getId().equals((Object)thisRepo.getId())) {
                UIUtils.showError(com.ibm.team.enterprise.metadata.ui.query.wizard.Messages.SparseLoadWizard_Error, Messages.LoadActionBase_MultipleRepos, null);
                return null;
            }
            ++n2;
        }
        if (foundRepo == null) {
            UIUtils.showError(com.ibm.team.enterprise.metadata.ui.query.wizard.Messages.SparseLoadWizard_Error, Messages.LoadActionBase_ErrorFindingRepo, null);
        }
        return foundRepo;
    }

    public void run() {
        final Object[] selectedObjects = this.selection instanceof IStructuredSelection ? ((IStructuredSelection)this.selection).toArray() : null;
        final ITeamRepository[] repo = new ITeamRepository[1];
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        repo[0] = LoadActionBase.getRepository(selectedObjects, monitor);
                        if (repo[0] != null && !repo[0].loggedIn()) {
                            repo[0].login(monitor);
                        }
                    }
                    catch (TeamRepositoryException ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
            });
        }
        catch (InvocationTargetException ex) {
            UIUtils.showError(com.ibm.team.enterprise.metadata.ui.query.wizard.Messages.SparseLoadWizard_Error, Messages.LoadActionBase_ErrorLoggingIn, ex.getTargetException());
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (repo[0] == null || !repo[0].loggedIn()) {
            return;
        }
        final SparseLoadWizard wizard = new SparseLoadWizard(selectedObjects, this.loadDependencies(), repo[0]);
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        dialog.setBlockOnOpen(true);
        dialog.addPageChangedListener((IPageChangedListener)wizard);
        int status = dialog.open();
        if (status == 0) {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            if (wizard.isLoadOpForExtraWizard()) {
                                final OperationFailedException[] exception = new OperationFailedException[1];
                                IOperationRunner operationRunner = new IOperationRunner(){

                                    public void enqueue(String operationName, Operation toRun) {
                                        try {
                                            toRun.run(monitor, (IStatusCollector)new StatusCollector());
                                        }
                                        catch (OperationFailedException e) {
                                            exception[0] = e;
                                        }
                                    }

                                    public void dequeue(Operation toCancel) {
                                    }
                                };
                                wizard.getLoadWizardInput().doLoad(operationRunner);
                                if (exception[0] != null) {
                                    throw new InvocationTargetException(exception[0]);
                                }
                            } else {
                                ILoadOperation loadOp = wizard.getLoadOperation(monitor);
                                LoadAction.requestShowPendingView((IWorkspace)wizard.getWorkspaceToLoadFrom());
                                loadOp.run(monitor);
                                LoadActionBase.getUnshareDotProjectOp(loadOp, repo[0], monitor).run(monitor);
                            }
                        }
                        catch (TeamRepositoryException ex) {
                            throw new InvocationTargetException(ex);
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                String message = Messages.LoadActionBase_ErrorWhileLoading;
                MetadataUIPlugin.log(message, e);
                if (e.getCause() instanceof FileSystemStatusException) {
                    IStatus statusEx = ((FileSystemStatusException)e.getCause()).getStatus();
                    if (statusEx != null && statusEx.isMultiStatus()) {
                        UIUtils.showError2(com.ibm.team.enterprise.metadata.ui.query.wizard.Messages.SparseLoadWizard_Title_LoadRepositoryfiles, message, ((FileSystemStatusException)e.getCause()).getStatus());
                    } else {
                        UIUtils.showError(com.ibm.team.enterprise.metadata.ui.query.wizard.Messages.SparseLoadWizard_Title_LoadRepositoryfiles, message, e);
                    }
                }
                UIUtils.showError(com.ibm.team.enterprise.metadata.ui.query.wizard.Messages.SparseLoadWizard_Title_LoadRepositoryfiles, message, e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        this.setEnabled(this.selection != null && !this.selection.isEmpty());
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private static IUnshareOperation getUnshareDotProjectOp(ILoadOperation loadOp, final ITeamRepository repo, IProgressMonitor monitor) throws FileSystemException {
        IUnshareOperation unshareOp = IOperationFactory.instance.getUnshareOperation(null, new IRepositoryResolver(){

            public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                if (id != null ? id.equals((Object)repo.getId()) : uri != null && uri.equals(repo.getRepositoryURI())) {
                    return repo;
                }
                throw new TeamRepositoryException(Messages.LoadActionBase_ErrorFindingRepo);
            }
        });
        unshareOp.setDeleteContent(false);
        Collection loadRequests = loadOp.getLoadRequests();
        if (loadRequests != null) {
            ArrayList<IShare> dotProjectShares = new ArrayList<IShare>();
            for (ILoadRequest loadRequest : loadRequests) {
                IShare dotProjectShare;
                IRelativeLocation relLoc;
                IShareable shareable;
                if (loadRequest.getRelativeLoadPath().segmentCount() != 1 || (shareable = loadRequest.getSandbox().findShareable(loadRequest.getConnection().getContextHandle(), loadRequest.getComponent(), loadRequest.getVersionableToLoad(), monitor)) == null || (relLoc = shareable.getLocalPath()) == null || relLoc.isEmpty() || !".project".equals(relLoc.toPath().lastSegment()) || (dotProjectShare = shareable.getShare(monitor)) == null || !shareable.isShare(monitor)) continue;
                dotProjectShares.add(dotProjectShare);
            }
            unshareOp.requestUnshareShares(dotProjectShares);
        }
        return unshareOp;
    }
}

