/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.action;

import com.ibm.team.enterprise.build.ui.metadata.api.IMetadata;
import com.ibm.team.enterprise.build.ui.metadata.core.api.MetadataFactory;
import com.ibm.team.enterprise.common.ui.util.Utils;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.action.Messages;
import com.ibm.team.enterprise.metadata.ui.query.util.ImpactAnalysisUtils;
import com.ibm.team.enterprise.metadata.ui.query.util.JazzFile;
import com.ibm.team.enterprise.metadata.ui.query.util.UIUtils;
import com.ibm.team.enterprise.metadata.ui.query.wizard.ImpactAnalysisWizard;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.internal.filesystem.ui.adapters.AbstractAdaptableRemoteResource;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ImpactAnalysisAction
extends Action
implements IObjectActionDelegate {
    private Shell shell;
    private IStructuredSelection selection;
    private IWorkbenchPart part;

    public ImpactAnalysisAction() {
        super(Messages.ImpactAnalysisAction_LABEL);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.part = targetPart;
    }

    private JazzFile getJazzFile(IProgressMonitor monitor) throws TeamRepositoryException {
        Object obj = ImpactAnalysisWizard.getValidObjectFromSelection(this.selection);
        if (obj instanceof IResource) {
            return JazzFile.createJazzFile((IResource)obj, monitor);
        }
        if (obj instanceof SelectResult) {
            return JazzFile.createJazzFile((SelectResult)obj, monitor);
        }
        if (obj instanceof AbstractAdaptableRemoteResource) {
            return JazzFile.createJazzFile((AbstractAdaptableRemoteResource)obj, monitor);
        }
        return null;
    }

    public void run() {
        final Object object = ImpactAnalysisWizard.getValidObjectFromSelection(this.selection);
        if ((object instanceof IResource || object instanceof AbstractAdaptableRemoteResource) && !Utils.isShared((IAdaptable)((IAdaptable)object))) {
            MessageDialog.openError((Shell)this.part.getSite().getShell(), (String)Messages.ImpactAnalysis_ERROR_TITLE, (String)Messages.ImpactAnalysis_ERROR_FILE_NOT_SHARED);
            return;
        }
        final JazzFile[] jazzFile = new JazzFile[1];
        final ILanguageDefinition[] initialLangDef = new ILanguageDefinition[1];
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        boolean hasUUID;
                        IMetadata metadata;
                        jazzFile[0] = ImpactAnalysisAction.this.getJazzFile(monitor);
                        String langdefUUID = null;
                        if (object instanceof IResource) {
                            metadata = MetadataFactory.getInstance().getMetadata(new File(jazzFile[0].getFilePath()));
                            if (metadata != null) {
                                langdefUUID = metadata.getProperty("team.enterprise.language.definition");
                            }
                        } else if (object instanceof SelectResult) {
                            IWorkspaceConnection wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)jazzFile[0].getTeamRepository()).getWorkspaceConnection((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)jazzFile[0].getStreamId()), null), monitor);
                            IConfiguration config = wsConn.configuration((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)jazzFile[0].getComponentId()), null));
                            IVersionable versionableInStream = config.fetchCompleteItem((IVersionableHandle)((IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)jazzFile[0].getFileItemId()), null)), monitor);
                            langdefUUID = (String)versionableInStream.getUserProperties().get("team.enterprise.language.definition");
                        } else if (object instanceof IAdaptable && (metadata = MetadataFactory.getInstance().getMetadata(ImpactAnalysisUtils.getSharable((IAdaptable)object))) != null) {
                            langdefUUID = metadata.getProperty("team.enterprise.language.definition");
                        }
                        boolean bl = hasUUID = langdefUUID != null && langdefUUID.length() > 0;
                        if (hasUUID) {
                            initialLangDef[0] = (ILanguageDefinition)ClientFactory.getSystemDefinitionModelClient((ITeamRepository)jazzFile[0].getTeamRepository()).findSystemDefinitionComplete(langdefUUID, null, ILanguageDefinition.ITEM_TYPE, monitor);
                        }
                    }
                    catch (TeamRepositoryException ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException ex) {
            String message = Messages.ImpactAnalysis_General_Error;
            Throwable t = ex.getTargetException();
            if (t == null) {
                t = ex;
            }
            MetadataUIPlugin.log(message, t);
            UIUtils.showError(Messages.ImpactAnalysis_ERROR_TITLE, message, t);
        }
        if (jazzFile[0] != null) {
            if (jazzFile[0].getStreamId() == null) {
                UIUtils.showError(Messages.ImpactAnalysis_General_Error, Messages.ImpactAnalysis_ERROR_NO_STREAM, null);
            } else {
                ImpactAnalysisWizard wizard = new ImpactAnalysisWizard(jazzFile[0], initialLangDef[0]);
                wizard.init(this.part.getSite().getWorkbenchWindow().getWorkbench(), this.selection);
                WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
                dialog.create();
                dialog.open();
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = (IStructuredSelection)selection;
        this.setEnabled(this.selection != null && this.selection.size() == 1);
    }
}

