/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.action;

import com.ibm.team.enterprise.metadata.client.query.IMetadataQueryClient;
import com.ibm.team.enterprise.metadata.query.common.IMetadataQuery;
import com.ibm.team.enterprise.metadata.ui.query.action.Messages;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorInput;
import com.ibm.team.enterprise.metadata.ui.query.navigator.QueryNodeEE;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.repository.client.ITeamRepository;
import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class DuplicateMetadataQueryAction
extends Action {
    private final QueryNodeEE queryNode;
    private String newQueryName;
    private IWorkbenchPart part;

    public DuplicateMetadataQueryAction(QueryNodeEE queryNode, String newQueryName) {
        this.setText(Messages.DuplicateMetadataQueryAction_LABEL);
        this.queryNode = queryNode;
        this.newQueryName = newQueryName;
    }

    public void setActivePart(IWorkbenchPart part) {
        this.part = part;
    }

    public void run() {
        if (this.queryNode == null) {
            return;
        }
        IWorkbenchPage page = null;
        page = this.part != null ? this.part.getSite().getPage() : FoundationUIUtils.getActivePage();
        String srcName = this.queryNode.getLabel();
        if (this.newQueryName == null) {
            this.newQueryName = DuplicateMetadataQueryAction.generateNewName1(srcName);
        }
        try {
            ITeamRepository repository = (ITeamRepository)this.queryNode.getProjectAreaHandle().getOrigin();
            IMetadataQueryClient client = (IMetadataQueryClient)repository.getClientLibrary(IMetadataQueryClient.class);
            IMetadataQuery newQuery = client.duplicateMetadataQuery(this.queryNode.getProjectAreaHandle(), srcName, this.newQueryName, null);
            QueryEditorInput input = new QueryEditorInput(this.queryNode.getProjectAreaHandle(), newQuery);
            input.setIsNew(true);
            input.setIsDirty(true);
            page.openEditor((IEditorInput)input, "com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditor");
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)page.getActivePart().getSite().getShell(), (String)Messages.SourceCodeData_ERROR_TITLE, (String)NLS.bind((String)Messages.DuplicateMetadataQueryAction_ERROR, (Object)srcName, (Object)e.getMessage()));
        }
    }

    public static String generateNewName1(String originalName) {
        return MessageFormat.format(Messages.DuplicateMetadataQueryAction_COPYNAME1, originalName);
    }

    public static String generateNewName2(String originalName) {
        return MessageFormat.format(Messages.DuplicateMetadataQueryAction_COPYNAME2, originalName);
    }
}

