/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.action;

import com.ibm.team.enterprise.metadata.client.query.IMetadataQueryClient;
import com.ibm.team.enterprise.metadata.ui.query.action.Messages;
import com.ibm.team.enterprise.metadata.ui.query.navigator.QueryNodeEE;
import com.ibm.team.enterprise.metadata.ui.query.view.ViewUtil;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteMetadataQueryAction
extends Action {
    private IWorkbenchPart part;
    private IStructuredSelection selection;
    List<String> deletedNames = new ArrayList<String>();
    IProjectAreaHandle projectArea;

    public DeleteMetadataQueryAction() {
        this.setText(Messages.DeleteMetadataQueryAction_LABEL);
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public void run() {
        if (this.selection == null) {
            return;
        }
        MessageDialog dialog = new MessageDialog(this.part.getSite().getShell(), Messages.DeleteMetadataQueryAction_CONFIRM_TITLE, null, Messages.DeleteMetadataQueryAction_CONFIRM_MESSAGE, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            try {
                this.deletedNames.clear();
                this.projectArea = null;
                new ProgressMonitorDialog(this.part.getSite().getShell()).run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            Iterator iterator = DeleteMetadataQueryAction.this.selection.iterator();
                            IMetadataQueryClient client = null;
                            while (iterator.hasNext()) {
                                QueryNodeEE queryNode = (QueryNodeEE)((Object)iterator.next());
                                if (DeleteMetadataQueryAction.this.projectArea == null) {
                                    DeleteMetadataQueryAction.this.projectArea = queryNode.getProjectAreaHandle();
                                }
                                if (client == null) {
                                    ITeamRepository repository = (ITeamRepository)queryNode.getProjectAreaHandle().getOrigin();
                                    client = (IMetadataQueryClient)repository.getClientLibrary(IMetadataQueryClient.class);
                                }
                                DeleteMetadataQueryAction.this.deletedNames.add(queryNode.getLabel());
                            }
                            String[] nameArray = new String[DeleteMetadataQueryAction.this.deletedNames.size()];
                            DeleteMetadataQueryAction.this.deletedNames.toArray(nameArray);
                            if (DeleteMetadataQueryAction.this.projectArea != null && DeleteMetadataQueryAction.this.deletedNames.size() > 0) {
                                client.deleteMetadataQueries(DeleteMetadataQueryAction.this.projectArea, nameArray, monitor);
                            }
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                return;
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.part.getSite().getShell(), (String)Messages.DeleteMetadataQueryAction_MESSAGE_LABEL, (String)Messages.bind((String)Messages.DeleteMetadataQueryAction_ERROR, (Object)e.getTargetException().getLocalizedMessage()));
                return;
            }
            if (this.projectArea != null && this.deletedNames.size() > 0) {
                String[] nameArray = new String[this.deletedNames.size()];
                this.deletedNames.toArray(nameArray);
                ViewUtil.refreshTeamArtifacts();
                ViewUtil.forceCloseEditors(nameArray);
            }
        }
    }

    public void setActivePart(IWorkbenchPart part) {
        this.part = part;
    }
}

