/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.action;

import com.ibm.icu.text.Collator;
import com.ibm.team.enterprise.metadata.common.query.util.AttributeProviderFactory;
import com.ibm.team.enterprise.metadata.query.common.AttributeExpression;
import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.Term;
import com.ibm.team.enterprise.metadata.ui.query.ImagePool;
import com.ibm.team.enterprise.metadata.ui.query.action.AddConditionAction;
import com.ibm.team.enterprise.metadata.ui.query.action.Messages;
import com.ibm.team.enterprise.metadata.ui.query.dialog.AttributeContentProvider;
import com.ibm.team.enterprise.metadata.ui.query.dialog.AttributeLabelProvider;
import com.ibm.team.enterprise.metadata.ui.query.dialog.SelectAttributeDialog;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditor;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class AddConditionsAction
extends Action {
    private final Term term;
    private final Shell shell;

    public AddConditionsAction(Shell shell, Term term) {
        this.term = term;
        this.shell = shell;
        this.setImageDescriptor(ImagePool.ADD_CONDITION_ICON);
        this.setText(Messages.AddConditionsAction_LABEL);
    }

    public void run() {
        SelectAttributeDialog dialog = new SelectAttributeDialog(new AttributeLabelProvider(), new AttributeContentProvider(AddConditionsAction.getCurrentEditor()), this.shell);
        List defaultAttributes = AttributeProviderFactory.getInstance().getDefaultAttributes();
        dialog.setComparator(new ViewerComparator(){

            protected Comparator<Object> getComparator() {
                return Collator.getInstance();
            }
        });
        dialog.setInput(defaultAttributes);
        if (dialog.open() == 0) {
            List<IAttribute> attributes = dialog.getSelectedAttributes();
            for (IAttribute attribute : attributes) {
                AddConditionAction action = new AddConditionAction(this.term, (Expression)new AttributeExpression(this.term, attribute, null));
                action.run();
            }
        }
    }

    private static QueryEditor getCurrentEditor() {
        try {
            IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (part instanceof QueryEditor) {
                return (QueryEditor)part;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

