/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query;

import org.eclipse.jface.dialogs.IDialogSettings;

public class QueryUISettings {
    private static final String SHOW_CUSTOM_ATTRIBUTES = "showCustomAttributes";
    private static final String SHOW_BUILT_IN_ATTRIBUTES = "showBuiltInAttributes";
    private static final String SHOW_SCANNER_ATTRIBUTES = "showScannerAttributes";
    private final IDialogSettings dialogSettings;

    public QueryUISettings(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
    }

    public boolean isShowCustom() {
        return this.dialogSettings.getBoolean(SHOW_CUSTOM_ATTRIBUTES);
    }

    public boolean isShowBuiltInt() {
        if (!this.hasSettings(SHOW_BUILT_IN_ATTRIBUTES)) {
            return true;
        }
        return this.dialogSettings.getBoolean(SHOW_BUILT_IN_ATTRIBUTES);
    }

    public boolean isShowScanner() {
        if (!this.hasSettings(SHOW_SCANNER_ATTRIBUTES)) {
            return true;
        }
        return this.dialogSettings.getBoolean(SHOW_SCANNER_ATTRIBUTES);
    }

    public void saveShowCustom(boolean isShowCustom) {
        this.dialogSettings.put(SHOW_CUSTOM_ATTRIBUTES, isShowCustom);
    }

    public void saveShowBuiltInt(boolean isShowBuiltIn) {
        this.dialogSettings.put(SHOW_BUILT_IN_ATTRIBUTES, isShowBuiltIn);
    }

    public void saveShowScanner(boolean isShowScanner) {
        this.dialogSettings.put(SHOW_SCANNER_ATTRIBUTES, isShowScanner);
    }

    public boolean hasSettings(String id) {
        return this.dialogSettings.get(id) != null;
    }
}

