/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.utils;

import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportPropertyValue;
import com.ibm.team.enterprise.metadata.ui.collection.utils.AbstractWidgetSet;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class NumberWidgetSet
extends AbstractWidgetSet {
    private final boolean dirtyFlag = false;
    private String propertyName;
    protected Label widgetLabel;
    protected Text valueText;

    public NumberWidgetSet(FormToolkit toolkit, Composite parent, TransportProperty property, TransportProperty parentProperty) {
        super(toolkit, parent, property, parentProperty);
    }

    @Override
    protected void createWidgets() {
        this.widgetLabel = this.toolkit.createLabel(this.parentComposite, String.valueOf(this.getPropertyName()) + ":");
        GridData textData = new GridData(768);
        textData.horizontalSpan = 2;
        this.valueText = this.toolkit.createText(this.parentComposite, this.EMPTY_STRING);
        this.valueText.setLayoutData((Object)textData);
    }

    @Override
    protected void initializeWidgets() {
        Number value = this.property.getValue().getNumberValue();
        this.valueText.setText(value.toString());
    }

    @Override
    protected void validateWidgets() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void registerModifyListener(ModifyListener listener) {
        this.valueText.addModifyListener(listener);
    }

    @Override
    public void registerSelectionListener(SelectionListener listener) {
    }

    @Override
    public void registerFocusListener(FocusListener listener) {
        this.valueText.addFocusListener(listener);
        this.valueText.setData((Object)this);
    }

    @Override
    public void registerCellEditorListener(ICellEditorListener listener) {
    }

    @Override
    public String getPropertyName() {
        if (this.propertyName == null) {
            this.propertyName = this.property.getLocalName();
        }
        return this.propertyName;
    }

    @Override
    public TransportPropertyValue getPropertyValue() {
        Double numberValue = new Double(0.0);
        String valueTextString = null;
        if (!this.valueText.isDisposed() && !this.valueText.getText().equalsIgnoreCase("")) {
            valueTextString = this.valueText.getText();
        }
        try {
            if (valueTextString != null) {
                numberValue = Double.parseDouble(valueTextString);
            }
        }
        catch (NumberFormatException e) {
            numberValue = Double.valueOf("0");
        }
        return new TransportPropertyValue((Number)numberValue);
    }
}

