/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.utils;

import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportPropertyValue;
import com.ibm.team.enterprise.metadata.ui.collection.utils.AbstractWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.CollectionWidgetGenerator;
import com.ibm.team.enterprise.metadata.ui.collection.utils.IWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.MetadataCollectionComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ListWidgetSet
extends AbstractWidgetSet {
    private boolean dirtyFlag = false;
    private String listNamespace;
    private String propertyName;
    private Section listSection;
    private Composite sectionComposite;
    private List<IWidgetSet> widgetList;

    public ListWidgetSet(FormToolkit toolkit, Composite parent, TransportProperty property, TransportProperty parentProperty) {
        super(toolkit, parent, property, parentProperty);
    }

    @Override
    protected void createWidgets() {
        this.listSection = this.toolkit.createSection(this.parentComposite, 34);
        GridData sectionData = new GridData(768);
        sectionData.horizontalSpan = 3;
        this.listSection.setLayoutData((Object)sectionData);
        this.listSection.setLayout((Layout)new GridLayout());
        this.listSection.setText(this.getPropertyName());
        this.sectionComposite = this.toolkit.createComposite((Composite)this.listSection);
        this.sectionComposite.setLayoutData((Object)new GridData(768));
        this.sectionComposite.setLayout((Layout)new GridLayout(3, false));
        List propertyList = this.property.getValue().getPropertyList();
        Collections.sort(propertyList, new MetadataCollectionComparator());
        for (TransportProperty currProp : propertyList) {
            if (this.widgetList == null) {
                this.widgetList = new ArrayList<IWidgetSet>();
            }
            this.widgetList.add(CollectionWidgetGenerator.getCollectionWidgetGenerator().generateCollectionWidgets(currProp, this.sectionComposite, this.toolkit));
        }
        this.listSection.setClient((Control)this.sectionComposite);
    }

    @Override
    protected void initializeWidgets() {
    }

    @Override
    protected void validateWidgets() {
    }

    @Override
    public boolean isDirty() {
        return this.dirtyFlag;
    }

    @Override
    public void registerModifyListener(ModifyListener listener) {
        for (IWidgetSet widgetSet : this.widgetList) {
            widgetSet.registerModifyListener(listener);
        }
    }

    @Override
    public void registerSelectionListener(SelectionListener listener) {
        for (IWidgetSet widgetSet : this.widgetList) {
            widgetSet.registerSelectionListener(listener);
        }
    }

    @Override
    public void registerFocusListener(FocusListener listener) {
        for (IWidgetSet widgetSet : this.widgetList) {
            widgetSet.registerFocusListener(listener);
        }
    }

    @Override
    public void registerCellEditorListener(ICellEditorListener listener) {
    }

    @Override
    public String getPropertyName() {
        if (this.propertyName == null) {
            this.propertyName = this.property.getLocalName();
        }
        return this.propertyName;
    }

    private String getNamespace() {
        if (this.listNamespace == null) {
            return "";
        }
        return this.listNamespace;
    }

    public TransportPropertyValue getPropertyValue(String namespace) {
        if (this.listNamespace == null) {
            this.listNamespace = namespace;
        }
        return this.getPropertyValue();
    }

    @Override
    public TransportPropertyValue getPropertyValue() {
        ArrayList<TransportProperty> propertyList = new ArrayList<TransportProperty>();
        for (IWidgetSet currWidgetSet : this.widgetList) {
            TransportProperty currProperty = null;
            currProperty = currWidgetSet instanceof ListWidgetSet ? new TransportProperty(this.getNamespace(), currWidgetSet.getPropertyName(), ((ListWidgetSet)currWidgetSet).getPropertyValue(this.getNamespace())) : new TransportProperty(this.getNamespace(), currWidgetSet.getPropertyName(), currWidgetSet.getPropertyValue());
            if (currProperty == null) continue;
            propertyList.add(currProperty);
        }
        TransportPropertyValue listValue = new TransportPropertyValue(propertyList);
        return listValue;
    }
}

