/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.utils;

import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportPropertyValue;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.collection.editors.NamespaceCollectionPage;
import com.ibm.team.enterprise.metadata.ui.collection.nls.Messages;
import com.ibm.team.enterprise.metadata.ui.collection.utils.AbstractComplexWidgetSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DependencyTypeWidgetSet
extends AbstractComplexWidgetSet
implements ICellModifier {
    private boolean dirtyFlag = false;
    private String namespace = null;
    private final NamespaceCollectionPage page;
    private Composite sectionComposite;
    private Table fTable;
    private TableViewer fTableViewer;
    private ToolItem removeItem;
    private ToolItem addItem;
    private int numColumns;
    private String[] columnHeaders;
    private TableColumn[] tableColumns;
    private CellEditor[] tableCellEditors;
    private Label dependencyCountLabel;

    public DependencyTypeWidgetSet(FormToolkit toolkit, Composite parent, List<TransportProperty> propertyList) {
        this(toolkit, parent, propertyList, false);
    }

    public DependencyTypeWidgetSet(FormToolkit toolkit, Composite parent, List<TransportProperty> propertyList, boolean suppressToolbar) {
        this(toolkit, parent, propertyList, false, null);
    }

    public DependencyTypeWidgetSet(FormToolkit toolkit, Composite parent, List<TransportProperty> propertyList, boolean suppressToolbar, NamespaceCollectionPage page) {
        super(toolkit, parent, propertyList, suppressToolbar);
        if (!propertyList.isEmpty()) {
            this.namespace = propertyList.get(0).getNamespace();
            this.countRefresh();
        }
        this.page = page;
    }

    private void countRefresh() {
        if (this.fTable != null && !this.fTable.isDisposed()) {
            int count = this.fTable.getItemCount();
            if (count > 1) {
                this.dependencyCountLabel.setText(Messages.bind((String)Messages.DEPENDENCY_COUNT_MESSAGE, (Object)this.fTable.getItemCount()));
            } else if (count > 0) {
                this.dependencyCountLabel.setText(Messages.DEPENDENCY_COUNT_ONE);
            }
        }
    }

    private void setupTableConstants() {
        this.numColumns = 4;
        this.columnHeaders = new String[]{"dependencyLogicalName", "dependencyFileType", "dependencyPath", "dependencyReferenceType"};
        this.tableColumns = new TableColumn[this.numColumns];
        this.tableCellEditors = new CellEditor[this.numColumns];
    }

    @Override
    protected void createWidgets() {
        this.setupTableConstants();
        this.sectionComposite = this.toolkit.createComposite(this.parentComposite);
        GridData sectionData = new GridData(1808);
        sectionData.horizontalSpan = 3;
        this.sectionComposite.setLayoutData((Object)sectionData);
        GridLayout sectionLayout = new GridLayout(3, false);
        sectionLayout.marginLeft = 0;
        this.sectionComposite.setLayout((Layout)sectionLayout);
        this.createToolbar(this.sectionComposite, this.toolkit);
        this.createTable(this.sectionComposite, this.toolkit);
        Label spaceLabel = this.toolkit.createLabel(this.parentComposite, "");
        GridData spaceData = new GridData(768);
        spaceData.horizontalSpan = 3;
        spaceLabel.setLayoutData((Object)spaceData);
    }

    private void createToolbar(Composite parent, FormToolkit toolkit) {
        Composite headerComposite = new Composite(parent, 0);
        headerComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        headerComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label propertyLabel = new Label(headerComposite, 0);
        new Label(headerComposite, 0);
        this.dependencyCountLabel = new Label(headerComposite, 0);
        FontData fontData = propertyLabel.getFont().getFontData()[0];
        Font font = new Font((Device)Display.getDefault(), new FontData(fontData.getName(), fontData.getHeight(), 3));
        propertyLabel.setFont(font);
        propertyLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).create());
        Composite toolBarComposite = new Composite(headerComposite, 0);
        toolBarComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).create());
        toolBarComposite.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        ToolBar actionToolbar = new ToolBar(toolBarComposite, 0x800100);
        if (this.getBooleanFlag()) {
            this.addItem = new ToolItem(actionToolbar, 0x800008);
            this.addItem.setImage(MetadataUIPlugin.getImage("icons/obj16/add_obj.gif"));
            this.addItem.setToolTipText(Messages.AddNewMetadataPropertyDialog_BUTTON_OK);
            this.addItem.setEnabled(this.getBooleanFlag());
            this.addItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                }

                public void widgetSelected(SelectionEvent event) {
                    List<TransportProperty> tableProperty = DependencyTypeWidgetSet.this.getProperty();
                    ArrayList<TransportProperty> dependencyPropertyList = new ArrayList<TransportProperty>();
                    dependencyPropertyList.add(new TransportProperty(DependencyTypeWidgetSet.this.namespace, "dependencyFileType", new TransportPropertyValue("dependencyFileType")));
                    dependencyPropertyList.add(new TransportProperty(DependencyTypeWidgetSet.this.namespace, "dependencyLogicalName", new TransportPropertyValue("dependencyLogicalName")));
                    dependencyPropertyList.add(new TransportProperty(DependencyTypeWidgetSet.this.namespace, "dependencyReferenceType", new TransportPropertyValue("dependencyReferenceType")));
                    dependencyPropertyList.add(new TransportProperty(DependencyTypeWidgetSet.this.namespace, "dependencyPath", new TransportPropertyValue("dependencyPath")));
                    TransportProperty resultProperty = new TransportProperty(DependencyTypeWidgetSet.this.namespace, "dependency", new TransportPropertyValue(dependencyPropertyList));
                    tableProperty.add(resultProperty);
                    DependencyTypeWidgetSet.this.fTableViewer.refresh();
                    DependencyTypeWidgetSet.this.fTableViewer.editElement((Object)resultProperty, 0);
                }
            });
        }
        this.removeItem = new ToolItem(actionToolbar, 0x800008);
        this.removeItem.setImage(MetadataUIPlugin.getImage("icons/obj16/delete_edit.gif"));
        this.removeItem.setToolTipText(Messages.AddNewMetadataPropertyDialog_BUTTON_REMOVE);
        this.removeItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                Object selectionElement;
                ISelection tableSelection = DependencyTypeWidgetSet.this.fTableViewer.getSelection();
                if (tableSelection != null && (selectionElement = ((StructuredSelection)tableSelection).getFirstElement()) instanceof TransportProperty) {
                    TransportProperty selectedProperty = (TransportProperty)selectionElement;
                    List<TransportProperty> tableProperty = DependencyTypeWidgetSet.this.getProperty();
                    if (tableProperty.contains(selectedProperty)) {
                        tableProperty.remove(selectedProperty);
                    }
                    DependencyTypeWidgetSet.this.dirtyFlag = true;
                    DependencyTypeWidgetSet.this.fTableViewer.refresh(true);
                    DependencyTypeWidgetSet.this.countRefresh();
                    if (DependencyTypeWidgetSet.this.page != null) {
                        DependencyTypeWidgetSet.this.page.setDirty(DependencyTypeWidgetSet.this.dirtyFlag);
                    }
                }
            }
        });
    }

    private void createTable(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new GridLayout());
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 1;
        tableComposite.setLayoutData((Object)layoutData);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        this.fTable = new Table(tableComposite, 67588);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        int i = 0;
        while (i < this.numColumns) {
            this.tableColumns[i] = new TableColumn(this.fTable, 16384, i);
            this.tableColumns[i].setText(this.columnHeaders[i]);
            this.tableColumns[i].pack();
            this.tableColumns[i].addSelectionListener((SelectionListener)this.getSelectionAdapter(this.tableColumns[i], i));
            tableLayout.setColumnData((Widget)this.tableColumns[i], (ColumnLayoutData)new ColumnWeightData(100 / this.numColumns, this.tableColumns[i].getWidth()));
            ++i;
        }
        this.fTableViewer = new TableViewer(this.fTable);
        this.fTableViewer.setColumnProperties(this.columnHeaders);
        i = 0;
        while (i < this.numColumns) {
            this.tableCellEditors[i] = new TextCellEditor((Composite)this.fTable);
            ++i;
        }
        this.fTableViewer.setCellEditors(this.tableCellEditors);
        this.fTableViewer.setCellModifier((ICellModifier)this);
        this.fTableViewer.setContentProvider((IContentProvider)new DependencyTypeContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new DependencyTypeLabelProvider());
        this.fTableViewer.setComparator((ViewerComparator)new DependencyTypeComparator());
        this.fTableViewer.setInput(this.getProperty());
        this.fTableViewer.setSelection((ISelection)new StructuredSelection(this.fTableViewer.getElementAt(0)));
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DependencyTypeWidgetSet.this.removeItem != null) {
                    ISelection tableSelection = DependencyTypeWidgetSet.this.fTableViewer.getSelection();
                    if (tableSelection != null && ((StructuredSelection)tableSelection).isEmpty()) {
                        DependencyTypeWidgetSet.this.removeItem.setEnabled(false);
                    } else {
                        DependencyTypeWidgetSet.this.removeItem.setEnabled(true);
                    }
                }
            }
        });
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependencyTypeComparator comparator = (DependencyTypeComparator)DependencyTypeWidgetSet.this.fTableViewer.getComparator();
                comparator.setColumn(index);
                int sortDirection = comparator.getDirection();
                DependencyTypeWidgetSet.this.fTableViewer.getTable().setSortDirection(sortDirection);
                DependencyTypeWidgetSet.this.fTableViewer.getTable().setSortColumn(column);
                DependencyTypeWidgetSet.this.fTableViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    @Override
    protected void initializeWidgets() {
    }

    @Override
    public boolean isDirty() {
        return this.dirtyFlag;
    }

    @Override
    public void registerFocusListener(FocusListener listener) {
        this.fTable.addFocusListener(listener);
    }

    @Override
    public void registerModifyListener(ModifyListener listener) {
    }

    @Override
    public void registerCellEditorListener(ICellEditorListener listener) {
        CellEditor[] cellEditorArray = this.tableCellEditors;
        int n = this.tableCellEditors.length;
        int n2 = 0;
        while (n2 < n) {
            CellEditor e = cellEditorArray[n2];
            e.addListener(listener);
            ++n2;
        }
    }

    @Override
    public void registerSelectionListener(SelectionListener listener) {
        this.fTable.addSelectionListener(listener);
    }

    @Override
    protected void validateWidgets() {
    }

    @Override
    public List<TransportPropertyValue> getPropertyValue() {
        ArrayList<TransportPropertyValue> tableValueList = new ArrayList<TransportPropertyValue>();
        if (this.fTableViewer != null) {
            TableItem[] tableItemArray = this.fTableViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransportProperty dataProperty;
                TransportPropertyValue dataPropertyValue;
                TableItem tableItem = tableItemArray[n2];
                Object itemData = tableItem.getData();
                if (itemData instanceof TransportProperty && (dataPropertyValue = (dataProperty = (TransportProperty)itemData).getValue()).getValueType() == 3) {
                    tableValueList.add(dataPropertyValue);
                }
                ++n2;
            }
        }
        return tableValueList;
    }

    @Override
    public String getPropertyName() {
        return "dependency";
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof TransportProperty) {
            TransportProperty tableElement = (TransportProperty)element;
            TransportPropertyValue tableElementProperties = tableElement.getValue();
            List tablePropertyList = tableElementProperties.getPropertyList();
            for (TransportProperty tableProperty : tablePropertyList) {
                if (!tableProperty.getLocalName().equalsIgnoreCase(property)) continue;
                return tableProperty.getValue().getStringValue();
            }
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        TableItem tableItem;
        Object elementData;
        if (element instanceof TableItem && (elementData = (tableItem = (TableItem)element).getData()) instanceof TransportProperty) {
            TransportProperty tableElement = (TransportProperty)elementData;
            TransportPropertyValue tableElementProperties = tableElement.getValue();
            List tablePropertyList = tableElementProperties.getPropertyList();
            for (TransportProperty tableProperty : tablePropertyList) {
                if (!tableProperty.getLocalName().equalsIgnoreCase(property)) continue;
                TransportPropertyValue tablePropertyValue = tableProperty.getValue();
                tablePropertyValue.setValue((String)value);
            }
            this.dirtyFlag = true;
            this.fTableViewer.refresh(true);
        }
    }

    class DependencyTypeComparator
    extends ViewerComparator {
        private int sortColumnIndex = 0;
        private int sortDirection = 1024;

        DependencyTypeComparator() {
        }

        public int getDirection() {
            return this.sortDirection;
        }

        public void setColumn(int column) {
            if (column == this.sortColumnIndex) {
                this.sortDirection = this.sortDirection == 1024 ? 128 : 1024;
            } else {
                this.sortColumnIndex = column;
                this.sortDirection = 1024;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int returnValue = 0;
            String propertyValue1 = this.resolveTransportValue((TransportProperty)e1, this.sortColumnIndex);
            String propertyValue2 = this.resolveTransportValue((TransportProperty)e2, this.sortColumnIndex);
            if (propertyValue1 != null && propertyValue2 != null) {
                returnValue = propertyValue1.compareTo(propertyValue2);
            }
            if (this.sortDirection == 1024) {
                returnValue = -returnValue;
            }
            return returnValue;
        }

        private String resolveTransportValue(TransportProperty dependencyProperty, int column) {
            String columnKey = DependencyTypeWidgetSet.this.columnHeaders[column];
            List propertyList = dependencyProperty.getValue().getPropertyList();
            int nameIndex = 0;
            String stringValue = null;
            while (nameIndex <= propertyList.size() - 1) {
                if (((TransportProperty)propertyList.get(nameIndex)).getLocalName().equalsIgnoreCase(columnKey)) {
                    TransportProperty columnProperty = (TransportProperty)propertyList.get(nameIndex);
                    stringValue = columnProperty.getValue().getStringValue();
                    break;
                }
                ++nameIndex;
            }
            return stringValue;
        }
    }

    class DependencyTypeContentProvider
    implements IStructuredContentProvider {
        List<TransportProperty> contentList = null;

        DependencyTypeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.contentList == null) {
                return new Object[0];
            }
            return this.contentList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                this.contentList = (List)newInput;
            }
        }
    }

    class DependencyTypeLabelProvider
    implements ITableLabelProvider {
        DependencyTypeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TransportProperty) {
                TransportProperty property = (TransportProperty)element;
                TransportPropertyValue dependencyPropertyList = property.getValue();
                List dependencyProperties = dependencyPropertyList.getPropertyList();
                for (TransportProperty columnProperty : dependencyProperties) {
                    if (!columnProperty.getLocalName().equalsIgnoreCase(DependencyTypeWidgetSet.this.columnHeaders[columnIndex])) continue;
                    return columnProperty.getValue().getStringValue();
                }
            }
            return "<UNKNOWN VALUE>";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

