/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.utils;

import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportPropertyValue;
import com.ibm.team.enterprise.metadata.ui.collection.nls.Messages;
import com.ibm.team.enterprise.metadata.ui.collection.utils.AbstractComplexWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.CollectionWidgetGenerator;
import com.ibm.team.enterprise.metadata.ui.collection.utils.IAbstractWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.IWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.MetadataCollectionComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComplexListWidgetSet
extends AbstractComplexWidgetSet {
    private final boolean dirtyFlag = false;
    private String listNamespace;
    private String propertyName;
    private Composite sectionComposite;
    private CTabFolder tabFolder;
    private CTabItem[] tabItems;

    public ComplexListWidgetSet(FormToolkit toolkit, Composite parent, List<TransportProperty> propertyList) {
        super(toolkit, parent, propertyList);
    }

    @Override
    protected void createWidgets() {
        this.sectionComposite = this.toolkit.createComposite(this.parentComposite);
        GridData sectionData = new GridData(768);
        sectionData.horizontalSpan = 3;
        this.sectionComposite.setLayoutData((Object)sectionData);
        GridLayout sectionLayout = new GridLayout(3, false);
        sectionLayout.marginLeft = 0;
        this.sectionComposite.setLayout((Layout)sectionLayout);
        this.createTabFolder(this.sectionComposite, this.toolkit);
        Label spaceLabel = this.toolkit.createLabel(this.parentComposite, "");
        GridData spaceData = new GridData(768);
        spaceData.horizontalSpan = 3;
        spaceLabel.setLayoutData((Object)spaceData);
    }

    private void createTabFolder(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new GridLayout());
        this.tabFolder = new CTabFolder(parent, 128);
        GridData folderData = new GridData(768);
        folderData.widthHint = 480;
        this.tabFolder.setLayoutData((Object)folderData);
        this.tabFolder.setLayout((Layout)new GridLayout());
        this.tabFolder.setSimple(false);
        toolkit.adapt((Control)this.tabFolder, true, true);
        toolkit.paintBordersFor((Composite)this.tabFolder);
        this.createTabs(this.getProperty(), this.tabFolder, toolkit);
        this.tabFolder.setSelection(0);
        this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(22));
    }

    private void createTabs(List<TransportProperty> propertyList, CTabFolder folder, FormToolkit toolkit) {
        if (this.tabItems == null) {
            this.tabItems = new CTabItem[propertyList.size()];
        }
        int i = 0;
        while (i < propertyList.size()) {
            TransportProperty prop = propertyList.get(i);
            this.tabItems[i] = this.createTab(prop.getLocalName());
            ArrayList<IWidgetSet> widgetList = new ArrayList<IWidgetSet>();
            this.tabItems[i].setControl((Control)this.createTabWidgets(prop, (Composite)folder, toolkit, widgetList));
            this.tabItems[i].setData(widgetList);
            ++i;
        }
    }

    private CTabItem createTab(String title) {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(title);
        return item;
    }

    private Composite createTabWidgets(TransportProperty tabProperty, Composite folderParent, FormToolkit toolkit, List<IWidgetSet> widgetList) {
        Composite tabItemParent = new Composite(folderParent, 0);
        tabItemParent.setLayout((Layout)new GridLayout(3, false));
        tabItemParent.setBackground(Display.getCurrent().getSystemColor(1));
        List propertyList = tabProperty.getValue().getPropertyList();
        Collections.sort(propertyList, new MetadataCollectionComparator());
        for (TransportProperty currProp : propertyList) {
            if (widgetList == null) {
                widgetList = new ArrayList<IWidgetSet>();
            }
            widgetList.add(CollectionWidgetGenerator.getCollectionWidgetGenerator().generateCollectionWidgets(tabProperty, currProp, tabItemParent, toolkit));
        }
        return tabItemParent;
    }

    @Override
    protected void initializeWidgets() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void registerCellEditorListener(ICellEditorListener listener) {
    }

    @Override
    public void registerFocusListener(FocusListener listener) {
        if (this.tabFolder != null) {
            CTabItem[] tabItems;
            CTabItem[] cTabItemArray = tabItems = this.tabFolder.getItems();
            int n = tabItems.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem tabItem = cTabItemArray[n2];
                Object tabData = tabItem.getData();
                if (tabData instanceof List) {
                    List setList = (List)tabData;
                    for (IWidgetSet set : setList) {
                        set.registerFocusListener(listener);
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void registerModifyListener(ModifyListener listener) {
        if (this.tabFolder != null) {
            CTabItem[] tabItems;
            CTabItem[] cTabItemArray = tabItems = this.tabFolder.getItems();
            int n = tabItems.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem tabItem = cTabItemArray[n2];
                Object tabData = tabItem.getData();
                if (tabData instanceof List) {
                    List setList = (List)tabData;
                    for (IWidgetSet set : setList) {
                        set.registerModifyListener(listener);
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void registerSelectionListener(SelectionListener listener) {
        if (this.tabFolder != null) {
            CTabItem[] tabItems;
            CTabItem[] cTabItemArray = tabItems = this.tabFolder.getItems();
            int n = tabItems.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem tabItem = cTabItemArray[n2];
                Object tabData = tabItem.getData();
                if (tabData instanceof List) {
                    List setList = (List)tabData;
                    for (IWidgetSet set : setList) {
                        set.registerSelectionListener(listener);
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    protected void validateWidgets() {
    }

    @Override
    public String getPropertyName() {
        if (this.propertyName == null) {
            List<TransportProperty> propList = this.getProperty();
            this.propertyName = !propList.isEmpty() ? propList.get(0).getLocalName() : Messages.ComplexListWidgetSet_ERROR_NONAME;
        }
        return this.propertyName;
    }

    private String getNamespace() {
        if (this.listNamespace == null) {
            return "";
        }
        return this.listNamespace;
    }

    public List<TransportPropertyValue> getPropertyValue(String namespace) {
        if (this.listNamespace == null) {
            this.listNamespace = namespace;
        }
        return this.getPropertyValue();
    }

    @Override
    public List<TransportPropertyValue> getPropertyValue() {
        ArrayList<TransportPropertyValue> folderValueList = new ArrayList<TransportPropertyValue>();
        if (this.tabFolder != null) {
            CTabItem[] tabItems;
            CTabItem[] cTabItemArray = tabItems = this.tabFolder.getItems();
            int n = tabItems.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem tabItem = cTabItemArray[n2];
                Object tabData = tabItem.getData();
                if (tabData instanceof List) {
                    List setList = (List)tabData;
                    folderValueList.add(this.internalGetPropertyValue(setList));
                }
                ++n2;
            }
        }
        return folderValueList;
    }

    private TransportPropertyValue internalGetPropertyValue(List<IWidgetSet> tabSet) {
        ArrayList<TransportProperty> propertyList = new ArrayList<TransportProperty>();
        for (IAbstractWidgetSet iAbstractWidgetSet : tabSet) {
            TransportProperty currProperty = null;
            if (iAbstractWidgetSet instanceof ComplexListWidgetSet) {
                List<TransportPropertyValue> nestedList = ((ComplexListWidgetSet)iAbstractWidgetSet).getPropertyValue(this.getNamespace());
                for (TransportPropertyValue nestedValue : nestedList) {
                    currProperty = new TransportProperty(this.getNamespace(), iAbstractWidgetSet.getPropertyName(), nestedValue);
                    if (currProperty == null) continue;
                    propertyList.add(currProperty);
                }
                continue;
            }
            if (!(iAbstractWidgetSet instanceof IWidgetSet) || (currProperty = new TransportProperty(this.getNamespace(), iAbstractWidgetSet.getPropertyName(), ((IWidgetSet)iAbstractWidgetSet).getPropertyValue())) == null) continue;
            propertyList.add(currProperty);
        }
        TransportPropertyValue transportPropertyValue = new TransportPropertyValue(propertyList);
        return transportPropertyValue;
    }
}

