/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.utils;

import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportPropertyValue;
import com.ibm.team.enterprise.metadata.ui.collection.editors.NamespaceCollectionPage;
import com.ibm.team.enterprise.metadata.ui.collection.utils.AbstractComplexWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.AbstractWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.BooleanWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.ComplexListWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.DependencyTypeWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.ListWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.NumberWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.StringWidgetSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CollectionWidgetGenerator {
    private static CollectionWidgetGenerator generator;

    private CollectionWidgetGenerator() {
    }

    public static CollectionWidgetGenerator getCollectionWidgetGenerator() {
        if (generator == null) {
            generator = new CollectionWidgetGenerator();
        }
        return generator;
    }

    public AbstractWidgetSet generateCollectionWidgets(TransportProperty property, Composite parent, FormToolkit toolkit) {
        return this.generateCollectionWidgets(null, property, parent, toolkit);
    }

    public AbstractWidgetSet generateCollectionWidgets(TransportProperty parentProperty, TransportProperty property, Composite parent, FormToolkit toolkit) {
        TransportPropertyValue value = property.getValue();
        switch (value.getValueType()) {
            case 1: {
                return new BooleanWidgetSet(toolkit, parent, property, parentProperty);
            }
            case 2: {
                return new NumberWidgetSet(toolkit, parent, property, parentProperty);
            }
            case 0: {
                return new StringWidgetSet(toolkit, parent, property, parentProperty);
            }
            case 3: {
                return new ListWidgetSet(toolkit, parent, property, parentProperty);
            }
        }
        return null;
    }

    public AbstractComplexWidgetSet generateNestedCollectionWidgets(List<TransportProperty> originalPropertyList, Composite parent, FormToolkit toolkit, boolean showToolbar) {
        return this.generateNestedCollectionWidgets(originalPropertyList, parent, toolkit, showToolbar, null);
    }

    public AbstractComplexWidgetSet generateNestedCollectionWidgets(List<TransportProperty> originalPropertyList, Composite parent, FormToolkit toolkit, boolean showToolbar, NamespaceCollectionPage page) {
        boolean isDependency = false;
        for (TransportProperty property : originalPropertyList) {
            if (!property.getLocalName().equalsIgnoreCase("dependency")) continue;
            isDependency = true;
            break;
        }
        if (isDependency) {
            return new DependencyTypeWidgetSet(toolkit, parent, originalPropertyList, showToolbar, page);
        }
        return new ComplexListWidgetSet(toolkit, parent, originalPropertyList);
    }

    public Map<String, List<TransportProperty>> parseComplexProperties(List<TransportProperty> originalPropertyList, Map<String, List<TransportProperty>> complexPropertyMap) {
        Object[] originalPropertyArray = originalPropertyList.toArray();
        if (complexPropertyMap == null) {
            complexPropertyMap = new HashMap<String, List<TransportProperty>>();
        }
        int i = originalPropertyArray.length - 1;
        while (i >= 0) {
            TransportProperty currProperty;
            if (originalPropertyArray[i] instanceof TransportProperty && (currProperty = (TransportProperty)originalPropertyArray[i]).getValue().getValueType() == 3) {
                String complexPropertyName = currProperty.getLocalName();
                List<Object> complexPropertyList = null;
                if (complexPropertyMap.containsKey(complexPropertyName)) {
                    complexPropertyList = complexPropertyMap.get(complexPropertyName);
                } else {
                    complexPropertyList = new ArrayList();
                    complexPropertyMap.put(complexPropertyName, complexPropertyList);
                }
                complexPropertyList.add(currProperty);
                originalPropertyList.remove(currProperty);
            }
            --i;
        }
        return complexPropertyMap;
    }

    public List<TransportProperty> parseUserProperties(List<TransportProperty> originalPropertyList) {
        ArrayList<TransportProperty> userPropertyList = new ArrayList<TransportProperty>();
        Object[] originalPropertyArray = originalPropertyList.toArray();
        int i = originalPropertyArray.length - 1;
        while (i >= 0) {
            TransportProperty currProperty = (TransportProperty)originalPropertyArray[i];
            if (currProperty.isUserAdded()) {
                userPropertyList.add(currProperty);
                originalPropertyList.remove(currProperty);
            }
            --i;
        }
        return userPropertyList;
    }
}

