/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.utils;

import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportPropertyValue;
import com.ibm.team.enterprise.metadata.ui.collection.utils.AbstractWidgetSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BooleanWidgetSet
extends AbstractWidgetSet {
    private boolean dirtyFlag = false;
    private String propertyName;
    private Composite buttonComposite;
    private Button trueButton;
    private Button falseButton;

    public BooleanWidgetSet(FormToolkit toolkit, Composite parent, TransportProperty property, TransportProperty parentProperty) {
        super(toolkit, parent, property, parentProperty);
    }

    @Override
    protected void createWidgets() {
        this.toolkit.createLabel(this.parentComposite, String.valueOf(this.getPropertyName()) + ":");
        this.buttonComposite = this.toolkit.createComposite(this.parentComposite);
        GridDataFactory.swtDefaults().grab(true, false).span(2, 0).applyTo((Control)this.buttonComposite);
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).applyTo(this.buttonComposite);
        this.trueButton = this.toolkit.createButton(this.buttonComposite, Boolean.toString(true), 16);
        this.falseButton = this.toolkit.createButton(this.buttonComposite, Boolean.toString(false), 16);
    }

    @Override
    protected void initializeWidgets() {
        Boolean value = this.property.getValue().getBooleanValue();
        this.trueButton.setSelection(value.booleanValue());
        this.falseButton.setSelection(value == false);
    }

    @Override
    protected void validateWidgets() {
    }

    @Override
    public boolean isDirty() {
        return this.dirtyFlag;
    }

    @Override
    public void registerCellEditorListener(ICellEditorListener listener) {
    }

    @Override
    public void registerModifyListener(ModifyListener listener) {
    }

    @Override
    public void registerSelectionListener(SelectionListener listener) {
        this.trueButton.addSelectionListener(listener);
        this.falseButton.addSelectionListener(listener);
    }

    @Override
    public void registerFocusListener(FocusListener listener) {
        this.trueButton.addFocusListener(listener);
        this.falseButton.addFocusListener(listener);
        this.trueButton.setData((Object)this);
        this.falseButton.setData((Object)this);
    }

    @Override
    public String getPropertyName() {
        if (this.propertyName == null) {
            this.propertyName = this.property.getLocalName();
        }
        return this.propertyName;
    }

    @Override
    public TransportPropertyValue getPropertyValue() {
        Boolean booleanValue = false;
        if (!this.trueButton.isDisposed() && !this.falseButton.isDisposed() && this.trueButton.getSelection()) {
            booleanValue = true;
        }
        return new TransportPropertyValue(booleanValue);
    }
}

