/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.editors;

import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.collection.editors.MetadataCollectionEditor;
import com.ibm.team.enterprise.metadata.ui.collection.nls.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class RefreshEditorAction
extends Action {
    private final MetadataCollectionEditor fEditor;
    private final Shell fEditorShell;

    public RefreshEditorAction(MetadataCollectionEditor editor, Shell editorShell) {
        super(Messages.RefreshEditorAction_TITLE);
        this.fEditor = editor;
        this.fEditorShell = editorShell;
        this.setImageDescriptor(MetadataUIPlugin.getImageDescriptor("icons/gen/refresh.gif"));
    }

    protected void updateEnabledState() {
        if (this.fEditor.isBusy()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        if (this.fEditor.isDirty() && !this.confirmRefresh()) {
            return;
        }
        this.fEditor.refreshMetadataCollection();
    }

    protected boolean confirmRefresh() {
        String message = Messages.RefreshEditorAction_CONFIRM_DESCRIPTION;
        return MessageDialog.openConfirm((Shell)this.fEditorShell, (String)Messages.RefreshEditorAction_CONFIRM_TITLE, (String)message);
    }
}

