/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.editors;

import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.collection.editors.MetadataCollectionEditor;
import com.ibm.team.enterprise.metadata.ui.collection.nls.Messages;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;

public class NewNamespaceAction
extends Action {
    private final MetadataCollectionEditor fEditor;
    private final Shell fEditorShell;

    public NewNamespaceAction(MetadataCollectionEditor editor, Shell editorShell) {
        super(Messages.NewNamespaceAction_TITLE);
        this.fEditor = editor;
        this.fEditorShell = editorShell;
        this.setImageDescriptor(MetadataUIPlugin.getImageDescriptor("icons/elcl16/newnamespace.gif"));
        this.setToolTipText(Messages.NewNamespaceAction_TITLE);
    }

    protected void updateEnabledState() {
        if (this.fEditor.isBusy()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        InputDialog dialog = this.createInputDialog();
        if (dialog.open() != 0) {
            return;
        }
        String dialogValue = dialog.getValue();
        this.fEditor.createNewNamespace(dialogValue);
    }

    private InputDialog createInputDialog() {
        String title = Messages.NewNamespaceAction_DIALOG_TITLE;
        String message = Messages.NewNamespaceAction_DIALOG_MESSAGE;
        InputDialog input = new InputDialog(this.fEditorShell, title, message, "", new IInputValidator(){

            public String isValid(String stringToValidate) {
                Set<String> existingNamespaces;
                Map<String, List<TransportProperty>> metadataMap = NewNamespaceAction.this.fEditor.getSortedMetadata();
                if (metadataMap != null && (existingNamespaces = metadataMap.keySet()).contains(stringToValidate)) {
                    return Messages.NewNamespaceAction_ERROR_NAMESPACEEXISTS;
                }
                if (stringToValidate.length() > 0 && stringToValidate.charAt(stringToValidate.length() - 1) != '/') {
                    return Messages.MetadataCollectionEditor_ERROR_NAMESPACE_SLASH;
                }
                try {
                    URI validateURI = new URI(stringToValidate);
                    if (!validateURI.isAbsolute()) {
                        return Messages.MetadataCollectionEditor_ERROR_NAMESPACE_ABSOLUTE;
                    }
                }
                catch (URISyntaxException e) {
                    return e.getReason();
                }
                return null;
            }
        });
        return input;
    }
}

