/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.editors;

import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportPropertyValue;
import com.ibm.team.enterprise.metadata.ui.collection.editors.AddNewMetadataPropertyDialog;
import com.ibm.team.enterprise.metadata.ui.collection.editors.CommonCollectionPage;
import com.ibm.team.enterprise.metadata.ui.collection.editors.MetadataCollectionEditor;
import com.ibm.team.enterprise.metadata.ui.collection.nls.Messages;
import com.ibm.team.enterprise.metadata.ui.collection.utils.AbstractCommonWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.AbstractComplexWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.AbstractWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.CollectionWidgetGenerator;
import com.ibm.team.enterprise.metadata.ui.collection.utils.ComplexListWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.DependencyTypeWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.IAbstractWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.IComplexWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.IWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.ListWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.MetadataCollectionComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NamespaceCollectionPage
extends CommonCollectionPage
implements SelectionListener,
ModifyListener,
FocusListener,
ICellEditorListener {
    private boolean isDirty;
    private final MetadataCollectionEditor editor;
    private final String namespacePrefix;
    private String namespaceText;
    private Section dependencySection;
    private Composite sectionComposite;
    private Composite dependencyComposite;
    private Composite controlComposite;
    private Section userPropertySection;
    private Composite userPropertyComposite;
    private Button addPropertyButton;
    private Button removePropertyButton;
    private final Map<String, List<TransportProperty>> complexScannerPropertyMap;
    private final Map<String, List<TransportProperty>> complexUserPropertyMap;
    private final List<TransportProperty> scannerProperties;
    private List<TransportProperty> userProperties;
    private List<IAbstractWidgetSet> widgetList;
    private Object currentSelection = null;

    public NamespaceCollectionPage(FormEditor editor, String nsPrefix, String namespace, List<TransportProperty> namespaceProperties, List<TransportProperty> defaultProperties) {
        super(editor, "com.ibm.teamz.metadata.collection." + nsPrefix, nsPrefix, defaultProperties);
        this.editor = (MetadataCollectionEditor)editor;
        this.scannerProperties = namespaceProperties;
        this.namespaceText = namespace;
        this.namespacePrefix = nsPrefix;
        this.complexScannerPropertyMap = new HashMap<String, List<TransportProperty>>();
        this.complexUserPropertyMap = new HashMap<String, List<TransportProperty>>();
    }

    @Override
    protected void createCollectionWidgets(Composite parent, FormToolkit toolkit) {
        this.dependencySection = toolkit.createSection(parent, 450);
        GridData sectionData = new GridData(1808);
        sectionData.horizontalSpan = 4;
        this.dependencySection.setLayoutData((Object)sectionData);
        this.dependencySection.setLayout((Layout)new GridLayout());
        if (this.namespaceText.equalsIgnoreCase("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/")) {
            this.dependencySection.setText(Messages.NamespaceCollectionPage_SECTION_DEPENDENCY);
        } else {
            this.dependencySection.setText(Messages.NamespaceCollectionPage_SECTION_GENERAL);
        }
        this.dependencySection.setDescription(Messages.NamespaceCollectionPage_SECTION_GENERAL_DESCRIPTION);
        this.dependencyComposite = toolkit.createComposite((Composite)this.dependencySection);
        this.dependencyComposite.setLayoutData((Object)new GridData(768));
        this.dependencyComposite.setLayout((Layout)new GridLayout(3, false));
        if (this.userProperties == null || this.userProperties.isEmpty()) {
            this.userProperties = CollectionWidgetGenerator.getCollectionWidgetGenerator().parseUserProperties(this.scannerProperties);
        }
        this.userPropertySection = toolkit.createSection(parent, 450);
        sectionData = new GridData(768);
        sectionData.horizontalSpan = 4;
        this.userPropertySection.setLayoutData((Object)sectionData);
        this.userPropertySection.setLayout((Layout)new GridLayout());
        this.userPropertySection.setText(Messages.NamespaceCollectionPage_SECTION_USER);
        this.userPropertySection.setDescription(Messages.NamespaceCollectionPage_SECTION_USER_DESCRIPTION);
        this.sectionComposite = toolkit.createComposite((Composite)this.userPropertySection);
        this.sectionComposite.setLayoutData((Object)new GridData(1808));
        this.sectionComposite.setLayout((Layout)new GridLayout(2, false));
        this.userPropertyComposite = toolkit.createComposite(this.sectionComposite);
        this.userPropertyComposite.setLayoutData((Object)new GridData(768));
        this.userPropertyComposite.setLayout((Layout)new GridLayout(3, false));
        this.controlComposite = toolkit.createComposite(this.sectionComposite);
        this.controlComposite.setLayoutData((Object)new GridData(1040));
        this.controlComposite.setLayout((Layout)new GridLayout(1, false));
        if (this.widgetList == null) {
            this.widgetList = new ArrayList<IAbstractWidgetSet>();
        } else if (!this.widgetList.isEmpty()) {
            this.widgetList.clear();
        }
        this.createControlWidgets(this.controlComposite, toolkit);
        this.createPropertyWidgets(this.userPropertyComposite, this.userProperties, this.complexUserPropertyMap, toolkit);
        Collections.sort(this.scannerProperties, new MetadataCollectionComparator());
        this.createPropertyWidgets(this.dependencyComposite, this.scannerProperties, this.complexScannerPropertyMap, toolkit, false);
        this.userPropertySection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                NamespaceCollectionPage.this.fManagedForm.reflow(true);
            }
        });
        this.dependencySection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                NamespaceCollectionPage.this.fManagedForm.reflow(true);
            }
        });
        this.userPropertySection.setClient((Control)this.sectionComposite);
        this.dependencySection.setClient((Control)this.dependencyComposite);
    }

    private void createPropertyWidgets(Composite targetComposite, List<TransportProperty> widgetProperties, Map<String, List<TransportProperty>> complexPropertyMap, FormToolkit toolkit) {
        this.createPropertyWidgets(targetComposite, widgetProperties, complexPropertyMap, toolkit, true);
    }

    private void createPropertyWidgets(Composite targetComposite, List<TransportProperty> widgetProperties, Map<String, List<TransportProperty>> complexPropertyMap, FormToolkit toolkit, boolean showToolbar) {
        AbstractCommonWidgetSet widgetSet;
        if (complexPropertyMap == null || complexPropertyMap.isEmpty()) {
            CollectionWidgetGenerator.getCollectionWidgetGenerator().parseComplexProperties(widgetProperties, complexPropertyMap);
        }
        Set<String> complexPropertySet = complexPropertyMap.keySet();
        for (String currentSet : complexPropertySet) {
            List<TransportProperty> currentComplexPropertyList = complexPropertyMap.get(currentSet);
            widgetSet = CollectionWidgetGenerator.getCollectionWidgetGenerator().generateNestedCollectionWidgets(currentComplexPropertyList, targetComposite, toolkit, showToolbar, this);
            widgetSet.registerCellEditorListener(this);
            widgetSet.registerModifyListener(this);
            widgetSet.registerSelectionListener(this);
            widgetSet.registerFocusListener(this);
            this.widgetList.add(widgetSet);
        }
        for (TransportProperty prop : widgetProperties) {
            if (this.widgetList == null) {
                this.widgetList = new ArrayList<IAbstractWidgetSet>();
            }
            widgetSet = CollectionWidgetGenerator.getCollectionWidgetGenerator().generateCollectionWidgets(prop, targetComposite, toolkit);
            widgetSet.registerModifyListener(this);
            widgetSet.registerSelectionListener(this);
            widgetSet.registerFocusListener(this);
            this.widgetList.add(widgetSet);
        }
    }

    @Override
    protected void createControlWidgets(Composite controlParent, FormToolkit toolkit) {
        this.addPropertyButton = toolkit.createButton(controlParent, Messages.NamespaceCollectionPage_BUTTON_ADD, 8);
        this.addPropertyButton.setLayoutData((Object)new GridData(768));
        this.removePropertyButton = toolkit.createButton(controlParent, Messages.NamespaceCollectionPage_BUTTON_REMOVE, 8);
        this.removePropertyButton.setLayoutData((Object)new GridData(768));
        this.removePropertyButton.setEnabled(false);
        this.addPropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                TransportProperty keyValueProperty;
                String keyValuePropertyName;
                List keyValue;
                ArrayList<String> existingPropertyNames = new ArrayList<String>();
                ArrayList<TransportProperty> existingProperties = new ArrayList<TransportProperty>();
                for (TransportProperty sProperty : NamespaceCollectionPage.this.scannerProperties) {
                    String sPropertyName = sProperty.getLocalName();
                    if (existingPropertyNames.contains(sPropertyName)) continue;
                    existingPropertyNames.add(sPropertyName);
                    existingProperties.add(sProperty);
                }
                for (String complexPropKey : NamespaceCollectionPage.this.complexScannerPropertyMap.keySet()) {
                    keyValue = (List)NamespaceCollectionPage.this.complexScannerPropertyMap.get(complexPropKey);
                    if (keyValue.isEmpty() || existingPropertyNames.contains(keyValuePropertyName = (keyValueProperty = (TransportProperty)keyValue.get(0)).getLocalName())) continue;
                    existingPropertyNames.add(keyValuePropertyName);
                    existingProperties.add(keyValueProperty);
                }
                for (TransportProperty uProperty : NamespaceCollectionPage.this.userProperties) {
                    String uPropertyName = uProperty.getLocalName();
                    if (existingPropertyNames.contains(uPropertyName)) continue;
                    existingPropertyNames.add(uPropertyName);
                    existingProperties.add(uProperty);
                }
                for (String complexPropKey : NamespaceCollectionPage.this.complexUserPropertyMap.keySet()) {
                    keyValue = (List)NamespaceCollectionPage.this.complexUserPropertyMap.get(complexPropKey);
                    if (keyValue.isEmpty() || existingPropertyNames.contains(keyValuePropertyName = (keyValueProperty = (TransportProperty)keyValue.get(0)).getLocalName())) continue;
                    existingPropertyNames.add(keyValuePropertyName);
                    existingProperties.add(keyValueProperty);
                }
                AddNewMetadataPropertyDialog dialog = new AddNewMetadataPropertyDialog(NamespaceCollectionPage.this.getSite().getShell(), existingProperties, NamespaceCollectionPage.this.namespaceText);
                if (dialog.open() == 0) {
                    TransportProperty resultProperty = dialog.getResultProperty();
                    if (resultProperty.getValue().getValueType() == 3) {
                        ArrayList<TransportProperty> singletonList = new ArrayList<TransportProperty>();
                        singletonList.add(resultProperty);
                        String newPropertyName = resultProperty.getLocalName();
                        List existingNewProperty = (List)NamespaceCollectionPage.this.complexUserPropertyMap.get(newPropertyName);
                        if (existingNewProperty == null) {
                            NamespaceCollectionPage.this.complexUserPropertyMap.put(newPropertyName, singletonList);
                        } else {
                            existingNewProperty.addAll(singletonList);
                        }
                    } else {
                        NamespaceCollectionPage.this.userProperties.add(resultProperty);
                    }
                    NamespaceCollectionPage.this.refresh();
                    NamespaceCollectionPage.this.setDirty(true);
                }
            }
        });
        this.removePropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String targetName = null;
                if (NamespaceCollectionPage.this.currentSelection != null && NamespaceCollectionPage.this.currentSelection instanceof Widget) {
                    boolean doRemove;
                    Object objectData = ((Widget)NamespaceCollectionPage.this.currentSelection).getData();
                    if (objectData instanceof IWidgetSet) {
                        targetName = ((IWidgetSet)objectData).getPropertyName();
                    }
                    TransportProperty parentProperty = null;
                    if (objectData instanceof AbstractWidgetSet && (parentProperty = ((AbstractWidgetSet)objectData).getParentProperty()) != null) {
                        targetName = parentProperty.getLocalName();
                    }
                    if ((doRemove = MessageDialog.openConfirm((Shell)NamespaceCollectionPage.this.getSite().getShell(), (String)Messages.NamespaceCollectionPage_DIALOG_TITLE, (String)NLS.bind((String)(parentProperty == null ? Messages.NamespaceCollectionPage_DIALOG_MESSAGE : Messages.NamespaceCollectionPage_DIALOG_MESSAGE_COMPLEX), (Object)(targetName == null ? "" : "\"" + targetName + "\" ")))) && objectData instanceof AbstractWidgetSet) {
                        TransportProperty targetProperty;
                        TransportProperty transportProperty = targetProperty = parentProperty == null ? ((AbstractWidgetSet)objectData).getProperty() : parentProperty;
                        if (parentProperty == null) {
                            if (NamespaceCollectionPage.this.scannerProperties.remove(targetProperty)) {
                                NamespaceCollectionPage.this.refresh();
                                NamespaceCollectionPage.this.setDirty(true);
                            } else if (NamespaceCollectionPage.this.userProperties.remove(targetProperty)) {
                                NamespaceCollectionPage.this.refresh();
                                NamespaceCollectionPage.this.setDirty(true);
                            }
                        } else {
                            List targetList = null;
                            String parentPropertyName = parentProperty.getLocalName();
                            targetList = (List)NamespaceCollectionPage.this.complexScannerPropertyMap.get(parentPropertyName);
                            if (targetList != null && targetList.remove(targetProperty)) {
                                NamespaceCollectionPage.this.refresh();
                                NamespaceCollectionPage.this.setDirty(true);
                            } else {
                                targetList = (List)NamespaceCollectionPage.this.complexUserPropertyMap.get(parentPropertyName);
                                if (targetList != null && targetList.remove(targetProperty)) {
                                    NamespaceCollectionPage.this.refresh();
                                    NamespaceCollectionPage.this.setDirty(true);
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    public boolean isDirty() {
        return !this.isDirty ? super.isDirty() : this.isDirty;
    }

    public void setDirty(boolean state) {
        this.isDirty = state;
        this.editor.fireDirtyPropertyChangeEvent();
    }

    @Override
    public void doSave(String newNamespace, IProgressMonitor monitor) {
        if (newNamespace != null && !this.namespaceText.equalsIgnoreCase(newNamespace)) {
            this.namespaceText = newNamespace;
        }
        this.doSave(monitor);
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        ArrayList<TransportProperty> saveProperties = new ArrayList<TransportProperty>();
        if (this.widgetList != null) {
            for (IAbstractWidgetSet currWidget : this.widgetList) {
                TransportProperty currProperty = null;
                if (currWidget instanceof IWidgetSet) {
                    currProperty = currWidget instanceof ListWidgetSet ? new TransportProperty(this.namespaceText, currWidget.getPropertyName(), ((ListWidgetSet)currWidget).getPropertyValue(this.namespaceText), currWidget.isUserAdded()) : new TransportProperty(this.namespaceText, currWidget.getPropertyName(), ((IWidgetSet)currWidget).getPropertyValue(), currWidget.isUserAdded());
                    if (currProperty == null) continue;
                    saveProperties.add(currProperty);
                    continue;
                }
                if (!(currWidget instanceof IComplexWidgetSet) || !(currWidget instanceof ComplexListWidgetSet) && !(currWidget instanceof DependencyTypeWidgetSet)) continue;
                List<TransportPropertyValue> nestedValues = currWidget instanceof ComplexListWidgetSet ? ((ComplexListWidgetSet)currWidget).getPropertyValue(this.namespaceText) : ((DependencyTypeWidgetSet)currWidget).getPropertyValue();
                for (TransportPropertyValue nestedValue : nestedValues) {
                    currProperty = new TransportProperty(this.namespaceText, currWidget.getPropertyName(), nestedValue, currWidget.isUserAdded());
                    if (currProperty == null) continue;
                    saveProperties.add(currProperty);
                }
            }
            this.commonCollectionProperties.addAll(saveProperties);
        } else {
            this.commonCollectionProperties.addAll(this.scannerProperties);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
    }

    public void modifyText(ModifyEvent event) {
        Object eventData = null;
        Object eventSource = event.getSource();
        if (eventSource instanceof Widget && (eventData = ((Widget)eventSource).getData()) != null) {
            TransportProperty eventProperty = null;
            if (eventData instanceof AbstractWidgetSet) {
                eventProperty = ((AbstractWidgetSet)eventData).getProperty();
                if (eventProperty != null) {
                    eventProperty.setValue(((AbstractWidgetSet)eventData).getPropertyValue());
                }
            } else {
                boolean cfr_ignored_0 = eventData instanceof AbstractComplexWidgetSet;
            }
        }
        this.setDirty(true);
    }

    public void focusGained(FocusEvent event) {
        Object sourceData;
        Object eventSource = event.getSource();
        if (eventSource instanceof Widget && (sourceData = ((Widget)eventSource).getData()) instanceof IWidgetSet) {
            this.currentSelection = event.getSource();
            this.updateRemovePropertyState();
            return;
        }
        this.currentSelection = null;
    }

    public void focusLost(FocusEvent event) {
    }

    private void updateRemovePropertyState() {
        if (this.currentSelection != null && this.currentSelection instanceof Widget) {
            this.removePropertyButton.setEnabled(true);
        } else {
            this.removePropertyButton.setEnabled(false);
        }
    }

    public void refresh() {
        if (this.defaultBody != null && !this.defaultBody.isDisposed()) {
            this.defaultBody.dispose();
            this.createFormContent(this.fManagedForm);
        }
        if (this.mainForm != null) {
            this.mainForm.reflow(true);
        }
        this.setDirty(false);
    }

    public String getNamespace() {
        return this.namespaceText;
    }

    public void applyEditorValue() {
    }

    public void cancelEditor() {
    }

    public void editorValueChanged(boolean arg0, boolean arg1) {
        this.setDirty(true);
    }
}

