/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.editors;

import com.ibm.team.enterprise.common.ui.util.Utils;
import com.ibm.team.enterprise.metadata.client.collection.MetadataCollectionUtils;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportFile;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.collection.nls.Messages;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.Workspace;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class MetadataCollectionEditorInput
extends FileEditorInput {
    boolean isNewMetadata = false;
    boolean doCreateNewMetadata = false;
    private TransportFile metadataCollection = null;
    private IFile fFile = null;
    private IShareable shareableFile;
    private ITeamRepository repo;
    private final String errorTitleMessage = Messages.MetadataCollectionEditor_ERROR_GENERAL_TITLE;
    private String inputFailureMessage = null;
    private String componentName = "";

    public MetadataCollectionEditorInput(IFile file, IProgressMonitor monitor) {
        super(file);
        this.fFile = file;
        this.init(monitor);
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    private void init(IProgressMonitor monitor) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        final Shell parent = workbench.getWorkbenchWindowCount() > 0 ? workbench.getWorkbenchWindows()[0].getShell() : null;
        String noStreamMessage = Messages.MetadataCollectionEditor_ERROR_NOSTREAM;
        final String decisionMessage = Messages.MetadataCollectionEditor_ERROR_NODATA;
        final String noFileMessage = Messages.MetadataCollectionEditor_ERROR_NOFILE;
        final String unknownErrorMessage = Messages.MetadataCollectionEditor_ERROR_UNKNOWN;
        String loggedOutMessage = Messages.MetadataCollectionEditor_ERROR_LOGGED_OUT;
        String notSharedMessage = Messages.MetadataCollectionEditor_ERROR_NOT_SHARED;
        try {
            if (this.fFile != null && Utils.isShared((IAdaptable)this.fFile)) {
                this.shareableFile = Utils.getSharable((IResource)this.fFile);
                this.repo = Utils.getTeamRepository((IShareable)this.shareableFile);
                if (this.repo != null && this.repo.loggedIn()) {
                    IWorkspaceHandle workspaceHandle = this.getWorkspaceHandle(this.shareableFile);
                    IWorkspace workspace = (IWorkspace)this.repo.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
                    IWorkspace stream = this.getWorkspaceStream(workspace, this.repo);
                    if (stream == null) {
                        this.inputFailureMessage = noStreamMessage;
                    }
                } else {
                    this.inputFailureMessage = loggedOutMessage;
                }
            } else {
                this.inputFailureMessage = notSharedMessage;
            }
        }
        catch (Exception e) {
            this.inputFailureMessage = unknownErrorMessage;
            MetadataUIPlugin.log(e);
        }
        if (this.inputFailureMessage == null) {
            TransportFile metadata = null;
            try {
                metadata = MetadataCollectionUtils.getSourceFileMetadata((IFile)this.fFile, (IProgressMonitor)monitor);
            }
            catch (TeamRepositoryException e) {
                this.setInputFailureMessage(unknownErrorMessage);
                MetadataUIPlugin.log(e);
            }
            if (metadata == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MetadataCollectionEditorInput.this.setDoCreateNewMetadata(MessageDialog.openQuestion((Shell)parent, (String)MetadataCollectionEditorInput.this.errorTitleMessage, (String)decisionMessage));
                        if (MetadataCollectionEditorInput.this.doCreateNewMetadata) {
                            if (MetadataCollectionEditorInput.this.fFile != null) {
                                TransportFile metadata = null;
                                try {
                                    metadata = MetadataCollectionUtils.createSourceFileMetadata((IFile)MetadataCollectionEditorInput.this.fFile, (boolean)true);
                                    MetadataCollectionEditorInput.this.isNewMetadata = true;
                                }
                                catch (TeamRepositoryException e) {
                                    MetadataCollectionEditorInput.this.setInputFailureMessage(unknownErrorMessage);
                                    MetadataUIPlugin.log(e);
                                }
                                if (metadata != null) {
                                    MetadataCollectionEditorInput.this.setMetadataCollection(metadata);
                                }
                            } else {
                                MetadataCollectionEditorInput.this.setInputFailureMessage(noFileMessage);
                            }
                        }
                    }
                });
            } else {
                this.setMetadataCollection(metadata);
            }
        }
    }

    private void setDoCreateNewMetadata(boolean shouldCreateMetadata) {
        this.doCreateNewMetadata = shouldCreateMetadata;
    }

    private IWorkspaceHandle getWorkspaceHandle(IShareable share) throws Exception {
        IShare s = share.getShare((IProgressMonitor)new NullProgressMonitor());
        ISharingDescriptor desc = s.getSharingDescriptor();
        return (IWorkspaceHandle)desc.getConnectionHandle();
    }

    private IWorkspace getWorkspaceStream(IWorkspace workspace, ITeamRepository repo) throws TeamRepositoryException {
        IWorkspace flowTarget;
        IWorkspaceHandle flowTargetHandle;
        UUID defaultFlow;
        if (workspace.isStream()) {
            return workspace;
        }
        IWorkspace stream = null;
        Workspace ws = (Workspace)workspace;
        CurrentFlows flows = ws.getCurrentFlows();
        if (flows != null && (defaultFlow = flows.getDefaultAcceptFlow()) != null && (flowTargetHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(defaultFlow, null)) != null && (flowTarget = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)flowTargetHandle, 0, (IProgressMonitor)new NullProgressMonitor())).isStream()) {
            stream = flowTarget;
        }
        return stream;
    }

    public TransportFile getMetadataCollection() {
        return this.metadataCollection;
    }

    public ITeamRepository getTeamRepository() {
        return this.repo;
    }

    public String getInputFailureMessage() {
        return this.inputFailureMessage;
    }

    public void setInputFailureMessage(String newMessage) {
        this.inputFailureMessage = newMessage;
    }

    private void setMetadataCollection(TransportFile metadataCollection) {
        this.metadataCollection = metadataCollection;
        if (metadataCollection != null) {
            for (TransportProperty tProperty : metadataCollection.getProperties()) {
                if (!"http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/".equals(tProperty.getNamespace()) || !"componentId".equals(tProperty.getLocalName())) continue;
                try {
                    String componentUuidValue = tProperty.getValue().getStringValue();
                    IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)componentUuidValue), null);
                    IComponent component = (IComponent)this.repo.itemManager().fetchPartialItem((IItemHandle)componentHandle, 0, Arrays.asList(IComponent.NAME_PROPERTY), null);
                    this.componentName = component.getName();
                }
                catch (Exception e) {
                    MetadataUIPlugin.log(e);
                }
                break;
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetadataCollectionEditorInput)) {
            return false;
        }
        return super.equals(obj);
    }

    public String getComponentName() {
        return this.componentName;
    }
}

