/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.editors;

import com.ibm.team.enterprise.common.ui.TransportFileEditorInput;
import com.ibm.team.enterprise.metadata.client.collection.MetadataCollectionUtils;
import com.ibm.team.enterprise.metadata.client.query.IMetadataQueryClient;
import com.ibm.team.enterprise.metadata.client.query.MetadataQueryClientUtil;
import com.ibm.team.enterprise.metadata.client.scanner.IMetadataScannerClientLibrary;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportFile;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportPropertyValue;
import com.ibm.team.enterprise.metadata.common.scanner.IFileMetadataScanner;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.collection.editors.CommonCollectionPage;
import com.ibm.team.enterprise.metadata.ui.collection.editors.DeleteNamespaceAction;
import com.ibm.team.enterprise.metadata.ui.collection.editors.EmptyCollectionPage;
import com.ibm.team.enterprise.metadata.ui.collection.editors.MetadataCollectionEditorInput;
import com.ibm.team.enterprise.metadata.ui.collection.editors.NamespaceCollectionPage;
import com.ibm.team.enterprise.metadata.ui.collection.editors.NewNamespaceAction;
import com.ibm.team.enterprise.metadata.ui.collection.editors.RefreshEditorAction;
import com.ibm.team.enterprise.metadata.ui.collection.editors.SaveEditorAction;
import com.ibm.team.enterprise.metadata.ui.collection.nls.Messages;
import com.ibm.team.enterprise.metadata.ui.collection.utils.NamespaceCollectionComparator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.ui.editor.TeamFormEditor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressService;

public class MetadataCollectionEditor
extends TeamFormEditor {
    boolean isPageChanging = false;
    boolean errorOccurred = false;
    boolean isNewMetadata = false;
    private TransportFile metadataCollection;
    private Map<String, List<TransportProperty>> sortedMetadata;
    private Map<String, IFileMetadataScanner> scannerMap;
    private ITeamRepository repo;
    private IFile file;
    private TransportFileEditorInput tFileInput;
    protected int fBusyCount;
    private boolean fIsDisposed = false;
    protected IMessageManager fMessageManager;
    private SaveEditorAction fSaveAction;
    private RefreshEditorAction fRefreshAction;
    private NewNamespaceAction fNewNSAction;
    private DeleteNamespaceAction fDeleteNSAction;
    private Text fNamespaceText;
    private NamespaceCollectionPage[] nsPage;
    private Shell parent;
    private final String errorTitleMessage = Messages.MetadataCollectionEditor_ERROR_GENERAL_TITLE;
    private final String errorDescriptionMessage = Messages.MetadataCollectionEditor_ERROR_GENERAL_DESCRIPTION;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IProgressService ps = PlatformUI.getWorkbench().getProgressService();
        if (!(input instanceof MetadataCollectionEditorInput) && input instanceof FileEditorInput) {
            this.file = ((FileEditorInput)input).getFile();
            try {
                ps.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        MetadataCollectionEditor.this.setInput((IEditorInput)new MetadataCollectionEditorInput(MetadataCollectionEditor.this.file, monitor));
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw new PartInitException(Messages.MetadataCollectionEditor_ERROR_UNKNOWN);
            }
            catch (InterruptedException e) {
                throw new PartInitException(Messages.MetadataCollectionEditor_ERROR_UNKNOWN);
            }
        }
        if (input instanceof MetadataCollectionEditorInput) {
            MetadataCollectionEditorInput metadataInput = (MetadataCollectionEditorInput)input;
            TransportFile metadataFile = metadataInput.getMetadataCollection();
            if (this.file == null) {
                this.file = metadataInput.getFile();
            }
            if (metadataFile == null) throw new PartInitException(metadataInput.getInputFailureMessage());
            super.init(site, input);
            this.setMetadataCollection(metadataFile);
            this.repo = metadataInput.getTeamRepository();
            this.isNewMetadata = metadataInput.isNewMetadata;
            this.errorOccurred = metadataInput.getInputFailureMessage() != null;
        } else if (input instanceof TransportFileEditorInput) {
            this.tFileInput = (TransportFileEditorInput)input;
            TransportFile metadata = this.tFileInput.getTransportFile();
            if (metadata == null) throw new PartInitException(Messages.MetadataCollectionEditor_ERROR_UNKNOWN);
            super.init(site, input);
            this.setMetadataCollection(metadata);
            this.repo = this.tFileInput.getTeamRepository();
            this.isNewMetadata = false;
            try {
                ps.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (MetadataCollectionEditor.this.tFileInput.getComponentName().isEmpty()) {
                            try {
                                String componentUuidValue = MetadataCollectionEditor.this.tFileInput.getComponentId();
                                IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)componentUuidValue), null);
                                IComponent component = (IComponent)MetadataCollectionEditor.this.tFileInput.getTeamRepository().itemManager().fetchPartialItem((IItemHandle)componentHandle, 0, Arrays.asList(IComponent.NAME_PROPERTY), monitor);
                                MetadataCollectionEditor.this.tFileInput.setComponentName(component.getName());
                            }
                            catch (TeamRepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                MetadataUIPlugin.log(e);
            }
        }
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    MetadataCollectionEditor.this.initializeScannerMap();
                }
            });
            return;
        }
        catch (InvocationTargetException e) {
            MetadataUIPlugin.log(e);
            throw new PartInitException(Messages.MetadataCollectionEditor_ERROR_UNKNOWN);
        }
        catch (InterruptedException e) {
            MetadataUIPlugin.log(e);
            throw new PartInitException(Messages.MetadataCollectionEditor_ERROR_UNKNOWN);
        }
    }

    private void initializeScannerMap() {
        if (this.scannerMap == null) {
            this.scannerMap = new HashMap<String, IFileMetadataScanner>();
        }
        if (this.scannerMap.isEmpty()) {
            IFileMetadataScanner[] metadataScanners;
            IMetadataScannerClientLibrary scannerLibrary = (IMetadataScannerClientLibrary)this.repo.getClientLibrary(IMetadataScannerClientLibrary.class);
            try {
                metadataScanners = scannerLibrary.getAllMetadataScanners();
            }
            catch (TeamRepositoryException e) {
                metadataScanners = null;
            }
            if (metadataScanners != null && metadataScanners.length > 0) {
                IFileMetadataScanner[] iFileMetadataScannerArray = metadataScanners;
                int n = metadataScanners.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileMetadataScanner scanner = iFileMetadataScannerArray[n2];
                    this.scannerMap.put(scanner.getNamespace(), scanner);
                    ++n2;
                }
            }
        }
    }

    private void openErrorDialog(IStatus errorStatus) {
        final ErrorDialog dialog = new ErrorDialog(this.parent, this.errorTitleMessage, this.errorDescriptionMessage, errorStatus, 7);
        dialog.setBlockOnOpen(true);
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.open();
                }
            });
        } else {
            dialog.open();
        }
        this.errorOccurred = true;
    }

    protected void createPages() {
        this.addPages();
    }

    protected void addPages() {
        try {
            if (this.errorOccurred) {
                this.addPage((IFormPage)new EmptyCollectionPage((FormEditor)this));
            } else {
                this.initializePages();
                NamespaceCollectionPage[] namespaceCollectionPageArray = this.nsPage;
                int n = this.nsPage.length;
                int n2 = 0;
                while (n2 < n) {
                    NamespaceCollectionPage page = namespaceCollectionPageArray[n2];
                    this.addPage((IFormPage)page);
                    ++n2;
                }
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    protected void pageChange(int newPageIndex) {
        Map<String, IFileMetadataScanner> sMap = this.getScannerMap();
        this.isPageChanging = true;
        super.pageChange(newPageIndex);
        IFormPage currentPage = this.getActivePageInstance();
        if (currentPage != null && currentPage instanceof NamespaceCollectionPage) {
            String ns = ((NamespaceCollectionPage)currentPage).getNamespace();
            this.fNamespaceText.setText(ns);
            boolean enabledState = currentPage.getTitle().equalsIgnoreCase(Messages.MetadataCollectionEditor_TITLE) || sMap.containsKey(ns);
            this.fNamespaceText.setEnabled(!enabledState);
            this.fDeleteNSAction.setEnabled(!enabledState);
        }
        this.isPageChanging = false;
    }

    private Map<String, IFileMetadataScanner> getScannerMap() {
        return this.scannerMap;
    }

    private void initializePages() {
        this.sortedMetadata = this.sortFileMetadata(this.metadataCollection);
        ArrayList<TransportProperty> defaultMetadata = new ArrayList<TransportProperty>();
        List<TransportProperty> scmMetadata = this.sortedMetadata.get("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/");
        if (scmMetadata != null && !scmMetadata.isEmpty()) {
            defaultMetadata.addAll(scmMetadata);
            String componentName = "";
            if (this.getEditorInput() instanceof MetadataCollectionEditorInput) {
                componentName = ((MetadataCollectionEditorInput)this.getEditorInput()).getComponentName();
            } else if (this.getEditorInput() instanceof TransportFileEditorInput) {
                componentName = ((TransportFileEditorInput)this.getEditorInput()).getComponentName();
            }
            if (!componentName.isEmpty()) {
                defaultMetadata.add(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/", "componentName", new TransportPropertyValue(componentName)));
            }
        }
        Object[] namespaces = null;
        Set<String> namespaceSet = this.sortedMetadata.keySet();
        namespaceSet.remove("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/");
        ArrayList<String> namespaceList = new ArrayList<String>();
        namespaceList.addAll(namespaceSet);
        Collections.sort(namespaceList, new NamespaceCollectionComparator());
        namespaces = namespaceList.toArray();
        int numPages = namespaces.length;
        this.nsPage = new NamespaceCollectionPage[numPages];
        int i = 0;
        while (i < numPages) {
            String currNamespace = (String)namespaces[i];
            List<TransportProperty> currPropertyList = this.sortedMetadata.get(currNamespace);
            if (!currNamespace.equalsIgnoreCase("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/")) {
                String nsPrefix;
                if (currNamespace.equalsIgnoreCase("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/")) {
                    nsPrefix = Messages.MetadataCollectionEditor_TITLE;
                } else {
                    IFileMetadataScanner currScanner;
                    String scannerPrefix = null;
                    Map<String, IFileMetadataScanner> sMap = this.getScannerMap();
                    IFileMetadataScanner iFileMetadataScanner = currScanner = sMap != null ? sMap.get(currNamespace) : null;
                    if (currScanner != null) {
                        scannerPrefix = currScanner.getLabel();
                    }
                    nsPrefix = scannerPrefix != null ? scannerPrefix : String.valueOf(Messages.MetadataCollectionEditor_TABTITLE_GENERAL) + i;
                }
                this.nsPage[i] = new NamespaceCollectionPage((FormEditor)this, nsPrefix, currNamespace, currPropertyList, !currNamespace.equalsIgnoreCase("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/") ? null : defaultMetadata);
            }
            ++i;
        }
        if (numPages == 0) {
            this.nsPage = new NamespaceCollectionPage[1];
            this.nsPage[0] = new NamespaceCollectionPage((FormEditor)this, Messages.MetadataCollectionEditor_TITLE, "http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", new ArrayList<TransportProperty>(), defaultMetadata);
        }
        if (scmMetadata != null) {
            for (TransportProperty property : scmMetadata) {
                if (!property.getLocalName().equalsIgnoreCase("fileName")) continue;
                String fileName = property.getValue().getStringValue();
                this.setPartName(fileName);
            }
        }
        if (this.isNewMetadata && this.nsPage.length > 0) {
            this.nsPage[0].setDirty(true);
        }
    }

    private Map<String, List<TransportProperty>> sortFileMetadata(TransportFile metadata) {
        List rawList = metadata.getProperties();
        HashMap<String, List<TransportProperty>> returnMap = new HashMap<String, List<TransportProperty>>();
        for (TransportProperty currProperty : rawList) {
            String currNamespace = currProperty.getNamespace();
            if (returnMap.containsKey(currNamespace)) {
                returnMap.get(currNamespace).add(currProperty);
                continue;
            }
            ArrayList<TransportProperty> newList = new ArrayList<TransportProperty>();
            newList.add(currProperty);
            returnMap.put(currNamespace, newList);
        }
        return returnMap;
    }

    public void doSave(IProgressMonitor monitor) {
        IFormPage formPage = null;
        try {
            try {
                TransportFile metadata = null;
                if (this.file != null) {
                    metadata = MetadataCollectionUtils.createSourceFileMetadata((IFile)this.file, (boolean)false);
                } else {
                    String itemSlug = MetadataCollectionUtils.getSlug((String)this.tFileInput.getFileItemId());
                    String fileResourceURI = "http://www.ibm.com/xmlns/prod/rational/rtc/scd/file/" + itemSlug;
                    metadata = new TransportFile(fileResourceURI);
                }
                if (this.pages != null) {
                    for (Object currPage : this.pages) {
                        if (currPage instanceof IFormPage) {
                            formPage = (IFormPage)currPage;
                            if (formPage instanceof CommonCollectionPage) {
                                if (this.getActivePageInstance() == formPage) {
                                    ((CommonCollectionPage)formPage).doSave(this.fNamespaceText.getText(), monitor);
                                } else {
                                    formPage.doSave(monitor);
                                }
                                List<TransportProperty> pageList = ((CommonCollectionPage)formPage).getPageProperties();
                                if (pageList != null) {
                                    metadata.getProperties().addAll(pageList);
                                }
                            }
                            if (!(formPage instanceof NamespaceCollectionPage)) continue;
                            ((NamespaceCollectionPage)formPage).setDirty(false);
                            continue;
                        }
                        formPage = null;
                    }
                }
                if (this.file != null) {
                    MetadataCollectionUtils.setSourceFileMetadata((IFile)this.file, (TransportFile)metadata, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    MetadataCollectionUtils.setSourceFileMetadata((ITeamRepository)this.repo, (String)this.tFileInput.getStreamId(), (String)this.tFileInput.getComponentId(), (String)this.tFileInput.getFileItemId(), (TransportFile)metadata, (IProgressMonitor)new NullProgressMonitor());
                }
                this.saveProperties4Query(metadata, monitor);
            }
            catch (TeamRepositoryException e) {
                this.openErrorDialog((IStatus)new Status(4, MetadataUIPlugin.getUniqueIdentifier(), e.getLocalizedMessage()));
                if (formPage != null && formPage instanceof NamespaceCollectionPage) {
                    ((NamespaceCollectionPage)formPage).setDirty(true);
                }
                this.isNewMetadata = false;
                this.fireDirtyPropertyChangeEvent();
            }
        }
        finally {
            this.isNewMetadata = false;
            this.fireDirtyPropertyChangeEvent();
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public TransportFile getMetadataCollection() {
        return this.metadataCollection;
    }

    public void setMetadataCollection(TransportFile metadataCollection) {
        this.metadataCollection = metadataCollection;
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        Form form = headerForm.getForm().getForm();
        form.setText(Messages.MetadataCollectionEditor_FORMTITLE);
        IToolBarManager toolBarManager = form.getToolBarManager();
        this.fNewNSAction = new NewNamespaceAction(this, form.getShell());
        toolBarManager.add((IAction)this.fNewNSAction);
        this.fDeleteNSAction = new DeleteNamespaceAction(this, form.getShell());
        toolBarManager.add((IAction)this.fDeleteNSAction);
        this.fRefreshAction = new RefreshEditorAction(this, form.getShell());
        toolBarManager.add((IAction)this.fRefreshAction);
        this.fSaveAction = new SaveEditorAction(this);
        toolBarManager.add((IContributionItem)this.fSaveAction);
        form.updateToolBar();
        this.addPropertyListener(new DirtyPropertyListener());
        this.fMessageManager = headerForm.getMessageManager();
        this.fMessageManager.setDecorationPosition(16512);
        this.createHeaderSecondRow(headerForm);
    }

    private void createHeaderSecondRow(final IManagedForm headerForm) {
        FormToolkit toolkit = this.getToolkit();
        Composite head = headerForm.getForm().getForm().getHead();
        Composite headClient = new Composite(head, 0);
        GridLayout layout = new GridLayout(2, false);
        headClient.setLayout((Layout)layout);
        GridData gridData = new GridData();
        headClient.setLayoutData((Object)gridData);
        Label label = toolkit.createLabel(headClient, Messages.MetadataCollectionEditor_LABEL_NAMESPACE);
        label.setBackground(null);
        this.fNamespaceText = toolkit.createText(headClient, "");
        this.fNamespaceText.setLayoutData((Object)new GridData(768));
        this.fNamespaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!MetadataCollectionEditor.this.isPageChanging) {
                    IFormPage page = MetadataCollectionEditor.this.getActivePageInstance();
                    if (page != null && page instanceof NamespaceCollectionPage) {
                        ((NamespaceCollectionPage)page).setDirty(true);
                    }
                    ScrolledForm headForm = headerForm.getForm();
                    String namespaceValue = MetadataCollectionEditor.this.fNamespaceText.getText();
                    if (namespaceValue.charAt(namespaceValue.length() - 1) != '/') {
                        headForm.setMessage(Messages.MetadataCollectionEditor_ERROR_NAMESPACE_SLASH, 3);
                        return;
                    }
                    try {
                        URI namespaceURI = new URI(namespaceValue);
                        if (!namespaceURI.isAbsolute()) {
                            headForm.setMessage(Messages.MetadataCollectionEditor_ERROR_NAMESPACE_ABSOLUTE, 3);
                            return;
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    headForm.setMessage(null, 0);
                }
            }
        });
        headerForm.getForm().setHeadClient((Control)headClient);
    }

    public void fireDirtyPropertyChangeEvent() {
        this.firePropertyChange(257);
    }

    protected SaveEditorAction getSaveEditorAction() {
        return this.fSaveAction;
    }

    protected RefreshEditorAction getRefreshEditorAction() {
        return this.fRefreshAction;
    }

    protected NewNamespaceAction getNewEditorAction() {
        return this.fNewNSAction;
    }

    protected DeleteNamespaceAction getDeleteEditorAction() {
        return this.fDeleteNSAction;
    }

    protected void setBusy(boolean isBusy) {
        if (!this.isDisposed()) {
            if (this.fBusyCount == 0 && isBusy) {
                this.getHeaderForm().getForm().setBusy(true);
            } else if (this.fBusyCount == 1 && !isBusy) {
                this.getHeaderForm().getForm().setBusy(false);
            }
            if (isBusy) {
                ++this.fBusyCount;
            } else if (this.fBusyCount > 0) {
                --this.fBusyCount;
            }
        }
        this.getSaveEditorAction().updateEnabledState();
        this.getRefreshEditorAction().updateEnabledState();
    }

    protected boolean isBusy() {
        return this.fBusyCount > 0;
    }

    protected boolean isDisposed() {
        return this.fIsDisposed;
    }

    public void dispose() {
        this.fIsDisposed = true;
        super.dispose();
    }

    public void refreshMetadataCollection() {
        this.removePages();
        this.nsPage = null;
        this.errorOccurred = false;
        try {
            TransportFile metadata = null;
            metadata = this.file != null ? MetadataCollectionUtils.getSourceFileMetadata((IFile)this.file, (IProgressMonitor)new NullProgressMonitor()) : MetadataCollectionUtils.getSourceFileMetadata((ITeamRepository)this.repo, (String)this.tFileInput.getStreamId(), (String)this.tFileInput.getComponentId(), (String)this.tFileInput.getFileItemId(), (IProgressMonitor)new NullProgressMonitor());
            this.setMetadataCollection(metadata);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        this.addPages();
        if (this.pages != null) {
            for (Object currPage : this.pages) {
                if (!(currPage instanceof NamespaceCollectionPage)) continue;
                NamespaceCollectionPage editorPage = (NamespaceCollectionPage)((Object)currPage);
                editorPage.refresh();
                IManagedForm managedForm = editorPage.getManagedForm();
                if (managedForm == null) continue;
                managedForm.reflow(true);
            }
            this.getHeaderForm().getForm().reflow(true);
            this.fireDirtyPropertyChangeEvent();
        }
        this.setActivePage(0);
    }

    public void deleteCurrentNamespace() {
        String currentNamespace = this.fNamespaceText.getText();
        if (this.pages != null) {
            Object[] pageArray = this.pages.toArray();
            int i = pageArray.length - 1;
            while (i >= 0) {
                if (((NamespaceCollectionPage)((Object)pageArray[i])).getNamespace().equalsIgnoreCase(currentNamespace)) {
                    this.removePage(i);
                }
                --i;
            }
        }
        this.sortedMetadata.remove(currentNamespace);
        ((NamespaceCollectionPage)this.getActivePageInstance()).setDirty(true);
    }

    public void createNewNamespace(String newNamespace) {
        NamespaceCollectionPage newPage;
        this.sortedMetadata.put(newNamespace, new ArrayList());
        int originalPageNums = this.nsPage.length;
        NamespaceCollectionPage[] newPageArray = new NamespaceCollectionPage[originalPageNums + 1];
        System.arraycopy(this.nsPage, 0, newPageArray, 0, originalPageNums);
        newPageArray[originalPageNums] = newPage = new NamespaceCollectionPage((FormEditor)this, String.valueOf(Messages.MetadataCollectionEditor_TABTITLE) + originalPageNums, newNamespace, new ArrayList<TransportProperty>(), null);
        try {
            this.addPage((IFormPage)newPage);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        this.nsPage = newPageArray;
        this.setActivePage(originalPageNums);
        this.fNamespaceText.setText(newNamespace);
        newPage.setDirty(true);
    }

    public Map<String, List<TransportProperty>> getSortedMetadata() {
        return this.sortedMetadata;
    }

    protected Composite createPageContainer(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.editor");
        return super.createPageContainer(parent);
    }

    private void saveProperties4Query(TransportFile transportFile, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.repo == null || transportFile == null || transportFile.getProperties().size() == 0) {
            return;
        }
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        List properties = transportFile.getProperties();
        for (TransportProperty property : properties) {
            IAttribute attribute;
            if (!property.isUserAdded() || (attribute = MetadataQueryClientUtil.toAttribute((TransportProperty)property, (String)this.repo.getRepositoryURI())) == null) continue;
            attributes.add(attribute);
        }
        if (attributes.size() > 0) {
            IMetadataQueryClient queryClient = (IMetadataQueryClient)this.repo.getClientLibrary(IMetadataQueryClient.class);
            queryClient.saveCustomAttributes(attributes, true, monitor);
        }
    }

    public boolean isDirty() {
        return super.isDirty() || this.isNewMetadata;
    }

    protected class DirtyPropertyListener
    implements IPropertyListener {
        protected DirtyPropertyListener() {
        }

        public void propertyChanged(Object source, int propertyId) {
            if (source instanceof IEditorPart && propertyId == 257) {
                MetadataCollectionEditor.this.getSaveEditorAction().updateEnabledState();
            }
        }
    }
}

