/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.editors;

import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.ui.collection.nls.Messages;
import com.ibm.team.enterprise.metadata.ui.collection.utils.AbstractWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.CollectionWidgetGenerator;
import com.ibm.team.enterprise.metadata.ui.collection.utils.IWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.ListWidgetSet;
import com.ibm.team.enterprise.metadata.ui.collection.utils.MetadataCollectionComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class CommonCollectionPage
extends FormPage {
    private Section defaultSection;
    private Composite defaultComposite;
    protected Composite defaultBody;
    protected IManagedForm fManagedForm;
    protected ScrolledForm mainForm;
    protected List<TransportProperty> defaultProperties;
    protected List<TransportProperty> commonCollectionProperties;
    private List<IWidgetSet> commonWidgetList;

    public CommonCollectionPage(FormEditor editor, String id, String title, List<TransportProperty> defaultProperties) {
        super(editor, id, title);
        this.defaultProperties = defaultProperties;
        this.commonCollectionProperties = new ArrayList<TransportProperty>();
    }

    protected final void createFormContent(IManagedForm managedForm) {
        this.fManagedForm = managedForm;
        this.mainForm = this.fManagedForm.getForm();
        FormToolkit toolkit = this.fManagedForm.getToolkit();
        Composite formBody = this.mainForm.getBody();
        GridData layoutData = new GridData(1808);
        GridLayout layout = new GridLayout();
        formBody.setLayoutData((Object)layoutData);
        formBody.setLayout((Layout)layout);
        this.defaultBody = toolkit.createComposite(formBody);
        GridData defaultData = new GridData(1808);
        defaultData.horizontalSpan = 2;
        this.defaultBody.setLayoutData((Object)defaultData);
        this.defaultBody.setLayout((Layout)new GridLayout());
        if (this.defaultProperties != null) {
            this.createDefaultWidgets(this.defaultBody, toolkit);
        }
        this.createCollectionWidgets(this.defaultBody, toolkit);
    }

    protected void createDefaultWidgets(Composite defaultParent, FormToolkit toolkit) {
        this.defaultSection = toolkit.createSection(defaultParent, 418);
        GridData sectionData = new GridData(768);
        sectionData.horizontalSpan = 3;
        this.defaultSection.setLayoutData((Object)sectionData);
        this.defaultSection.setLayout((Layout)new GridLayout());
        this.defaultSection.setText(Messages.CommonCollectionPage_SECTION_DEFAULT);
        this.defaultSection.setDescription(Messages.CommonCollectionPage_SECTION_DEFAULT_DESCRIPTION);
        this.defaultComposite = toolkit.createComposite((Composite)this.defaultSection);
        this.defaultComposite.setLayoutData((Object)new GridData(768));
        this.defaultComposite.setLayout((Layout)new GridLayout(3, false));
        Collections.sort(this.defaultProperties, new MetadataCollectionComparator());
        if (this.commonWidgetList == null) {
            this.commonWidgetList = new ArrayList<IWidgetSet>();
        } else if (!this.commonWidgetList.isEmpty()) {
            this.commonWidgetList.clear();
        }
        for (TransportProperty currProp : this.defaultProperties) {
            AbstractWidgetSet widgetSet = CollectionWidgetGenerator.getCollectionWidgetGenerator().generateCollectionWidgets(currProp, this.defaultComposite, toolkit);
            this.commonWidgetList.add(widgetSet);
        }
        Control[] controlArray = this.defaultComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Text) {
                Text textControl = (Text)c;
                textControl.setEditable(false);
                textControl.setForeground(Display.getCurrent().getSystemColor(18));
            } else {
                c.setEnabled(false);
            }
            ++n2;
        }
        this.defaultSection.setClient((Control)this.defaultComposite);
    }

    protected abstract void createCollectionWidgets(Composite var1, FormToolkit var2);

    protected abstract void createControlWidgets(Composite var1, FormToolkit var2);

    public List<TransportProperty> getPageProperties() {
        return this.commonCollectionProperties;
    }

    public abstract void doSave(String var1, IProgressMonitor var2);

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        String namespaceText = "http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/";
        ArrayList<TransportProperty> pageProperties = new ArrayList<TransportProperty>();
        if (this.commonWidgetList != null) {
            for (IWidgetSet currWidget : this.commonWidgetList) {
                TransportProperty currProperty = null;
                if (currWidget instanceof ListWidgetSet) {
                    currProperty = new TransportProperty(namespaceText, currWidget.getPropertyName(), ((ListWidgetSet)currWidget).getPropertyValue(namespaceText), currWidget.isUserAdded());
                } else if (!"componentName".equals(currWidget.getPropertyName())) {
                    currProperty = new TransportProperty(namespaceText, currWidget.getPropertyName(), currWidget.getPropertyValue(), currWidget.isUserAdded());
                }
                if (currProperty == null) continue;
                pageProperties.add(currProperty);
            }
            if (!this.commonCollectionProperties.isEmpty()) {
                this.commonCollectionProperties.clear();
            }
            this.commonCollectionProperties.addAll(pageProperties);
        }
    }
}

