/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.editors;

import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportPropertyValue;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.collection.editors.ChildProperty;
import com.ibm.team.enterprise.metadata.ui.collection.nls.Messages;
import com.ibm.team.enterprise.metadata.ui.collection.utils.MetadataCollectionComparator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.RowDataFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddNewMetadataPropertyDialog
extends StatusDialog
implements SelectionListener {
    private boolean initialState = false;
    private final List<TransportProperty> initialProperties;
    private final Map<String, TransportProperty> initialPropertyMap;
    private Text descriptionLabel;
    private List<ChildProperty> childList;
    private TransportProperty resultProperty;
    private final String namespace;
    private CCombo propertyNameCombo;
    private Composite buttonComposite;
    private Button booleanProperty;
    private Button stringProperty;
    private Button numberProperty;
    private Button dependencyProperty;
    private Button complexProperty;
    private Button addProperty;
    private Button removeProperty;
    private Table complexPropertyTable;
    private TableViewerColumn complexNameColumn;
    private TableViewerColumn complexTypeColumn;
    private TableViewer complexPropertyTableViewer;
    private final String[] columnNames = new String[]{"column1", "column2"};
    private final String[] propertyTypes = new String[]{Messages.AddNewMetadataPropertyDialog_BUTTON_STRINGTYPE, Messages.AddNewMetadataPropertyDialog_BUTTON_BOOLEANTYPE, Messages.AddNewMetadataPropertyDialog_BUTTON_NUMBERTYPE};

    protected AddNewMetadataPropertyDialog(Shell shell, String targetNamespace) {
        this(shell, new ArrayList<TransportProperty>(), targetNamespace);
    }

    protected AddNewMetadataPropertyDialog(Shell shell, List<TransportProperty> existingProperties, String targetNamespace) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.namespace = targetNamespace;
        this.initialProperties = existingProperties;
        this.initialPropertyMap = new HashMap<String, TransportProperty>();
        Collections.sort(this.initialProperties, new MetadataCollectionComparator());
    }

    protected Control createDialogArea(Composite parent) {
        final Composite mainComposite = new Composite(parent, 0);
        ArrayList<Object> tabList = new ArrayList<Object>();
        GridData dialogData = this.createWidgetData(0, 1808);
        mainComposite.setLayoutData((Object)dialogData);
        mainComposite.setLayout((Layout)new GridLayout(3, false));
        mainComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = mainComposite.getClientArea();
                Point preferredSize = AddNewMetadataPropertyDialog.this.complexPropertyTable.computeSize(-1, -1);
                int width = area.width - 2 * AddNewMetadataPropertyDialog.this.complexPropertyTable.getHeaderHeight();
                if (preferredSize.y > area.height + AddNewMetadataPropertyDialog.this.complexPropertyTable.getHeaderHeight()) {
                    Point vBarSize = AddNewMetadataPropertyDialog.this.complexPropertyTable.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = AddNewMetadataPropertyDialog.this.complexPropertyTable.getSize();
                if (oldSize.x > area.width) {
                    AddNewMetadataPropertyDialog.this.complexNameColumn.getColumn().setWidth(width / 3);
                    AddNewMetadataPropertyDialog.this.complexTypeColumn.getColumn().setWidth(width - AddNewMetadataPropertyDialog.this.complexNameColumn.getColumn().getWidth());
                    AddNewMetadataPropertyDialog.this.complexPropertyTable.setSize(area.width, area.height);
                } else {
                    AddNewMetadataPropertyDialog.this.complexPropertyTable.setSize(area.width, area.height);
                    AddNewMetadataPropertyDialog.this.complexNameColumn.getColumn().setWidth(width / 3);
                    AddNewMetadataPropertyDialog.this.complexTypeColumn.getColumn().setWidth(width - AddNewMetadataPropertyDialog.this.complexNameColumn.getColumn().getWidth());
                }
                int computedHeight = ((AddNewMetadataPropertyDialog)AddNewMetadataPropertyDialog.this).descriptionLabel.computeSize((int)area.width, (int)-1).y;
                RowDataFactory.swtDefaults().hint(width, computedHeight).applyTo((Control)AddNewMetadataPropertyDialog.this.descriptionLabel);
            }
        });
        Label propertyNameLabel = new Label(mainComposite, 0);
        propertyNameLabel.setText(Messages.AddNewMetadataPropertyDialog_LABEL_NAME);
        propertyNameLabel.setLayoutData((Object)this.createWidgetData());
        this.propertyNameCombo = new CCombo(mainComposite, 2048);
        this.propertyNameCombo.setLayoutData((Object)this.createWidgetData(2));
        for (TransportProperty prop : this.initialProperties) {
            this.propertyNameCombo.add(prop.getLocalName());
            this.initialPropertyMap.put(prop.getLocalName(), prop);
        }
        this.propertyNameCombo.addSelectionListener((SelectionListener)this);
        this.propertyNameCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                AddNewMetadataPropertyDialog.this.handleValidatePropertyNameCombo();
                AddNewMetadataPropertyDialog.this.validate();
            }
        });
        tabList.add(this.propertyNameCombo);
        new Label(mainComposite, 0);
        Composite descriptionComposite = new Composite(mainComposite, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)descriptionComposite);
        RowLayoutFactory.fillDefaults().wrap(true).margins(0, 5).applyTo(descriptionComposite);
        this.descriptionLabel = new Text(descriptionComposite, 72);
        this.descriptionLabel.setText(Messages.AddNewMetadataPropertyDialog_COMBO_DESCRIPTION);
        int parentWidth = dialogData.widthHint - propertyNameLabel.getBounds().width;
        int computedHeight = this.descriptionLabel.computeSize((int)parentWidth, (int)-1).y;
        RowDataFactory.swtDefaults().hint(parentWidth, computedHeight).applyTo((Control)this.descriptionLabel);
        tabList.add(descriptionComposite);
        Label propertyTypeLabel = new Label(mainComposite, 0);
        propertyTypeLabel.setText(Messages.AddNewMetadataPropertyDialog_LABEL_TYPE);
        propertyTypeLabel.setLayoutData((Object)this.createWidgetData());
        this.booleanProperty = new Button(mainComposite, 16);
        this.booleanProperty.setText(Messages.AddNewMetadataPropertyDialog_BUTTON_BOOLEANTYPE);
        this.booleanProperty.setLayoutData((Object)this.createWidgetData(2));
        this.booleanProperty.setSelection(true);
        this.createSpacer(mainComposite, 1);
        this.stringProperty = new Button(mainComposite, 16);
        this.stringProperty.setText(Messages.AddNewMetadataPropertyDialog_BUTTON_STRINGTYPE);
        this.stringProperty.setLayoutData((Object)this.createWidgetData(2));
        this.createSpacer(mainComposite, 1);
        this.numberProperty = new Button(mainComposite, 16);
        this.numberProperty.setText(Messages.AddNewMetadataPropertyDialog_BUTTON_NUMBERTYPE);
        this.numberProperty.setLayoutData((Object)this.createWidgetData(2));
        this.createSpacer(mainComposite, 1);
        this.dependencyProperty = new Button(mainComposite, 16);
        this.dependencyProperty.setText(Messages.AddNewMetadataPropertyDialog_BUTTON_DEPENDENCYTYPE);
        this.dependencyProperty.setLayoutData((Object)this.createWidgetData(2));
        this.createSpacer(mainComposite, 1);
        this.complexProperty = new Button(mainComposite, 16);
        this.complexProperty.setText(Messages.AddNewMetadataPropertyDialog_BUTTON_COMPLEXTYPE);
        this.complexProperty.setLayoutData((Object)this.createWidgetData(2));
        this.booleanProperty.addSelectionListener((SelectionListener)this);
        this.stringProperty.addSelectionListener((SelectionListener)this);
        this.numberProperty.addSelectionListener((SelectionListener)this);
        this.dependencyProperty.addSelectionListener((SelectionListener)this);
        this.complexProperty.addSelectionListener((SelectionListener)this);
        tabList.add(this.booleanProperty);
        this.createSpacer(mainComposite, 1);
        this.createTableViewer(mainComposite);
        this.complexPropertyTableViewer.setInput(this.getChildProperties());
        this.buttonComposite = new Composite(mainComposite, 0);
        this.buttonComposite.setLayoutData((Object)this.createWidgetData(1, 1040));
        this.buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.addProperty = new Button(this.buttonComposite, 8);
        this.addProperty.setLayoutData((Object)this.createWidgetData(0, 769));
        this.addProperty.setText(Messages.AddNewMetadataPropertyDialog_BUTTON_ADD);
        this.removeProperty = new Button(this.buttonComposite, 8);
        this.removeProperty.setLayoutData((Object)this.createWidgetData(0, 769));
        this.removeProperty.setText(Messages.AddNewMetadataPropertyDialog_BUTTON_REMOVE);
        this.addProperty.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                AddNewMetadataPropertyDialog.this.handleAddChildProperty();
                AddNewMetadataPropertyDialog.this.validate();
            }
        });
        this.removeProperty.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                AddNewMetadataPropertyDialog.this.handleRemoveChildProperty();
                AddNewMetadataPropertyDialog.this.validate();
            }
        });
        this.updateEnableState();
        this.propertyNameCombo.forceFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.addProperty_dialog");
        mainComposite.setTabList(tabList.toArray(new Control[0]));
        return mainComposite;
    }

    private void handleAddChildProperty() {
        ChildProperty newProperty = new ChildProperty();
        this.handleAddChildProperty(newProperty);
    }

    private void handleAddChildProperty(ChildProperty newProperty) {
        this.childList.add(newProperty);
        this.complexPropertyTableViewer.add((Object)newProperty);
        this.complexPropertyTableViewer.refresh();
        this.complexPropertyTableViewer.editElement((Object)newProperty, 0);
    }

    private void handleRemoveChildProperty() {
        StructuredSelection tableSelection = (StructuredSelection)this.complexPropertyTableViewer.getSelection();
        Object selectionObject = tableSelection.getFirstElement();
        if (selectionObject instanceof ChildProperty) {
            ChildProperty childSelection = (ChildProperty)selectionObject;
            this.handleRemoveChildProperty(childSelection);
        }
    }

    private void handleRemoveChildProperty(ChildProperty oldProperty) {
        this.childList.remove(oldProperty);
        this.complexPropertyTableViewer.refresh();
    }

    private void createTableViewer(Composite parent) {
        this.complexPropertyTableViewer = new TableViewer(parent, 68354);
        this.complexPropertyTableViewer.setUseHashlookup(true);
        this.complexPropertyTableViewer.setColumnProperties(this.columnNames);
        this.complexNameColumn = new TableViewerColumn(this.complexPropertyTableViewer, 0);
        this.complexNameColumn.getColumn().setText(Messages.AddNewMetadataPropertyDialog_COLUMN_NAME);
        this.complexNameColumn.getColumn().setWidth(100);
        this.complexNameColumn.setEditingSupport((EditingSupport)new MetadataPropertyTableEditingSupport((ColumnViewer)this.complexPropertyTableViewer, 0));
        this.complexTypeColumn = new TableViewerColumn(this.complexPropertyTableViewer, 0);
        this.complexTypeColumn.getColumn().setText(Messages.AddNewMetadataPropertyDialog_COLUMN_TYPE);
        this.complexTypeColumn.getColumn().setWidth(100);
        this.complexTypeColumn.setEditingSupport((EditingSupport)new MetadataPropertyTableEditingSupport((ColumnViewer)this.complexPropertyTableViewer, 1));
        this.complexPropertyTable = this.complexPropertyTableViewer.getTable();
        GridData tableData = this.createWidgetData();
        tableData.horizontalIndent = 30;
        tableData.widthHint = 200;
        tableData.heightHint = 100;
        this.complexPropertyTable.setLayoutData((Object)tableData);
        this.complexPropertyTable.setLinesVisible(true);
        this.complexPropertyTable.setHeaderVisible(true);
        this.complexPropertyTable.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.AddNewMetadataPropertyDialog_BUTTON_COMPLEXTYPE;
            }
        });
        this.complexPropertyTableViewer.setContentProvider((IContentProvider)new MetadataPropertyTableContentProvider());
        this.complexPropertyTableViewer.setLabelProvider((IBaseLabelProvider)new MetadataPropertyTableLabelProvider());
    }

    private Label createSpacer(Composite parent, int numColumns) {
        Label spacerLabel = new Label(parent, 0);
        spacerLabel.setLayoutData((Object)this.createWidgetData(numColumns));
        return spacerLabel;
    }

    private GridData createWidgetData() {
        return this.createWidgetData(0);
    }

    private GridData createWidgetData(int columnSpan) {
        return this.createWidgetData(columnSpan, 768);
    }

    private GridData createWidgetData(int columnSpan, int swtStyle) {
        GridData gd = new GridData(swtStyle);
        if (columnSpan > 0) {
            gd.horizontalSpan = columnSpan;
        }
        return gd;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.AddNewMetadataPropertyDialog_TITLE);
    }

    private List<ChildProperty> getChildProperties() {
        if (this.childList == null) {
            this.childList = new ArrayList<ChildProperty>();
        }
        return this.childList;
    }

    protected void okPressed() {
        if (this.resultProperty == null) {
            String propertyName = this.propertyNameCombo.getText();
            if (this.complexProperty.getSelection()) {
                ArrayList<TransportProperty> propertyList = new ArrayList<TransportProperty>();
                for (ChildProperty child : this.childList) {
                    TransportProperty newProperty = null;
                    String name = child.getChildPropertyName();
                    switch (child.getChildPropertyType()) {
                        case 1: {
                            newProperty = new TransportProperty(this.namespace, name, new TransportPropertyValue(Boolean.FALSE));
                            break;
                        }
                        case 2: {
                            newProperty = new TransportProperty(this.namespace, name, new TransportPropertyValue((Number)Double.valueOf("0")));
                            break;
                        }
                        case 0: {
                            newProperty = new TransportProperty(this.namespace, name, new TransportPropertyValue(""));
                            break;
                        }
                    }
                    if (newProperty == null) continue;
                    propertyList.add(newProperty);
                }
                this.resultProperty = new TransportProperty(this.namespace, propertyName, new TransportPropertyValue(propertyList));
            } else if (this.dependencyProperty.getSelection()) {
                ArrayList<TransportProperty> dependencyPropertyList = new ArrayList<TransportProperty>();
                dependencyPropertyList.add(new TransportProperty(this.namespace, "dependencyFileType", new TransportPropertyValue("dependencyFileType")));
                dependencyPropertyList.add(new TransportProperty(this.namespace, "dependencyLogicalName", new TransportPropertyValue("dependencyLogicalName")));
                dependencyPropertyList.add(new TransportProperty(this.namespace, "dependencyReferenceType", new TransportPropertyValue("dependencyReferenceType")));
                dependencyPropertyList.add(new TransportProperty(this.namespace, "dependencyPath", new TransportPropertyValue("dependencyPath")));
                this.resultProperty = new TransportProperty(this.namespace, "dependency", new TransportPropertyValue(dependencyPropertyList));
            } else if (this.booleanProperty.getSelection()) {
                this.resultProperty = new TransportProperty(this.namespace, propertyName, new TransportPropertyValue(Boolean.FALSE));
            } else if (this.stringProperty.getSelection()) {
                this.resultProperty = new TransportProperty(this.namespace, propertyName, new TransportPropertyValue(""));
            } else if (this.numberProperty.getSelection()) {
                this.resultProperty = new TransportProperty(this.namespace, propertyName, new TransportPropertyValue((Number)Double.valueOf("0")));
            }
        }
        if (this.resultProperty != null) {
            this.resultProperty.setUserAdded(true);
        }
        super.okPressed();
    }

    public TransportProperty getResultProperty() {
        return this.resultProperty;
    }

    private void updateEnableState() {
        boolean complexWidgetState = this.complexProperty.getSelection();
        this.buttonComposite.setEnabled(complexWidgetState);
        if (complexWidgetState && this.initialPropertyMap.containsKey(this.propertyNameCombo.getText())) {
            complexWidgetState = false;
        }
        if (complexWidgetState && !this.complexPropertyTable.isEnabled()) {
            this.complexPropertyTable.removeAll();
            this.childList.clear();
            this.validate();
        }
        this.complexPropertyTable.setEnabled(complexWidgetState);
        this.addProperty.setEnabled(complexWidgetState);
        this.removeProperty.setEnabled(complexWidgetState);
    }

    private void updatePropertyTypeEnableState(int enabledType) {
        if (enabledType == -1) {
            this.booleanProperty.setEnabled(true);
            this.stringProperty.setEnabled(true);
            this.numberProperty.setEnabled(true);
            this.dependencyProperty.setEnabled(true);
            this.complexProperty.setEnabled(true);
        } else {
            this.booleanProperty.setEnabled(enabledType == 1);
            this.booleanProperty.setSelection(enabledType == 1);
            this.stringProperty.setEnabled(enabledType == 0);
            this.stringProperty.setSelection(enabledType == 0);
            this.numberProperty.setEnabled(enabledType == 2);
            this.numberProperty.setSelection(enabledType == 2);
            this.dependencyProperty.setEnabled(false);
            this.dependencyProperty.setSelection(false);
            this.complexProperty.setEnabled(enabledType == 3);
            this.complexProperty.setSelection(enabledType == 3);
        }
        this.updateEnableState();
    }

    private void updateComplexPropertyTypeStructure(TransportProperty complexProperty) {
        if (complexProperty != null) {
            List structureProperties = complexProperty.getValue().getPropertyList();
            this.childList.clear();
            for (TransportProperty childProperty : structureProperties) {
                ChildProperty newProperty = new ChildProperty(false);
                newProperty.setChildPropertyName(childProperty.getLocalName());
                newProperty.setChildPropertyType(childProperty.getValue().getValueType());
                this.handleAddChildProperty(newProperty);
            }
        } else {
            this.childList.clear();
            this.complexPropertyTableViewer.refresh();
        }
    }

    private void validate() {
        this.updateStatus((IStatus)new Status(0, MetadataUIPlugin.getUniqueIdentifier(), ""));
        if (this.propertyNameCombo.getText().trim().equalsIgnoreCase("")) {
            this.updateStatus((IStatus)new Status(4, MetadataUIPlugin.getUniqueIdentifier(), Messages.AddNewMetadataPropertyDialog_ERROR_NONAME));
        } else {
            this.validatePropertyName();
            if (this.complexProperty.getSelection()) {
                if (this.childList.isEmpty()) {
                    this.updateStatus((IStatus)new Status(4, MetadataUIPlugin.getUniqueIdentifier(), Messages.AddNewMetadataPropertyDialog_ERROR_COMPLEX_NOCHILD));
                } else {
                    for (ChildProperty prop : this.childList) {
                        if (prop.getChildPropertyName().equalsIgnoreCase("")) {
                            this.updateStatus((IStatus)new Status(4, MetadataUIPlugin.getUniqueIdentifier(), Messages.AddNewMetadataPropertyDialog_ERROR_COMPLEX_NONAME));
                            continue;
                        }
                        if (!prop.getChildPropertyName().equalsIgnoreCase(Messages.ChildProperty_DEFAULTNAME)) continue;
                        this.updateStatus((IStatus)new Status(4, MetadataUIPlugin.getUniqueIdentifier(), Messages.AddNewMetadataPropertyDialog_ERROR_COMPLEX_DEFAULT));
                    }
                }
            } else if (this.dependencyProperty.getSelection() && !this.propertyNameCombo.getText().equalsIgnoreCase("dependency")) {
                this.updateStatus((IStatus)new Status(4, MetadataUIPlugin.getUniqueIdentifier(), Messages.AddNewMetadataPropertyDialog_ERROR_DEPENDENCY));
            }
        }
    }

    private void validatePropertyName() {
        String propertyNameString = this.propertyNameCombo.getText();
        try {
            new URI(propertyNameString);
        }
        catch (URISyntaxException e) {
            this.updateStatus((IStatus)new Status(4, MetadataUIPlugin.getUniqueIdentifier(), Messages.AddNewMetadataPropertyDialog_ERROR_SYNTAX));
            return;
        }
        if (propertyNameString.indexOf(".") != -1 || propertyNameString.indexOf(":") != -1 || propertyNameString.indexOf("\\") != -1) {
            this.updateStatus((IStatus)new Status(4, MetadataUIPlugin.getUniqueIdentifier(), Messages.AddNewMetadataPropertyDialog_ERROR_ILLEGAL_CHAR));
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource instanceof Button) {
            if (eventSource == this.dependencyProperty && this.dependencyProperty.getSelection()) {
                this.propertyNameCombo.setText("dependency");
            }
            if (eventSource == this.complexProperty) {
                this.handleAddChildProperty();
                this.complexPropertyTableViewer.getTable().setFocus();
                this.complexPropertyTableViewer.getTable().select(0);
                this.updateEnableState();
                this.getButton(0).setEnabled(false);
            }
            this.validate();
        } else if (eventSource == this.propertyNameCombo) {
            this.handleValidatePropertyNameCombo();
        }
    }

    private void handleValidatePropertyNameCombo() {
        String comboText = this.propertyNameCombo.getText();
        this.validatePropertyName();
        if (comboText.equalsIgnoreCase("dependency") && this.propertyNameCombo.isEnabled()) {
            this.booleanProperty.setEnabled(false);
            this.booleanProperty.setSelection(false);
            this.stringProperty.setEnabled(false);
            this.stringProperty.setSelection(false);
            this.numberProperty.setEnabled(false);
            this.numberProperty.setSelection(false);
            this.dependencyProperty.setEnabled(true);
            this.dependencyProperty.setSelection(true);
            this.complexProperty.setEnabled(false);
            this.complexProperty.setSelection(false);
        } else if (this.initialPropertyMap.containsKey(comboText)) {
            int propertyValueType = this.initialPropertyMap.get(comboText).getValue().getValueType();
            this.updatePropertyTypeEnableState(propertyValueType);
            if (propertyValueType == 3) {
                this.updateComplexPropertyTypeStructure(this.initialPropertyMap.get(comboText));
            } else {
                this.updateComplexPropertyTypeStructure(null);
            }
        } else {
            this.updatePropertyTypeEnableState(-1);
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button returnButton = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            returnButton.setText(Messages.AddNewMetadataPropertyDialog_BUTTON_OK);
        }
        return returnButton;
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (!this.initialState) {
            this.getButton(0).setEnabled(false);
            this.initialState = true;
        }
    }

    class MetadataPropertyTableContentProvider
    implements IStructuredContentProvider {
        private List<ChildProperty> providerList;

        MetadataPropertyTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.providerList != null) {
                return this.providerList.toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                this.providerList = (List)newInput;
            }
        }
    }

    class MetadataPropertyTableEditingSupport
    extends EditingSupport {
        private CellEditor editor;
        private final int column;

        MetadataPropertyTableEditingSupport(ColumnViewer viewer, int column) {
            super(viewer);
            switch (column) {
                case 0: {
                    this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                    break;
                }
                case 1: {
                    this.editor = new ComboBoxCellEditor((Composite)((TableViewer)viewer).getTable(), AddNewMetadataPropertyDialog.this.propertyTypes, 8);
                    break;
                }
                default: {
                    this.editor = null;
                }
            }
            this.column = column;
        }

        protected boolean canEdit(Object element) {
            return ((ChildProperty)element).isEditable;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            ChildProperty child = (ChildProperty)element;
            switch (this.column) {
                case 0: {
                    return child.getChildPropertyName();
                }
                case 1: {
                    return child.getChildPropertyType();
                }
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            ChildProperty child = (ChildProperty)element;
            switch (this.column) {
                case 0: {
                    child.setChildPropertyName(String.valueOf(value));
                    AddNewMetadataPropertyDialog.this.validate();
                    break;
                }
                case 1: {
                    child.setChildPropertyType((Integer)value);
                    break;
                }
            }
            this.getViewer().update(element, null);
        }
    }

    class MetadataPropertyTableLabelProvider
    implements ITableLabelProvider {
        MetadataPropertyTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ChildProperty) {
                ChildProperty property = (ChildProperty)element;
                if (columnIndex == 0) {
                    return property.getChildPropertyName();
                }
                if (columnIndex == 1) {
                    int propertyType = property.getChildPropertyType();
                    return propertyType >= 0 ? AddNewMetadataPropertyDialog.this.propertyTypes[propertyType] : null;
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

