/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.collection.action;

import com.ibm.team.enterprise.common.ui.TransportFileEditorInput;
import com.ibm.team.enterprise.common.ui.util.Utils;
import com.ibm.team.enterprise.metadata.client.collection.MetadataCollectionUtils;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportFile;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.collection.editors.MetadataCollectionEditorInput;
import com.ibm.team.enterprise.metadata.ui.collection.nls.Messages;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.internal.filesystem.ui.adapters.AbstractAdaptableRemoteResource;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class OpenDependencyEditorAction
extends Action
implements IObjectActionDelegate {
    private MetadataCollectionEditorInput input = null;
    private TransportFileEditorInput tfInput = null;
    private String errorMessage = null;
    protected IWorkbenchPart workbench;
    protected IStructuredSelection selection;

    public OpenDependencyEditorAction() {
        super(Messages.OpenDependencyEditorAction_TITLE);
    }

    public void run(final IFile file) {
        if (this.selection != null && !this.selection.isEmpty()) {
            this.errorMessage = null;
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            IWorkbenchPage page = win.getActivePage();
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("com.ibm.team.enterprise.metadata.collection.ui.collectionEditor");
            try {
                IProgressService ps = PlatformUI.getWorkbench().getProgressService();
                ps.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (file instanceof IFile) {
                            OpenDependencyEditorAction.this.setInput((IEditorInput)new MetadataCollectionEditorInput(file, monitor));
                        } else {
                            TransportFileEditorInput i = OpenDependencyEditorAction.this.createTransportFileEditorInput(monitor);
                            OpenDependencyEditorAction.this.setInput((IEditorInput)i);
                        }
                    }
                });
                if (this.input != null) {
                    if (this.input.getMetadataCollection() != null) {
                        page.openEditor((IEditorInput)this.input, desc.getId(), true, 3);
                    } else if (this.input.getInputFailureMessage() != null) {
                        this.errorMessage = this.input.getInputFailureMessage();
                    }
                } else if (this.tfInput != null) {
                    page.openEditor((IEditorInput)this.tfInput, desc.getId(), true, 3);
                }
                if (this.errorMessage != null) {
                    this.openErrorDialog((IStatus)new Status(4, MetadataUIPlugin.getUniqueIdentifier(), this.errorMessage));
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println(e.getStackTrace());
                e.printStackTrace();
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart workbench) {
        this.workbench = workbench;
    }

    public void run(IAction action) {
        IFile file = this.getFileFromSelection();
        this.run(file);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = (IStructuredSelection)selection;
    }

    private IFile getFileFromSelection() {
        Object context;
        if (this.selection != null && !this.selection.isEmpty() && (context = this.selection.getFirstElement()) instanceof IFile) {
            return (IFile)context;
        }
        return null;
    }

    private void openErrorDialog(IStatus errorStatus) {
        String errorTitleMessage = Messages.MetadataCollectionEditor_ERROR_GENERAL_TITLE;
        String errorDescriptionMessage = Messages.MetadataCollectionEditor_ERROR_GENERAL_DESCRIPTION;
        final ErrorDialog dialog = new ErrorDialog(null, errorTitleMessage, errorDescriptionMessage, errorStatus, 7);
        dialog.setBlockOnOpen(true);
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.open();
                }
            });
        } else {
            dialog.open();
        }
    }

    private void setInput(IEditorInput input) {
        if (input == null) {
            this.input = null;
            this.tfInput = null;
        } else if (input instanceof MetadataCollectionEditorInput) {
            this.input = (MetadataCollectionEditorInput)input;
        } else if (input instanceof TransportFileEditorInput) {
            this.tfInput = (TransportFileEditorInput)input;
        }
    }

    private TransportFileEditorInput createTransportFileEditorInput(IProgressMonitor monitor) {
        block11: {
            Object context;
            if (this.selection != null && !this.selection.isEmpty() && (context = this.selection.getFirstElement()) instanceof IAdaptable) {
                AbstractAdaptableRemoteResource aarr = (AbstractAdaptableRemoteResource)((IAdaptable)context).getAdapter(AbstractAdaptableRemoteResource.class);
                if (aarr != null) {
                    if (aarr.isUnshared()) {
                        this.errorMessage = Messages.MetadataCollectionEditor_ERROR_NOT_SHARED;
                    } else {
                        try {
                            IShareable shareable = (IShareable)aarr.getAdapter(IShareable.class);
                            IShare share = null;
                            try {
                                share = shareable.getShare((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                            }
                            catch (FileSystemException fileSystemException) {
                                // empty catch block
                            }
                            if (share == null) {
                                this.errorMessage = Messages.MetadataCollectionEditor_ERROR_NOT_SHARED;
                                break block11;
                            }
                            ITeamRepository repo = Utils.getTeamRepository((IShareable)shareable);
                            if (repo != null && repo.loggedIn()) {
                                MetadataCollectionUtils.MetadataClientArgs args = MetadataCollectionUtils.getMetadataClientArgs((IShareable)shareable);
                                TransportFile file = MetadataCollectionUtils.getSourceFileMetadata((IShareable)shareable, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                                return new TransportFileEditorInput(file, repo, args.getStreamId());
                            }
                            this.errorMessage = Messages.MetadataCollectionEditor_ERROR_LOGGED_OUT;
                        }
                        catch (TeamRepositoryException e) {
                            this.errorMessage = Messages.MetadataCollectionEditor_ERROR_UNKNOWN;
                            MetadataUIPlugin.log(e);
                        }
                    }
                } else {
                    this.errorMessage = Messages.MetadataCollectionEditor_ERROR_UNKNOWN;
                }
            }
        }
        return null;
    }
}

