/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui;

import com.ibm.team.enterprise.metadata.ui.Messages;
import com.ibm.team.enterprise.metadata.ui.query.QueryUISettings;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.JazzResources;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MetadataUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.team.enterprise.metadata.ui";
    private static final String MID_SHADOW = "com.ibm.team.workitem.ide.ui.MID_SHADOW";
    private static MetadataUIPlugin plugin;
    private QueryUISettings uiSettings;
    private ResourceManager fResourceManager;
    public static final int INTERNAL_ERROR = 120;

    public MetadataUIPlugin() {
        plugin = this;
    }

    public static MetadataUIPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static void log(Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = "";
        }
        MetadataUIPlugin.log((IStatus)new Status(4, MetadataUIPlugin.getUniqueIdentifier(), 4, message, exception));
    }

    public static void log(String message) {
        if (message == null) {
            message = "";
        }
        MetadataUIPlugin.log((IStatus)new Status(4, MetadataUIPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(IStatus status) {
        FoundationLog.log((IStatus)status);
    }

    public static void log(String message, Throwable exception) {
        MetadataUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, message, exception));
    }

    public void logError(String message) {
        this.logError(message, null);
    }

    public void logError(String message, Exception exception) {
        plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, (Throwable)exception));
    }

    public QueryUISettings getUISettings() {
        if (this.uiSettings == null) {
            this.uiSettings = new QueryUISettings(this.getDialogSettings());
        }
        return this.uiSettings;
    }

    public static Image getImage(String path) {
        ImageRegistry imageRegistry = MetadataUIPlugin.getDefault().getImageRegistry();
        Image image = imageRegistry.get(path);
        if (image == null) {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)MetadataUIPlugin.getUniqueIdentifier(), (String)path);
            imageRegistry.put(path, descriptor);
            image = imageRegistry.get(path);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageRegistry imageRegistry = MetadataUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor descriptor = imageRegistry.getDescriptor(path);
        if (descriptor == null) {
            descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)MetadataUIPlugin.getUniqueIdentifier(), (String)path);
            imageRegistry.put(path, descriptor);
        }
        return descriptor;
    }

    private ResourceManager getResourceManager() {
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.fResourceManager;
    }

    public static Image getImage(ImageDescriptor imageDesc) {
        return JazzResources.getImageWithDefault((ResourceManager)MetadataUIPlugin.getDefault().getResourceManager(), (ImageDescriptor)imageDesc);
    }

    public Color getMidShadow() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get(MID_SHADOW);
    }

    public static IStatus runInUI(final String name, final IRunnableWithProgress runnable, IProgressMonitor monitor) {
        if (Display.getCurrent() != null) {
            return MetadataUIPlugin.run(name, runnable, monitor);
        }
        FoundationUIJob job = new FoundationUIJob(name){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                return MetadataUIPlugin.run(name, runnable, monitor);
            }
        };
        job.setSystem(true);
        job.schedule();
        return Status.OK_STATUS;
    }

    public static IStatus run(String name, IRunnableWithProgress runnable, IProgressMonitor monitor) {
        try {
            runnable.run(monitor);
        }
        catch (InvocationTargetException x) {
            return new Status(4, PLUGIN_ID, 4, NLS.bind((String)Messages.MetadataUIPlugin_EXCEPTION_EXECUTING, (Object)name), (Throwable)x);
        }
        catch (InterruptedException x) {
            return new Status(8, PLUGIN_ID, 8, NLS.bind((String)Messages.MetadataUIPlugin_INTERRUPTED_EXECUTING, (Object)name), (Throwable)x);
        }
        return Status.OK_STATUS;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fResourceManager != null) {
                this.fResourceManager.dispose();
                this.fResourceManager = null;
            }
            Job.getJobManager().cancel((Object)plugin);
        }
        finally {
            super.stop(context);
        }
    }
}

