/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.utils;

import java.util.Map;
import java.util.Set;

public class FileTypeClassification {
    private Map<Integer, String> attcList = null;
    private Map<Integer, Integer> attnList = null;
    private Map<Integer, Set<String>> inclList = null;
    private static final String FILE_TYPE_CD_DBD = "DBD";
    private static final String FILE_TYPE_CD_MAC = "MAC";
    private static final String FILE_TYPE_CD_MAIN = "MAIN";
    private static final String FILE_TYPE_CD_MAP = "MAP";
    private static final String FILE_TYPE_CD_MFS = "MFS";
    private static final String FILE_TYPE_CD_PSB = "PSB";
    public static final String FILE_TYPE_CD_UNKNOWN = "UNKN";
    public static final String FILE_TYPE_CD_INCL = "INCL";
    public static final String FILE_TYPE_CD_PROC = "PROC";

    public FileTypeClassification(Map<Integer, String> iAttcList, Map<Integer, Integer> iAttnList, Map<Integer, Set<String>> iInclList) {
        this.attcList = iAttcList;
        this.attnList = iAttnList;
        this.inclList = iInclList;
    }

    private String checkAsmFileTypeCd() {
        if (this.attnList != null) {
            if (this.attnList.containsKey(39) && this.attnList.get(39) == 0) {
                return FILE_TYPE_CD_MAC;
            }
            if (this.attnList.containsKey(65)) {
                return FILE_TYPE_CD_MAP;
            }
            if (this.attnList.containsKey(87)) {
                return FILE_TYPE_CD_MFS;
            }
        }
        if (this.inclList != null && this.inclList.containsKey(8)) {
            if (this.inclList.get(8).contains("DBDGEN")) {
                return FILE_TYPE_CD_DBD;
            }
            if (this.inclList.get(8).contains("PSBGEN")) {
                return FILE_TYPE_CD_PSB;
            }
        }
        if (this.fileContainsEntry()) {
            return FILE_TYPE_CD_MAIN;
        }
        return FILE_TYPE_CD_INCL;
    }

    private String classifyAsm() {
        boolean rc = false;
        String fileTypeCd = this.checkAsmFileTypeCd();
        if (!fileTypeCd.equals(FILE_TYPE_CD_INCL)) {
            return fileTypeCd;
        }
        rc = this.doIncludedFilesContainEntry();
        if (rc) {
            return FILE_TYPE_CD_MAIN;
        }
        return FILE_TYPE_CD_INCL;
    }

    private String classifyCobol() {
        if (this.attnList != null && this.attnList.containsKey(34)) {
            return FILE_TYPE_CD_MAIN;
        }
        return FILE_TYPE_CD_INCL;
    }

    private String classifyJcl() {
        if (this.attnList != null) {
            if (this.attnList.containsKey(39) && this.attnList.get(39) == 0) {
                return FILE_TYPE_CD_PROC;
            }
            if (this.attnList.containsKey(52)) {
                return FILE_TYPE_CD_MAIN;
            }
        }
        return FILE_TYPE_CD_INCL;
    }

    private String classifyPli() {
        if (this.attcList != null && this.attcList.containsKey(56) && this.attcList.get(56).equals(FILE_TYPE_CD_MAIN)) {
            return FILE_TYPE_CD_MAIN;
        }
        return FILE_TYPE_CD_INCL;
    }

    private boolean doIncludedFilesContainEntry() {
        boolean rc = false;
        return rc;
    }

    private boolean fileContainsEntry() {
        if (this.attnList != null && (this.attnList.containsKey(46) || this.attnList.containsKey(57) || this.attnList.containsKey(47) || this.attnList.containsKey(82) || this.attnList.containsKey(84) || this.attnList.containsKey(85) || this.attnList.containsKey(86) || this.attnList.containsKey(58))) {
            return true;
        }
        return this.inclList != null && this.inclList.containsKey(8) && this.inclList.get(8).contains("DFHEIENT");
    }

    public String identifyFileType(String iLanguageCd) {
        if (iLanguageCd.equals("ASM")) {
            return this.classifyAsm();
        }
        if (iLanguageCd.equals("COB")) {
            return this.classifyCobol();
        }
        if (iLanguageCd.equals("JCL")) {
            return this.classifyJcl();
        }
        if (iLanguageCd.equals("PLI")) {
            return this.classifyPli();
        }
        return FILE_TYPE_CD_UNKNOWN;
    }
}

