/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.previous;

import com.ibm.team.enterprise.zos.metadata.common.classify.cfgmgr.ConfigEntry;
import com.ibm.team.enterprise.zos.metadata.common.classify.cfgmgr.ConfigFile;
import com.ibm.team.enterprise.zos.metadata.common.classify.cfgmgr.ConfigRuntimeException;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierASM;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierC;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierCOB;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierCPP;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierEASY;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierJCL;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierMetaDataHelper;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierPLI;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierXML;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.SingleFileMetadata;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.metadata.ScannerData;
import com.ibm.team.enterprise.zos.metadata.common.classify.utils.FileHandler;
import com.ibm.team.enterprise.zos.metadata.common.classify.utils.FileTypeClassification;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class dmh5210 {
    private static final String dd_output = "DD:ATTRBOUT";
    public static final int RD_COMMENT_LINES = 27;
    public static final int RD_NONCOMMENT_LINES = 28;
    public static final int RD_BLANK_LINES = 29;
    public static final int RD_NONCOMNT_BEF_1ST = 39;
    public static final int RD_NONCOMNT_AFT_1ST = 40;
    public static final int RD_PROC_DEF = 63;
    public static final int DMH_RECORD_COUNT_MEM = 106;
    private final int LANGUAGE_CD_ASM = 1;
    private final int LANGUAGE_CD_BINARY = 2;
    private final int LANGUAGE_CD_COBOL = 3;
    private final int LANGUAGE_CD_EASYTRIEVE = 4;
    private final int LANGUAGE_CD_EMPTY = 5;
    private final int LANGUAGE_CD_GONE = 6;
    private final int LANGUAGE_CD_JCL = 7;
    private final int LANGUAGE_CD_PLI = 8;
    private final int LANGUAGE_CD_UNKN = 9;
    private final int LANGUAGE_CD_C = 10;
    private final int LANGUAGE_CD_CPP = 11;
    private final int INREC_LENGTH = 259;
    private final String STR_ASM = "ASM";
    private final String STR_BIN = "BIN";
    private final String STR_C = "C";
    private final String STR_COB = "COB";
    private final String STR_CPP = "CPP";
    private final String STR_EASY = "EASY";
    private final String STR_EMP = "EMP?";
    private final String STR_GONE = "GONE";
    private final String STR_JCL = "JCL";
    private final String STR_PLI = "PLI";
    public final String STR_UNKN = "UNKN";
    private final String STR_XML = "XML";
    private final String aipAnalyzers = "/com/ibm/team/enterprise/zos/metadata/common/classify/aipAnalyzers";
    private boolean extensionDrivesScan;
    private boolean firstAttr = true;
    private boolean isWindows;
    private ClassifierMetaDataHelper dmh5211;
    private final ClassifierJCL dmh5212 = new ClassifierJCL();
    private final ClassifierCOB dmh5213 = new ClassifierCOB();
    private final ClassifierPLI dmh5214 = new ClassifierPLI();
    private final ClassifierASM dmh5215 = new ClassifierASM();
    private final ClassifierEASY dmh5216 = new ClassifierEASY();
    private final ClassifierC classifierC = new ClassifierC();
    private final ClassifierCPP classifierCPP = new ClassifierCPP();
    private int lineCount = 0;
    private int MaximumSeverity;
    private int winlang;
    private PrintWriter out = null;
    private ScannerData scannerData = null;
    private String check_ContentMIMEType;
    private String check_FileExtension;
    private String check_LanguageCd;
    private String containerName;
    private String fileName;
    private String inrec;
    private String languageCd;
    private String localName;
    private String rmDDName;
    private String rmType;
    private String siteName;
    private String stCurrentContainerNameNoQuotes;
    private String stCurrentRmType;
    private String[] fileRecords = null;
    private StringBuffer jsonStringBuffer;

    dmh5210() {
    }

    private boolean assignLanguageBasedOnExtension(String iLanguageCd, String iFileSpecText, String iFileContent) {
        if (this.check_LanguageCd.equals("ASM") || this.check_LanguageCd.equals("COB") || this.check_LanguageCd.equals("EASY") || this.check_LanguageCd.equals("JCL") || this.check_LanguageCd.equals("PLI")) {
            this.extensionDrivesScan = true;
            return false;
        }
        if (iLanguageCd.length() != 0) {
            this.check_LanguageCd = iLanguageCd;
            return false;
        }
        if (!this.DMHIOAPI_CheckIfMemberExists(iFileSpecText, iFileContent)) {
            this.EOF_GONE_Member();
            return true;
        }
        if (this.check_LanguageCd.length() != 0) {
            int lineCount = 0;
            if (this.check_ContentMIMEType.contains("text") && (lineCount = this.CountLinesInFile(iFileContent)) == 0) {
                this.EOF_EMPTY_Member();
                return true;
            }
            this.dmh5211.setLanguageCd(this.check_LanguageCd);
            ClassifierMetaData metaData = new ClassifierMetaData();
            metaData.setLanguageCd(this.check_LanguageCd);
            metaData.setTotalLine(lineCount);
            this.dmh5211.setMetaData(metaData);
            return true;
        }
        this.check_LanguageCd = "UNKN";
        return false;
    }

    private void CaptureMarginsForPLI(String iParm) {
        int m = 0;
        int n = 0;
        String margins = "";
        margins = iParm;
        if (m < 1 || m > 100) {
            return;
        }
        if (n > m) {
            // empty if block
        }
    }

    private boolean checkFileExtension(String iFileNameNoQuotes) {
        String charValue;
        int pChar = iFileNameNoQuotes.lastIndexOf(46);
        if (pChar == -1) {
            return false;
        }
        if (iFileNameNoQuotes.substring(pChar).length() == 1) {
            return false;
        }
        this.check_FileExtension = iFileNameNoQuotes.substring(pChar + 1);
        String workFileExtension = charValue = this.check_FileExtension.toUpperCase();
        boolean foundExtensionMatch = false;
        boolean foundLanguageCd = false;
        String cfgSection = "";
        String currentCfgSection = null;
        String contentMIMEType = "";
        String languageCd = "";
        Map<String, String> values = this.getConfigMap("/com/ibm/team/enterprise/zos/metadata/common/classify/aipAnalyzers");
        TreeSet<String> keys = new TreeSet<String>(values.keySet());
        block0: for (String key : keys) {
            String value = values.get(key);
            int index = key.indexOf(46);
            if (index == -1) {
                cfgSection = "";
            } else {
                cfgSection = key.substring(0, index);
                key = key.substring(index + 1);
            }
            if (currentCfgSection == null) {
                currentCfgSection = cfgSection;
            } else if (!currentCfgSection.equals(cfgSection)) {
                if (foundExtensionMatch && foundLanguageCd) break;
                foundExtensionMatch = false;
                foundLanguageCd = false;
                contentMIMEType = "";
                languageCd = "";
                currentCfgSection = cfgSection;
            }
            if (key.equals("contentMIMEType")) {
                contentMIMEType = value;
                continue;
            }
            if (key.equals("fileExts")) {
                String[] tempString = value.split(",");
                int i = 0;
                while (i < tempString.length) {
                    charValue = tempString[i].toUpperCase();
                    if (charValue.equals(workFileExtension)) {
                        foundExtensionMatch = true;
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            if (!key.equals("languageCd")) continue;
            foundLanguageCd = true;
            languageCd = value;
        }
        if (foundExtensionMatch && languageCd.length() != 0) {
            this.check_ContentMIMEType = contentMIMEType;
            this.check_LanguageCd = languageCd;
        }
        return true;
    }

    private boolean checkForBlankLine() {
        String temp = this.inrec.trim();
        if (temp.length() != 0) {
            return false;
        }
        this.dmh5212.incrementBlankCount();
        this.dmh5213.incrementBlankCount();
        this.dmh5214.incrementBlankCount();
        this.dmh5215.incrementBlankCount();
        this.dmh5216.incrementBlankCount();
        this.classifierC.incrementBlankCount();
        this.classifierCPP.incrementBlankCount();
        return true;
    }

    private boolean CheckRexxExecIdentifier() {
        String pChar = this.inrec.trim();
        if (!pChar.startsWith("/*")) {
            return false;
        }
        pChar = pChar.substring(2);
        pChar = pChar.toUpperCase();
        return pChar.contains("REXX");
    }

    private boolean CheckForExactMatchScores() {
        boolean rc = true;
        if (this.classifierC.getScore() != 0) {
            if (this.classifierCPP.getScore() != 0 && this.classifierC.getScore() != this.classifierCPP.getScore()) {
                rc = false;
            }
            if (this.dmh5216.getScore() != 0 && this.classifierC.getScore() != this.dmh5216.getScore()) {
                rc = false;
            }
            if (this.dmh5215.getScore() != 0 && this.classifierC.getScore() != this.dmh5215.getScore()) {
                rc = false;
            }
            if (this.dmh5214.getScore() != 0 && this.classifierC.getScore() != this.dmh5214.getScore()) {
                rc = false;
            }
            if (this.dmh5213.getScore() != 0 && this.classifierC.getScore() != this.dmh5213.getScore()) {
                rc = false;
            }
            if (this.dmh5212.getScore() != 0 && this.classifierC.getScore() != this.dmh5212.getScore()) {
                rc = false;
            }
        } else if (this.classifierCPP.getScore() != 0) {
            if (this.dmh5216.getScore() != 0 && this.classifierCPP.getScore() != this.dmh5216.getScore()) {
                rc = false;
            }
            if (this.dmh5215.getScore() != 0 && this.classifierCPP.getScore() != this.dmh5215.getScore()) {
                rc = false;
            }
            if (this.dmh5214.getScore() != 0 && this.classifierCPP.getScore() != this.dmh5214.getScore()) {
                rc = false;
            }
            if (this.dmh5213.getScore() != 0 && this.classifierCPP.getScore() != this.dmh5213.getScore()) {
                rc = false;
            }
            if (this.dmh5212.getScore() != 0 && this.classifierCPP.getScore() != this.dmh5212.getScore()) {
                rc = false;
            }
        } else if (this.dmh5216.getScore() != 0) {
            if (this.dmh5215.getScore() != 0 && this.dmh5216.getScore() != this.dmh5215.getScore()) {
                rc = false;
            }
            if (this.dmh5214.getScore() != 0 && this.dmh5216.getScore() != this.dmh5214.getScore()) {
                rc = false;
            }
            if (this.dmh5213.getScore() != 0 && this.dmh5216.getScore() != this.dmh5213.getScore()) {
                rc = false;
            }
            if (this.dmh5212.getScore() != 0 && this.dmh5216.getScore() != this.dmh5212.getScore()) {
                rc = false;
            }
        } else if (this.dmh5215.getScore() != 0) {
            if (this.dmh5214.getScore() != 0 && this.dmh5215.getScore() != this.dmh5214.getScore()) {
                rc = false;
            }
            if (this.dmh5213.getScore() != 0 && this.dmh5215.getScore() != this.dmh5213.getScore()) {
                rc = false;
            }
            if (this.dmh5212.getScore() != 0 && this.dmh5215.getScore() != this.dmh5212.getScore()) {
                rc = false;
            }
        } else if (this.dmh5214.getScore() != 0) {
            if (this.dmh5213.getScore() != 0 && this.dmh5214.getScore() != this.dmh5213.getScore()) {
                rc = false;
            }
            if (this.dmh5212.getScore() != 0 && this.dmh5214.getScore() != this.dmh5212.getScore()) {
                rc = false;
            }
        } else if (this.dmh5213.getScore() != 0 && this.dmh5212.getScore() != 0 && this.dmh5213.getScore() != this.dmh5212.getScore()) {
            rc = false;
        }
        return rc;
    }

    private boolean checkIfXML(String iFileContent) {
        ClassifierXML classifierXML = new ClassifierXML();
        return classifierXML.isFileXML(iFileContent);
    }

    private boolean ChooseALanguageCode() {
        double totalScore = this.dmh5212.getScore() + this.dmh5213.getScore() + this.dmh5214.getScore() + this.dmh5215.getScore() + this.dmh5216.getScore() + this.classifierC.getScore() + this.classifierCPP.getScore();
        if (totalScore == 0.0) {
            return false;
        }
        int winscore = 0;
        if (this.dmh5215.getScore() > winscore) {
            winscore = this.dmh5215.getScore();
            this.winlang = 1;
        }
        if (this.dmh5213.getScore() > winscore) {
            winscore = this.dmh5213.getScore();
            this.winlang = 3;
        }
        if (this.dmh5216.getScore() > winscore) {
            winscore = this.dmh5216.getScore();
            this.winlang = 4;
        }
        if (this.dmh5212.getScore() > winscore) {
            winscore = this.dmh5212.getScore();
            this.winlang = 7;
        }
        if (this.dmh5214.getScore() > winscore) {
            winscore = this.dmh5214.getScore();
            this.winlang = 8;
        }
        if (this.classifierC.getScore() > winscore) {
            winscore = this.classifierC.getScore();
            this.winlang = 10;
        }
        if (this.classifierCPP.getScore() > winscore) {
            winscore = this.classifierCPP.getScore();
            this.winlang = 11;
        }
        if (totalScore == (double)winscore) {
            if ((double)winscore < (double)this.lineCount * 0.05) {
                this.winlang = 9;
                return false;
            }
            return true;
        }
        if (this.CheckForExactMatchScores()) {
            this.winlang = 9;
            return false;
        }
        double tieBreakScore = this.dmh5216.getScore() != 0 ? totalScore * 0.4 : totalScore * 0.5;
        if ((double)winscore >= tieBreakScore) {
            return true;
        }
        if (this.winlang == 1 && this.dmh5215.hasMACRO_MEND()) {
            return true;
        }
        this.winlang = 9;
        return false;
    }

    private void ClearBadLanguageScores() {
        this.classifierC.isScoreBad(this.lineCount);
        this.classifierCPP.isScoreBad(this.lineCount);
        this.dmh5212.isScoreBad(this.lineCount);
        this.dmh5213.isScoreBad(this.lineCount);
        this.dmh5214.isScoreBad(this.lineCount);
        this.dmh5215.isScoreBad(this.lineCount);
        this.dmh5216.isScoreBad(this.lineCount);
        this.IsPLI_StillBad();
    }

    private int CountLinesInFile(String iFileContent) {
        int lineCount = 0;
        this.fileRecords = iFileContent.split("\n");
        while (this.DMHIOAPI_GetRecord(lineCount)) {
            ++lineCount;
        }
        return lineCount;
    }

    private void EchoParameters(String[] iArgs) {
        int i = 1;
        while (i < iArgs.length) {
            ++i;
        }
    }

    private void EOF_Asm_Member() {
        this.dmh5211.setLanguageCd("ASM");
        ClassifierMetaData metaData = this.dmh5215.processEndOfFile(this.lineCount);
        metaData.setLanguageCd("ASM");
        this.dmh5211.setMetaData(metaData);
        String workString = "ASM";
        if (this.dmh5215.hasBMSmacro()) {
            workString = String.valueOf(workString) + " (BMS macro)";
        } else if (this.dmh5215.hasDBDGENstatement()) {
            workString = String.valueOf(workString) + " (DBDGEN)";
        } else if (this.dmh5215.hasPSBGENstatement()) {
            workString = String.valueOf(workString) + " (PSBGEN)";
        }
    }

    private void EOF_Cobol_Member() {
        this.dmh5211.setLanguageCd("COB");
        ClassifierMetaData metaData = this.dmh5213.processEndOfFile(this.lineCount);
        metaData.setLanguageCd("COB");
        this.dmh5211.setMetaData(metaData);
    }

    private void EOF_C_Member() {
        this.dmh5211.setLanguageCd("C");
        ClassifierMetaData metaData = this.classifierC.processEndOfFile(this.lineCount);
        metaData.setLanguageCd("C");
        this.dmh5211.setMetaData(metaData);
    }

    private void EOF_CPP_Member() {
        this.dmh5211.setLanguageCd("CPP");
        ClassifierMetaData metaData = this.classifierCPP.processEndOfFile(this.lineCount);
        metaData.setLanguageCd("CPP");
        this.dmh5211.setMetaData(metaData);
    }

    private void EOF_Easytrieve_Member() {
        this.dmh5211.setLanguageCd("EASY");
        ClassifierMetaData metaData = this.dmh5216.processEndOfFile(this.lineCount);
        metaData.setLanguageCd("EASY");
        this.dmh5211.setMetaData(metaData);
    }

    private void EOF_EMPTY_Member() {
        this.dmh5211.setLanguageCd("EMP?");
        ClassifierMetaData metaData = new ClassifierMetaData();
        metaData.setLanguageCd("EMP?");
        this.dmh5211.setMetaData(metaData);
    }

    private void EOF_GONE_Member() {
        this.dmh5211.setLanguageCd("GONE");
        ClassifierMetaData metaData = new ClassifierMetaData();
        metaData.setLanguageCd("GONE");
        this.dmh5211.setMetaData(metaData);
    }

    private void EOF_Jcl_Member() {
        this.dmh5211.setLanguageCd("JCL");
        ClassifierMetaData metaData = this.dmh5212.processEndOfFile(this.lineCount);
        metaData.setLanguageCd("JCL");
        this.dmh5211.setMetaData(metaData);
    }

    private void EOF_PLI_Member() {
        this.dmh5211.setLanguageCd("PLI");
        ClassifierMetaData metaData = this.dmh5214.processEndOfFile(this.lineCount);
        metaData.setLanguageCd("PLI");
        this.dmh5211.setMetaData(metaData);
    }

    private void EOF_UNK_Member() {
        this.dmh5211.setLanguageCd("UNKN");
        ClassifierMetaData metaData = new ClassifierMetaData();
        metaData.setLanguageCd("UNKN");
        this.dmh5211.setMetaData(metaData);
    }

    private void FreeReservedWords() {
        this.dmh5212.resetReservedWords();
        this.dmh5213.resetReservedWords();
        this.dmh5214.resetReservedWords();
        this.dmh5215.resetReservedWords();
        this.dmh5216.resetReservedWords();
        this.classifierC.resetReservedWords();
        this.classifierCPP.resetReservedWords();
    }

    private ConfigFile getConfigFile(String filename) throws ConfigRuntimeException {
        InputStream inputStream;
        if (filename.indexOf(46) == -1) {
            filename = String.valueOf(filename) + ".cfg";
        }
        if ((inputStream = this.getClass().getResourceAsStream(filename)) == null) {
            throw new ConfigRuntimeException("Could not getResourceAsStream() for [" + filename + "]");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        ConfigFile c = new ConfigFile(dataInputStream);
        if (c == null) {
            throw new ConfigRuntimeException("Could not create ConfigFile() for [" + filename + "]");
        }
        return c;
    }

    private Map<String, String> getConfigMap(String config) throws ConfigRuntimeException {
        TreeMap<String, String> m = new TreeMap<String, String>();
        ConfigFile c = this.getConfigFile(config);
        Map<String, ConfigEntry> valueMap = c.getAllValuesMap();
        for (String key : valueMap.keySet()) {
            m.put(key, valueMap.get(key).getValue());
        }
        return m;
    }

    public String getFileTypeCd() {
        return this.dmh5211.getFileTypeCd();
    }

    public String getLanguageCd() {
        return this.dmh5211.getLanguageCd();
    }

    public void init() {
        this.containerName = "";
        this.dmh5211 = new ClassifierMetaDataHelper();
        this.fileName = "";
        this.firstAttr = true;
        this.languageCd = "";
        this.localName = "";
        this.rmDDName = "";
        this.rmType = "";
        this.siteName = "";
        this.stCurrentContainerNameNoQuotes = null;
        this.stCurrentRmType = null;
        this.winlang = 9;
        this.ResetMaximumSeverity();
    }

    private void InitializeFields(String iFileName) {
        this.winlang = 9;
        this.dmh5211.setMemberName(iFileName);
        this.dmh5212.setIdentifier('N');
        this.dmh5212.setBlankCount(0);
        this.dmh5213.setIdentifier('N');
        this.dmh5213.setBlankCount(0);
        this.dmh5214.setIdentifier('N');
        this.dmh5214.setBlankCount(0);
        this.dmh5215.setIdentifier('N');
        this.dmh5215.setBlankCount(0);
        this.dmh5216.setIdentifier('N');
        this.dmh5216.setBlankCount(0);
        this.classifierC.setIdentifier('N');
        this.classifierC.setBlankCount(0);
        this.classifierCPP.setIdentifier('N');
        this.classifierCPP.setBlankCount(0);
    }

    private void InitializeLanguageValidators(String iLanguageCd) {
        if (iLanguageCd != null && iLanguageCd.length() != 0) {
            if (iLanguageCd.equals("ASM")) {
                this.dmh5215.processInitialization();
                this.dmh5215.setIdentifier('U');
                return;
            }
            if (iLanguageCd.equals("COB")) {
                this.dmh5213.processInitialization();
                this.dmh5213.setIdentifier('U');
                return;
            }
            if (iLanguageCd.equals("C")) {
                this.classifierC.processInitialization();
                this.classifierC.setIdentifier('U');
                return;
            }
            if (iLanguageCd.equals("CPP")) {
                this.classifierCPP.processInitialization();
                this.classifierCPP.setIdentifier('U');
                return;
            }
            if (iLanguageCd.equals("EASY")) {
                this.dmh5216.processInitialization();
                this.dmh5216.setIdentifier('U');
                return;
            }
            if (iLanguageCd.equals("JCL")) {
                this.dmh5212.processInitialization();
                this.dmh5212.setIdentifier('U');
                return;
            }
            if (iLanguageCd.equals("PLI")) {
                this.dmh5214.processInitialization();
                this.dmh5214.setIdentifier('U');
                return;
            }
        }
        this.dmh5212.processInitialization();
        this.dmh5212.setIdentifier('U');
        this.dmh5213.processInitialization();
        this.dmh5213.setIdentifier('U');
        this.dmh5214.processInitialization();
        this.dmh5214.setIdentifier('U');
        this.dmh5215.processInitialization();
        this.dmh5215.setIdentifier('U');
        this.dmh5216.processInitialization();
        this.dmh5216.setIdentifier('U');
        this.classifierC.processInitialization();
        this.classifierC.setIdentifier('U');
        this.classifierCPP.processInitialization();
        this.classifierCPP.setIdentifier('U');
    }

    private void IsPLI_StillBad() {
        if (this.dmh5214.getScore() == 0) {
            return;
        }
        if (this.dmh5214.getReserveWordCount() >= this.lineCount / 2 && (this.dmh5215.getScore() != 0 && this.dmh5215.getReserveWordCount() != 0 || this.dmh5213.getScore() != 0 && (this.dmh5213.getVerbCount() != 0 || this.dmh5213.getPictureCount() != 0 || this.dmh5213.getCompilerDirectingCount() != 0) || this.dmh5216.getScore() != 0 && (this.dmh5216.getReserveWordCount() != 0 || !this.dmh5216.getEasyMajorKeyWordFound()) || this.dmh5212.getScore() != 0 && this.dmh5212.getReserveWordCount() != 0) && !this.dmh5214.HasSemicolon()) {
            this.dmh5214.setScore(0);
        }
    }

    private void MemoryStructureCleanup() {
        if (this.dmh5212.getIdentifier() != 'D') {
            this.dmh5212.processDeallocate();
            this.dmh5212.setIdentifier('D');
        }
        if (this.dmh5213.getIdentifier() != 'D') {
            this.dmh5213.processDeallocate();
            this.dmh5213.setIdentifier('D');
        }
        if (this.dmh5214.getIdentifier() != 'D') {
            this.dmh5214.processDeallocate();
            this.dmh5214.setIdentifier('D');
        }
        if (this.dmh5215.getIdentifier() != 'D') {
            this.dmh5215.processDeallocate();
            this.dmh5215.setIdentifier('D');
        }
        if (this.dmh5216.getIdentifier() != 'D') {
            this.dmh5216.processDeallocate();
            this.dmh5216.setIdentifier('D');
        }
        if (this.classifierC.getIdentifier() != 'D') {
            this.classifierC.processDeallocate();
            this.classifierC.setIdentifier('D');
        }
        if (this.classifierCPP.getIdentifier() != 'D') {
            this.classifierCPP.processDeallocate();
            this.classifierCPP.setIdentifier('D');
        }
    }

    /*
     * Unable to fully structure code
     */
    private void MemberProcessor(String iLanguageCd, String iFileContent) {
        returnNow = false;
        recordRead = this.ReadTheInputFile();
        if (recordRead && this.fileRecords.length != 0) ** GOTO lbl127
        return;
lbl-1000:
        // 1 sources

        {
            ++this.lineCount;
            if (this.dmh5212.getIdentifier() == 'N' && this.dmh5213.getIdentifier() == 'N' && this.dmh5214.getIdentifier() == 'N' && this.dmh5215.getIdentifier() == 'N' && this.dmh5216.getIdentifier() == 'N' && this.classifierC.getIdentifier() == 'N' && this.classifierCPP.getIdentifier() == 'N') {
                returnNow = true;
                break;
            }
            if (this.checkForBlankLine()) {
                recordRead = this.ReadTheInputFile();
                continue;
            }
            if (this.lineCount == 1 && this.CheckRexxExecIdentifier()) break;
            if (this.winlang == 9) {
                if (this.dmh5212.getIdentifier() != 'N') {
                    if (this.dmh5212.getIgnoreCase()) {
                        this.dmh5212.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                    } else {
                        this.dmh5212.process(this.lineCount, this.inrec, iLanguageCd);
                    }
                }
                if (this.dmh5213.getIdentifier() != 'N') {
                    if (this.dmh5213.getIgnoreCase()) {
                        this.dmh5213.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                    } else {
                        this.dmh5213.process(this.lineCount, this.inrec, iLanguageCd);
                    }
                }
                if (this.dmh5214.getIdentifier() != 'N') {
                    if (this.dmh5214.getIgnoreCase()) {
                        this.dmh5214.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                    } else {
                        this.dmh5214.process(this.lineCount, this.inrec, iLanguageCd);
                    }
                }
                if (this.dmh5215.getIdentifier() != 'N') {
                    if (this.dmh5215.getIgnoreCase()) {
                        this.dmh5215.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                    } else {
                        this.dmh5215.process(this.lineCount, this.inrec, iLanguageCd);
                    }
                }
                if (this.dmh5216.getIdentifier() != 'N') {
                    if (this.dmh5216.getIgnoreCase()) {
                        this.dmh5216.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                    } else {
                        this.dmh5216.process(this.lineCount, this.inrec, iLanguageCd);
                    }
                }
                if (this.classifierC.getIdentifier() != 'N') {
                    if (this.classifierC.getIgnoreCase()) {
                        this.classifierC.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                    } else {
                        this.classifierC.process(this.lineCount, this.inrec, iLanguageCd);
                    }
                }
                if (this.classifierCPP.getIdentifier() != 'N') {
                    if (this.classifierCPP.getIgnoreCase()) {
                        this.classifierCPP.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                    } else {
                        this.classifierCPP.process(this.lineCount, this.inrec, iLanguageCd);
                    }
                }
                if (this.dmh5215.getIdentifier() == 'Y') {
                    this.winlang = 1;
                    break;
                }
                if (this.dmh5213.getIdentifier() == 'Y') {
                    this.winlang = 3;
                    break;
                }
                if (this.dmh5216.getIdentifier() == 'Y') {
                    this.winlang = 4;
                    break;
                }
                if (this.dmh5212.getIdentifier() == 'Y') {
                    this.winlang = 7;
                    break;
                }
                if (this.dmh5214.getIdentifier() == 'Y') {
                    this.winlang = 8;
                    break;
                }
                if (this.classifierC.getIdentifier() == 'Y') {
                    this.winlang = 10;
                    break;
                }
                if (this.classifierCPP.getIdentifier() == 'Y') {
                    this.winlang = 11;
                    break;
                }
                recordRead = this.ReadTheInputFile();
                continue;
            }
            if (this.winlang == 1) {
                if (this.dmh5215.getIdentifier() == 'U') {
                    if (this.dmh5215.getIgnoreCase()) {
                        this.dmh5215.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                    } else {
                        this.dmh5215.process(this.lineCount, this.inrec, iLanguageCd);
                    }
                }
                this.dmh5215.setIdentifier('Y');
                break;
            }
            if (this.winlang == 3) {
                if (this.dmh5213.getIdentifier() == 'U') {
                    if (this.dmh5213.getIgnoreCase()) {
                        this.dmh5213.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                    } else {
                        this.dmh5213.process(this.lineCount, this.inrec, iLanguageCd);
                    }
                }
                this.dmh5213.setIdentifier('Y');
                break;
            }
            if (this.winlang == 4) {
                if (this.dmh5216.getIdentifier() == 'U') {
                    if (this.dmh5216.getIgnoreCase()) {
                        this.dmh5216.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                    } else {
                        this.dmh5216.process(this.lineCount, this.inrec, iLanguageCd);
                    }
                }
                this.dmh5216.setIdentifier('Y');
                break;
            }
            if (this.winlang == 7) {
                if (this.dmh5212.getIdentifier() == 'U') {
                    if (this.dmh5212.getIgnoreCase()) {
                        this.dmh5212.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                    } else {
                        this.dmh5212.process(this.lineCount, this.inrec, iLanguageCd);
                    }
                }
                this.dmh5212.setIdentifier('Y');
                break;
            }
            if (this.winlang == 10) {
                if (this.classifierC.getIdentifier() == 'U') {
                    if (this.classifierC.getIgnoreCase()) {
                        this.classifierC.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                    } else {
                        this.classifierC.process(this.lineCount, this.inrec, iLanguageCd);
                    }
                }
                this.classifierC.setIdentifier('Y');
                break;
            }
            if (this.winlang == 11) {
                if (this.classifierCPP.getIdentifier() == 'U') {
                    if (this.classifierCPP.getIgnoreCase()) {
                        this.classifierCPP.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                    } else {
                        this.classifierCPP.process(this.lineCount, this.inrec, iLanguageCd);
                    }
                }
                this.classifierCPP.setIdentifier('Y');
                break;
            }
            if (this.dmh5214.getIdentifier() == 'U') {
                if (this.dmh5214.getIgnoreCase()) {
                    this.dmh5214.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                } else {
                    this.dmh5214.process(this.lineCount, this.inrec, iLanguageCd);
                }
            }
            this.dmh5214.setIdentifier('Y');
            break;
lbl127:
            // 3 sources

            ** while (recordRead)
        }
lbl128:
        // 17 sources

        if (returnNow) {
            return;
        }
        if (this.winlang == 9) {
            this.ClearBadLanguageScores();
            this.ChooseALanguageCode();
            return;
        }
        recordRead = this.ReadTheInputFile();
        while (recordRead && this.winlang != 9) {
            ++this.lineCount;
            if (this.checkForBlankLine()) {
                recordRead = this.ReadTheInputFile();
                continue;
            }
            if (this.winlang == 1) {
                if (this.dmh5215.getIgnoreCase()) {
                    this.dmh5215.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                } else {
                    this.dmh5215.process(this.lineCount, this.inrec, iLanguageCd);
                }
                if (this.dmh5215.getIdentifier() == 'N') {
                    this.winlang = 9;
                    break;
                }
            } else if (this.winlang == 3) {
                if (this.dmh5213.getIgnoreCase()) {
                    this.dmh5213.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                } else {
                    this.dmh5213.process(this.lineCount, this.inrec, iLanguageCd);
                }
                if (this.dmh5213.getIdentifier() == 'N') {
                    this.winlang = 9;
                    break;
                }
            } else if (this.winlang == 4) {
                if (this.dmh5216.getIgnoreCase()) {
                    this.dmh5216.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                } else {
                    this.dmh5216.process(this.lineCount, this.inrec, iLanguageCd);
                }
                if (this.dmh5216.getIdentifier() == 'N') {
                    this.winlang = 9;
                    break;
                }
            } else if (this.winlang == 7) {
                if (this.dmh5212.getIgnoreCase()) {
                    this.dmh5212.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                } else {
                    this.dmh5212.process(this.lineCount, this.inrec, iLanguageCd);
                }
                if (this.dmh5212.getIdentifier() == 'N') {
                    this.winlang = 9;
                    break;
                }
            } else if (this.winlang == 10) {
                if (this.classifierC.getIgnoreCase()) {
                    this.classifierC.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                } else {
                    this.classifierC.process(this.lineCount, this.inrec, iLanguageCd);
                }
                if (this.classifierC.getIdentifier() == 'N') {
                    this.winlang = 9;
                    break;
                }
            } else if (this.winlang == 11) {
                if (this.classifierCPP.getIgnoreCase()) {
                    this.classifierCPP.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                } else {
                    this.classifierCPP.process(this.lineCount, this.inrec, iLanguageCd);
                }
                if (this.classifierCPP.getIdentifier() == 'N') {
                    this.winlang = 9;
                    break;
                }
            } else {
                if (this.dmh5214.getIgnoreCase()) {
                    this.dmh5214.process(this.lineCount, this.inrec.toUpperCase(), iLanguageCd);
                } else {
                    this.dmh5214.process(this.lineCount, this.inrec, iLanguageCd);
                }
                if (this.dmh5214.getIdentifier() == 'N') {
                    this.winlang = 9;
                    break;
                }
            }
            recordRead = this.ReadTheInputFile();
        }
    }

    public boolean LoadReservedWords() {
        if (!this.dmh5212.init()) {
            return false;
        }
        if (!this.dmh5213.init()) {
            return false;
        }
        if (!this.dmh5214.init()) {
            return false;
        }
        if (!this.dmh5215.init()) {
            return false;
        }
        if (!this.dmh5216.init()) {
            return false;
        }
        if (!this.classifierC.init()) {
            return false;
        }
        return this.classifierCPP.init();
    }

    public void mainProcessing(String[] iArgs) {
        if (!this.LoadReservedWords()) {
            return;
        }
        if (this.DMHU005() != 0) {
            this.FreeReservedWords();
            return;
        }
        if (this.containerName.length() != 0 && this.fileName.length() != 0) {
            this.ProcessSingleFile(this.siteName, "", this.rmDDName, this.containerName, this.fileName, this.localName, "", null, this.languageCd);
        } else {
            this.ProcessMultipleFiles();
        }
        this.FreeReservedWords();
    }

    private boolean OpenProcessCloseFile(String iLanguageCd, String iFileContent, String iFileSpecText) {
        this.lineCount = 0;
        this.InitializeLanguageValidators(iLanguageCd);
        if (!this.DMHIOAPI_CheckIfMemberExists(iFileSpecText, iFileContent)) {
            return false;
        }
        if (!this.DMHIOAPI_Open(iFileSpecText, iFileContent)) {
            return false;
        }
        this.MemberProcessor(iLanguageCd, iFileContent);
        return true;
    }

    private boolean ParseCommandLine(String[] iArgs) {
        boolean returnNow = false;
        int tokenNumber = 0;
        int i = 0;
        while (i < iArgs.length) {
            String currParm = iArgs[i];
            if (!(++tokenNumber != 1 && tokenNumber <= 2 || currParm.charAt(0) != '-' && currParm.charAt(0) != '/')) {
                String workArgIn = currParm = currParm.substring(1);
                String workArgOut = workArgIn.toUpperCase();
                if (workArgOut.equals("H") || workArgOut.equals("HE") || workArgOut.equals("HEL") || workArgOut.equals("HELP") || workArgOut.equals("?")) {
                    this.ShowCopyrightStatement("dmh5210");
                    this.ShowVersionInformation();
                    this.ShowUsageInformation();
                    returnNow = true;
                    break;
                }
                if (workArgOut.startsWith("L")) {
                    this.languageCd = workArgOut.substring(1);
                } else if (workArgOut.equals("V") || workArgOut.equals("VE") || workArgOut.equals("VER") || workArgOut.equals("VERS") || workArgOut.equals("VERSI") || workArgOut.equals("VERSIO") || workArgOut.equals("VERSION")) {
                    this.ShowCopyrightStatement("dmh5210");
                    this.ShowVersionInformation();
                    returnNow = true;
                    break;
                }
            } else if (currParm.startsWith("margins(") || currParm.startsWith("MARGINS(")) {
                this.CaptureMarginsForPLI(currParm);
            } else if (currParm.startsWith("RM=")) {
                this.rmType = currParm.substring(3);
            } else if (currParm.startsWith("RMDD=")) {
                this.rmDDName = currParm.substring(5);
            } else if (currParm.startsWith("SITE=")) {
                this.siteName = currParm.substring(5);
            } else if (this.containerName.length() == 0) {
                this.containerName = currParm;
            } else if (this.fileName.length() == 0) {
                this.fileName = currParm;
            } else if (this.localName.length() == 0) {
                this.localName = currParm;
            }
            ++i;
        }
        return returnNow;
    }

    private void ProcessMultipleFiles() {
        int maxRc = 0;
        int tokenNumber = 0;
        this.SetMaximumSeverity(16);
        String languageCd = "";
        String containerName = "";
        String fileName = "";
        String filesSiteName = "";
        String localName = "";
        String rmDDName = "";
        String workArgIn = "";
        int delimiter = 32;
        tokenNumber = 0;
        if (delimiter == 32) {
            delimiter = 32;
        }
        ++tokenNumber;
        String workArgOut = "";
        languageCd = "";
        if (!(workArgOut.substring(0, 8).equals("MARGINS(") || workArgOut.substring(0, 3).equals("RM=") || workArgOut.substring(0, 5).equals("RMDD=") || workArgOut.substring(0, 5).equals("SITE="))) {
            if (containerName.length() == 0) {
                containerName = workArgIn;
            } else if (fileName.length() == 0) {
                fileName = workArgIn;
            } else if (localName.length() == 0) {
                localName = workArgIn;
            }
        }
        workArgIn = "";
        this.ProcessSingleFile("", "", "", containerName, fileName, localName, "", null, languageCd);
        if (this.DMHU005() > maxRc) {
            maxRc = this.DMHU005();
        }
        this.ResetMaximumSeverity();
        this.SetMaximumSeverity(maxRc);
    }

    public void ProcessSingleFile(String iSiteName, String iRmType, String iRmDDName, String iContainerName, String iFileName, String iLocalName, String iFileContent, InputStream iInputStream, String iLanguageCd) {
        String fileContent;
        if (iSiteName == null) {
            iSiteName = "";
        }
        if (iRmType == null) {
            iRmType = "";
        }
        if (iRmDDName == null) {
            iRmDDName = "";
        }
        if (iContainerName == null) {
            iContainerName = "";
        }
        if (iFileName == null) {
            iFileName = "";
        }
        if (iLocalName == null) {
            iLocalName = "";
        }
        if (iLanguageCd == null) {
            iLanguageCd = "";
        }
        this.dmh5211.addNewFile();
        FileHandler fileHandler = new FileHandler(iContainerName, iFileName, iLocalName);
        this.InitializeFields(fileHandler.getNormalizedFileName());
        fileHandler.setRmType(iRmType);
        fileHandler.setRmDDName(iRmDDName);
        this.dmh5211.setSiteName(iSiteName);
        this.dmh5211.setContainerName(fileHandler.getNormalizedContainerName());
        this.dmh5211.setRmType(fileHandler.getRmType());
        String fileSpecText = fileHandler.getFileToOpen();
        if (iFileContent == null) {
            if (iInputStream == null) {
                fileContent = fileHandler.getFileContent(fileSpecText);
            } else {
                try {
                    fileContent = FileHandler.readInputStream(iInputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            fileContent = iFileContent;
        }
        this.ProcessFilesContent(fileHandler, fileSpecText, iLanguageCd, fileContent);
        ClassifierMetaData metaData = this.dmh5211.getMetaData();
        FileTypeClassification fileTypeClassification = new FileTypeClassification(metaData.getAttcList(), metaData.getAttnList(), metaData.getInclList());
        String fileTypeCd = fileTypeClassification.identifyFileType(metaData.getLanguageCd());
        this.dmh5211.setFileTypeCd(fileTypeCd);
    }

    private void ProcessFilesContent(FileHandler iFileHandler, String iFileSpecText, String iLanguageCd, String iFileContent) {
        if (this.checkIfXML(iFileContent)) {
            int lineCount = this.CountLinesInFile(iFileContent);
            this.dmh5211.setLanguageCd("XML");
            ClassifierMetaData metaData = new ClassifierMetaData();
            metaData.setLanguageCd("XML");
            metaData.setTotalLine(lineCount);
            this.dmh5211.setMetaData(metaData);
            return;
        }
        this.extensionDrivesScan = false;
        this.check_ContentMIMEType = "";
        this.check_LanguageCd = "";
        if (iFileHandler != null && this.checkFileExtension(iFileHandler.getNormalizedFileName())) {
            if (this.assignLanguageBasedOnExtension(iLanguageCd, iFileSpecText, iFileContent)) {
                this.MemoryStructureCleanup();
                return;
            }
        } else if (iLanguageCd.length() != 0) {
            this.check_LanguageCd = iLanguageCd;
        }
        boolean rc = this.OpenProcessCloseFile(this.check_LanguageCd, iFileContent, iFileSpecText);
        this.recordDiscoveredLanguageCd(rc, this.extensionDrivesScan, iFileHandler, iFileContent, iFileSpecText);
        this.MemoryStructureCleanup();
    }

    private boolean ReadTheInputFile() {
        return this.DMHIOAPI_GetRecord(this.lineCount);
    }

    private void recordDiscoveredLanguageCd(boolean iRC, boolean iExtensionDrivesScan, FileHandler iFileHandler, String iFileContent, String iFileSpecText) {
        if (this.ReportWinLanguage(iRC)) {
            return;
        }
        if (!iExtensionDrivesScan) {
            this.EOF_UNK_Member();
            return;
        }
        this.MemoryStructureCleanup();
        if (iFileHandler == null) {
            this.InitializeFields("");
        } else {
            this.InitializeFields(iFileHandler.getNormalizedFileName());
        }
        boolean rc = this.OpenProcessCloseFile("", iFileContent, iFileSpecText);
        if (this.ReportWinLanguage(rc)) {
            return;
        }
        this.EOF_UNK_Member();
    }

    private void ReplaceCharWithPeriod(short i) {
    }

    private boolean ReportWinLanguage(boolean iRC) {
        if (!iRC) {
            this.EOF_GONE_Member();
            return true;
        }
        if (this.lineCount == 0) {
            this.EOF_EMPTY_Member();
            return true;
        }
        boolean rc = false;
        switch (this.winlang) {
            case 1: {
                this.EOF_Asm_Member();
                rc = true;
                break;
            }
            case 10: {
                this.EOF_C_Member();
                rc = true;
                break;
            }
            case 3: {
                this.EOF_Cobol_Member();
                rc = true;
                break;
            }
            case 11: {
                this.EOF_CPP_Member();
                rc = true;
                break;
            }
            case 4: {
                this.EOF_Easytrieve_Member();
                rc = true;
                break;
            }
            case 7: {
                this.EOF_Jcl_Member();
                rc = true;
                break;
            }
            case 8: {
                this.EOF_PLI_Member();
                rc = true;
                break;
            }
        }
        return rc;
    }

    private void ShowCopyrightStatement(String iArgv0) {
    }

    private void ShowUsageInformation() {
    }

    private void ShowVersionInformation() {
    }

    public int DMHU005() {
        return this.MaximumSeverity;
    }

    public void ResetMaximumSeverity() {
        this.MaximumSeverity = 0;
    }

    public void SetMaximumSeverity(int iSetting) {
        this.MaximumSeverity = iSetting;
    }

    public static void main(String ... args) {
        dmh5210 dmh52102 = new dmh5210();
        dmh52102.init();
        boolean returnNow = dmh52102.ParseCommandLine(args);
        if (returnNow) {
            return;
        }
        dmh52102.mainProcessing(args);
        dmh52102.generateImportFile();
        System.out.println("MaximumSeverity: " + dmh52102.DMHU005());
    }

    private boolean DMHIOAPI_CheckIfMemberExists(String iFileSpecText, String iFileContent) {
        if (iFileContent != null) {
            return true;
        }
        File file = new File(iFileSpecText);
        return file.exists() && file.canRead();
    }

    private boolean DMHIOAPI_Open(String iFileSpecText, String iFileContent) {
        if (iFileContent != null) {
            this.fileRecords = iFileContent.split("\n");
            return true;
        }
        File file = new File(iFileSpecText);
        FileInputStream fis = null;
        String contents = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            contents = this.readInputStream(fis);
            this.fileRecords = contents.split("\n");
            fis.close();
        }
        catch (IOException e) {
            this.fileRecords = null;
            return false;
        }
        return true;
    }

    private String readInputStream(InputStream readStream) throws IOException {
        int BUFF_SIZE = 4096;
        ByteArrayOutputStream accumulator = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int currentSize = 0;
        int readSize = readStream.read(buffer, 0, 4096);
        while (readSize >= 0) {
            accumulator.write(buffer, 0, readSize);
            currentSize += readSize;
            readSize = readStream.read(buffer, 0, 4096);
        }
        return accumulator.toString();
    }

    private boolean DMHIOAPI_GetRecord(int iLineCount) {
        if (this.fileRecords == null) {
            return false;
        }
        if (iLineCount >= this.fileRecords.length) {
            return false;
        }
        this.inrec = this.fileRecords[iLineCount];
        if (this.inrec.endsWith("\r")) {
            this.inrec = this.inrec.substring(0, this.inrec.length() - 1);
        }
        return true;
    }

    public void CreateATTNRecords(String iOutputFormat, Integer iAttrTypeId, Integer iAttrNumValue) {
        String attrName = this.getNumericAttrName(iAttrTypeId);
        if (iOutputFormat.equals("scannerData")) {
            this.scannerData.addGeneralProperty(attrName, iAttrNumValue);
        } else if (iOutputFormat.equals("JSON")) {
            if (this.firstAttr) {
                this.firstAttr = false;
            } else {
                this.jsonStringBuffer.append(",");
            }
            this.jsonStringBuffer.append("\n\t\t");
            this.jsonStringBuffer.append("{\"type\":\"" + attrName + "\", \"value\":\"" + iAttrNumValue + "\"}");
        } else {
            this.out.println(String.format("ATTN %d %d", iAttrTypeId, iAttrNumValue));
            this.out.flush();
        }
    }

    private void createAttributeRecords(String iOutputFormat, ClassifierMetaData iMetaData) {
        if (iOutputFormat.equals("JSON")) {
            this.jsonStringBuffer.append("\t\"attrs\": [");
        }
        this.CreateATTNRecords(iOutputFormat, 106, iMetaData.getTotalLine());
        this.CreateATTNRecords(iOutputFormat, 27, iMetaData.getCommentLine());
        this.CreateATTNRecords(iOutputFormat, 28, iMetaData.getNonCommentLine());
        this.CreateATTNRecords(iOutputFormat, 29, iMetaData.getBlankLine());
        Map<Integer, Integer> attnList = iMetaData.getAttnList();
        if (attnList != null) {
            for (Map.Entry<Integer, Integer> e : attnList.entrySet()) {
                this.CreateATTNRecords(iOutputFormat, e.getKey(), e.getValue());
            }
        }
        if (iMetaData.getAttcList() != null) {
            this.ReportATTCForPLIoptions(iMetaData.getAttcList());
        }
        if (iOutputFormat.equals("JSON")) {
            this.jsonStringBuffer.append("\n\t\t], ");
        }
        this.CreateINCLrecord(iOutputFormat, iMetaData.getInclList());
        this.CreateCicsMapRecord(iOutputFormat, iMetaData.getMapSetList());
    }

    private void CreateINCLrecord(String iOutputFormat, Map iInclList) {
        if (iInclList == null || iInclList.size() == 0) {
            return;
        }
        if (iOutputFormat.equals("JSON")) {
            this.jsonStringBuffer.append("\n\t\"references\": [");
        }
        boolean firstIncl = true;
        for (Map.Entry e : iInclList.entrySet()) {
            Set values = (Set)e.getValue();
            for (Object value : values) {
                Integer inclTypeId = (Integer)e.getKey();
                String inclName = (String)value;
                if (iOutputFormat.equals("scannerData")) {
                    this.formatInclData(iOutputFormat, inclTypeId, inclName);
                    continue;
                }
                if (iOutputFormat.equals("JSON")) {
                    if (firstIncl) {
                        this.jsonStringBuffer.append("\n\t\t");
                        firstIncl = false;
                    } else {
                        this.jsonStringBuffer.append(",\n\t\t");
                    }
                    this.jsonStringBuffer.append("{");
                    this.formatInclData(iOutputFormat, inclTypeId, inclName);
                    this.jsonStringBuffer.append("}");
                    continue;
                }
                this.out.println(String.format("INCL %d %s", inclTypeId, inclName));
                this.out.flush();
            }
        }
        if (iOutputFormat.equals("JSON")) {
            this.jsonStringBuffer.append("\n\t\t], ");
        }
    }

    private void CreateCicsMapRecord(String iOutputFormat, Map iMapSetList) {
        if (iMapSetList == null || iMapSetList.size() == 0) {
            return;
        }
        if (iOutputFormat.equals("JSON")) {
            this.jsonStringBuffer.append("\n\t\"cicsMaps\": [");
        }
        boolean firstMapSet = true;
        String currentMapSetName = "";
        for (Map.Entry e : iMapSetList.entrySet()) {
            Set values = (Set)e.getValue();
            for (Object value : values) {
                String mapSetName = (String)e.getKey();
                String mapName = (String)value;
                if (mapSetName.length() == 0) {
                    mapSetName = mapName;
                }
                if (!iOutputFormat.equals("JSON")) continue;
                if (firstMapSet) {
                    firstMapSet = false;
                    this.jsonStringBuffer.append(this.formatJsonCicsMapSet(mapSetName));
                    currentMapSetName = mapSetName;
                } else if (!mapSetName.equals(currentMapSetName)) {
                    this.jsonStringBuffer.append("\n\t\t\t]\n\t\t},");
                    this.jsonStringBuffer.append(this.formatJsonCicsMapSet(mapSetName));
                    currentMapSetName = mapSetName;
                } else {
                    this.jsonStringBuffer.append(",");
                }
                this.jsonStringBuffer.append(this.formatJsonCicsMap(mapName));
            }
        }
        if (iOutputFormat.equals("JSON")) {
            this.jsonStringBuffer.append("\n\t\t\t]\n\t\t}\n\t\t],");
        }
    }

    private void closeAttrRecordFile() {
        this.out.flush();
        this.out.close();
    }

    private void createFMTrecord() {
        this.out.println(String.format("FMT MEMIDENT 1", new Object[0]));
        this.out.flush();
    }

    private void createLIBRrecord(String iContainerName, String iRmType) {
        this.out.println(String.format("LIBR %s %s", this.quote(iContainerName), iRmType));
        this.out.flush();
    }

    private void createMEMBrecord(String iMemberName, String iLanguageCd) {
        this.out.println(String.format("MEMB %s %s", this.quote(iMemberName), iLanguageCd));
        this.out.flush();
    }

    private void createSITErecord(String iSiteName) {
        if (iSiteName == null || iSiteName.length() == 0) {
            return;
        }
        this.out.println(String.format("SITE %s", this.quote(iSiteName)));
        this.out.flush();
    }

    private void createTOOLrecord() {
        this.out.println(String.format("TOOL 0001000217", new Object[0]));
        this.out.flush();
    }

    private void formatDependencyData(String iOutputFormat, String iType, String iInclName, String iDdName, String iFileTypeCd) {
        if (iOutputFormat.equals("scannerData")) {
            this.scannerData.addDependencyData(iInclName, iType, iFileTypeCd, iDdName);
        } else if (iOutputFormat.equals("JSON")) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\"type\":\"" + iType + "\"");
            stringBuffer.append(", \"name\":\"" + iInclName + "\"");
            if (iDdName != null) {
                stringBuffer.append(", \"ddName\":\"" + iDdName + "\"");
            }
            stringBuffer.append(", \"fileTypeCd\":\"" + iFileTypeCd + "\"");
            this.jsonStringBuffer.append(stringBuffer.toString());
        }
    }

    private void formatInclData(String iOutputFormat, Integer iInclTypeId, String iInclName) {
        switch (iInclTypeId) {
            case 3: {
                this.formatDependencyData(iOutputFormat, "COPY", iInclName, null, "INCL");
                break;
            }
            case 4: {
                String[] tokens = iInclName.split(" DD=");
                this.formatDependencyData(iOutputFormat, "COPY", tokens[0], tokens[1], "INCL");
                break;
            }
            case 5: {
                this.formatDependencyData(iOutputFormat, "++INCLUDE", iInclName, null, "INCL");
                break;
            }
            case 6: {
                this.formatDependencyData(iOutputFormat, "-INC", iInclName, null, "INCL");
                break;
            }
            case 7: {
                this.formatDependencyData(iOutputFormat, "SQL INCLUDE", iInclName, null, "INCL");
                break;
            }
            case 8: {
                this.formatDependencyData(iOutputFormat, "MACRO", iInclName, null, "MAC");
                break;
            }
            case 9: {
                this.formatDependencyData(iOutputFormat, "PROC", iInclName, null, "PROC");
                break;
            }
            case 62: {
                this.formatDependencyData(iOutputFormat, "MACRO_DEF", iInclName, null, "MAC");
                break;
            }
            default: {
                this.formatDependencyData(iOutputFormat, "unknown", iInclName, null, "INCL");
            }
        }
    }

    private String formatJsonCicsMap(String iMapName) {
        String mapType;
        String mapName;
        StringBuffer metaData = new StringBuffer();
        if (iMapName.startsWith("\"") || iMapName.startsWith("'")) {
            mapName = iMapName.substring(1, iMapName.length() - 1);
            mapType = "literal";
        } else {
            mapName = iMapName;
            mapType = "dataElement";
        }
        metaData.append("\n\t\t\t{\"map\":\"" + mapName + "\", \"mapType\":\"" + mapType + "\"}");
        return metaData.toString();
    }

    private String formatJsonCicsMapSet(String iMapSetName) {
        String mapSetType;
        String mapSetName;
        StringBuffer metaData = new StringBuffer();
        if (iMapSetName.startsWith("\"") || iMapSetName.startsWith("'")) {
            mapSetName = iMapSetName.substring(1, iMapSetName.length() - 1);
            mapSetType = "literal";
        } else {
            mapSetName = iMapSetName;
            mapSetType = "dataElement";
        }
        metaData.append("\n\t\t{\n\t\t\"mapSet\":\"" + mapSetName + "\",");
        metaData.append("\n\t\t\"mapSetType\":\"" + mapSetType + "\",");
        metaData.append("\n\t\t\"maps\": [");
        return metaData.toString();
    }

    private String getNumericAttrName(Integer iAttrTypeId) {
        String attrName;
        switch (iAttrTypeId) {
            case 27: {
                attrName = "commentLines";
                break;
            }
            case 28: {
                attrName = "nonCommentLines";
                break;
            }
            case 29: {
                attrName = "blankLines";
                break;
            }
            case 30: {
                attrName = "execCICS";
                break;
            }
            case 31: {
                attrName = "execDLI";
                break;
            }
            case 32: {
                attrName = "execIDMS";
                break;
            }
            case 33: {
                attrName = "execSQL";
                break;
            }
            case 34: {
                attrName = "identificationDivision";
                break;
            }
            case 35: {
                attrName = "environmentDivision";
                break;
            }
            case 36: {
                attrName = "dataDivision";
                break;
            }
            case 37: {
                attrName = "procedureDivision";
                break;
            }
            case 38: {
                attrName = "callCBLTDLI";
                break;
            }
            case 39: {
                attrName = "nonCommentBefore1st";
                break;
            }
            case 40: {
                attrName = "nonCommentAfter1st";
                break;
            }
            case 41: {
                attrName = "callPLITDLI";
                break;
            }
            case 42: {
                attrName = "callASMTDLI";
                break;
            }
            case 43: {
                attrName = "callAIBTDLI";
                break;
            }
            case 44: {
                attrName = "OPSYN";
                break;
            }
            case 45: {
                attrName = "ICTL";
                break;
            }
            case 46: {
                attrName = "CSECT";
                break;
            }
            case 47: {
                attrName = "START";
                break;
            }
            case 48: {
                attrName = "PSB";
                break;
            }
            case 49: {
                attrName = "PCB";
                break;
            }
            case 50: {
                attrName = "FCT";
                break;
            }
            case 51: {
                attrName = "PCT";
                break;
            }
            case 52: {
                attrName = "jobCard";
                break;
            }
            case 53: {
                attrName = "execStmt";
                break;
            }
            case 54: {
                attrName = "execPgm";
                break;
            }
            case 55: {
                attrName = "PPT";
                break;
            }
            case 56: {
                attrName = "OPTIONS";
                break;
            }
            case 57: {
                attrName = "ENTRY";
                break;
            }
            case 62: {
                attrName = "macroDef";
                break;
            }
            case 63: {
                attrName = "procDef";
                break;
            }
            case 64: {
                attrName = "copyReplacing";
                break;
            }
            case 65: {
                attrName = "DFHMSD";
                break;
            }
            case 81: {
                attrName = "DBD";
                break;
            }
            case 82: {
                attrName = "CEEENTRY";
                break;
            }
            case 83: {
                attrName = "splittingNodes";
                break;
            }
            case 84: {
                attrName = "CEEXAHD";
                break;
            }
            case 85: {
                attrName = "CEEXART";
                break;
            }
            case 86: {
                attrName = "CEEXAST";
                break;
            }
            case 87: {
                attrName = "MFS";
                break;
            }
            case 106: {
                attrName = "recordCount";
                break;
            }
            default: {
                attrName = "unknown";
            }
        }
        return attrName;
    }

    private String getCharacterAttrName(Integer iAttrTypeId) {
        String attrName;
        switch (iAttrTypeId) {
            case 56: {
                attrName = "OPTIONS";
                break;
            }
            default: {
                attrName = "unknown";
            }
        }
        return attrName;
    }

    public void generateImportFile() {
        if (!this.openAttrRecordFile()) {
            return;
        }
        this.createFMTrecord();
        this.createTOOLrecord();
        String currentContainerNameNoQuotes = null;
        String currentRmType = null;
        String currentSiteName = null;
        for (SingleFileMetadata file : this.dmh5211.getFiles()) {
            String siteName = file.getSiteName();
            if (currentSiteName == null || !currentSiteName.equals(siteName)) {
                this.createSITErecord(siteName);
                currentSiteName = siteName;
            }
            String containerName = file.getContainerName();
            String rmType = file.getRmType();
            if (currentContainerNameNoQuotes == null || !currentContainerNameNoQuotes.equals(containerName) || currentRmType == null || !currentRmType.equals(rmType)) {
                this.createLIBRrecord(containerName, rmType);
                currentContainerNameNoQuotes = containerName;
                currentRmType = rmType;
            }
            String memberName = file.getMemberName();
            String languageCd = file.getLanguageCd();
            this.createMEMBrecord(memberName, languageCd);
            this.createAttributeRecords("", file.getMetaData());
        }
        this.closeAttrRecordFile();
    }

    public String generateJsonOutput() {
        this.jsonStringBuffer = new StringBuffer("");
        this.jsonStringBuffer.append("{\n\"classify\": {");
        for (SingleFileMetadata file : this.dmh5211.getFiles()) {
            String memberName = file.getMemberName();
            String languageCd = file.getLanguageCd();
            this.jsonStringBuffer.append("\n");
            this.jsonStringBuffer.append("\t\"name\":\"" + memberName + "\",\n");
            this.jsonStringBuffer.append("\t\"languageCd\":\"" + languageCd + "\",\n");
            this.createAttributeRecords("JSON", file.getMetaData());
            this.jsonStringBuffer.append("\n");
            String tempFileTypeCd = file.getFileTypeCd();
            if (tempFileTypeCd.equals("INCL") || tempFileTypeCd.equals("PROC")) {
                this.jsonStringBuffer.append("\t\"fileTypeCd\":\"" + tempFileTypeCd + "\",\n");
                this.jsonStringBuffer.append("\t\"logicalName\":\"" + this.getLogicalName(memberName) + "\"\n");
            } else {
                this.jsonStringBuffer.append("\t\"fileTypeCd\":\"" + tempFileTypeCd + "\"\n");
            }
            this.jsonStringBuffer.append("\t}\n}");
        }
        return this.jsonStringBuffer.toString();
    }

    public ScannerData generateScannerData() {
        for (SingleFileMetadata file : this.dmh5211.getFiles()) {
            String languageCd = file.getLanguageCd();
            String fileTypeCd = file.getFileTypeCd();
            if (this.scannerData == null) {
                this.scannerData = new ScannerData();
            }
            this.scannerData.setLanguage(languageCd);
            this.scannerData.setFileType(fileTypeCd);
            this.createAttributeRecords("scannerData", file.getMetaData());
        }
        return this.scannerData;
    }

    private boolean openAttrRecordFile() {
        FileWriter fw;
        try {
            fw = new FileWriter(dd_output);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.out = new PrintWriter(fw);
        return true;
    }

    private void ReportATTCForPLIoptions(Map<Integer, String> iOptions) {
    }

    private String formatJsonATTC(String iAttrName, String iAttrCharValue) {
        StringBuffer metaData = new StringBuffer("");
        metaData.append("\"type\":\"" + iAttrName + "\"");
        metaData.append(", ");
        metaData.append("\"value\":\"" + iAttrCharValue + "\"");
        return metaData.toString();
    }

    private String quote(String s) {
        return s.indexOf(32) == -1 ? s : String.valueOf('\"') + s + '\"';
    }

    private String getLogicalName(String iFilename) {
        int pChar = iFilename.lastIndexOf(46);
        if (pChar == -1) {
            return iFilename.toUpperCase();
        }
        return iFilename.substring(0, pChar).toUpperCase();
    }
}

