/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.previous;

import com.ibm.team.enterprise.zos.metadata.common.classify.previous.Classifier;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierReservedWord;
import com.ibm.team.enterprise.zos.metadata.common.classify.utils.StringUtils;

class ClassifierPLI
extends Classifier {
    private static final boolean IGNORE_CASE = true;
    private boolean DD_flag = false;
    private boolean EXEC_CICS_flag_PLI = false;
    private boolean EXEC_SQL_flag_PLI = false;
    private boolean possibleHyphenFound = false;
    private boolean semicolonFound = false;
    private char P_featurestate;
    private char P_StringDelimiter;
    private char P_TokenState;
    private int blankCount_PLI;
    private int index = 3;
    private int P_procedureCnt;
    private final int PLI_margin_m;
    private final int PLI_margin_n;
    private int reserveWordCount_C;
    private int reserveWordCount_SQL;
    private short columnCurrentRecord;
    private String currToken;
    private String lib = "";
    private String prevPrevToken;
    private String prevToken;

    public ClassifierPLI() {
        this.PLI_margin_m = 2;
        this.PLI_margin_n = 72;
        this.reservedWordFilename = "/com/ibm/team/enterprise/zos/metadata/common/classify/rwPLI.txt";
        this.reserveWordCount_C = 0;
        this.reserveWordCount_SQL = 0;
    }

    private void AccumulatePointsForTheScore(ClassifierReservedWord iRw, String iCurrentChar, String ipInRecord) {
        if (this.EXEC_CICS_flag_PLI || this.EXEC_SQL_flag_PLI) {
            return;
        }
        boolean countTypes = true;
        if (iRw.getTokenWordType() == 5) {
            this.score += iRw.getTokenWeight();
            ++this.reserveWordCount;
        } else if (iRw.getTokenWordType() == 1) {
            if (!(iCurrentChar.startsWith("-") || this.possibleHyphenFound || ipInRecord.startsWith("*") || ipInRecord.startsWith("&"))) {
                if (this.currToken.equals("CHAR") && !iCurrentChar.startsWith("(")) {
                    ++this.reserveWordCount_C;
                }
                if (this.currToken.equals("INT")) {
                    ++this.reserveWordCount_C;
                }
                if (this.currToken.equals("SELECT") || this.currToken.equals("FROM")) {
                    ++this.reserveWordCount_SQL;
                }
                this.score += iRw.getTokenWeight();
                ++this.reserveWordCount;
            }
        } else if (iRw.getTokenWordType() == 3) {
            if (this.currToken.equals("EXIT") || this.currToken.equals("PROC")) {
                if (iCurrentChar.charAt(0) == '.' || iCurrentChar.charAt(0) == '-' || this.possibleHyphenFound) {
                    countTypes = false;
                } else {
                    this.score += iRw.getTokenWeight();
                    ++this.reserveWordCount;
                }
            } else {
                this.score += iRw.getTokenWeight();
                ++this.reserveWordCount;
            }
        }
        int attrTypeId = iRw.getTokenAttrTypeId();
        if (attrTypeId == 0) {
            return;
        }
        if (!countTypes) {
            return;
        }
        if (attrTypeId == 37 && this.prevPrevToken.length() > 0 && this.prevPrevToken.charAt(0) == '%') {
            return;
        }
        this.metaData.incrementNumValue(attrTypeId);
    }

    public boolean ClassifyPLI() {
        return this.P_procedureCnt > 0;
    }

    @Override
    public boolean getIgnoreCase() {
        return true;
    }

    public int getPLIBlankLines() {
        return this.blankCount_PLI;
    }

    public int getReserveWordCount_C() {
        return this.reserveWordCount_C;
    }

    public int getReserveWordCount_SQL() {
        return this.reserveWordCount_SQL;
    }

    public boolean HasSemicolon() {
        return this.semicolonFound;
    }

    @Override
    public void isScoreBad(int iLineCount) {
        if (this.score == 0) {
            return;
        }
        if (this.getReserveWordCount() == 0) {
            this.score = 0;
            return;
        }
        if (this.getReserveWordCount() == 1) {
            if ((double)this.getReserveWordCount() < (double)(iLineCount - (this.getBlankCount() + this.getPLIBlankLines()) - this.getCommentCount()) * 0.25) {
                this.score = 0;
            } else if (!this.HasSemicolon()) {
                this.score = 0;
            }
            return;
        }
        if (!this.ClassifyPLI() && (double)this.score < (double)iLineCount * 0.05) {
            this.score = 0;
            return;
        }
        int reserveWordDiff = this.getReserveWordCount() - this.getReserveWordCount_C();
        if ((double)reserveWordDiff < (double)this.getReserveWordCount() * 0.05) {
            this.score = 0;
            return;
        }
        reserveWordDiff = this.getReserveWordCount() - this.getReserveWordCount_SQL();
        if ((double)reserveWordDiff < (double)this.getReserveWordCount() * 0.05) {
            this.score = 0;
        }
    }

    private void TokenComplete(String P_p_line, String ipInRecord) {
        this.P_TokenState = (char)83;
        if (this.currToken.length() == 0) {
            return;
        }
        if (this.currToken.equals(";")) {
            this.semicolonFound = true;
            this.EXEC_CICS_flag_PLI = false;
            this.EXEC_SQL_flag_PLI = false;
            this.P_featurestate = (char)73;
            this.prevPrevToken = this.prevToken;
            this.prevToken = this.currToken;
            this.currToken = "";
            return;
        }
        if (this.currToken.equals("(")) {
            this.prevPrevToken = this.prevToken;
            this.prevToken = this.currToken;
            this.currToken = "";
            return;
        }
        if (this.currToken.equals(")")) {
            this.prevPrevToken = this.prevToken;
            this.prevToken = this.currToken;
            this.currToken = "";
            return;
        }
        if (this.currToken.length() == 1 && (this.currToken.equals(",") || this.currToken.equals("'") || this.currToken.equals(":") || this.currToken.equals("+") || this.currToken.equals("-") || this.currToken.equals("/") || this.currToken.equals("*") || this.currToken.equals("=") || this.currToken.equals("&") || this.currToken.equals("<") || this.currToken.equals(">") || this.currToken.equals("."))) {
            this.possibleHyphenFound = this.currToken.equals("-");
            this.prevPrevToken = this.prevToken;
            this.prevToken = this.currToken;
            this.currToken = "";
            return;
        }
        ClassifierReservedWord rw = (ClassifierReservedWord)this.reservedWords.get(this.currToken);
        if (rw != null) {
            this.AccumulatePointsForTheScore(rw, P_p_line, ipInRecord);
        }
        this.possibleHyphenFound = false;
        switch (this.P_featurestate) {
            case 'I': {
                if (this.currToken.equals("%INCLUDE") || this.currToken.equals("%XINCLUDE") || this.prevToken.equals("%") && (this.currToken.equals("INCLUDE") || this.currToken.equals("XINCLUDE"))) {
                    if (this.identifier == 'U') {
                        this.identifier = (char)89;
                    }
                    this.P_featurestate = (char)77;
                    break;
                }
                if (this.currToken.equals("CALL")) {
                    this.P_featurestate = (char)67;
                    break;
                }
                if (this.currToken.equals("END-EXEC")) {
                    this.EXEC_CICS_flag_PLI = false;
                    this.EXEC_SQL_flag_PLI = false;
                    break;
                }
                if (this.currToken.equals("EXEC") || this.currToken.equals("EXECUTE")) {
                    this.P_featurestate = (char)69;
                    break;
                }
                if (rw == null || rw.getTokenAttrTypeId() != 37 || this.prevPrevToken.length() <= 0 || this.prevPrevToken.charAt(0) == '%') break;
                ++this.P_procedureCnt;
                this.P_featurestate = (char)80;
                break;
            }
            case 'C': {
                if (this.currToken.equals("PLITDLI")) {
                    this.metaData.incrementNumValue(41);
                    if (this.identifier == 'U') {
                        this.identifier = (char)89;
                    }
                }
                this.P_featurestate = (char)73;
                break;
            }
            case 'E': {
                if (this.currToken.equals("SQL")) {
                    this.metaData.incrementNumValue(33);
                    this.EXEC_SQL_flag_PLI = true;
                    this.P_featurestate = (char)83;
                    break;
                }
                if (this.currToken.equals("CICS")) {
                    this.metaData.incrementNumValue(30);
                    this.EXEC_CICS_flag_PLI = true;
                } else if (this.currToken.equals("DLI")) {
                    this.metaData.incrementNumValue(31);
                } else if (this.currToken.equals("IDMS")) {
                    this.metaData.incrementNumValue(32);
                }
                this.P_featurestate = (char)73;
                break;
            }
            case 'P': {
                if (rw == null || rw.getTokenAttrTypeId() != 56) break;
                this.P_featurestate = (char)82;
                break;
            }
            case 'R': {
                if (!this.currToken.equals("MAIN")) break;
                this.metaData.addOptions(56, this.currToken);
                break;
            }
            case 'S': {
                if (this.currToken.equals("INCLUDE")) {
                    this.P_featurestate = (char)77;
                    this.index = 7;
                    break;
                }
                this.P_featurestate = (char)73;
                break;
            }
            case 'M': {
                if (this.DD_flag) {
                    this.lib = " DD=";
                    this.lib = String.valueOf(this.lib) + this.currToken;
                    this.index = 4;
                    this.DD_flag = false;
                    break;
                }
                this.metaData.addInclude(this.index, String.valueOf(this.currToken) + this.lib);
                this.lib = "";
                this.index = 3;
                this.P_featurestate = (char)73;
                break;
            }
        }
        this.prevPrevToken = this.prevToken;
        this.prevToken = this.currToken;
        this.currToken = "";
    }

    @Override
    public ClassifierMetaData processEndOfFile(int iLineCount) {
        this.metaData.setTotalLine(iLineCount);
        this.metaData.setBlankline(this.blankCount + this.blankCount_PLI);
        this.metaData.setNonCommentLine(iLineCount - this.blankCount - this.getCommentCount());
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        super.processInitialization();
        this.processDeallocate();
        this.blankCount_PLI = 0;
        this.EXEC_CICS_flag_PLI = false;
        this.EXEC_SQL_flag_PLI = false;
        this.P_featurestate = (char)73;
        this.prevPrevToken = "";
        this.prevToken = "";
        this.currToken = "";
        this.P_procedureCnt = 0;
        this.P_TokenState = (char)83;
        this.semicolonFound = false;
        this.reserveWordCount_C = 0;
        this.reserveWordCount = 0;
        this.reserveWordCount_SQL = 0;
        this.identifier = (char)85;
        this.metaData = new ClassifierMetaData();
    }

    private boolean ProcessFunctionCode(String P_p_line, int iLineCount, String iBaseLanguageString) {
        boolean returnNow;
        if (this.identifier == 'U') {
            if (iBaseLanguageString == null || iBaseLanguageString != null && !iBaseLanguageString.equals("PLI")) {
                if (P_p_line.startsWith("//") || P_p_line.startsWith(">")) {
                    this.identifier = (char)78;
                    this.score = 0;
                    this.processDeallocate();
                    returnNow = true;
                } else {
                    returnNow = false;
                }
            } else {
                returnNow = false;
            }
        } else {
            returnNow = this.identifier != 'Y';
        }
        return returnNow;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void processOneRecord(int iRecordCount, String iRecord, String iBaseLanguage) {
        if (this.ProcessFunctionCode(iRecord, iRecordCount, iBaseLanguage)) {
            return;
        }
        if ((iRecord = StringUtils.trimEnd(iRecord)).length() < 2) {
            return;
        }
        pInRecord = iRecord;
        this.columnCurrentRecord = 1;
        currentChar = iRecord.charAt(0);
        if (this.PLI_margin_m > 1 && (currentChar == '0' || currentChar == '-' || currentChar == '+' || currentChar == '1')) {
            iRecord = " " + iRecord.substring(1);
        }
        if (iRecord.charAt(0) != '*' && iRecord.charAt(0) != '%' || this.columnCurrentRecord != 1) {
            while (this.columnCurrentRecord < this.PLI_margin_m && this.columnCurrentRecord <= this.PLI_margin_n && iRecord.charAt(0) != '\n' && iRecord.length() != 0) {
                iRecord = iRecord.substring(1);
                this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
            }
        }
        if (this.columnCurrentRecord <= this.PLI_margin_n || iRecord.charAt(0) != '\n' && iRecord.length() != 0) ** GOTO lbl19
        return;
lbl-1000:
        // 1 sources

        {
            iRecord = iRecord.substring(1);
            this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
lbl19:
            // 2 sources

            ** while (iRecord.charAt((int)0) == ' ' && this.columnCurrentRecord <= this.PLI_margin_n && iRecord.charAt((int)0) != '\n' && iRecord.length() != 0)
        }
lbl20:
        // 1 sources

        if (this.columnCurrentRecord > this.PLI_margin_n || iRecord.charAt(0) == '\n' || iRecord.length() == 0) {
            ++this.blankCount_PLI;
            return;
        }
        comment_completed = false;
        comment_only_record = true;
        comment_started = false;
        P_IsDelimiter = false;
        P_NewLine = true;
        returnNow = false;
        while (iRecord.length() != 0 && this.columnCurrentRecord <= this.PLI_margin_n) {
            block47: {
                block50: {
                    block48: {
                        block49: {
                            if (this.P_TokenState == 'M') break block47;
                            if (iRecord.charAt(0) != '*') break block48;
                            if (this.columnCurrentRecord != 1) break block49;
                            if (iRecord.length() > 8 && iRecord.substring(0, 9).equals("*PROCESS ")) {
                                iRecord = "%" + iRecord.substring(1);
                            } else {
                                P_IsDelimiter = true;
                            }
                            break block50;
                        }
                        if (this.columnCurrentRecord != 7) ** GOTO lbl45
                        if (this.P_TokenState == 'Q') {
                            P_IsDelimiter = true;
                        } else {
                            comment_only_record = false;
                            break;
lbl45:
                            // 1 sources

                            P_IsDelimiter = true;
                        }
                        break block50;
                    }
                    if (iRecord.charAt(0) == '(') {
                        P_IsDelimiter = true;
                        if (this.P_featurestate == 'M' && (this.P_TokenState == 'C' || this.P_TokenState == 'B')) {
                            this.DD_flag = true;
                            iRecord = iRecord.substring(1);
                            this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                        }
                    } else {
                        P_IsDelimiter = iRecord.charAt(0) == ')' || iRecord.charAt(0) == ',' || iRecord.charAt(0) == '\'' || iRecord.charAt(0) == ';' || iRecord.charAt(0) == ':' || iRecord.charAt(0) == '+' || iRecord.charAt(0) == '-' || iRecord.charAt(0) == '/' || iRecord.charAt(0) == '=' || iRecord.charAt(0) == '&' || iRecord.charAt(0) == '<' || iRecord.charAt(0) == '>' || iRecord.charAt(0) == '.' || iRecord.charAt(0) == ' ';
                    }
                }
                if (iRecord.startsWith("/*") && this.P_TokenState != 'Q') {
                    comment_started = true;
                    this.score += 5;
                    this.P_TokenState = (char)77;
                    iRecord = iRecord.substring(1);
                    iRecord = iRecord.substring(1);
                    this.columnCurrentRecord = (short)(this.columnCurrentRecord + 2);
                    if (iRecord.length() == 0) break;
                }
                if (comment_only_record && this.P_TokenState != 'M' && iRecord.charAt(0) != ' ') {
                    comment_only_record = false;
                }
            }
            block0 : switch (this.P_TokenState) {
                case 'B': {
                    if (P_NewLine) {
                        this.TokenComplete(iRecord, pInRecord);
                        break;
                    }
                    if (iRecord.charAt(0) == ' ') {
                        iRecord = iRecord.substring(1);
                        this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                        break;
                    }
                    this.TokenComplete(iRecord, pInRecord);
                    break;
                }
                case 'C': {
                    if (P_NewLine) {
                        this.TokenComplete(iRecord, pInRecord);
                        break;
                    }
                    if (iRecord.charAt(0) == ' ') {
                        this.P_TokenState = (char)66;
                        iRecord = iRecord.substring(1);
                        this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                        break;
                    }
                    if (P_IsDelimiter) {
                        this.TokenComplete(iRecord, pInRecord);
                        break;
                    }
                    this.currToken = String.valueOf(this.currToken) + iRecord.substring(0, 1);
                    iRecord = iRecord.substring(1);
                    this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                    break;
                }
                case 'E': {
                    if (iRecord.charAt(0) == this.P_StringDelimiter) {
                        iRecord = iRecord.substring(1);
                        this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                        this.P_TokenState = (char)81;
                        break;
                    }
                    this.TokenComplete(iRecord, pInRecord);
                    break;
                }
                case 'M': {
                    if (iRecord.startsWith("*/")) {
                        comment_completed = true;
                        this.score += 5;
                        iRecord = iRecord.substring(1);
                        this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                        iRecord = iRecord.substring(1);
                        this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                        this.TokenComplete(iRecord, pInRecord);
                        break;
                    }
                    iRecord = iRecord.substring(1);
                    this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                    break;
                }
                case 'Q': {
                    if (iRecord.charAt(0) == this.P_StringDelimiter) {
                        this.P_TokenState = (char)69;
                    }
                    this.currToken = String.valueOf(this.currToken) + iRecord.substring(0, 1);
                    iRecord = iRecord.substring(1);
                    this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                    break;
                }
                case 'S': {
                    switch (iRecord.charAt(0)) {
                        case ' ': {
                            iRecord = iRecord.substring(1);
                            this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                            break block0;
                        }
                        case 'X': {
                            this.currToken = String.valueOf(this.currToken) + iRecord.substring(0, 1);
                            iRecord = iRecord.substring(1);
                            this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                            this.P_TokenState = (char)88;
                            break block0;
                        }
                        case '\"': 
                        case '\'': {
                            this.P_StringDelimiter = iRecord.charAt(0);
                            this.currToken = String.valueOf(this.currToken) + iRecord.substring(0, 1);
                            iRecord = iRecord.substring(1);
                            this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                            this.P_TokenState = (char)81;
                            break block0;
                        }
                    }
                    if (P_IsDelimiter) {
                        this.currToken = String.valueOf(this.currToken) + iRecord.substring(0, 1);
                        iRecord = iRecord.substring(1);
                        this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                        this.TokenComplete(iRecord, pInRecord);
                        break;
                    }
                    this.currToken = String.valueOf(this.currToken) + iRecord.substring(0, 1);
                    iRecord = iRecord.substring(1);
                    this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                    this.P_TokenState = (char)67;
                    break;
                }
                case 'X': {
                    if (iRecord.charAt(0) == ' ') {
                        iRecord = iRecord.substring(1);
                        this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                        this.P_TokenState = (char)66;
                        break;
                    }
                    if (iRecord.charAt(0) == '\"' || iRecord.charAt(0) == '\'') {
                        this.P_StringDelimiter = iRecord.charAt(0);
                        this.currToken = String.valueOf(this.currToken) + iRecord.substring(0, 1);
                        iRecord = iRecord.substring(1);
                        this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                        this.P_TokenState = (char)81;
                        break;
                    }
                    if (P_IsDelimiter) {
                        this.TokenComplete(iRecord, pInRecord);
                        break;
                    }
                    this.currToken = String.valueOf(this.currToken) + iRecord.substring(0, 1);
                    iRecord = iRecord.substring(1);
                    this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                    this.P_TokenState = (char)67;
                    break;
                }
            }
            if (returnNow) break;
            if (this.currToken.length() >= 1024) {
                this.TokenComplete(iRecord, pInRecord);
            }
            P_NewLine = false;
        }
        if (returnNow) {
            return;
        }
        if (comment_only_record) {
            this.metaData.incrementCommentLine();
            if (comment_started || comment_completed) {
                return;
            }
            this.score += 5;
        }
    }
}

