/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.previous;

import com.ibm.team.enterprise.zos.metadata.common.classify.previous.Classifier;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.utils.StringUtils;

class ClassifierJCL
extends Classifier {
    private static final boolean IGNORE_CASE = true;
    private boolean after_first_proc;
    private boolean first_proc;
    private boolean J_Continuation = false;
    private int noncomment_aft_proc;
    private String Name;
    private String Operator;
    private String Parameter;

    public ClassifierJCL() {
        this.reservedWordFilename = "/com/ibm/team/enterprise/zos/metadata/common/classify/rwJCL.txt";
    }

    private boolean CheckForCA7ControlStatement(String iRecord) {
        String token;
        String record = iRecord.trim();
        if (!record.startsWith("#")) {
            return false;
        }
        if (record.length() >= 3 && ((token = record.substring(0, 3)).equals("#JI") || token.equals("#JO") || token.equals("#XI") || token.equals("#XO"))) {
            return true;
        }
        if (record.length() >= 4 && ((token = record.substring(0, 4)).equals("#ARF") || token.equals("#HLD") || token.equals("#JCL") || token.equals("#MNT") || token.equals("#MSG") || token.equals("#NOX") || token.equals("#NTR") || token.equals("#RES") || token.equals("#SCC") || token.equals("#VER"))) {
            return true;
        }
        return record.length() >= 5 && ((token = record.substring(0, 5)).equals("#JEND") || token.equals("#XEND") || token.equals("#7UNI"));
    }

    private void ClearTokenFields() {
        this.Name = "";
        this.Operator = "";
        this.Parameter = "";
    }

    private void CompleteJStatement(int iLineCount) {
        if (this.Name.equals("JOBLIB") || this.Name.equals("STEPLIB")) {
            ++this.reserveWordCount;
            this.score += 50;
        }
        if (this.Operator.equals("CNTL") || this.Operator.equals("COMMAND") || this.Operator.equals("ELSE") || this.Operator.equals("ENDCNTL") || this.Operator.equals("ENDIF") || this.Operator.equals("IF") || this.Operator.equals("JCLLIB") || this.Operator.equals("OUTPUT") || this.Operator.equals("SET") || this.Operator.equals("XMIT")) {
            ++this.reserveWordCount;
        } else if (this.Operator.equals("COPY") || this.Operator.equals("INCLUDE")) {
            if (this.Parameter.contains("MEMBER=(")) {
                ++this.reserveWordCount;
                String pChar = this.Parameter.substring(8);
                this.RecordIncludedSource(3, pChar);
            } else if (this.Parameter.contains("MEMBER=")) {
                ++this.reserveWordCount;
                String pChar = this.Parameter.substring(7);
                this.RecordIncludedSource(3, pChar);
            }
        } else if (this.Operator.equals("DD")) {
            ++this.reserveWordCount;
            this.score += 500;
            if (this.identifier == 'U') {
                this.identifier = (char)89;
            }
        } else if (this.Operator.equals("EXEC")) {
            ++this.reserveWordCount;
            this.score += 500;
            this.metaData.incrementNumValue(53);
            if (this.identifier == 'U') {
                this.identifier = (char)89;
            }
            if (this.Parameter.length() != 0) {
                if (this.Parameter.contains("PGM=")) {
                    this.metaData.incrementNumValue(54);
                } else {
                    int pSearchChar = this.Parameter.indexOf(",");
                    if (pSearchChar != -1) {
                        this.Parameter = this.Parameter.substring(0, pSearchChar);
                    }
                    if (this.Parameter.contains("PROC=")) {
                        String pChar = this.Parameter.substring(5);
                        this.RecordIncludedSource(9, pChar);
                    } else {
                        this.RecordIncludedSource(9, this.Parameter);
                    }
                }
            }
        } else if (this.Operator.equals("JOB") || this.Operator.equals("JOB,")) {
            ++this.reserveWordCount;
            this.score += 500;
            this.metaData.incrementNumValue(52);
            if (this.identifier == 'U') {
                this.identifier = (char)89;
            }
        } else if (this.Operator.equals("PROC")) {
            ++this.reserveWordCount;
            if (this.first_proc) {
                this.metaData.setNonBefore(iLineCount - this.blankCount - this.getCommentCount() - 1);
                this.first_proc = false;
            }
        } else if (this.Operator.equals("PEND")) {
            ++this.reserveWordCount;
            this.after_first_proc = true;
        }
    }

    @Override
    public boolean getIgnoreCase() {
        return true;
    }

    @Override
    public void isScoreBad(int iLineCount) {
        if (this.score == 0) {
            return;
        }
        if (this.getReserveWordCount() == 0 && iLineCount != this.getCommentCount()) {
            this.score = 0;
        }
    }

    @Override
    public ClassifierMetaData processEndOfFile(int iLineCount) {
        if (this.after_first_proc) {
            this.metaData.setNonAfter(this.noncomment_aft_proc);
        }
        this.metaData.setTotalLine(iLineCount);
        this.metaData.setBlankline(this.blankCount);
        this.metaData.setNonCommentLine(iLineCount - this.blankCount - this.getCommentCount());
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        super.processInitialization();
        this.after_first_proc = false;
        this.first_proc = true;
        this.noncomment_aft_proc = 0;
        this.metaData = new ClassifierMetaData();
        this.ClearTokenFields();
    }

    @Override
    protected void processOneRecord(int iRecordCount, String iRecord, String iBaseLanguageString) {
        if (this.identifier == 'U') {
            if (this.CheckForCA7ControlStatement(iRecord)) {
                return;
            }
            if (!iRecord.startsWith("/")) {
                if (iRecord.startsWith(" ")) {
                    String tempChar = iRecord.trim();
                    if (tempChar.length() == 0) {
                        return;
                    }
                } else if (iBaseLanguageString == null || iBaseLanguageString != null && !iBaseLanguageString.equals("JCL")) {
                    this.identifier = (char)78;
                    this.score = 0;
                    this.processDeallocate();
                    return;
                }
            }
        } else if (this.identifier == 'Y') {
            if (this.CheckForCA7ControlStatement(iRecord)) {
                return;
            }
        } else {
            return;
        }
        if (!iRecord.startsWith("/")) {
            return;
        }
        if (iRecord.startsWith("/*")) {
            if (this.after_first_proc) {
                ++this.noncomment_aft_proc;
            }
            return;
        }
        if (!iRecord.startsWith("//")) {
            return;
        }
        this.score += 5;
        if (iRecord.startsWith("//*")) {
            this.metaData.incrementCommentLine();
            return;
        }
        if (iRecord.equals("//")) {
            return;
        }
        String jclText = iRecord.substring(2).trim();
        if (jclText.length() == 0) {
            return;
        }
        if (this.after_first_proc) {
            ++this.noncomment_aft_proc;
        }
        String[] tokens = StringUtils.splitQuoted(jclText, ' ', false, false, true);
        if (this.J_Continuation) {
            this.J_Continuation = false;
            if (tokens.length != 0) {
                this.Parameter = String.valueOf(this.Parameter) + tokens[0];
            }
        } else {
            this.ClearTokenFields();
            if (iRecord.startsWith("// ")) {
                if (tokens.length == 1) {
                    this.Operator = tokens[0];
                } else if (tokens.length > 1) {
                    this.Operator = tokens[0];
                    this.Parameter = tokens[1];
                }
            } else if (tokens.length == 1) {
                this.Name = tokens[0];
            } else if (tokens.length == 2) {
                this.Name = tokens[0];
                this.Operator = tokens[1];
            } else if (tokens.length > 2) {
                this.Name = tokens[0];
                this.Operator = tokens[1];
                this.Parameter = tokens[2];
            }
        }
        if (this.Parameter.endsWith(",")) {
            this.J_Continuation = true;
        } else {
            this.CompleteJStatement(iRecordCount);
            this.ClearTokenFields();
        }
    }

    private void RecordIncludedSource(int iType, String iName) {
        if (this.DMHU997(iName)) {
            this.metaData.addInclude(iType, iName);
        }
    }

    private boolean DMHU997(String iFileName) {
        String validFirstChar;
        String validChars;
        int MEMBER_NAME_LENGTH;
        if (this.isWindows) {
            MEMBER_NAME_LENGTH = 255;
            validChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz$#@1234567890-._ ~";
            validFirstChar = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz$#@1234567890-._~";
        } else {
            MEMBER_NAME_LENGTH = 11;
            validChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz$#@1234567890-";
            validFirstChar = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz$#@";
        }
        int length = iFileName.length();
        if (length > MEMBER_NAME_LENGTH - 1) {
            return false;
        }
        if (length < 1) {
            return false;
        }
        boolean invalidCharFound = false;
        char[] validCharArray = validChars.toCharArray();
        int i = 0;
        while (i < iFileName.length()) {
            boolean foundCharInArray = false;
            int j = 0;
            while (j < validCharArray.length) {
                if (iFileName.charAt(i) == validCharArray[j]) {
                    foundCharInArray = true;
                    break;
                }
                ++j;
            }
            if (!foundCharInArray) {
                invalidCharFound = true;
                break;
            }
            ++i;
        }
        if (invalidCharFound) {
            return false;
        }
        String firstChar = iFileName.substring(0, 1);
        return validFirstChar.contains(firstChar);
    }
}

