/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.previous;

import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierC;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierReservedWord;

class ClassifierCPP
extends ClassifierC {
    public ClassifierCPP() {
        this.reservedWordFilename = "/com/ibm/team/enterprise/zos/metadata/common/classify/rwCPP.txt";
    }

    @Override
    protected void AccumulatePointsForTheScore(ClassifierReservedWord iRw) {
        if (iRw.getTokenWordType() == 1) {
            ++this.reserveWordCount;
            this.score += iRw.getTokenWeight();
        } else if (iRw.getTokenWordType() == 3) {
            this.score += iRw.getTokenWeight();
        } else if (iRw.getTokenWordType() == 5) {
            ++this.languageWordCount;
            this.score += iRw.getTokenWeight();
        } else {
            this.score += iRw.getTokenWeight();
        }
        if (this.debug) {
            System.out.println("CPP score: " + this.score);
        }
    }

    @Override
    public void isScoreBad(int iLineCount) {
        if (this.score == 0) {
            return;
        }
        int languageWordCount = this.getLanguageWordCount();
        int reserveWordCount = this.getReserveWordCount();
        if (languageWordCount == 0 || reserveWordCount == 0) {
            this.score = 0;
        }
    }
}

