/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.previous;

import com.ibm.team.enterprise.zos.metadata.common.classify.previous.Classifier;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierReservedWord;
import com.ibm.team.enterprise.zos.metadata.common.classify.utils.StringUtils;

class ClassifierCOB
extends Classifier {
    private static final boolean IGNORE_CASE = true;
    private boolean C_Continuation;
    private boolean C_NewLine;
    private boolean CBL_marker;
    private boolean EXEC_CICS_flag_COB;
    private boolean EXEC_SQL_flag_COB;
    private boolean freeFormatCOBOL;
    private boolean idDivFound;
    private boolean inRemarksParaFlag;
    private boolean invalidCOBOLsequence;
    private char C_featurestate;
    private char C_foundIN;
    private char C_StringDelimiter;
    private char C_TokenState;
    private char inDivision = (char)32;
    private int columnCurrentRecord;
    private int columnPriorRecord;
    private int compilerDirectingCount_COBOL;
    private int keep_index;
    private int periodWORDperiod;
    private int pictureCount;
    private int verbCount_COBOL;
    private short previousTokenNumberOnLine;
    private short tokenNumberOnLine;
    private String currentToken;
    private String includedMember;
    private String mapName;
    private String mapSetName;
    private String previousToken;
    private String previousPreviousToken;

    public ClassifierCOB() {
        this.reservedWordFilename = "/com/ibm/team/enterprise/zos/metadata/common/classify/rwCOB.txt";
    }

    private void AccumulatePointsForTheScore(ClassifierReservedWord iRw, String iCurrentChar) {
        int attrTypeId;
        if (this.EXEC_CICS_flag_COB || this.EXEC_SQL_flag_COB) {
            return;
        }
        if (iRw.getTokenWordType() == 1) {
            if (this.currentToken.equals("PIC")) {
                if (!iCurrentChar.startsWith("'")) {
                    ++this.pictureCount;
                }
            } else if (this.currentToken.equals("PICTURE")) {
                ++this.pictureCount;
            }
            this.score += iRw.getTokenWeight();
        } else {
            this.score += iRw.getTokenWeight();
            if (iRw.getTokenWordType() == 3) {
                ++this.verbCount_COBOL;
            }
        }
        if (this.tokenNumberOnLine == 1 && (this.currentToken.equals("BASIS") || this.currentToken.equals("CBL") || this.currentToken.equals("PROCESS") || this.currentToken.equals("*CONTROL") || this.currentToken.equals("*CBL") || this.currentToken.equals("COPY") || this.currentToken.equals("DELETE") || this.currentToken.equals("EJECT") || this.currentToken.equals("ENTER") || this.currentToken.equals("INSERT") || this.currentToken.equals("READY") || this.currentToken.equals("RESET") || this.currentToken.equals("REPLACE") || this.currentToken.equals("SERVICE") || this.currentToken.equals("SKIP1") || this.currentToken.equals("SKIP2") || this.currentToken.equals("SKIP3") || this.currentToken.equals("TITLE") || this.currentToken.equals("USE"))) {
            ++this.compilerDirectingCount_COBOL;
            this.score += 2;
        }
        if ((attrTypeId = iRw.getTokenAttrTypeId()) != 0 && this.inDivision == 'P') {
            this.metaData.incrementNumValue(attrTypeId);
        }
    }

    private void CaptureCopyName(String iIncludedMember) {
        if (iIncludedMember.length() > 5 && iIncludedMember.substring(0, 5).equals("LIB$:")) {
            this.metaData.addInclude(this.keep_index, iIncludedMember.substring(5));
        } else {
            this.metaData.addInclude(this.keep_index, iIncludedMember);
        }
        this.C_foundIN = (char)78;
        this.keep_index = 3;
    }

    private boolean CheckAlternateLocationOfINC(String inrec) {
        if (this.freeFormatCOBOL) {
            return false;
        }
        if (inrec.length() < 12) {
            return false;
        }
        inrec = inrec.substring(6);
        if ((inrec = inrec.trim()).length() == 0) {
            return false;
        }
        if (inrec.startsWith("-INC ")) {
            inrec = inrec.substring(4);
            if ((inrec = inrec.trim()).length() != 0) {
                String[] token = StringUtils.split(inrec, ".");
                String memberName = token[0];
                this.metaData.addInclude(6, memberName);
                return true;
            }
        }
        return false;
    }

    private boolean CheckOtherColumnSevenValues(String iC_p_line, String iBaseLanguageString, int iLineCount) {
        String col7;
        if (this.identifier == 'Y' || this.CBL_marker) {
            return false;
        }
        if (iC_p_line.startsWith("*")) {
            this.freeFormatCOBOL = true;
            return false;
        }
        if (iLineCount == 1 && (iC_p_line.length() > 2 && iC_p_line.substring(0, 3).equals("ID ") || iC_p_line.length() > 15 && iC_p_line.substring(0, 15).equals("IDENTIFICATION "))) {
            this.freeFormatCOBOL = true;
            return false;
        }
        if (iC_p_line.startsWith(" ")) {
            if (iC_p_line.substring(1, 1).equals("/")) {
                if (!iC_p_line.substring(2, 1).equals("*")) {
                    this.freeFormatCOBOL = true;
                    return false;
                }
            } else if (!iC_p_line.substring(1, 1).equals(" ")) {
                this.freeFormatCOBOL = true;
                return false;
            }
        }
        if (StringUtils.isNumeric(col7 = iC_p_line.substring(6, 7))) {
            boolean letItGo = true;
            int column = 1;
            while (column < 7) {
                if (iC_p_line.substring(column - 1, 1).equals("*")) break;
                if (!iC_p_line.substring(column - 1, 1).equals(" ") && !StringUtils.isNumeric(iC_p_line.substring(column - 1, 1))) {
                    letItGo = false;
                    break;
                }
                column = (short)(column + 1);
            }
            if (letItGo) {
                return false;
            }
        }
        if (iBaseLanguageString != null && iBaseLanguageString.equals("COB")) {
            return false;
        }
        if (col7.startsWith("$")) {
            return true;
        }
        this.identifier = (char)78;
        this.score = 0;
        this.processDeallocate();
        return true;
    }

    public int getCompilerDirectingCount() {
        return this.compilerDirectingCount_COBOL;
    }

    @Override
    public boolean getIgnoreCase() {
        return true;
    }

    public boolean getInvalidCOBOLsequence() {
        return this.invalidCOBOLsequence;
    }

    public int getPictureCount() {
        return this.pictureCount;
    }

    public int getVerbCount() {
        return this.verbCount_COBOL;
    }

    private void TokenComplete(String C_p_line) {
        this.tokenNumberOnLine = (short)(this.tokenNumberOnLine + 1);
        this.scoreCompletedToken(C_p_line);
        this.previousPreviousToken = this.previousToken;
        this.previousToken = this.currentToken;
        this.previousTokenNumberOnLine = this.tokenNumberOnLine;
        this.currentToken = "";
        this.C_TokenState = (char)83;
    }

    private void HandlePeriodToken() {
        if (this.EXEC_SQL_flag_COB) {
            return;
        }
        if (this.periodWORDperiod == 0) {
            this.periodWORDperiod = 1;
        } else if (this.periodWORDperiod == 2) {
            this.invalidCOBOLsequence = true;
            this.periodWORDperiod = 0;
        }
    }

    @Override
    public void isScoreBad(int iLineCount) {
        if (this.score == 0) {
            return;
        }
        if (this.getInvalidCOBOLsequence()) {
            this.score = 0;
        } else if (this.getVerbCount() == 0 && this.getPictureCount() == 0 && this.getCommentCount() == 0 && this.getCompilerDirectingCount() == 0) {
            if (iLineCount == 1) {
                if (this.score < 5) {
                    this.score = 0;
                }
            } else if (iLineCount < 5 && this.score < 9) {
                this.score = 0;
            }
        }
    }

    @Override
    public ClassifierMetaData processEndOfFile(int iLineCount) {
        this.metaData.setTotalLine(iLineCount);
        this.metaData.setBlankline(this.blankCount);
        this.metaData.setNonCommentLine(iLineCount - this.blankCount - this.getCommentCount());
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        super.processInitialization();
        this.processDeallocate();
        this.metaData = new ClassifierMetaData();
        this.C_Continuation = false;
        this.C_NewLine = false;
        this.C_featurestate = (char)73;
        this.C_foundIN = (char)78;
        this.C_StringDelimiter = (char)32;
        this.C_TokenState = (char)83;
        this.CBL_marker = false;
        this.columnCurrentRecord = 0;
        this.columnPriorRecord = 0;
        this.compilerDirectingCount_COBOL = 0;
        this.currentToken = "";
        this.EXEC_CICS_flag_COB = false;
        this.EXEC_SQL_flag_COB = false;
        this.freeFormatCOBOL = false;
        this.idDivFound = false;
        this.includedMember = "";
        this.inDivision = (char)32;
        this.inRemarksParaFlag = false;
        this.invalidCOBOLsequence = false;
        this.keep_index = 3;
        this.mapName = "";
        this.mapSetName = "";
        this.periodWORDperiod = 0;
        this.pictureCount = 0;
        this.previousToken = "";
        this.previousPreviousToken = "";
        this.previousTokenNumberOnLine = 0;
        this.tokenNumberOnLine = 0;
        this.verbCount_COBOL = 0;
    }

    @Override
    protected void processOneRecord(int iRecordCount, String iRecord, String iBaseLanguageString) {
        if (this.identifier == 'U') {
            if ((iBaseLanguageString == null || iBaseLanguageString != null && !iBaseLanguageString.equals("COB")) && iRecord.startsWith("//")) {
                this.identifier = (char)78;
                this.score = 0;
                this.processDeallocate();
                return;
            }
        } else if (this.identifier != 'Y') {
            return;
        }
        this.CBL_marker = this.idDivFound ? false : iRecord.contains("CBL ") || iRecord.contains("CBL\n") || iRecord.contains("PROCESS ") || iRecord.contains("PROCESS\n");
        this.columnPriorRecord = this.columnCurrentRecord;
        this.C_Continuation = false;
        if (this.CheckAlternateLocationOfINC(iRecord)) {
            return;
        }
        if (this.ValidateColumnSeven(iRecord, iBaseLanguageString, iRecordCount)) {
            return;
        }
        if (this.C_TokenState == 'E') {
            this.C_TokenState = (char)67;
        }
        if (this.C_TokenState == 'Q' && this.freeFormatCOBOL) {
            this.C_TokenState = (char)67;
        }
        if (this.C_TokenState == 'Q') {
            if (this.C_Continuation) {
                iRecord = iRecord.substring(7);
                this.columnCurrentRecord = 7;
                while (iRecord.length() != 0 && (iRecord.startsWith(" ") || iRecord.startsWith("\t"))) {
                    iRecord = iRecord.substring(1);
                    ++this.columnCurrentRecord;
                }
                if (iRecord.length() == 0) {
                    return;
                }
                if (iRecord.startsWith("\"") || iRecord.startsWith("'")) {
                    iRecord = iRecord.substring(1);
                    ++this.columnCurrentRecord;
                }
            } else {
                this.currentToken = String.valueOf(this.currentToken) + ".";
                if (this.currentToken.length() >= 160) {
                    this.TokenComplete(iRecord);
                    this.periodWORDperiod = 0;
                    return;
                }
                this.columnCurrentRecord = this.columnPriorRecord + 2;
                while (iRecord.length() != 0 && (iRecord.startsWith(" ") || iRecord.startsWith("\t"))) {
                    iRecord = iRecord.substring(1);
                    ++this.columnCurrentRecord;
                }
                if (iRecord.length() == 0) {
                    return;
                }
            }
        } else {
            if (this.freeFormatCOBOL) {
                this.columnCurrentRecord = 1;
            } else {
                iRecord = iRecord.substring(6);
                this.columnCurrentRecord = 7;
            }
            while (iRecord.length() != 0 && (iRecord.startsWith(" ") || iRecord.startsWith("\t"))) {
                iRecord = iRecord.substring(1);
                ++this.columnCurrentRecord;
            }
            if (iRecord.length() == 0) {
                return;
            }
            if (iRecord.startsWith("*")) {
                this.score += 5;
                this.metaData.incrementCommentLine();
                return;
            }
        }
        this.C_NewLine = true;
        if (this.C_TokenState == 'S') {
            this.tokenNumberOnLine = 0;
        }
        while (!iRecord.startsWith("\n") && iRecord.length() != 0 && this.columnCurrentRecord != 72) {
            char nextChar;
            char currentChar = iRecord.charAt(0);
            boolean C_IsDelimiter = currentChar == '.' ? (this.EXEC_SQL_flag_COB ? true : (this.columnCurrentRecord + 1 == 72 ? true : (iRecord.length() == 1 ? true : (nextChar = iRecord.charAt(1)) == ' ' || nextChar == '\n' || nextChar == '\t'))) : currentChar == ' ' || currentChar == '(' || currentChar == ')' || currentChar == ',' || currentChar == ':' || currentChar == ';' || currentChar == '\'' || currentChar == '/' || currentChar == '*' || currentChar == '=' || currentChar == '>' || currentChar == '<' || currentChar == '+' || currentChar == '\"';
            block0 : switch (this.C_TokenState) {
                case 'S': {
                    currentChar = iRecord.charAt(0);
                    if (currentChar == ' ' || currentChar == '\t') {
                        iRecord = iRecord.substring(1);
                        ++this.columnCurrentRecord;
                        break;
                    }
                    if (currentChar == 'X') {
                        this.currentToken = String.valueOf(this.currentToken) + iRecord.substring(0, 1);
                        if ((iRecord = iRecord.substring(1)).length() == 0) {
                            this.C_TokenState = (char)67;
                            break;
                        }
                        currentChar = iRecord.charAt(0);
                        ++this.columnCurrentRecord;
                        if (currentChar == '\"' || currentChar == '\'') {
                            this.C_TokenState = (char)88;
                            break;
                        }
                        this.C_TokenState = (char)67;
                        break;
                    }
                    if (currentChar == '\"' || currentChar == '\'') {
                        this.C_StringDelimiter = currentChar;
                        this.currentToken = String.valueOf(this.currentToken) + iRecord.substring(0, 1);
                        iRecord = iRecord.substring(1);
                        ++this.columnCurrentRecord;
                        this.C_TokenState = (char)81;
                        break;
                    }
                    if (C_IsDelimiter) {
                        this.currentToken = String.valueOf(this.currentToken) + iRecord.substring(0, 1);
                        iRecord = iRecord.substring(1);
                        ++this.columnCurrentRecord;
                        this.TokenComplete(iRecord);
                        break;
                    }
                    this.currentToken = String.valueOf(this.currentToken) + iRecord.substring(0, 1);
                    iRecord = iRecord.substring(1);
                    ++this.columnCurrentRecord;
                    this.C_TokenState = (char)67;
                    break;
                }
                case 'C': {
                    if (this.C_NewLine && !this.C_Continuation) {
                        this.TokenComplete(iRecord);
                        this.tokenNumberOnLine = 0;
                        this.C_TokenState = (char)67;
                        break;
                    }
                    if (iRecord.substring(1, 1).equals(" ") || iRecord.substring(1, 1).equals("\t")) {
                        this.C_TokenState = (char)66;
                        iRecord = iRecord.substring(1);
                        ++this.columnCurrentRecord;
                        break;
                    }
                    if (C_IsDelimiter) {
                        this.TokenComplete(iRecord);
                        break;
                    }
                    this.currentToken = String.valueOf(this.currentToken) + iRecord.substring(0, 1);
                    iRecord = iRecord.substring(1);
                    ++this.columnCurrentRecord;
                    break;
                }
                case 'B': {
                    if (this.C_NewLine) {
                        if (this.C_Continuation) {
                            this.C_TokenState = (char)67;
                            break;
                        }
                        this.TokenComplete(iRecord);
                        break;
                    }
                    if (iRecord.substring(1, 1).equals(" ") || iRecord.substring(1, 1).equals("\t")) {
                        iRecord = iRecord.substring(1);
                        ++this.columnCurrentRecord;
                        break;
                    }
                    this.TokenComplete(iRecord);
                    break;
                }
                case 'Q': {
                    if (currentChar == this.C_StringDelimiter) {
                        this.C_TokenState = (char)69;
                    }
                    this.currentToken = String.valueOf(this.currentToken) + iRecord.substring(0, 1);
                    iRecord = iRecord.substring(1);
                    ++this.columnCurrentRecord;
                    break;
                }
                case 'E': {
                    if (currentChar == this.C_StringDelimiter) {
                        iRecord = iRecord.substring(1);
                        ++this.columnCurrentRecord;
                        this.C_TokenState = (char)81;
                        break;
                    }
                    this.TokenComplete(iRecord);
                    break;
                }
                case 'X': {
                    switch (iRecord.charAt(0)) {
                        case '\t': 
                        case ' ': {
                            iRecord = iRecord.substring(1);
                            ++this.columnCurrentRecord;
                            this.C_TokenState = (char)66;
                            break block0;
                        }
                        case '\"': 
                        case '\'': {
                            this.C_StringDelimiter = iRecord.charAt(0);
                            this.currentToken = String.valueOf(this.currentToken) + iRecord.substring(0, 1);
                            iRecord = iRecord.substring(1);
                            ++this.columnCurrentRecord;
                            this.C_TokenState = (char)81;
                            break block0;
                        }
                    }
                    if (C_IsDelimiter) {
                        this.TokenComplete(iRecord);
                        break;
                    }
                    this.currentToken = String.valueOf(this.currentToken) + iRecord.substring(0, 1);
                    iRecord = iRecord.substring(1);
                    ++this.columnCurrentRecord;
                    this.C_TokenState = (char)67;
                    break;
                }
            }
            if (this.identifier == 'N') break;
            if (this.currentToken.length() >= 160) {
                this.TokenComplete(iRecord);
                if (this.identifier == 'N') break;
            }
            this.C_NewLine = false;
            this.C_Continuation = false;
        }
        this.periodWORDperiod = 0;
    }

    private void scoreCompletedToken(String C_p_line) {
        if (this.currentToken.equals(".")) {
            if (this.C_featurestate == 'R') {
                this.CaptureCopyName(this.includedMember);
                this.C_featurestate = (char)73;
            } else {
                this.HandlePeriodToken();
            }
            return;
        }
        if (this.currentToken.length() == 1 && (this.currentToken.equals("(") || this.currentToken.equals(")") || this.currentToken.equals(",") || this.currentToken.equals(":") || this.currentToken.equals("\"") || this.currentToken.equals("'") || this.currentToken.equals("/") || this.currentToken.equals("*") || this.currentToken.equals("=") || this.currentToken.equals(">") || this.currentToken.equals("<") || this.currentToken.equals("+"))) {
            this.periodWORDperiod = 0;
            return;
        }
        if (this.currentToken.length() == 1 && this.currentToken.equals(";")) {
            this.periodWORDperiod = 0;
            this.EXEC_CICS_flag_COB = false;
            this.EXEC_SQL_flag_COB = false;
            return;
        }
        ClassifierReservedWord rw = (ClassifierReservedWord)this.reservedWords.get(this.currentToken);
        if (rw != null) {
            this.periodWORDperiod = 0;
            if (!this.inRemarksParaFlag) {
                this.AccumulatePointsForTheScore(rw, C_p_line);
            } else if (this.tokenNumberOnLine == 1 && (this.currentToken.equals("ID") || this.currentToken.equals("IDENTIFICATION") || this.currentToken.equals("ENVIRONMENT") || this.currentToken.equals("DATA") || this.currentToken.equals("PROCEDURE") || this.currentToken.equals("DIVISION"))) {
                this.AccumulatePointsForTheScore(rw, C_p_line);
            }
        } else if (this.inRemarksParaFlag) {
            this.periodWORDperiod = 0;
        } else if (!StringUtils.isNumeric(this.currentToken) && this.inDivision == 'P') {
            this.periodWORDperiod = this.periodWORDperiod == 1 ? 2 : 0;
        }
        switch (this.C_featurestate) {
            case 'A': {
                this.C_featurestate = this.processState_A();
                break;
            }
            case 'E': {
                this.C_featurestate = this.processState_E();
                break;
            }
            case 'C': {
                this.C_featurestate = this.processState_C();
                break;
            }
            case 'M': {
                this.C_featurestate = this.processState_M();
                break;
            }
            case 'N': {
                this.C_featurestate = this.processState_N();
                break;
            }
            case 'O': {
                this.C_featurestate = this.processState_O();
                break;
            }
            case 'P': {
                this.C_featurestate = this.processState_P();
                break;
            }
            case 'R': {
                this.C_featurestate = this.processState_R();
                break;
            }
            case 'S': {
                this.C_featurestate = this.processState_S();
                break;
            }
            default: {
                this.C_featurestate = this.processState_I();
            }
        }
    }

    private char processState_A() {
        this.metaData.addInclude(7, this.currentToken);
        return 'I';
    }

    private char processState_C() {
        this.includedMember = this.currentToken;
        this.includedMember = StringUtils.strip(this.includedMember, "\"");
        this.includedMember = StringUtils.strip(this.includedMember, "'");
        this.C_foundIN = (char)78;
        return 'R';
    }

    private char processState_E() {
        if (this.currentToken.equals("CICS")) {
            this.EXEC_CICS_flag_COB = true;
            this.metaData.incrementNumValue(30);
            return 'O';
        }
        if (this.currentToken.equals("SQL")) {
            this.EXEC_SQL_flag_COB = true;
            this.metaData.incrementNumValue(33);
            return 'S';
        }
        if (this.currentToken.equals("DLI")) {
            this.metaData.incrementNumValue(31);
        } else if (this.currentToken.equals("IDMS")) {
            this.metaData.incrementNumValue(32);
        }
        return 'I';
    }

    private char processState_I() {
        if (this.currentToken.equals("DIVISION")) {
            if (this.previousTokenNumberOnLine == 1) {
                if (this.previousToken.equals("ID") || this.previousToken.equals("IDENTIFICATION")) {
                    this.inDivision = (char)73;
                    this.idDivFound = true;
                    this.metaData.incrementNumValue(34);
                    this.inRemarksParaFlag = false;
                    if (this.identifier == 'U') {
                        this.identifier = (char)89;
                    }
                } else if (this.previousToken.equals("ENVIRONMENT")) {
                    this.inDivision = (char)69;
                    this.metaData.incrementNumValue(35);
                    this.inRemarksParaFlag = false;
                    if (this.identifier == 'U') {
                        this.identifier = (char)89;
                    }
                } else if (this.previousToken.equals("DATA")) {
                    this.inDivision = (char)68;
                    this.metaData.incrementNumValue(36);
                    this.inRemarksParaFlag = false;
                    if (this.identifier == 'U') {
                        this.identifier = (char)89;
                    }
                } else if (this.previousToken.equals("PROCEDURE")) {
                    this.inDivision = (char)80;
                    this.metaData.incrementNumValue(37);
                    this.inRemarksParaFlag = false;
                    if (this.identifier == 'U') {
                        this.identifier = (char)89;
                    }
                }
            }
            return 'I';
        }
        if (this.inRemarksParaFlag) {
            return 'I';
        }
        if (this.currentToken.equals("COPY")) {
            return 'C';
        }
        if (this.currentToken.equals("EXEC") || this.currentToken.equals("EXECUTE")) {
            return 'E';
        }
        if (this.currentToken.equals("'CBLTDLI'") || this.currentToken.equals("\"CBLTDLI\"")) {
            if (this.previousToken.equals("CALL")) {
                this.metaData.incrementNumValue(38);
            }
        } else if (this.currentToken.equals("END-EXEC")) {
            this.EXEC_CICS_flag_COB = false;
            this.EXEC_SQL_flag_COB = false;
        } else if (this.currentToken.equals("REMARKS") && this.inDivision == 'I') {
            this.inRemarksParaFlag = true;
        }
        return 'I';
    }

    private char processState_M() {
        if (this.currentToken.equals("END-EXEC")) {
            this.EXEC_CICS_flag_COB = false;
            return 'I';
        }
        if (this.currentToken.equals("MAP") || this.currentToken.equals("MAPSET")) {
            return 'P';
        }
        return 'M';
    }

    private char processState_N() {
        if (this.C_foundIN == 'N') {
            String ddName = this.currentToken;
            ddName = StringUtils.strip(ddName, "\"");
            ddName = StringUtils.strip(ddName, "'");
            this.includedMember = String.valueOf(this.includedMember) + " DD=" + ddName;
            this.keep_index = 4;
            this.C_foundIN = (char)89;
            return 'R';
        }
        return 'N';
    }

    private char processState_O() {
        if (this.currentToken.equals("RECEIVE") || this.currentToken.equals("SEND")) {
            this.mapName = "";
            this.mapSetName = "";
            return 'M';
        }
        if (this.currentToken.equals("HANDLE") || this.currentToken.equals("LINK") || this.currentToken.equals("XCTL")) {
            this.metaData.incrementNumValue(83);
        }
        return 'I';
    }

    private char processState_P() {
        if (this.currentToken.equals("END-EXEC")) {
            if (this.mapName.length() != 0) {
                if (this.mapSetName.length() != 0) {
                    this.metaData.addMap(this.mapSetName, this.mapName);
                } else {
                    this.metaData.addMap(this.mapName, this.mapName);
                }
            }
            this.EXEC_CICS_flag_COB = false;
            return 'I';
        }
        if (this.previousPreviousToken.equals("MAP") && this.previousToken.equals("(")) {
            this.mapName = this.currentToken;
        } else if (this.previousPreviousToken.equals("MAPSET") && this.previousToken.equals("(")) {
            this.mapSetName = this.currentToken;
        }
        return 'P';
    }

    private char processState_R() {
        if (this.currentToken.equals("IN") || this.currentToken.equals("OF")) {
            return 'N';
        }
        if (this.currentToken.equals("REPLACING")) {
            this.metaData.incrementNumValue(64);
            this.CaptureCopyName(this.includedMember);
            return 'I';
        }
        return 'R';
    }

    private char processState_S() {
        if (this.currentToken.equals("INCLUDE")) {
            this.score += 10;
            return 'A';
        }
        return 'I';
    }

    private boolean ValidateColumnSeven(String iC_p_line, String iBaseLanguageString, int iLineCount) {
        boolean rc;
        if (this.freeFormatCOBOL) {
            return false;
        }
        if (iC_p_line.length() < 7) {
            return true;
        }
        char column7char = iC_p_line.charAt(6);
        switch (column7char) {
            case ' ': 
            case 'D': {
                rc = false;
                break;
            }
            case '*': 
            case '/': {
                this.score += 5;
                this.metaData.incrementCommentLine();
                rc = true;
                break;
            }
            case '-': {
                ++this.score;
                this.C_Continuation = true;
                rc = false;
                break;
            }
            default: {
                rc = this.CheckOtherColumnSevenValues(iC_p_line, iBaseLanguageString, iLineCount);
            }
        }
        return rc;
    }
}

