/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.previous;

import com.ibm.team.enterprise.zos.metadata.common.classify.previous.Classifier;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierReservedWord;

class ClassifierC
extends Classifier {
    private static final boolean IGNORE_CASE = false;
    private static final char CHAR_START = '\'';
    private static final char STRING_START = '\"';
    private static final String BRACKET_CHARS = "{[()]}";
    private static final String COMMENT_END = "*/";
    private static final String COMMENT_START = "/*";
    private static final String OPERATOR_CHARS = "-+*/<>!~%^&|=";
    private static final String SEQUENCE_CHARS = ",";
    private static final String SINGLE_COMMENT = "//";
    private static final String[] TRIGRAPH_CHARS = new String[]{"??=", "??(", "??)", "??/", "??'", "??<", "??>", "??!", "??-"};
    private boolean newLine;
    private char featureState;
    private String currentChar;
    private String stringDelimiter;
    private char tokenState;
    private short tokenNumber;
    private String currentToken;
    private String inComment;

    public ClassifierC() {
        this.reservedWordFilename = "/com/ibm/team/enterprise/zos/metadata/common/classify/rwC.txt";
    }

    protected void AccumulatePointsForTheScore(ClassifierReservedWord iRw) {
        if (iRw.getTokenWordType() == 1) {
            ++this.reserveWordCount;
            this.score += iRw.getTokenWeight();
        } else {
            this.score = iRw.getTokenWordType() == 3 ? (this.score += iRw.getTokenWeight()) : (this.score += iRw.getTokenWeight());
        }
        if (this.debug) {
            System.out.println("C score: " + this.score);
        }
    }

    private void CompleteToken(String iBaseLanguageString) {
        this.tokenNumber = (short)(this.tokenNumber + 1);
        if (this.debug) {
            System.out.println("   Token[" + this.tokenNumber + "] " + this.currentToken);
        }
        if (this.currentToken.charAt(0) == '\'' || this.currentToken.charAt(0) == '\"') {
            this.currentToken = "";
            this.tokenState = (char)83;
            return;
        }
        if (this.currentToken.contains(BRACKET_CHARS) || this.currentToken.contains(OPERATOR_CHARS)) {
            this.currentToken = "";
            this.tokenState = (char)83;
            return;
        }
        ClassifierReservedWord rw = (ClassifierReservedWord)this.reservedWords.get(this.currentToken);
        if (rw != null) {
            this.AccumulatePointsForTheScore(rw);
        }
        switch (this.featureState) {
            case 'C': {
                break;
            }
            case 'E': {
                if (iBaseLanguageString == null || iBaseLanguageString != null && !iBaseLanguageString.equals("C")) {
                    if (this.currentToken.equals("CICS")) {
                        this.identifier = (char)78;
                        this.score = 0;
                        this.processDeallocate();
                        break;
                    }
                    if (this.currentToken.equals("SQL")) {
                        this.identifier = (char)78;
                        this.score = 0;
                        this.processDeallocate();
                        break;
                    }
                }
                this.featureState = (char)73;
                break;
            }
            case 'I': {
                if (this.currentToken.equals("EXEC") || this.currentToken.equals("EXECUTE")) {
                    this.featureState = (char)69;
                    break;
                }
                if (!this.currentToken.equals("#include")) break;
                this.featureState = (char)67;
                break;
            }
        }
        this.currentToken = "";
        this.tokenState = (char)83;
    }

    @Override
    public void isScoreBad(int iLineCount) {
        if (this.score == 0) {
            return;
        }
        int reserveWordCount = this.getReserveWordCount();
        if (reserveWordCount == 0) {
            this.score = 0;
        }
    }

    private boolean LastCharOnTheRecord(String iChar) {
        boolean rc = true;
        iChar = iChar.substring(1);
        while (iChar.length() != 0) {
            if (iChar.charAt(0) == ' ') {
                iChar = iChar.substring(1);
                continue;
            }
            rc = false;
            break;
        }
        return rc;
    }

    @Override
    public boolean getIgnoreCase() {
        return false;
    }

    @Override
    public ClassifierMetaData processEndOfFile(int iLineCount) {
        this.metaData.setTotalLine(iLineCount);
        this.metaData.setBlankline(this.blankCount);
        this.metaData.setNonCommentLine(iLineCount - this.blankCount - this.getCommentCount());
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        super.processInitialization();
        this.processDeallocate();
        this.currentToken = "";
        this.featureState = (char)73;
        this.identifier = (char)85;
        this.inComment = null;
        this.metaData = new ClassifierMetaData();
        this.reserveWordCount = 0;
        this.tokenState = (char)83;
    }

    @Override
    protected void processOneRecord(int iRecordCount, String iRecord, String iBaseLanguageString) {
        if (this.identifier == 'N') {
            return;
        }
        if (this.identifier == 'U' && iBaseLanguageString != null && iBaseLanguageString != null) {
            iBaseLanguageString.equals("C");
        }
        if (this.debug) {
            System.out.println("C/C++ line: " + iRecord);
        }
        while (iRecord.length() != 0) {
            this.currentChar = iRecord.substring(0, 1);
            if (!this.currentChar.equals(" ")) break;
            iRecord = iRecord.substring(1);
        }
        if (iRecord.length() == 0) {
            return;
        }
        this.newLine = true;
        this.tokenNumber = 0;
        while (iRecord.length() != 0) {
            this.currentChar = iRecord.substring(0, 1);
            if (this.inComment != null) {
                if (this.inComment.equals(COMMENT_START)) {
                    if (iRecord.startsWith(COMMENT_END)) {
                        iRecord = iRecord.substring(COMMENT_END.length());
                        this.inComment = null;
                        continue;
                    }
                    iRecord = iRecord.substring(1);
                    continue;
                }
                iRecord = iRecord.substring(1);
                continue;
            }
            if (iRecord.startsWith(COMMENT_START)) {
                this.inComment = COMMENT_START;
                iRecord = iRecord.substring(COMMENT_START.length());
                continue;
            }
            if (iRecord.startsWith(SINGLE_COMMENT)) {
                this.inComment = SINGLE_COMMENT;
                iRecord = iRecord.substring(SINGLE_COMMENT.length());
                continue;
            }
            if (iRecord.startsWith("?") && iRecord.length() > 2) {
                String tempTrigraphChar = iRecord.substring(0, 3);
                boolean found = false;
                int i = 0;
                while (i < TRIGRAPH_CHARS.length) {
                    if (tempTrigraphChar.equals(TRIGRAPH_CHARS[i])) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (found) {
                    this.currentToken = tempTrigraphChar;
                    iRecord = iRecord.substring(3);
                    this.CompleteToken(iBaseLanguageString);
                    continue;
                }
            }
            boolean isDelimiter = BRACKET_CHARS.contains(this.currentChar) || OPERATOR_CHARS.contains(this.currentChar) || SEQUENCE_CHARS.contains(this.currentChar);
            boolean tokenComplete = false;
            switch (this.tokenState) {
                case 'B': {
                    if (!this.newLine && this.currentChar.equals(" ")) break;
                    tokenComplete = true;
                    break;
                }
                case 'C': {
                    if (this.newLine) {
                        tokenComplete = true;
                        break;
                    }
                    if (this.currentChar.equals(" ")) {
                        this.tokenState = (char)66;
                        break;
                    }
                    if (isDelimiter) {
                        tokenComplete = true;
                        break;
                    }
                    this.currentToken = String.valueOf(this.currentToken) + this.currentChar;
                    break;
                }
                case 'E': {
                    if (this.currentChar.equals(this.stringDelimiter)) {
                        this.tokenState = (char)81;
                        break;
                    }
                    tokenComplete = true;
                    break;
                }
                case 'Q': {
                    if (this.currentChar.equals(this.stringDelimiter)) {
                        this.tokenState = (char)69;
                    }
                    this.currentToken = String.valueOf(this.currentToken) + this.currentChar;
                    break;
                }
                case 'S': {
                    if (this.currentChar.equals("X")) {
                        this.currentToken = String.valueOf(this.currentToken) + iRecord.substring(0, 1);
                        this.tokenState = (char)88;
                        break;
                    }
                    if (this.currentChar.charAt(0) == '\'' || this.currentChar.charAt(0) == '\"') {
                        this.stringDelimiter = this.currentChar;
                        this.currentToken = String.valueOf(this.currentToken) + this.currentChar;
                        this.tokenState = (char)81;
                        break;
                    }
                    if (this.currentChar.equals(" ")) break;
                    this.currentToken = String.valueOf(this.currentToken) + this.currentChar;
                    if (isDelimiter) {
                        iRecord = iRecord.substring(1);
                        tokenComplete = true;
                        break;
                    }
                    this.tokenState = (char)67;
                    break;
                }
                case 'X': {
                    if (this.currentChar.equals(" ")) {
                        this.tokenState = (char)66;
                        break;
                    }
                    if (this.currentChar.equals(Character.valueOf('\'')) || this.currentChar.equals(Character.valueOf('\"'))) {
                        this.stringDelimiter = this.currentChar;
                        this.currentToken = String.valueOf(this.currentToken) + this.currentChar;
                        iRecord = iRecord.substring(1);
                        this.tokenState = (char)81;
                        break;
                    }
                    if (isDelimiter) {
                        tokenComplete = true;
                        break;
                    }
                    this.currentToken = String.valueOf(this.currentToken) + iRecord.substring(0, 1);
                    iRecord = iRecord.substring(1);
                    this.tokenState = (char)67;
                    break;
                }
            }
            if (tokenComplete || this.currentToken.length() >= 255) {
                this.CompleteToken(iBaseLanguageString);
                if (this.identifier == 'N') {
                    break;
                }
            } else {
                if (iRecord.length() == 0) break;
                iRecord = iRecord.substring(1);
            }
            this.newLine = false;
        }
        if (this.identifier == 'N') {
            return;
        }
        if (this.inComment == SINGLE_COMMENT) {
            this.inComment = null;
        }
        if (this.tokenState != 'S') {
            this.CompleteToken(iBaseLanguageString);
        }
    }
}

