/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.previous;

import com.ibm.team.enterprise.zos.metadata.common.classify.previous.Classifier;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.previous.ClassifierReservedWord;
import com.ibm.team.enterprise.zos.metadata.common.classify.utils.StringUtils;
import java.util.Map;
import java.util.Set;

class ClassifierASM
extends Classifier {
    private final int LABEL_LENGTH = 63;
    private final int OPERATION_LENGTH = 63;
    private final int OPERAND_LENGTH = 8192;
    private final int Initial = 1;
    private final int ScanningLabel = 2;
    private final int LookingForOperation = 3;
    private final int ScanningOperation = 4;
    private final int LookingForOperands = 5;
    private final int ScanningOperandForAIF = 6;
    private final int ScanningOperands = 7;
    private final int ScanningQuotedString = 8;
    private final int QuoteFoundInString = 9;
    private final String ASM_charSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz@$#_0123456789+-,=.*()'/& ";
    private boolean continuationLine = false;
    private boolean after_1st_macro = false;
    private boolean BMSmacroFound = false;
    private boolean DBDGEN_END_Found = false;
    private boolean DBDGEN_Found = false;
    private boolean first_macro = true;
    private boolean literalContinued = false;
    private boolean MACRO_MEND_Found = false;
    private boolean macroWellFormed = true;
    private boolean operandForAIF = false;
    private boolean operandWellFormed = true;
    private boolean processingComment = false;
    private boolean PSBGEN_Found = false;
    private boolean REPRO_Found = false;
    private boolean TELL_Found = false;
    private char languageFeatureState = (char)79;
    private int A_State;
    private int column;
    private int DBDGEN_Operations_score = 0;
    private int noncomment_after_1st_macro = 0;
    private int parenCount = 0;
    private int PSBGEN_Operations_score = 0;
    private String Label;
    private String Operand;
    private String pOperandContinued;
    private String Operation;

    public ClassifierASM() {
        this.reservedWordFilename = "/com/ibm/team/enterprise/zos/metadata/common/classify/rwASM.txt";
    }

    private boolean CheckFirstColumn(String iRecord, int iLineCount, String iBaseLanguageString) {
        if (iRecord.charAt(0) == '>' && iLineCount == 1) {
            return true;
        }
        if (iRecord.charAt(0) == '*') {
            this.processingComment = true;
            this.score += 5;
            this.metaData.incrementCommentLine();
            this.checkIfContinuationLine(iRecord);
            return true;
        }
        if (this.processingComment && this.continuationLine) {
            this.checkIfContinuationLine(iRecord);
            return true;
        }
        this.processingComment = false;
        if ((iBaseLanguageString == null || iBaseLanguageString != null && !iBaseLanguageString.equals("ASM")) && iRecord.startsWith("//")) {
            if (this.DBDGEN_END_Found) {
                return true;
            }
            this.identifier = (char)78;
            this.score = 0;
            this.processDeallocate();
            return true;
        }
        String tokens = iRecord.trim();
        if (tokens.startsWith(".*")) {
            this.score += 5;
            this.metaData.incrementCommentLine();
            return true;
        }
        return false;
    }

    private void checkIfContinuationLine(String iRecord) {
        this.continuationLine = iRecord.length() >= 72 && iRecord.charAt(71) != ' ';
    }

    private void CheckIncludeOperand(String[] iTokens) {
        if (iTokens.length == 1) {
            return;
        }
        if (!iTokens[1].equals("INCLUDE")) {
            return;
        }
        if (iTokens.length == 2) {
            return;
        }
        this.metaData.addInclude(7, iTokens[2]);
    }

    private void CheckNonReservedWord() {
        if (this.Operation.equals("EXEC")) {
            this.macroWellFormed = false;
            if (this.Operand == null) {
                return;
            }
            String[] tokens = StringUtils.split(this.Operand);
            if (tokens[0].equals("CICS")) {
                this.metaData.incrementNumValue(30);
            } else if (tokens[0].equals("DLI")) {
                this.metaData.incrementNumValue(31);
            } else if (tokens[0].equals("IDMS")) {
                this.metaData.incrementNumValue(32);
            } else if (tokens[0].equals("SQL")) {
                this.metaData.incrementNumValue(33);
                this.CheckIncludeOperand(tokens);
            }
            return;
        }
        if (this.Operation.equals("TELL")) {
            if (this.Operand.contains("CODE=NO")) {
                this.TELL_Found = true;
            }
            return;
        }
        this.metaData.addInclude(8, this.Operation);
        if (this.Operation.equals("AREA") || this.Operation.equals("DATASET") || this.Operation.equals("FIELD") || this.Operation.equals("FINISH") || this.Operation.equals("FLD") || this.Operation.equals("FLDK") || this.Operation.equals("LCHILD") || this.Operation.equals("SEGM") || this.Operation.equals("XDFLD")) {
            this.DBDGEN_Operations_score += 10;
        } else if (this.Operation.equals("DBDGEN")) {
            this.score += this.DBDGEN_Operations_score;
            this.DBDGEN_Operations_score = 0;
            this.DBDGEN_Found = true;
        } else if (this.Operation.equals("PSBGEN")) {
            this.score += this.PSBGEN_Operations_score;
            this.PSBGEN_Operations_score = 0;
            this.PSBGEN_Found = true;
        } else if (this.Operation.equals("SENSEG")) {
            this.PSBGEN_Operations_score += 10;
        }
    }

    private boolean CheckOperandContents() {
        return this.Operand.contains("'") || !this.Operand.contains(";");
    }

    private void CheckOperandForm() {
        if (!this.Operand.contains("=")) {
            this.operandWellFormed = false;
            return;
        }
        if (this.Operand.endsWith(",")) {
            return;
        }
        this.operandWellFormed = false;
    }

    private void CheckReservedWord(ClassifierReservedWord iRw, int iLineCount) {
        if (iRw.getTokenWordType() == 5 || iRw.getTokenWordType() == 3) {
            this.score += iRw.getTokenWeight();
            ++this.reserveWordCount;
        } else if (iRw.getTokenWordType() == 1) {
            if (this.Operation.equals("END") && this.DBDGEN_Found) {
                this.DBDGEN_END_Found = true;
            }
            this.score += iRw.getTokenWeight();
            ++this.reserveWordCount;
        }
        int attrTypeId = iRw.getTokenAttrTypeId();
        if (attrTypeId != 0) {
            if (this.hasItBeenDelcaredAMacro()) {
                this.metaData.addInclude(8, this.Operation);
                return;
            }
            if (attrTypeId == 65) {
                if (this.Operand.contains("TYPE=DSECT") || this.Operand.contains("TYPE=MAP")) {
                    this.metaData.incrementNumValue(attrTypeId);
                    this.BMSmacroFound = true;
                }
            } else {
                this.metaData.incrementNumValue(attrTypeId);
            }
        }
        if (this.Operation.equals("CALL") || this.Operation.equals("CALLDLI")) {
            if (this.Operand.equals("AIBTDLI")) {
                this.metaData.incrementNumValue(43);
            } else if (this.Operand.equals("ASMTDLI")) {
                this.metaData.incrementNumValue(42);
            } else if (this.Operand.equals("CBLTDLI")) {
                this.metaData.incrementNumValue(38);
            }
        } else if (this.Operation.equals("COPY")) {
            this.metaData.addInclude(3, this.Operand);
        } else if (this.Operation.equals("MACRO")) {
            if (this.first_macro) {
                this.first_macro = false;
                this.metaData.setNonBefore(iLineCount - this.blankCount - this.getCommentCount() - 1);
            }
            this.languageFeatureState = (char)73;
        } else if (this.Operation.equals("MEND")) {
            this.after_1st_macro = true;
            if (!this.first_macro) {
                this.MACRO_MEND_Found = true;
            }
        } else if (this.Operation.equals("REPRO")) {
            this.REPRO_Found = true;
        }
    }

    private boolean CheckStandardCharacterSet(String iChar) {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz@$#_0123456789+-,=.*()'/& ".contains(iChar);
    }

    private void ClearTokenFields() {
        this.Label = "";
        this.Operation = "";
        this.Operand = "";
        this.macroWellFormed = true;
        this.operandWellFormed = true;
        this.pOperandContinued = "";
    }

    public boolean hasBMSmacro() {
        return this.BMSmacroFound;
    }

    public boolean hasDBDGENstatement() {
        return this.DBDGEN_Found;
    }

    public boolean hasMACRO_MEND() {
        return this.MACRO_MEND_Found;
    }

    public boolean hasPSBGENstatement() {
        return this.PSBGEN_Found;
    }

    public boolean hasWellFormedMacro() {
        return this.macroWellFormed;
    }

    private boolean CompleteAStatement(int iLineCount, String iBaseLanguageString) {
        if (this.Label.length() != 0 && (this.Label.contains("=") || this.Label.contains(","))) {
            this.macroWellFormed = false;
        }
        if (this.Operation.length() != 0 && (this.Operation.contains("=") || this.Operation.contains(","))) {
            this.macroWellFormed = false;
        }
        if (this.identifier == 'U' && (iBaseLanguageString == null || iBaseLanguageString != null && !iBaseLanguageString.equals("ASM")) && this.ShouldItBeRejectedAsASM()) {
            this.identifier = (char)78;
            this.score = 0;
            this.processDeallocate();
            return false;
        }
        switch (this.languageFeatureState) {
            case 'I': {
                this.metaData.addInclude(62, this.Operation);
                this.languageFeatureState = (char)79;
                break;
            }
            case 'O': {
                ClassifierReservedWord rw = (ClassifierReservedWord)this.reservedWords.get(this.Operation);
                if (rw != null) {
                    this.macroWellFormed = false;
                    this.CheckReservedWord(rw, iLineCount);
                    break;
                }
                this.CheckNonReservedWord();
                break;
            }
        }
        return true;
    }

    private boolean GetLabelOperationOperand(String A_p_line) {
        boolean invalidChar = false;
        boolean stop = false;
        this.column = 0;
        while (A_p_line.length() != 0 && !stop) {
            ++this.column;
            switch (this.A_State) {
                case 1: {
                    if (A_p_line.charAt(0) == ' ') {
                        this.A_State = 3;
                        break;
                    }
                    this.Label = String.valueOf(this.Label) + A_p_line.charAt(0);
                    this.A_State = 2;
                    break;
                }
                case 2: {
                    if (A_p_line.charAt(0) == ' ' || this.Label.length() == 63) {
                        this.A_State = 3;
                        break;
                    }
                    if (!this.CheckStandardCharacterSet(A_p_line.substring(0, 1))) {
                        invalidChar = true;
                        stop = true;
                        break;
                    }
                    this.Label = String.valueOf(this.Label) + A_p_line.charAt(0);
                    break;
                }
                case 3: {
                    if (this.column == 72) {
                        stop = true;
                        break;
                    }
                    if (A_p_line.charAt(0) == ' ') break;
                    this.Operation = String.valueOf(this.Operation) + A_p_line.charAt(0);
                    this.A_State = 4;
                    break;
                }
                case 4: {
                    if (A_p_line.charAt(0) == ' ' || this.Operation.length() >= 63) {
                        this.A_State = 5;
                        break;
                    }
                    if (!this.CheckStandardCharacterSet(A_p_line.substring(0, 1))) {
                        invalidChar = true;
                        stop = true;
                        break;
                    }
                    this.Operation = String.valueOf(this.Operation) + A_p_line.charAt(0);
                    break;
                }
                case 5: {
                    if (this.column == 72) {
                        stop = true;
                        break;
                    }
                    if (A_p_line.charAt(0) == ' ') break;
                    if (this.pOperandContinued.length() != 0) {
                        this.pOperandContinued = String.valueOf(this.pOperandContinued) + A_p_line.charAt(0);
                    } else {
                        this.Operand = String.valueOf(this.Operand) + A_p_line.charAt(0);
                    }
                    this.operandForAIF = this.Operation.equals("AIF");
                    if (this.operandForAIF) {
                        if (A_p_line.charAt(0) == '(') {
                            ++this.parenCount;
                        } else if (A_p_line.charAt(0) == ')') {
                            --this.parenCount;
                        }
                        this.A_State = 6;
                        break;
                    }
                    if (A_p_line.charAt(0) == '\'' || this.literalContinued) {
                        this.A_State = 8;
                        break;
                    }
                    this.A_State = 7;
                    break;
                }
                case 6: {
                    if (this.Operand.length() >= 8192) {
                        stop = true;
                        break;
                    }
                    this.Operand = String.valueOf(this.Operand) + A_p_line.charAt(0);
                    if (this.column == 72) {
                        stop = true;
                    } else if (A_p_line.charAt(0) == '(') {
                        ++this.parenCount;
                    } else if (A_p_line.charAt(0) == ')') {
                        --this.parenCount;
                    }
                    if (this.parenCount != 0) break;
                    this.A_State = 7;
                    break;
                }
                case 7: {
                    if (this.Operand.length() >= 8192) {
                        stop = true;
                        break;
                    }
                    if (A_p_line.charAt(0) == ' ') {
                        if (this.Operation.equals("EXEC")) break;
                        stop = true;
                        break;
                    }
                    String prevOperand = this.Operand;
                    this.Operand = String.valueOf(this.Operand) + A_p_line.charAt(0);
                    if (this.column == 72) {
                        stop = true;
                        break;
                    }
                    if (A_p_line.charAt(0) != '\'' || prevOperand.endsWith("L")) break;
                    this.A_State = 8;
                    break;
                }
                case 8: {
                    this.literalContinued = false;
                    if (this.Operand.length() >= 8192) {
                        stop = true;
                        break;
                    }
                    this.Operand = String.valueOf(this.Operand) + A_p_line.charAt(0);
                    if (this.column == 72) {
                        this.literalContinued = true;
                        stop = true;
                        break;
                    }
                    if (A_p_line.charAt(0) != '\'') break;
                    this.A_State = 9;
                    break;
                }
                case 9: {
                    if (A_p_line.charAt(0) == ' ' || this.Operand.length() >= 8192) {
                        stop = true;
                        break;
                    }
                    this.Operand = String.valueOf(this.Operand) + A_p_line.charAt(0);
                    if (A_p_line.charAt(0) == '\'') {
                        this.A_State = 8;
                        break;
                    }
                    this.A_State = 7;
                    break;
                }
            }
            A_p_line = A_p_line.substring(1);
        }
        return !invalidChar;
    }

    private boolean hasItBeenDelcaredAMacro() {
        Map<Integer, Set<String>> inclList = this.metaData.getInclList();
        if (inclList == null || inclList.size() == 0) {
            return false;
        }
        for (Map.Entry<Integer, Set<String>> e : inclList.entrySet()) {
            if (e.getKey() != 62) continue;
            Set<String> values = e.getValue();
            for (String value : values) {
                if (!this.Operation.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void isScoreBad(int iLineCount) {
        if (this.score == 0) {
            return;
        }
        if (this.getReserveWordCount() == 0) {
            if (!this.hasWellFormedMacro()) {
                this.score = 0;
            } else if (iLineCount == 1) {
                this.score = 0;
            }
        }
    }

    @Override
    public ClassifierMetaData processEndOfFile(int iLineCount) {
        if (this.after_1st_macro) {
            this.metaData.setNonAfter(this.noncomment_after_1st_macro);
        }
        this.metaData.setTotalLine(iLineCount);
        this.metaData.setBlankline(this.blankCount);
        this.metaData.setNonCommentLine(iLineCount - this.blankCount - this.getCommentCount());
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        super.processInitialization();
        this.processDeallocate();
        this.after_1st_macro = false;
        this.BMSmacroFound = false;
        this.column = 0;
        this.continuationLine = false;
        this.DBDGEN_END_Found = false;
        this.DBDGEN_Found = false;
        this.DBDGEN_Operations_score = 0;
        this.first_macro = true;
        this.literalContinued = false;
        this.languageFeatureState = (char)79;
        this.MACRO_MEND_Found = false;
        this.noncomment_after_1st_macro = 0;
        this.operandForAIF = false;
        this.parenCount = 0;
        this.processingComment = false;
        this.PSBGEN_Found = false;
        this.PSBGEN_Operations_score = 0;
        this.REPRO_Found = false;
        this.TELL_Found = false;
        this.ClearTokenFields();
        this.identifier = (char)85;
        this.metaData = new ClassifierMetaData();
    }

    @Override
    protected void processOneRecord(int iRecordCount, String iRecord, String iBaseLanguage) {
        if (this.identifier != 'U' && this.identifier != 'Y') {
            return;
        }
        if (this.REPRO_Found) {
            this.REPRO_Found = false;
            if (this.after_1st_macro) {
                ++this.noncomment_after_1st_macro;
            }
            return;
        }
        if (this.TELL_Found) {
            if (iRecord.substring(0, 4).equals("-END")) {
                this.TELL_Found = false;
            }
            if (this.after_1st_macro) {
                ++this.noncomment_after_1st_macro;
            }
            return;
        }
        if (this.CheckFirstColumn(iRecord, iRecordCount, iBaseLanguage)) {
            return;
        }
        if (iRecord.length() > 80) {
            this.identifier = (char)78;
            this.score = 0;
            this.processDeallocate();
            return;
        }
        if (this.after_1st_macro) {
            ++this.noncomment_after_1st_macro;
        }
        if (this.continuationLine) {
            this.checkIfContinuationLine(iRecord);
            this.A_State = 5;
        } else {
            this.checkIfContinuationLine(iRecord);
            this.ClearTokenFields();
            this.A_State = 1;
        }
        if (!this.GetLabelOperationOperand(iRecord)) {
            this.identifier = (char)78;
            this.score = 0;
            this.processDeallocate();
            return;
        }
        if (this.continuationLine) {
            this.CheckOperandForm();
            if (this.operandWellFormed) {
                this.score += 5;
            }
            return;
        }
        if (!this.CompleteAStatement(iRecordCount, iBaseLanguage)) {
            return;
        }
        if (!this.operandWellFormed) {
            this.macroWellFormed = false;
        } else {
            if (this.Operation.equals("END;") || this.Operation.equals("OTHER") || this.Operation.equals("WHEN")) {
                return;
            }
            if (this.CheckOperandContents() && this.macroWellFormed) {
                this.score += 5;
            }
        }
    }

    private boolean ShouldItBeRejectedAsASM() {
        if (this.Operation.equals("TITLE")) {
            return this.Label.length() > 8 || this.Operand.charAt(0) != '\'';
        }
        if (this.Label.length() != 0) {
            if (StringUtils.isNumeric(this.Label.substring(0, 1))) {
                return true;
            }
            if (this.Label.charAt(0) == '_') {
                return true;
            }
        }
        if (this.Operation.length() != 0) {
            if (StringUtils.isNumeric(this.Operation.substring(0, 1))) {
                return true;
            }
            if (this.Operation.charAt(0) == '_') {
                return true;
            }
            if (this.Operation.contains("+") || this.Operation.contains("-") || this.Operation.contains(",") || this.Operation.contains("=") || this.Operation.contains("*") || this.Operation.contains("(") || this.Operation.contains(")") || this.Operation.contains("'") || this.Operation.contains("/") || this.Operation.contains("\\") || this.Operation.contains("%") || this.Operation.contains("?") || this.Operation.contains(":") || this.Operation.contains("{") || this.Operation.contains("}")) {
                return true;
            }
            if (this.Operation.equals("CALL") && this.Operand.length() != 0 && this.Operand.endsWith(";")) {
                return true;
            }
        }
        return false;
    }
}

