/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.process;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class ProcessExec {
    private boolean isConsoleLogging;
    private boolean isFinished;
    private boolean isLogging;
    private Exception exception;
    private int returnCode;
    private int timeout;
    private long consoleLogLimit;
    private long logLimit;
    private Process p;
    private Map<String, String> envVars;
    private ProcessBuilder pb;
    private String input;
    private String submitPw;
    private StringBuffer log;
    private StringBuffer stderr;
    private StringBuffer stdout;

    public ProcessExec(String ... command) {
        this.init();
        this.pb = new ProcessBuilder(command);
    }

    public ProcessExec(List<String> command) {
        this.init();
        this.pb = new ProcessBuilder(command);
    }

    public StringBuffer getStdOut() {
        return this.stdout;
    }

    public StringBuffer getStdErr() {
        return this.stderr;
    }

    public void appendEnvVar(String key, String val, String sep) {
        Map<String, String> env = this.pb.environment();
        for (String k : env.keySet()) {
            if (!k.equalsIgnoreCase(key)) continue;
            key = k;
        }
        String s = StringUtils.getString(env.get(key), "");
        env.put(key, String.valueOf(s) + (s.length() == 0 || s.endsWith(sep) ? "" : sep) + val);
    }

    public Exception getException() {
        return this.exception;
    }

    public StringBuffer getLog() {
        return this.log;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    private void init() {
        this.consoleLogLimit = Long.MAX_VALUE;
        this.envVars = new JsonMap<String, String>();
        this.exception = null;
        this.input = null;
        this.isConsoleLogging = false;
        this.isFinished = false;
        this.isLogging = false;
        this.log = null;
        this.logLimit = Long.MAX_VALUE;
        this.p = null;
        this.pb = null;
        this.returnCode = 0;
        this.stderr = new StringBuffer();
        this.stdout = new StringBuffer();
        this.submitPw = null;
        this.timeout = 0;
    }

    private void log(String msg) {
        if (this.isLogging) {
            this.log.append(String.valueOf(msg) + "\n");
        }
        if (this.isConsoleLogging) {
            System.out.println(msg);
        }
    }

    public int run() {
        this.returnCode = 0;
        try {
            if (this.isLogging) {
                this.log = new StringBuffer();
            }
            String cmdString = StringUtils.join(this.pb.command().iterator(), " ");
            if (this.submitPw != null) {
                cmdString = StringUtils.replace(cmdString, this.submitPw, "********");
            }
            this.log("Starting command:  " + cmdString);
            this.log("   From location:  " + (this.pb.directory() == null ? "not-specified" : this.pb.directory().getAbsolutePath()));
            this.log("    Timeout(sec):  " + this.timeout);
            this.log("        Env vars:  " + this.envVars.toString());
            this.p = this.pb.start();
            ProcessWatcher pw = null;
            if (this.timeout > 0) {
                pw = new ProcessWatcher();
                pw.start();
            }
            StreamWatcher outWatcher = new StreamWatcher(1);
            outWatcher.start();
            StreamWatcher errWatcher = new StreamWatcher(2);
            errWatcher.start();
            if (this.input != null) {
                Thread.sleep(1000L);
                OutputStreamWriter w = new OutputStreamWriter(this.p.getOutputStream());
                w.write(this.input);
                ((Writer)w).flush();
                ((Writer)w).close();
            }
            this.p.waitFor();
            if (outWatcher.isAlive()) {
                outWatcher.join(10000L);
            }
            if (errWatcher.isAlive()) {
                errWatcher.join(10000L);
            }
            this.isFinished = true;
            if (this.isLogging) {
                this.log("---STDOUT---");
                this.log(this.stdout.toString());
                this.log("---STDERR---");
                this.log(this.stderr.toString());
            }
            this.log("");
            if (this.timeout < 0) {
                throw new IOException("Command timed out.");
            }
            this.returnCode = this.p.exitValue();
        }
        catch (IOException e) {
            this.exception = e;
            this.returnCode = 1;
        }
        catch (InterruptedException e) {
            this.exception = e;
            this.returnCode = 2;
        }
        this.log("Return code:  " + this.returnCode);
        if (this.exception != null) {
            this.log("Exception:  " + this.exception.getLocalizedMessage());
        }
        return this.returnCode;
    }

    public void setConsoleLogging(boolean b) {
        this.setConsoleLogging(b, Long.MAX_VALUE);
    }

    public void setConsoleLogging(boolean b, long iConsoleLogLimit) {
        this.isConsoleLogging = b;
        this.consoleLogLimit = iConsoleLogLimit;
    }

    public void setEnvVar(String key, String value) {
        this.envVars.put(key, value);
        this.pb.environment().put(key, value);
    }

    public void setInput(String iSetting) {
        this.input = iSetting;
    }

    public void setLocation(String s) {
        this.pb.directory(new File(s));
    }

    public void setLogging(boolean b) {
        this.setLogging(b, Long.MAX_VALUE);
    }

    public void setLogging(boolean b, long iLogLimit) {
        this.isLogging = b;
        this.logLimit = iLogLimit;
    }

    public void setSubmitPw(String iSetting) {
        this.submitPw = iSetting;
    }

    public void setTimeout(int iSetting) {
        this.timeout = iSetting;
    }

    public class ProcessWatcher
    extends Thread {
        @Override
        public void run() {
            block3: {
                do {
                    try {
                        ProcessWatcher.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ProcessExec processExec = ProcessExec.this;
                    processExec.timeout = processExec.timeout - 1;
                    if (ProcessExec.this.isFinished) break block3;
                } while (ProcessExec.this.timeout >= 0);
                System.err.println("Process watcher thread timed out!  Will destroy process.");
                ProcessExec.this.p.destroy();
            }
        }
    }

    public class StreamWatcher
    extends Thread {
        private final int type;
        private final StringBuffer buffer;

        public StreamWatcher(int iType) {
            this.buffer = iType == 1 ? ProcessExec.this.stdout : ProcessExec.this.stderr;
            this.type = iType;
        }

        @Override
        public void run() {
            InputStreamReader r = new InputStreamReader(this.type == 1 ? ProcessExec.this.p.getInputStream() : ProcessExec.this.p.getErrorStream());
            try {
                try {
                    int c;
                    while ((c = ((Reader)r).read()) != -1) {
                        if (ProcessExec.this.timeout < 0) {
                            System.err.println("Stream watcher thread timed out!");
                            break;
                        }
                        if (ProcessExec.this.isLogging) {
                            ProcessExec processExec = ProcessExec.this;
                            long l = processExec.logLimit;
                            processExec.logLimit = l - 1L;
                            if (l > 0L) {
                                this.buffer.append((char)c);
                            }
                        }
                        if (!ProcessExec.this.isConsoleLogging) continue;
                        ProcessExec processExec = ProcessExec.this;
                        long l = processExec.consoleLogLimit;
                        processExec.consoleLogLimit = l - 1L;
                        if (l <= 0L) continue;
                        System.out.print((char)c);
                    }
                }
                catch (Exception e) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
                    e.printStackTrace(new PrintStream(baos));
                    this.buffer.append(baos.toString());
                    try {
                        ((Reader)r).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    ((Reader)r).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

