/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonList;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonParser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonSerializer;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.IStringSubstituter;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static Pattern javaIdPattern = null;
    private static Set<String> javaKeywords = null;
    protected static Pattern applySubREPattern = Pattern.compile("^s/(.*[^/])/(.*)/(.*)$");
    private static Pattern timePattern;
    private static long SECOND;
    private static long MINUTE;
    private static long HOUR;
    private static long DAY;
    private static long WEEK;
    private static long MONTH;
    private static long YEAR;
    private static Pattern replaceVarsPattern;

    static {
        SECOND = 1000L;
        MINUTE = SECOND * 60L;
        HOUR = MINUTE * 60L;
        DAY = HOUR * 24L;
        WEEK = DAY * 7L;
        MONTH = DAY * 31L;
        YEAR = DAY * 365L;
        replaceVarsPattern = Pattern.compile("\\{([^\\}]+)\\}");
    }

    public static String[] split(String s, char c) {
        return StringUtils.split(s, c, false);
    }

    public static String[] split(String s, char c, boolean removeEscapes) {
        return StringUtils.split(s, c, removeEscapes, false);
    }

    public static String[] split(String s, char c, boolean removeEscapes, boolean preserveBlankSingleEntry) {
        char[] unEscapeChars = new char[]{'\\', c};
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s) && !preserveBlankSingleEntry) {
            return new String[0];
        }
        LinkedList<String> l = new LinkedList<String>();
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int escapeCount = 0;
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] == '\\') {
                ++escapeCount;
            } else if (sArray[i] == c && escapeCount % 2 == 0) {
                String s2 = new String(sArray, x1, i - x1);
                l.add(StringUtils.strip(removeEscapes ? StringUtils.unEscapeChars(s2, unEscapeChars) : s2));
                x1 = i + 1;
            }
            if (sArray[i] != '\\') {
                escapeCount = 0;
            }
            ++i;
        }
        String s2 = new String(sArray, x1, sArray.length - x1);
        l.add(StringUtils.strip(removeEscapes ? StringUtils.unEscapeChars(s2, unEscapeChars) : s2));
        return l.toArray(new String[l.size()]);
    }

    public static String[] split2(String s, char c, boolean removeEscapes) {
        return StringUtils.split(s, c, removeEscapes, false);
    }

    public static String[] splitQuoted(String s, char c) {
        return StringUtils.splitQuoted(s, c, false, false);
    }

    public static String[] splitQuoted(String s, char c, boolean removeEscapes, boolean removeQuotes) {
        return StringUtils.splitQuoted(s, c, removeEscapes, removeQuotes, false);
    }

    public static String[] splitQuoted(String s, char c, boolean removeEscapes, boolean removeQuotes, boolean ignoreEmptyTokens) {
        return StringUtils.splitQuoted(s, c, removeEscapes ? EscapeHandling.REMOVE : EscapeHandling.DONT_REMOVE, removeQuotes, ignoreEmptyTokens);
    }

    public static String[] splitQuoted(String s, char c, EscapeHandling removeEscapes, boolean removeQuotes, boolean ignoreEmptyTokens) {
        char[] unEscapeChars = new char[]{'\\', c};
        String quote = "\"";
        String quotequote = "\"\"";
        String apost = "'";
        String apostapost = "''";
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return new String[0];
        }
        LinkedList<String> l = new LinkedList<String>();
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int escapeCount = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int i = 0;
        while (i < sArray.length) {
            if (removeEscapes != EscapeHandling.IGNORE && sArray[i] == '\\') {
                ++escapeCount;
            } else if (escapeCount % 2 == 0) {
                if (sArray[i] == '\'' && !inDoubleQuote) {
                    inSingleQuote = !inSingleQuote;
                } else if (sArray[i] == '\"' && !inSingleQuote) {
                    inDoubleQuote = !inDoubleQuote;
                } else if (sArray[i] == c && !inSingleQuote && !inDoubleQuote) {
                    boolean isQuoted = false;
                    String s2 = StringUtils.strip(new String(sArray, x1, i - x1));
                    if (removeEscapes == EscapeHandling.REMOVE) {
                        s2 = StringUtils.unEscapeChars(s2, unEscapeChars);
                    }
                    if (removeQuotes && s2.length() > 1) {
                        char c1 = s2.charAt(0);
                        char c2 = s2.charAt(s2.length() - 1);
                        if (c1 == '\'' && c2 == '\'' || c1 == '\"' && c2 == '\"') {
                            s2 = s2.substring(1, s2.length() - 1);
                            s2 = c1 == '\'' ? s2.replaceAll("''", "'") : s2.replaceAll("\"\"", "\"");
                            isQuoted = true;
                        }
                    }
                    if (isQuoted || !ignoreEmptyTokens || !StringUtils.isEmpty(s2)) {
                        l.add(s2);
                    }
                    x1 = i + 1;
                }
            }
            if (sArray[i] != '\\') {
                escapeCount = 0;
            }
            ++i;
        }
        String s2 = StringUtils.strip(new String(sArray, x1, sArray.length - x1));
        if (removeEscapes == EscapeHandling.REMOVE) {
            s2 = StringUtils.unEscapeChars(s2, unEscapeChars);
        }
        if (removeQuotes && s2.length() > 1) {
            char c1 = s2.charAt(0);
            char c2 = s2.charAt(s2.length() - 1);
            if (c1 == '\'' && c2 == '\'' || c1 == '\"' && c2 == '\"') {
                s2 = s2.substring(1, s2.length() - 1);
            }
        }
        if (!ignoreEmptyTokens || !StringUtils.isEmpty(s2)) {
            l.add(s2);
        }
        return l.toArray(new String[l.size()]);
    }

    public static String[] splitParenthesized(String s, char c, boolean removeEscapes) {
        char[] unEscapeChars = new char[]{'\\', c};
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return new String[0];
        }
        LinkedList<String> l = new LinkedList<String>();
        char[] sArray = s.toCharArray();
        int parenthesisCount = 0;
        int escapeCount = 0;
        int x1 = 0;
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] == '(') {
                ++parenthesisCount;
            } else if (sArray[i] == ')') {
                --parenthesisCount;
            } else if (parenthesisCount == 0 && sArray[i] == '\\') {
                ++escapeCount;
            } else if (sArray[i] == c && parenthesisCount == 0 && escapeCount % 2 == 0) {
                String s2 = StringUtils.strip(new String(sArray, x1, i - x1));
                if (removeEscapes) {
                    s2 = StringUtils.unEscapeChars(s2, unEscapeChars);
                }
                l.add(s2);
                x1 = i + 1;
            }
            if (sArray[i] != '\\') {
                escapeCount = 0;
            }
            ++i;
        }
        String s2 = StringUtils.strip(new String(sArray, x1, sArray.length - x1));
        l.add(s2);
        return l.toArray(new String[l.size()]);
    }

    public static String[] splitBracketed(String s, char c, boolean removeEscapes) {
        char[] unEscapeChars = new char[]{'\\', c};
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return new String[0];
        }
        LinkedList<String> l = new LinkedList<String>();
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int bracketCount = 0;
        int escapeCount = 0;
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] == '{') {
                ++bracketCount;
            } else if (sArray[i] == '}') {
                --bracketCount;
            } else if (bracketCount == 0 && sArray[i] == '\\') {
                ++escapeCount;
            } else if (sArray[i] == c && bracketCount == 0 && escapeCount % 2 == 0) {
                String s2 = StringUtils.strip(new String(sArray, x1, i - x1));
                if (removeEscapes) {
                    s2 = StringUtils.unEscapeChars(s2, unEscapeChars);
                }
                l.add(s2);
                x1 = i + 1;
            }
            if (sArray[i] != '\\') {
                escapeCount = 0;
            }
            ++i;
        }
        String s2 = StringUtils.strip(new String(sArray, x1, sArray.length - x1));
        l.add(s2);
        return l.toArray(new String[l.size()]);
    }

    public static String[] splitOnAny(String s, String delim) {
        LinkedList<String> strings = new LinkedList<String>();
        if (s != null && s.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(s, delim);
            while (tokens.hasMoreTokens()) {
                strings.add(tokens.nextToken());
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String[] split(String s, String delim) {
        if (s == null) {
            return null;
        }
        if (s == null || s.length() == 0) {
            return new String[0];
        }
        if (delim == null || delim.length() == 0) {
            throw new RuntimeException(String.valueOf(delim == null ? "Null" : "Blank") + " delimiter passed to StringUtils.split(s, delim)");
        }
        LinkedList<String> l = new LinkedList<String>();
        int i1 = 0;
        int i2 = 0;
        while ((i2 = s.indexOf(delim, i1)) != -1) {
            l.add(StringUtils.strip(s.substring(i1, i2)));
            i1 = i2 + delim.length();
        }
        l.add(StringUtils.strip(s.substring(i1)));
        return l.toArray(new String[l.size()]);
    }

    public static String[] split(String s) {
        if (s == null) {
            return null;
        }
        LinkedList<String> l = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l.toArray(new String[l.size()]);
    }

    public static int countChars(String s, char c, boolean ignoreEscapedChars) {
        if (s == null) {
            return 0;
        }
        int n = 0;
        int escapeCount = 0;
        int i = 0;
        while (i < s.length()) {
            char sc = s.charAt(i);
            if (sc == '\\') {
                ++escapeCount;
            } else if (sc == c && escapeCount % 2 == 0) {
                ++n;
            }
            if (sc != '\\') {
                escapeCount = 0;
            }
            ++i;
        }
        return n;
    }

    public static String replace(String s, String from, String to) {
        if (s == null) {
            return null;
        }
        if (from == null || from.length() == 0 || s.indexOf(from) == -1) {
            return s;
        }
        if (to == null) {
            to = "";
        }
        StringBuffer sb = new StringBuffer(s.length());
        int i1 = 0;
        int i2 = 0;
        while ((i2 = s.indexOf(from, i1)) != -1) {
            sb.append(s.substring(i1, i2)).append(to);
            i1 = i2 + from.length();
        }
        return sb.append(s.substring(i1)).toString();
    }

    public static String replace(String s, char from, char to) {
        return StringUtils.replace(s, from, to, false, false);
    }

    public static String replace(String s, char from, char to, boolean ignoreEscapedChars, boolean ignoreQuoted) {
        if (s == null) {
            return null;
        }
        char[] sArray = s.toCharArray();
        int escapeCount = 0;
        int singleQuoteCount = 0;
        int doubleQuoteCount = 0;
        int i = 0;
        while (i < sArray.length) {
            char c = sArray[i];
            if (c == '\\' && ignoreEscapedChars) {
                ++escapeCount;
            } else if (escapeCount % 2 == 0) {
                if (c == '\'' && ignoreQuoted) {
                    ++singleQuoteCount;
                } else if (c == '\"' && ignoreQuoted) {
                    ++doubleQuoteCount;
                } else if (c == from && singleQuoteCount % 2 == 0 && doubleQuoteCount % 2 == 0) {
                    sArray[i] = to;
                }
            }
            if (sArray[i] != '\\') {
                escapeCount = 0;
            }
            ++i;
        }
        return new String(sArray);
    }

    public static String escapeChars(String s, char[] toEscape) {
        return StringUtils.escapeChars(s, toEscape, '\\');
    }

    public static String escapeDoubleQuotes(String s) {
        return StringUtils.escapeChars(s, new char[]{'\"'}, '\\');
    }

    public static String escapeChar(String s, char c) {
        return StringUtils.escapeChars(s, new char[]{c}, '\\');
    }

    public static String escapeChars(String s, char[] toEscape, char escapeChar) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(s.length());
        char[] sArray = s.toCharArray();
        int i = 0;
        while (i < sArray.length) {
            boolean isOneOf = false;
            int j = 0;
            while (j < toEscape.length && !isOneOf) {
                isOneOf = sArray[i] == toEscape[j] || sArray[i] == escapeChar;
                ++j;
            }
            if (isOneOf) {
                sb.append(escapeChar);
            }
            sb.append(sArray[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String unEscapeChars(String s, char[] toEscape) {
        return StringUtils.unEscapeChars(s, toEscape, '\\');
    }

    public static String unEscapeChars(String s, char[] toEscape, char escapeChar) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        char[] sArray = s.toCharArray();
        int i = 0;
        while (i < sArray.length) {
            char c = sArray[i];
            if (c == escapeChar && i + 1 != sArray.length) {
                char c2 = sArray[i + 1];
                boolean isOneOf = false;
                int j = 0;
                while (j < toEscape.length && !isOneOf) {
                    isOneOf = c2 == toEscape[j];
                    ++j;
                }
                if (isOneOf) {
                    ++i;
                } else if (c2 == escapeChar) {
                    sb.append(escapeChar);
                    ++i;
                }
            }
            sb.append(sArray[i]);
            ++i;
        }
        return sb.toString();
    }

    public static boolean isNumeric(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        int i = c[0] == '-' ? 1 : 0;
        while (i < c.length) {
            if (c[i] < '0' || c[i] > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String join(Object[] o, String delim) {
        if (o == null) {
            return null;
        }
        if (delim == null) {
            delim = "";
        }
        StringBuffer sb = new StringBuffer();
        if (o.length > 0) {
            sb.append(o[0]);
        }
        int i = 1;
        while (i < o.length) {
            sb.append(delim).append(o[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String join(int[] ints, String delim) {
        Object[] o = new Object[ints.length];
        int i = 0;
        while (i < ints.length) {
            o[i] = ints[i];
            ++i;
        }
        return StringUtils.join(o, delim);
    }

    public static String join(Object[] o, char delim, boolean escapeExisting) {
        if (o == null) {
            return null;
        }
        char[] c = new char[]{delim};
        StringBuffer sb = new StringBuffer();
        if (o.length > 0) {
            sb.append(escapeExisting ? StringUtils.escapeChars(o[0] == null ? "null" : o[0].toString(), c) : o[0]);
        }
        int i = 1;
        while (i < o.length) {
            sb.append(delim).append(escapeExisting ? StringUtils.escapeChars(o[i] == null ? "null" : o[i].toString(), c) : o[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String join(Iterator i, String delim) {
        if (i == null) {
            return null;
        }
        if (delim == null) {
            delim = "";
        }
        StringBuffer sb = new StringBuffer();
        if (i.hasNext()) {
            sb.append(i.next());
        }
        while (i.hasNext()) {
            sb.append(delim).append(i.next());
        }
        return sb.toString();
    }

    public static String join(Collection c, String delim) {
        return c == null ? "" : StringUtils.join(c.iterator(), delim);
    }

    public static String quoteAndJoin(Iterator i, String delim) {
        return StringUtils.quoteAndJoin(i, '\'', delim);
    }

    public static String quoteAndJoin(Iterator i, char quoteChar, String delim) {
        return StringUtils.quoteAndJoin(i, String.valueOf(quoteChar), String.valueOf(quoteChar), delim);
    }

    public static String quoteAndJoin(Iterator i, String startQuote, String endQuote, String delim) {
        if (i == null) {
            return null;
        }
        if (delim == null) {
            delim = "";
        }
        StringBuffer sb = new StringBuffer();
        if (i.hasNext()) {
            sb.append(startQuote).append(i.next()).append(endQuote);
        }
        while (i.hasNext()) {
            sb.append(delim).append(startQuote).append(i.next()).append(endQuote);
        }
        return sb.toString();
    }

    public static String join(Collection c, char delim, boolean escapeExisting) {
        return StringUtils.join(c.iterator(), delim, escapeExisting);
    }

    public static String join(Iterator i, char delim, boolean escapeExisting) {
        String s;
        Object o;
        if (i == null) {
            return null;
        }
        char[] c = new char[]{delim};
        StringBuffer sb = new StringBuffer();
        if (i.hasNext()) {
            o = i.next();
            s = o == null ? "null" : o.toString();
            sb.append(escapeExisting ? StringUtils.escapeChars(s, c) : s);
        }
        while (i.hasNext()) {
            o = i.next();
            s = o == null ? "null" : o.toString();
            sb.append(delim).append(escapeExisting ? StringUtils.escapeChars(s, c) : s);
        }
        return sb.toString();
    }

    public static String strip(String s, String stripChars) {
        if (s == null || s.length() == 0 || stripChars == null || stripChars.length() == 0) {
            return s;
        }
        char[] sc = stripChars.toCharArray();
        char[] sArray = s.toCharArray();
        int startPos = 0;
        int endPos = sArray.length - 1;
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] == ' ' || sArray[i] == '\t' || StringUtils.charIsOneOf(sArray[i], sc)) {
                ++startPos;
            } else {
                i = sArray.length;
            }
            ++i;
        }
        i = endPos;
        while (i > startPos) {
            if (sArray[i] == ' ' || sArray[i] == '\t' || StringUtils.charIsOneOf(sArray[i], sc)) {
                --endPos;
            } else {
                i = startPos;
            }
            --i;
        }
        return new String(sArray, startPos, endPos - startPos + 1);
    }

    public static String strip(String s) {
        return StringUtils.strip(s, " \t\r\n");
    }

    public static String[] strip(String[] s, boolean removeEmpty) {
        ArrayList<String> l = new ArrayList<String>(s.length);
        int i = 0;
        while (i < s.length) {
            if (!removeEmpty || !StringUtils.isEmpty(s[i])) {
                l.add(s[i]);
            }
            ++i;
        }
        return l.toArray(new String[l.size()]);
    }

    private static boolean charIsOneOf(char c, char[] cArray) {
        int i = 0;
        while (i < cArray.length) {
            if (c == cArray[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEmpty(CharSequence s) {
        if (s == null || s.length() == 0) {
            return true;
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean getBoolean(String s) {
        return StringUtils.getBoolean(s, false);
    }

    public static boolean getBoolean(String s, boolean defaultVal) {
        if (s == null || s.length() == 0) {
            return defaultVal;
        }
        char c = s.charAt(0);
        return c == 'T' || c == 't' || c == 'Y' || c == 'y' || c == '1';
    }

    public static int getInt(String s, int defaultVal) {
        if (!StringUtils.isNumeric(s)) {
            return defaultVal;
        }
        return Integer.parseInt(s);
    }

    public static int[] getInts(String s) {
        if (s == null) {
            return new int[0];
        }
        int[] l = new int[StringUtils.countChars(s, ',', false) + 1];
        int i = 0;
        String[] stringArray = StringUtils.split(s, ',');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s2 = stringArray[n2];
            l[i++] = Integer.parseInt(s2);
            ++n2;
        }
        return l;
    }

    public static Integer[] getIntegers(String s) {
        if (s == null) {
            return new Integer[0];
        }
        Integer[] l = new Integer[StringUtils.countChars(s, ',', false) + 1];
        int i = 0;
        String[] stringArray = StringUtils.split(s, ',');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s2 = stringArray[n2];
            l[i++] = Integer.valueOf(s2);
            ++n2;
        }
        return l;
    }

    public static Integer getInteger(String s, Integer defaultVal) {
        if (!StringUtils.isNumeric(s)) {
            return defaultVal;
        }
        return Integer.parseInt(s);
    }

    public static long getLong(String s, long defaultVal) {
        if (!StringUtils.isNumeric(s)) {
            return defaultVal;
        }
        return Long.parseLong(s);
    }

    public static Long getLong(String s, Long defaultVal) {
        if (!StringUtils.isNumeric(s)) {
            return defaultVal;
        }
        return Long.parseLong(s);
    }

    public static char getChar(String s, char defaultVal) {
        if (s == null || s.length() == 0) {
            return defaultVal;
        }
        return s.charAt(0);
    }

    public static String[] getVars(String type, String s) {
        type = String.valueOf(type) + "{";
        int varLength = type.length();
        LinkedList<String> l = new LinkedList<String>();
        int x1 = s.indexOf(type);
        while (x1 != -1) {
            int x2 = s.indexOf(125, x1);
            if (x2 != -1) {
                l.add(s.substring(x1 + varLength, x2));
                x1 = s.indexOf(type, x2);
                continue;
            }
            x1 = -1;
        }
        return l.toArray(new String[l.size()]);
    }

    public static String getString(String s, String def) {
        return StringUtils.coalesce(s, def);
    }

    public static String coalesce(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!StringUtils.isEmpty(s)) {
                return s;
            }
            ++n2;
        }
        return strings[strings.length - 1];
    }

    public static String getString(String s, String defaultVal, boolean trim) {
        if (s == null || s.length() == 0) {
            s = defaultVal;
        }
        if (s == null) {
            return null;
        }
        return trim ? s.trim() : s;
    }

    public static LinkedHashMap<String, String> getMap(String s) throws ParseException {
        return StringUtils.getMap(s, ',', '=');
    }

    public static LinkedHashMap<String, String> getMap(String s, char delim, char equals) throws ParseException {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        String[] tokens = StringUtils.split(s, delim, true);
        int i = 0;
        while (i < tokens.length) {
            String[] s2 = StringUtils.split(tokens[i], equals, true);
            if (s2.length != 2) {
                throw new ParseException("Invalid map string: [" + s + "]", 0);
            }
            String o = m.put(s2[0], s2[1]);
            if (o != null) {
                throw new ParseException("Duplicate keys in map string: [" + s + "]", 0);
            }
            ++i;
        }
        return m;
    }

    public static String makeUnicodeReadable(String s) {
        StringBuffer sb = new StringBuffer(s.length() * 2);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < ' ' && c != '\t' && c != '\n' || c > '~') {
                sb.append("\\u" + StringUtils.toHex(c));
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String convertToCsv(String input) {
        StringBuffer buf = new StringBuffer();
        boolean specialCharExists = false;
        int i = 0;
        while (i < input.length()) {
            char curChar = input.charAt(i);
            switch (curChar) {
                case '\n': {
                    specialCharExists = true;
                    break;
                }
                case ',': {
                    specialCharExists = true;
                    break;
                }
                case '\"': {
                    buf.append('\"');
                    specialCharExists = true;
                    break;
                }
            }
            buf.append(curChar);
            ++i;
        }
        return specialCharExists ? "\"" + buf + "\"" : input;
    }

    public static String toValidXmlString(String s) {
        if (s == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(s.length());
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            int c = chars[i];
            if (c == 62 || c == 60 || c == 34 || c == 39) {
                c = 63;
            } else if (!(c == 10 || c >= 32 && c <= 55295 || c >= 57344 && c <= 65533)) {
                c = 63;
            }
            sb.append((char)c);
            ++i;
        }
        return sb.toString();
    }

    public static String htmlEscape(String s) {
        StringBuffer sb = new StringBuffer(s.length() * 2);
        char[] cArray = s.toCharArray();
        int i = 0;
        while (i < cArray.length) {
            char c = cArray[i];
            if (c >= '@' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '-' && c <= '9' || c == '*' || c == '+' || c == '_') {
                sb.append(c);
            } else if (c > '\u00ff') {
                sb.append("%u" + StringUtils.toHex(c));
            } else {
                sb.append("%" + StringUtils.toHex(c, 2));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toHex(int num, int numDigits) {
        String s = StringUtils.toHex(num);
        return numDigits == 4 ? s : s.substring(4 - numDigits);
    }

    public static String toHex(int num) {
        char[] c = new char[4];
        int a = num % 16;
        c[3] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        int base = 16;
        int i = 1;
        while (i < 4) {
            a = num / base % 16;
            base <<= 4;
            c[3 - i] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
            ++i;
        }
        return new String(c);
    }

    public static String toHex(long num) {
        char[] c = new char[8];
        long a = num % 16L;
        c[7] = (char)(a > 9L ? 65L + a - 10L : 48L + a);
        int base = 16;
        int i = 1;
        while (i < 8) {
            a = num / (long)base % 16L;
            base <<= 4;
            c[7 - i] = (char)(a > 9L ? 65L + a - 10L : 48L + a);
            ++i;
        }
        return new String(c);
    }

    public static boolean isValidIdentifier(String s) {
        if (s == null || s.equals("")) {
            return false;
        }
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (i == 0 && !Character.isLetter(c[i])) {
                return false;
            }
            if (!Character.isLetterOrDigit(c[i]) && c[i] != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidJavaIdentifier(String s) {
        Matcher matcher;
        if (javaIdPattern == null) {
            String idRegex = "([\\p{L}_$}]++[\\p{L}\\p{N}_$]*)+";
            javaIdPattern = Pattern.compile(idRegex);
            javaKeywords = new HashSet<String>();
            javaKeywords.add("abstract");
            javaKeywords.add("assert");
            javaKeywords.add("boolean");
            javaKeywords.add("break");
            javaKeywords.add("byte");
            javaKeywords.add("case");
            javaKeywords.add("catch");
            javaKeywords.add("char");
            javaKeywords.add("class");
            javaKeywords.add("const");
            javaKeywords.add("continue");
            javaKeywords.add("default");
            javaKeywords.add("do");
            javaKeywords.add("double");
            javaKeywords.add("else");
            javaKeywords.add("enum");
            javaKeywords.add("extends");
            javaKeywords.add("final");
            javaKeywords.add("finally");
            javaKeywords.add("float");
            javaKeywords.add("for");
            javaKeywords.add("goto");
            javaKeywords.add("if");
            javaKeywords.add("implements");
            javaKeywords.add("import");
            javaKeywords.add("instanceof");
            javaKeywords.add("int");
            javaKeywords.add("interface");
            javaKeywords.add("long");
            javaKeywords.add("native");
            javaKeywords.add("new");
            javaKeywords.add("package");
            javaKeywords.add("private");
            javaKeywords.add("protected");
            javaKeywords.add("public");
            javaKeywords.add("return");
            javaKeywords.add("short");
            javaKeywords.add("static");
            javaKeywords.add("strictfp");
            javaKeywords.add("super");
            javaKeywords.add("switch");
            javaKeywords.add("synchronized");
            javaKeywords.add("this");
            javaKeywords.add("throw");
            javaKeywords.add("throws");
            javaKeywords.add("transient");
            javaKeywords.add("try");
            javaKeywords.add("void");
            javaKeywords.add("volatile");
            javaKeywords.add("while");
        }
        return (matcher = javaIdPattern.matcher(s)).matches() && !javaKeywords.contains(s);
    }

    public static String escapeApostrophes(String s) {
        char[] c = s.toCharArray();
        StringBuffer sb = new StringBuffer(s.length() + 1);
        int escapeCount = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int i = 0;
        while (i < c.length) {
            if (c[i] == '\\') {
                ++escapeCount;
            } else if (escapeCount % 2 == 0) {
                if (c[i] == '\'') {
                    if (inDoubleQuote || i > 0 && i < c.length - 1 && !Character.isWhitespace(c[i - 1]) && c[i - 1] != '+' && c[i - 1] != '-' && !Character.isWhitespace(c[i + 1])) {
                        sb.append('\\');
                    } else {
                        inSingleQuote = !inSingleQuote;
                    }
                } else if (c[i] == '\"') {
                    if (inSingleQuote || i > 0 && i < c.length - 1 && !Character.isWhitespace(c[i - 1]) && c[i - 1] != '+' && c[i - 1] != '-' && !Character.isWhitespace(c[i + 1])) {
                        sb.append('\\');
                    } else {
                        boolean bl = inDoubleQuote = !inDoubleQuote;
                    }
                }
            }
            if (c[i] != '\\') {
                escapeCount = 0;
            }
            sb.append(c[i]);
            ++i;
        }
        if (inSingleQuote || inDoubleQuote) {
            throw new RuntimeException("Single or double quote not properly closed in the following expression: [" + s + "]");
        }
        return sb.toString();
    }

    public static String[] fragment(String s, int length, String encoding) throws UnsupportedEncodingException {
        LinkedList<String> l = new LinkedList<String>();
        while (!StringUtils.isEmpty(s)) {
            String fragment = StringUtils.truncateBytes(s, length, encoding);
            s = s.substring(fragment.length());
            l.add(fragment);
        }
        return l.toArray(new String[l.size()]);
    }

    public static String applySubRE(String re, String s) {
        Matcher m = applySubREPattern.matcher(re);
        if (m.find()) {
            boolean isGlobal = m.group(3).indexOf(103) != -1;
            boolean isMultiLine = m.group(3).indexOf(115) == -1;
            Pattern p = Pattern.compile(m.group(1), isMultiLine ? 8 : 32);
            Matcher m2 = p.matcher(s);
            if (isGlobal) {
                return m2.replaceAll(m.group(2));
            }
            return m2.replaceFirst(m.group(2));
        }
        return s;
    }

    public static boolean containsUnEscapedChars(String s, char[] chars) {
        char[] sArray = s.toCharArray();
        boolean inEscape = false;
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] == '\\') {
                inEscape = !inEscape;
            } else {
                if (!inEscape) {
                    int j = 0;
                    while (j < chars.length) {
                        if (sArray[i] == chars[j]) {
                            return true;
                        }
                        ++j;
                    }
                }
                inEscape = false;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsEscapedChars(String s, char[] chars) {
        char[] sArray = s.toCharArray();
        boolean inEscape = false;
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] == '\\') {
                inEscape = !inEscape;
            } else {
                if (inEscape) {
                    int j = 0;
                    while (j < chars.length) {
                        if (sArray[i] == chars[j]) {
                            return true;
                        }
                        ++j;
                    }
                }
                inEscape = false;
            }
            ++i;
        }
        return false;
    }

    public static String chop(String s, int length) {
        return StringUtils.chop(s, length, false, false);
    }

    public static String chop(String s, int length, boolean chopBeginning, boolean doPad) {
        if (s == null) {
            return null;
        }
        if (s.length() < length) {
            if (doPad) {
                StringBuilder sb = new StringBuilder(length);
                sb.append(s);
                int i = s.length();
                while (i < length) {
                    sb.append(' ');
                    ++i;
                }
                return sb.toString();
            }
            return s;
        }
        if (chopBeginning) {
            return s.substring(s.length() - length);
        }
        return s.substring(0, length);
    }

    public static String[] addToArray(String[] array, String s) {
        String[] newArray;
        String[] stringArray = newArray = array == null ? new String[1] : new String[array.length + 1];
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                newArray[i] = array[i];
                ++i;
            }
        }
        newArray[newArray.length - 1] = s;
        return newArray;
    }

    public static String toValidXml(String s) {
        if (s == null) {
            return "null";
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '&' || c == '<' || c == '>' || c == '\"' || Character.isISOControl(c)) {
                StringBuffer sb = new StringBuffer(s.length());
                i = 0;
                while (i < s.length()) {
                    c = s.charAt(i);
                    if (c == '&') {
                        sb.append("&amp;");
                    } else if (c == '<') {
                        sb.append("&lt;");
                    } else if (c == '>') {
                        sb.append("&gt;");
                    } else if (c == '\"') {
                        sb.append("&quot;");
                    } else if (c != '\r' && c != '\n' && c != '\t' && Character.isISOControl(c)) {
                        sb.append("&#" + c + ";");
                    } else {
                        sb.append(c);
                    }
                    ++i;
                }
                return sb.toString();
            }
            ++i;
        }
        return s;
    }

    public static String toValidHtml(String s) {
        if (s == null) {
            return "null";
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '&' || c == '<' || c == '>' || c == '\"' || c == '\n' || c == '\t' || Character.isISOControl(c)) {
                StringBuffer sb = new StringBuffer(s.length());
                i = 0;
                while (i < s.length()) {
                    c = s.charAt(i);
                    if (c == '&') {
                        sb.append("&amp;");
                    } else if (c == '<') {
                        sb.append("&lt;");
                    } else if (c == '>') {
                        sb.append("&gt;");
                    } else if (c == '\"') {
                        sb.append("&quot;");
                    } else if (c == '\n') {
                        sb.append("<br>");
                    } else if (c == '\t') {
                        sb.append("&nbsp;&nbsp;&nbsp;");
                    } else if (Character.isISOControl(c)) {
                        sb.append("&#" + c + ";");
                    } else {
                        sb.append(c);
                    }
                    ++i;
                }
                return sb.toString();
            }
            ++i;
        }
        return s;
    }

    public static String[] toValidHtml(String[] s) {
        if (s == null) {
            return s;
        }
        int i = 0;
        while (i < s.length) {
            s[i] = StringUtils.toValidHtml(s[i]);
            ++i;
        }
        return s;
    }

    public static String toValidXmlAttr(String s) {
        if (s == null) {
            s = "";
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\"' || c == '\'' || c == '&' || c == '<' || Character.isISOControl(c)) {
                StringBuffer sb = new StringBuffer(s.length());
                i = 0;
                while (i < s.length()) {
                    c = s.charAt(i);
                    if (c == '\"') {
                        sb.append("&quot;");
                    } else if (c == '\'') {
                        sb.append("&#39;");
                    } else if (c == '&') {
                        sb.append("&amp;");
                    } else if (c == '<') {
                        sb.append("&lt;");
                    } else if (Character.isISOControl(c)) {
                        sb.append("&#" + c + ";");
                    } else {
                        sb.append(c);
                    }
                    ++i;
                }
                return sb.toString();
            }
            ++i;
        }
        return s;
    }

    public static String toXMLSafeString(String in) {
        if (in == null) {
            return "";
        }
        int len = in.length();
        if (len == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c = in.charAt(i);
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    break;
                }
                case '>': {
                    out.append("&gt;");
                    break;
                }
                case '&': {
                    out.append("&amp;");
                    break;
                }
                case '\"': {
                    out.append("&quot;");
                    break;
                }
                case '\'': {
                    out.append("&#039;");
                    break;
                }
                default: {
                    out.append(c);
                }
            }
            ++i;
        }
        return out.toString();
    }

    public static String toValidJavascriptParam(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\\\", "\\\\\\\\");
        s = s.replaceAll("\"", "\\\\&quot;");
        s = s.replaceAll("'", "\\\\&apos;");
        s = s.replaceAll("\\n", "\\\\n");
        return s;
    }

    public static long parseTime(String s) {
        if (timePattern == null) {
            timePattern = Pattern.compile("(\\d+)\\s*(\\w*)");
        }
        if ((s = s.toUpperCase()).equals("NEVER")) {
            return Long.MAX_VALUE;
        }
        if (s.equals("")) {
            return 0L;
        }
        Matcher m = timePattern.matcher(s);
        if (!m.matches()) {
            throw new RuntimeException("Invalid time string format: [" + s + "]");
        }
        long n = Long.parseLong(m.group(1));
        String x = m.group(2);
        if (x.startsWith("S")) {
            n *= SECOND;
        } else if (x.startsWith("MIN")) {
            n *= MINUTE;
        } else if (x.startsWith("H")) {
            n *= HOUR;
        } else if (x.startsWith("D")) {
            n *= DAY;
        } else if (x.startsWith("W")) {
            n *= WEEK;
        } else if (x.startsWith("MO")) {
            n *= MONTH;
        } else if (x.startsWith("Y")) {
            n *= YEAR;
        }
        return n;
    }

    public static String getTimeString(long l) {
        long x;
        LinkedList<String> parts = new LinkedList<String>();
        if (l == Long.MAX_VALUE) {
            return "never";
        }
        if (l >= YEAR) {
            x = l / YEAR;
            l %= YEAR;
            parts.add(String.valueOf(x) + " year" + (x > 1L ? "s" : ""));
        }
        if (l >= MONTH) {
            x = l / MONTH;
            l %= MONTH;
            parts.add(String.valueOf(x) + " month" + (x > 1L ? "s" : ""));
        }
        if (l >= DAY) {
            x = l / DAY;
            l %= DAY;
            parts.add(String.valueOf(x) + " day" + (x > 1L ? "s" : ""));
        }
        if (l >= HOUR) {
            x = l / HOUR;
            l %= HOUR;
            parts.add(String.valueOf(x) + " hour" + (x > 1L ? "s" : ""));
        }
        if (l >= MINUTE) {
            x = l / MINUTE;
            l %= MINUTE;
            parts.add(String.valueOf(x) + " minute" + (x > 1L ? "s" : ""));
        }
        if (l >= SECOND) {
            x = l / SECOND;
            l %= SECOND;
            parts.add(String.valueOf(x) + " second" + (x > 1L ? "s" : ""));
        }
        return StringUtils.join(parts.iterator(), ",");
    }

    public static String getTimeStringShort(long l) {
        StringBuffer sb = new StringBuffer();
        if (l < 0L) {
            return "00:00:00.000";
        }
        long x = l / HOUR;
        sb.append(String.valueOf(x < 10L ? "0" : "") + x + ":");
        x = (l %= HOUR) / MINUTE;
        sb.append(String.valueOf(x < 10L ? "0" : "") + x + ":");
        x = (l %= MINUTE) / SECOND;
        sb.append(String.valueOf(x < 10L ? "0" : "") + x + ".");
        x = l %= SECOND;
        sb.append(String.valueOf(x < 10L ? "00" : (x < 100L ? "0" : "")) + x);
        return sb.toString();
    }

    public static boolean needsTruncate(String s, int length, String charset) throws UnsupportedEncodingException {
        return s.getBytes(charset).length > length;
    }

    /*
     * Unable to fully structure code
     */
    public static String truncateBytes(String s, int length, String charset) throws UnsupportedEncodingException {
        cs = Charset.forName(charset);
        encoder = cs.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(new byte[]{63});
        try {
            in = CharBuffer.wrap(s);
            out = ByteBuffer.allocate(length);
            result = encoder.encode(in, out, true);
            hadReplacement = false;
            buf = out.array();
            i = 0;
            while (i < buf.length && !hadReplacement) {
                if (buf[i] == 63) {
                    hadReplacement = true;
                }
                ++i;
            }
            s2 = null;
            if (result.isOverflow() || hadReplacement) {
                out.limit(out.position());
                decoder = cs.newDecoder();
                out.rewind();
                s2 = decoder.decode(out).toString();
            } else {
                s2 = s;
            }
            if (s2.getBytes(charset).length > length) {
                return s2.substring(0, s2.length() - 1);
            }
            return s2;
        }
        catch (Throwable t) {
            ** while (s.getBytes((String)charset).length > length)
        }
lbl-1000:
        // 1 sources

        {
            s = s.substring(0, s.length() - 1);
            continue;
        }
lbl32:
        // 1 sources

        return s;
    }

    public static String getReaderContents(Reader r) throws IOException {
        StringBuffer sb = new StringBuffer();
        char[] cbuf = new char[1024];
        int charsRead = 0;
        while ((charsRead = r.read(cbuf, 0, 1024)) != -1) {
            sb.append(cbuf, 0, charsRead);
        }
        return sb.toString();
    }

    public static boolean isHexChars(String iString) {
        if (iString == null || iString.length() == 0) {
            return false;
        }
        char[] c = iString.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (!(c[i] >= '0' && c[i] <= '9' || c[i] >= 'a' && c[i] <= 'f' || c[i] >= 'A' && c[i] <= 'F')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isLike(String pattern, String source) {
        char zeroOrMore = '*';
        char anyChar = '?';
        return StringUtils.isLike(pattern, source, zeroOrMore, anyChar);
    }

    public static boolean isLike(String pattern, String source, char zeroOrMore, char anyChar) {
        if (source == null || pattern == null) {
            return false;
        }
        if (source.equals(pattern)) {
            return true;
        }
        int patternLen = pattern.length();
        StringBuffer wildcard = new StringBuffer(pattern);
        StringBuffer receiver = new StringBuffer(source);
        int iText = 0;
        int iPattern = 0;
        int lastStar = 0;
        int len = source.length();
        while (iPattern < patternLen) {
            char p;
            if ((p = wildcard.charAt(iPattern++)) == zeroOrMore) {
                if (iPattern >= patternLen) {
                    return true;
                }
                lastStar = iPattern;
                continue;
            }
            if (iText >= len) {
                return false;
            }
            char t = receiver.charAt(iText++);
            if (p == anyChar || p == t) {
                if (lastStar <= 0 || iPattern < patternLen || iText >= len) {
                    continue;
                }
            } else if (lastStar == 0) {
                return false;
            }
            int matched = iPattern - lastStar - 1;
            iPattern = lastStar;
            iText -= matched;
        }
        return iText >= len;
    }

    public static String[] removeDuplicates(String[] dups) {
        HashSet<String> nd = new HashSet<String>(dups.length);
        String[] stringArray = dups;
        int n = dups.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            nd.add(s);
            ++n2;
        }
        String[] noDups = nd.toArray(new String[nd.size()]);
        return noDups;
    }

    public static String substitute(String input, Pattern p, IStringSubstituter ss) {
        if (input == null) {
            return null;
        }
        Matcher m = p.matcher(input);
        StringBuffer sb = new StringBuffer(input.length());
        int i = 0;
        while (m.find()) {
            sb.append(input.substring(i, m.start()));
            sb.append(ss.substitute(m));
            i = m.end();
        }
        if (i == 0) {
            return input;
        }
        sb.append(input.substring(i));
        return sb.toString();
    }

    public static List<String> splitToList(String s, char d) {
        return StringUtils.splitToList(s, d, true);
    }

    public static List<String> splitToList(String s, char d, boolean removeEscapes) {
        if (s == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split(s, d, removeEscapes, false));
    }

    public static List<String> splitQuotedToList(String s, char d) {
        return StringUtils.splitQuotedToList(s, d, true, true, false);
    }

    public static List<String> splitQuotedToList(String s, char d, boolean removeEscapes, boolean removeQuotes, boolean ignoreEmptyTokens) {
        if (s == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.splitQuoted(s, d, removeEscapes, removeQuotes, ignoreEmptyTokens));
    }

    public static JsonList splitList(String s) {
        if (s == null) {
            return new JsonList();
        }
        if (s.startsWith("[")) {
            return new JsonList(s);
        }
        return new JsonList<String>((Collection<String>)StringUtils.splitToList(s, ','));
    }

    public static JsonMap<String, Object> parseUrlQuery(String queryString) throws Exception {
        if (StringUtils.isEmpty(queryString)) {
            return new JsonMap<String, Object>();
        }
        if (queryString.charAt(0) == '?') {
            queryString = queryString.substring(1);
        }
        JsonMap<String, Object> m = new JsonMap<String, Object>();
        int S1 = 1;
        int S2 = 2;
        int i1 = 0;
        int state = S1;
        String paramName = null;
        int i = 0;
        while (i < queryString.length()) {
            char c = queryString.charAt(i);
            if (state == S1) {
                if (c == '=') {
                    paramName = URLDecoder.decode(queryString.substring(i1, i), "UTF-8");
                    i1 = i + 1;
                    state = S2;
                } else if (c == '&') {
                    paramName = URLDecoder.decode(queryString.substring(i1, i), "UTF-8");
                    i1 = i + 1;
                    m.put(paramName, null);
                    state = S1;
                }
            } else if (state == S2 && c == '&') {
                String val = URLDecoder.decode(queryString.substring(i1, i), "UTF-8");
                char c2 = val.length() == 0 ? (char)'\u0000' : val.charAt(0);
                m.put(paramName, c2 == '{' || c2 == '[' ? JsonParser.DEFAULT.parse(val) : val);
                state = S1;
                i1 = i + 1;
            }
            ++i;
        }
        if (state == S1 && i1 < queryString.length()) {
            m.put(URLDecoder.decode(queryString.substring(i1, queryString.length()), "UTF-8"), null);
        } else if (state == S2) {
            String val = URLDecoder.decode(queryString.substring(i1, queryString.length()), "UTF-8");
            char c2 = val.length() == 0 ? (char)'\u0000' : val.charAt(0);
            m.put(paramName, c2 == '{' || c2 == '[' ? JsonParser.DEFAULT.parse(val) : val);
        }
        return m;
    }

    public static String createUrlQuery(JsonMap queryParams) {
        int d = 63;
        StringBuffer sb = new StringBuffer();
        for (Map.Entry e : queryParams.entrySet()) {
            sb.append((char)d);
            d = 38;
            sb.append(StringUtils.urlEncode(e.getKey().toString()));
            Object val = e.getValue();
            if (val == null) continue;
            sb.append("=");
            if (val instanceof Map || val instanceof Collection) {
                sb.append(StringUtils.urlEncode(JsonSerializer.DEFAULT_CONDENSED.serialize(val)));
                continue;
            }
            sb.append(StringUtils.urlEncode(val.toString()));
        }
        return sb.toString();
    }

    public static List<String> toStringList(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            ArrayList<String> l2 = new ArrayList<String>(c.size());
            for (Object o2 : c) {
                l2.add(o2 == null ? null : o2.toString());
            }
            return l2;
        }
        return StringUtils.splitToList(o.toString(), ',');
    }

    public static String[] append(String[] s, String ... add) {
        ArrayList<String> l = new ArrayList<String>(s.length + add.length);
        l.addAll(Arrays.asList(s));
        l.addAll(Arrays.asList(add));
        return l.toArray(new String[l.size()]);
    }

    public static String[] prepend(String[] s, String ... add) {
        ArrayList<String> l = new ArrayList<String>(s.length + add.length);
        l.addAll(Arrays.asList(add));
        l.addAll(Arrays.asList(s));
        return l.toArray(new String[l.size()]);
    }

    public static String[] remove(String[] s, String ... remove) {
        if (s == null) {
            return new String[0];
        }
        LinkedList<String> l = new LinkedList<String>(Arrays.asList(s));
        String[] stringArray = remove;
        int n = remove.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            l.remove(r);
            ++n2;
        }
        return l.toArray(new String[l.size()]);
    }

    public static String replaceVars(String in, final Map m) {
        return StringUtils.substitute(in, replaceVarsPattern, new IStringSubstituter(){

            @Override
            public String substitute(Matcher matcher) {
                String v = matcher.group(1);
                return m.containsKey(v) ? m.get(v).toString() : null;
            }
        });
    }

    public static String repeat(String pattern, int n) {
        return StringUtils.repeat(pattern, n, null);
    }

    public static String repeat(String pattern, int n, String separator) {
        return StringUtils.repeatAndAppend(new StringBuilder(), pattern, n, separator).toString();
    }

    public static StringBuilder repeatAndAppend(StringBuilder sb, String pattern, int n, String separator) {
        int i = 0;
        while (i < n) {
            sb.append(pattern);
            if (i < n - 1 && separator != null) {
                sb.append(separator);
            }
            ++i;
        }
        return sb;
    }

    public static String format(String s, Object ... args) {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format(s, args);
        fmt.close();
        return sb.toString();
    }

    public static String bytesToHex(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        int i = 0;
        while (i < b.length) {
            int v = b[i] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    public static byte[] hexToBytes(String s) {
        byte[] b = new byte[s.length() / 2];
        int i = 0;
        while (i < b.length) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte)v;
            ++i;
        }
        return b;
    }

    public static String toValidUrl(String url) {
        boolean needsEncoding = false;
        int i = 0;
        while (i < url.length() && !needsEncoding) {
            if (url.charAt(i) > '\u007f' || url.charAt(i) == ' ') {
                needsEncoding = true;
            }
            ++i;
        }
        if (!needsEncoding) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url.length() * 2);
        int i2 = 0;
        while (i2 < url.length()) {
            char c = url.charAt(i2);
            if (c == ' ') {
                sb.append('+');
            } else if (c > '\u007f') {
                sb.append(StringUtils.urlEncode("" + c));
            } else {
                sb.append(c);
            }
            ++i2;
        }
        return sb.toString();
    }

    public static String trimEnd(String iString) {
        int i = iString.length() - 1;
        while (i > 0 && Character.isWhitespace(iString.charAt(i))) {
            --i;
        }
        return iString.substring(0, i + 1);
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(String.valueOf(t.toString()) + "\n");
        StackTraceElement[] stackTraceElementArray = t.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            sb.append("\tat " + e + "\n");
            ++n2;
        }
        StackTraceElement[] parentStack = t.getStackTrace();
        Throwable cause = t.getCause();
        while (cause != null) {
            sb.append("Caused by: " + cause + "\n");
            StackTraceElement[] currentStack = cause.getStackTrace();
            int duplicates = StringUtils.countTraceDuplicates(currentStack, parentStack);
            int i = 0;
            while (i < currentStack.length - duplicates) {
                sb.append("\tat " + currentStack[i] + "\n");
                ++i;
            }
            if (duplicates > 0) {
                sb.append("\t... " + duplicates + " more\n");
            }
            parentStack = currentStack;
            cause = cause.getCause();
        }
        return sb.toString();
    }

    private static int countTraceDuplicates(StackTraceElement[] currentStack, StackTraceElement[] parentStack) {
        int duplicates = 0;
        int parentIndex = parentStack.length;
        int i = currentStack.length;
        while (--i >= 0 && --parentIndex >= 0) {
            StackTraceElement parentFrame = parentStack[parentIndex];
            if (!parentFrame.equals(currentStack[i])) break;
            ++duplicates;
        }
        return duplicates;
    }

    public static String urlEncode(String s) {
        try {
            s = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return s;
    }

    public static enum EscapeHandling {
        REMOVE,
        DONT_REMOVE,
        IGNORE;

    }
}

