/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.Environment;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocaleMgr {
    private static String externalDefaultEncoding = null;

    public static String getExternalDefaultEncoding() {
        String fileEncoding = System.getProperty("externalFileEncoding");
        if (!StringUtils.isEmpty(fileEncoding)) {
            return fileEncoding;
        }
        if (!StringUtils.isEmpty(externalDefaultEncoding)) {
            return externalDefaultEncoding;
        }
        if (Environment.isZOS()) {
            String language = Locale.getDefault().getLanguage();
            if (language.equals("en")) {
                return "Cp1047";
            }
            if (language.equals("ja")) {
                return "Cp930";
            }
            if (language.equals("zh")) {
                return "Cp1388";
            }
        }
        return Charset.defaultCharset().toString();
    }

    public static String getAssetAnalyzerFileEncoding() {
        String fileEncoding = System.getProperty("assetAnalyzerFileEncoding");
        if (!StringUtils.isEmpty(fileEncoding)) {
            return fileEncoding;
        }
        if (Environment.isZOS()) {
            return "Cp1047";
        }
        return Charset.defaultCharset().toString();
    }

    public static ResourceBundle getBundleForFile(File f) {
        return LocaleMgr.getBundleForFile(f.getAbsolutePath(), Locale.getDefault());
    }

    public static ResourceBundle getBundleForFile(String path) {
        return LocaleMgr.getBundleForFile(path, Locale.getDefault());
    }

    public static ResourceBundle getBundleForFile(String path, Locale locale) {
        path = path.replace('\\', '/');
        Pattern p = Pattern.compile("\\/?([^\\/].*)[\\/]([^\\/\\.]+)\\.[^\\.]+");
        Matcher m = p.matcher(path);
        if (!m.matches()) {
            return null;
        }
        String directory = m.group(1);
        String bundleName = m.group(2);
        try {
            URLClassLoader c = new URLClassLoader(new URL[]{new URL("file:/" + directory + "/"), new URL("file:/" + directory + "/i18n/")});
            return ResourceBundle.getBundle(bundleName, locale, c);
        }
        catch (IllegalArgumentException c) {
        }
        catch (MissingResourceException c) {
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        try {
            path = String.valueOf(directory.replace('/', '.')) + "." + bundleName;
            return ResourceBundle.getBundle(path, locale);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            path = String.valueOf(directory.replace('/', '.')) + ".i18n." + bundleName;
            return ResourceBundle.getBundle(path, locale);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    public static Locale getLocale(String localeString) {
        String[] s = StringUtils.split(localeString, '_');
        if (s.length == 0) {
            return null;
        }
        if (s.length == 1) {
            return new Locale(s[0], "");
        }
        if (s.length == 2) {
            return new Locale(s[0], s[1]);
        }
        return new Locale(s[0], s[1], s[2]);
    }

    public static boolean isEnglishLocale() {
        return Locale.getDefault().getLanguage().equals("en");
    }

    public static void setExternalDefaultEncoding(String externalDefaultEncoding) {
        LocaleMgr.externalDefaultEncoding = externalDefaultEncoding;
    }
}

