/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashAlgorithms {
    private static int BUFFER_SIZE = 65536;
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_PROPRIETARY = "PROPRIETARY";
    public static final String ALGORITHM_SAME_AS_GIT = "GIT";
    public static final String ALGORITHM_SHA1 = "SHA-1";
    public static final String ALGORITHM_SHA256 = "SHA-256";
    public static final String PARM_ALGORITHM_MD5 = "MD5";
    public static final String PARM_ALGORITHM_RAA = "RAA";
    public static final String PARM_ALGORITHM_SAME_AS_GIT = "GIT";
    public static final String PARM_ALGORITHM_SHA1 = "SHA1";
    public static final String PARM_ALGORITHM_SHA256 = "SHA256";
    public static final String RESPONSE_HEADER_FILE_HASH_RAA = "X-com.ibm.dmh.FileHash";

    private static long clshift(long hash, int pos) {
        int i = 0;
        while (i < pos) {
            hash = hash << 1 ^ (long)(hash < 0L ? 1 : 0);
            ++i;
        }
        return hash;
    }

    private static String convertBytesToHexFormat(byte[] mdbytes) {
        StringBuffer hexString = new StringBuffer();
        int i = 0;
        while (i < mdbytes.length) {
            hexString.append(Integer.toHexString(0x100 | 0xFF & mdbytes[i]).substring(1));
            ++i;
        }
        return hexString.toString();
    }

    private static byte[] digestData(MessageDigest md, InputStream is) throws IOException {
        byte[] dataBytes = new byte[BUFFER_SIZE];
        int nread = 0;
        while ((nread = is.read(dataBytes)) != -1) {
            md.update(dataBytes, 0, nread);
        }
        return md.digest();
    }

    public static String useGitAlgorithm(long filesize, InputStream is) throws IOException, NoSuchAlgorithmException {
        String gitString = "blob " + Long.toString(filesize) + "\u0000";
        MessageDigest md = MessageDigest.getInstance(ALGORITHM_SHA1);
        md.update(gitString.getBytes());
        byte[] mdbytes = HashAlgorithms.digestData(md, is);
        return HashAlgorithms.convertBytesToHexFormat(mdbytes);
    }

    public static long useProprietaryAlgorithm(InputStream is) throws IOException {
        long hash = 5381L;
        BufferedInputStream bis = new BufferedInputStream(is, BUFFER_SIZE);
        byte[] bytes = new byte[BUFFER_SIZE];
        int bytesRead = bis.read(bytes);
        while (bytesRead != -1) {
            int i = 0;
            while (i < bytesRead) {
                hash = HashAlgorithms.clshift(hash, 5) + hash + (long)bytes[i];
                ++i;
            }
            bytesRead = bis.read(bytes);
        }
        bis.close();
        if ((hash -= 5381L) == 0L) {
            return -1L;
        }
        return hash;
    }

    public static String useStandardAlgorithm(String algorithm, InputStream is) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] mdbytes = HashAlgorithms.digestData(md, is);
        return HashAlgorithms.convertBytesToHexFormat(mdbytes);
    }

    public static String validateHashParm(String hashParm) {
        if (hashParm == null) {
            return null;
        }
        if (hashParm.equals("MD5")) {
            return "MD5";
        }
        if (hashParm.equals(PARM_ALGORITHM_RAA)) {
            return ALGORITHM_PROPRIETARY;
        }
        if (hashParm.equals("GIT")) {
            return "GIT";
        }
        if (hashParm.equals(PARM_ALGORITHM_SHA1)) {
            return ALGORITHM_SHA1;
        }
        if (hashParm.equals(PARM_ALGORITHM_SHA256)) {
            return ALGORITHM_SHA256;
        }
        return null;
    }
}

