/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.ConfigMgr;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.process.ProcessExec;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Environment {
    public static boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("ix") >= 0 || os.indexOf("ux") >= 0;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().indexOf("win") != -1;
    }

    public static boolean isZOS() {
        String os = System.getProperty("os.name");
        return os.startsWith("OS/390") || os.startsWith("z/OS");
    }

    public static String getCurrentJobNameAndId() {
        return Environment.isZOS() ? new ZosInfo().getJobNameAndId() : "";
    }

    public static boolean isApplicationServer() {
        return Environment.isWASFullProfile() || Environment.isWASLiberty();
    }

    public static boolean isWASFullProfile() {
        boolean isWAS;
        boolean bl = isWAS = !StringUtils.isEmpty(System.getProperty("com.ibm.websphere.ServerType")) || !StringUtils.isEmpty(System.getProperty("com.ibm.websphere.servlet.application.name"));
        if (!isWAS && !Environment.isWASLiberty()) {
            try {
                Class.forName("com.ibm.websphere.runtime.ServerName");
                isWAS = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return isWAS;
    }

    public static boolean isWASLiberty() {
        return !StringUtils.isEmpty(System.getProperty("wlp.install.dir"));
    }

    public static String getEnvironment() {
        String text = String.format("isUnix=%s isWindows=%s isZOS=%s isApplicationServer=%s isWASFullProfile=%s isWASLiberty=%s currentJobAndId=%s", Environment.isUnix(), Environment.isWindows(), Environment.isZOS(), Environment.isApplicationServer(), Environment.isWASFullProfile(), Environment.isWASLiberty(), Environment.getCurrentJobNameAndId());
        return text;
    }

    public static void main(String[] args) {
        try {
            ConfigMgr.load(System.getProperty("WSAA_CONFIG"));
            System.out.println(Environment.getEnvironment());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static class ZosInfo {
        private String jobName = "";
        private String jobId = "";
        private String userid = "";
        private String component = "";

        ZosInfo() {
            try {
                if (Environment.isZOS()) {
                    File wsaaHome = new File(ConfigMgr.get("Common.wsaaHome"));
                    ProcessExec p = new ProcessExec(new File(wsaaHome, "bin/ZosInfo.rexx").toString());
                    p.setLocation(new File(wsaaHome, "bin").toString());
                    p.setLogging(true);
                    p.run();
                    String result = p.getStdOut().toString();
                    Pattern pattern = Pattern.compile("([^=\\r\\n]+) *= *([^\\r\\n]*)");
                    Matcher m = pattern.matcher(result);
                    while (m.find()) {
                        String key = m.group(1).trim().toUpperCase();
                        String val = m.group(2).trim();
                        if ("COMPONENT".equals(key)) {
                            this.component = val;
                            continue;
                        }
                        if ("JOBID".equals(key)) {
                            this.jobId = val;
                            continue;
                        }
                        if ("JOBNAME".equals(key)) {
                            this.jobName = val;
                            continue;
                        }
                        if (!"USERID".equals(key)) continue;
                        this.userid = val;
                    }
                }
            }
            catch (Throwable t) {
                this.jobName = "????????";
                this.jobId = "????????";
            }
        }

        String getJobName() {
            return this.jobName;
        }

        String getJobId() {
            return this.jobId;
        }

        String getJobNameAndId() {
            return String.format("%s(%s)", this.getJobName(), this.getJobId());
        }

        String getUserid() {
            return this.userid;
        }

        String getComponent() {
            return this.component;
        }
    }
}

