/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.utils;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.reservedWords.ReservedWordsASM_optableUNI;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ParserAsmStatement {
    private static final int NAME_LENGTH = 63;
    public static final int NAME_INVALID = 1;
    private static final int NAME_NONE = 2;
    public static final int NAME_NONE_OPERATION_BAD = 3;
    private static final int NAME_NONE_OPERATION_VALID_MACRO = 4;
    public static final int NAME_NONE_OPERATION_VALID_NOT_MACRO = 5;
    public static final int NAME_VALID = 6;
    public static final int NAME_VALID_OPERATION_BAD = 7;
    public static final int NAME_VALID_OPERATION_VALID_MACRO = 8;
    public static final int NAME_VALID_OPERATION_VALID_NOT_MACRO = 9;
    private static final int OPERATION_BAD = 10;
    public static final int OPERATION_INVALID = 11;
    public static final int OPERATION_NONE = 12;
    private static final int OPERATION_VALID = 13;
    private static final int OPERATION_VALID_MACRO = 14;
    private static final int OPERANDS_LENGTH = 8192;
    private static final int OPERATION_LENGTH = 63;
    private static final int SCAN_STATE_LookingForName = 1;
    private static final int SCAN_STATE_LookingForOperand = 2;
    private static final int SCAN_STATE_LookingForOperation = 3;
    private static final int SCAN_STATE_LookingForRemarks = 4;
    private static final int SCAN_STATE_LookingForRemarksWithComma = 5;
    private static final int SCAN_STATE_ScanningExec = 6;
    private static final int SCAN_STATE_ScanningName = 7;
    private static final int SCAN_STATE_ScanningOperand = 8;
    private static final int SCAN_STATE_ScanningOperandWithSpaces = 9;
    private static final int SCAN_STATE_ScanningOperation = 10;
    private static final int SCAN_STATE_ScanningQuotedString = 11;
    private static final int SCAN_STATE_Setup = 12;
    private static final int OPERAND_IS_CONTINUED_FALSE = 0;
    private static final int OPERAND_IS_CONTINUED_TRUE = 1;
    private static final int OPERAND_IS_CONTINUED_MAYBE = 2;
    public static final String ASM_STMT_ACTR = "ACTR";
    public static final String ASM_STMT_AEJECT = "AEJECT";
    private static final String ASM_STMT_AGO = "AGO";
    private static final String ASM_STMT_AIF = "AIF";
    public static final String ASM_STMT_AINSERT = "AINSERT";
    public static final String ASM_STMT_AMODE = "AMODE";
    public static final String ASM_STMT_ANOP = "ANOP";
    public static final String ASM_STMT_AREAD = "AREAD";
    public static final String ASM_STMT_ASPACE = "ASPACE";
    public static final String ASM_STMT_EJECT = "EJECT";
    public static final String ASM_STMT_END = "END";
    public static final String ASM_STMT_ENTRY = "ENTRY";
    public static final String ASM_STMT_EQU = "EQU";
    private static final String ASM_STMT_GBLA = "GBLA";
    private static final String ASM_STMT_GBLB = "GBLB";
    private static final String ASM_STMT_GBLC = "GBLC";
    private static final String ASM_STMT_LCLA = "LCLA";
    private static final String ASM_STMT_LCLB = "LCLB";
    private static final String ASM_STMT_LCLC = "LCLC";
    public static final String ASM_STMT_RMODE = "RMODE";
    public static final String ASM_STMT_SETA = "SETA";
    private static final String ASM_STMT_SETAF = "SETAF";
    public static final String ASM_STMT_SETB = "SETB";
    public static final String ASM_STMT_SETC = "SETC";
    private static final String ASM_STMT_SETCF = "SETCF";
    public static final String ASM_STMT_TITLE = "TITLE";
    private String standardCharSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_0123456789+-,=.*()'/& ";
    private static final String standardCharSetNationals = "@$#";
    private boolean allowSpacesOnContinuedLine = false;
    private boolean literalContinued = false;
    private boolean nonBlankCol72 = false;
    private boolean skipCicsCommand = false;
    private boolean stopScanningRecord = false;
    private int currentColumnNo = 0;
    private int currentFileLineNo = 0;
    private int currentSourceLineNo = 0;
    private int nameColumnNo = 0;
    private int nameFileLineNo = 0;
    private int nameSourceLineNo = 0;
    private int operandIsContinued = 0;
    private int operationColumnNo = 0;
    private int operationFileLineNo = 0;
    private int operationSourceLineNo = 0;
    private int parenCount = 0;
    private int scanState = 12;
    private List<String> remarks;
    private String currentChar;
    private String name = "";
    private String nextChar;
    private String operands = "";
    private String operation = "";
    private String previousChar = "";
    private String previousPreviousChar = "";
    private String prevOperands = "";

    public ParserAsmStatement() {
        this(null);
    }

    public ParserAsmStatement(String mvsCodePage) {
        if (!StringUtils.isEmpty(mvsCodePage)) {
            try {
                byte[] bytes1047 = standardCharSetNationals.getBytes("Cp1047");
                String chars = new String(bytes1047, mvsCodePage);
                this.standardCharSet = String.valueOf(this.standardCharSet) + chars;
            }
            catch (UnsupportedEncodingException e) {
                mvsCodePage = null;
            }
        }
        if (StringUtils.isEmpty(mvsCodePage)) {
            this.standardCharSet = String.valueOf(this.standardCharSet) + standardCharSetNationals;
        }
    }

    private boolean adjustScanStateForContinuationIndicator(String record, boolean useContinuedColumn) {
        boolean continuationLine;
        block8: {
            block7: {
                if (!useContinuedColumn) break block7;
                continuationLine = ParserAsmStatement.checkIfContinuationLine(record);
                switch (this.scanState) {
                    case 4: {
                        if (this.remarks != null && this.remarks.size() != 0) {
                            this.scanState = 2;
                            break;
                        }
                        break block8;
                    }
                    case 5: {
                        this.scanState = 2;
                        break;
                    }
                    case 12: {
                        this.setup();
                        this.scanState = 1;
                        break;
                    }
                }
                break block8;
            }
            continuationLine = ParserAsmStatement.checkIfContinuationLine(record);
            this.setup();
            this.scanState = 1;
        }
        if (this.skipCicsCommand) {
            this.scanState = 6;
        }
        return continuationLine;
    }

    private int checkName() {
        int nameLength = this.name.length();
        if (nameLength == 0) {
            return 2;
        }
        int rc = 6;
        int i = 0;
        while (i < this.name.length()) {
            String nameChar = this.name.substring(i, i + 1);
            if (!this.standardCharSet.contains(nameChar)) {
                rc = 1;
                break;
            }
            ++i;
        }
        return rc;
    }

    public boolean checkOperandForm(String operands, boolean isCompleteOperands) {
        if (!isCompleteOperands && !operands.contains("=")) {
            return false;
        }
        if (!isCompleteOperands && operands.endsWith(",")) {
            return true;
        }
        if (isCompleteOperands && !operands.endsWith(",")) {
            return true;
        }
        return this.scanState == 11;
    }

    private int checkOperation() {
        int operationLength = this.operation.length();
        if (operationLength == 0) {
            return 12;
        }
        String firstChar = this.operation.substring(0, 1);
        if (firstChar.equals("*")) {
            return 10;
        }
        int rc = 13;
        int i = 0;
        while (i < operationLength) {
            String operationChar = this.operation.substring(i, i + 1);
            if (!this.standardCharSet.contains(operationChar)) {
                rc = 11;
                break;
            }
            ++i;
        }
        return rc;
    }

    public static boolean checkIfContinuationLine(String record) {
        return record.length() >= 72 && record.charAt(71) != ' ';
    }

    public Boolean getLiteralContinued() {
        return this.literalContinued;
    }

    public String getName() {
        return this.name;
    }

    public int getNameColumnNo() {
        return this.nameColumnNo;
    }

    public int getNameFileLineNo() {
        return this.nameFileLineNo;
    }

    public int getNameSourceLineNo() {
        return this.nameSourceLineNo;
    }

    public String getOperands() {
        return this.operands;
    }

    public String getOperation() {
        return this.operation;
    }

    public int getOperationColumnNo() {
        return this.operationColumnNo;
    }

    public int getOperationFileLineNo() {
        return this.operationFileLineNo;
    }

    public int getOperationSourceLineNo() {
        return this.operationSourceLineNo;
    }

    public List<String> getRemarks() {
        return this.remarks;
    }

    public boolean getSkipCicsCommand() {
        return this.skipCicsCommand;
    }

    public boolean getNameOperationOperands(int lineNo, String A_p_line, boolean useContinuedColumn) {
        boolean continuationLine = this.adjustScanStateForContinuationIndicator(A_p_line, useContinuedColumn);
        String wholeLine = A_p_line;
        this.currentFileLineNo = lineNo;
        this.currentSourceLineNo = lineNo;
        this.stopScanningRecord = false;
        if (useContinuedColumn && A_p_line.length() > 15) {
            A_p_line = A_p_line.substring(15);
            this.currentColumnNo = 15;
            if (this.operandIsContinued == 2) {
                this.operands = this.operands.substring(0, this.operands.length() - 1);
            }
            this.operandIsContinued = 0;
        } else {
            this.currentColumnNo = 0;
        }
        while (A_p_line.length() != 0) {
            ++this.currentColumnNo;
            this.currentChar = A_p_line.substring(0, 1);
            try {
                this.nextChar = A_p_line.substring(1, 2);
            }
            catch (Exception e) {
                this.nextChar = "";
            }
            switch (this.scanState) {
                case 1: {
                    this.processScanStateLookingForName();
                    break;
                }
                case 2: {
                    this.processScanStateLookingForOperand();
                    break;
                }
                case 3: {
                    this.processScanStateLookingForOperation();
                    break;
                }
                case 4: {
                    this.processScanStateLookingForRemarks(A_p_line, wholeLine);
                    break;
                }
                case 5: {
                    this.processScanStateLookingForRemarksWithComma(A_p_line, wholeLine);
                    break;
                }
                case 6: {
                    this.processScanStateScanningExec(wholeLine);
                    break;
                }
                case 7: {
                    this.processScanStateScanningName();
                    break;
                }
                case 8: {
                    this.processScanStateScanningOperand(wholeLine);
                    break;
                }
                case 9: {
                    this.processScanStateScanningOperandWithSpaces();
                    break;
                }
                case 10: {
                    this.processScanStateScanningOperation();
                    break;
                }
                case 11: {
                    this.processScanStateScanningQuotedString();
                    break;
                }
            }
            if (this.stopScanningRecord) break;
            if (this.scanState != 2 && this.scanState != 4 && this.scanState != 5) {
                this.previousPreviousChar = this.previousChar;
                this.previousChar = this.currentChar;
            }
            A_p_line = A_p_line.substring(1);
        }
        if (!(this.operandIsContinued != 1 && this.operandIsContinued != 2 || this.scanState != 8 || this.stopScanningRecord || A_p_line.length() != 0)) {
            this.operandIsContinued = 0;
            this.scanState = 1;
        }
        return continuationLine;
    }

    private boolean hasAlternativeStatementFormat(String operation) {
        return operation.equals(ASM_STMT_AGO) || operation.equals(ASM_STMT_AIF) || operation.equals(ASM_STMT_GBLA) || operation.equals(ASM_STMT_GBLB) || operation.equals(ASM_STMT_GBLC) || operation.equals(ASM_STMT_LCLA) || operation.equals(ASM_STMT_LCLB) || operation.equals(ASM_STMT_LCLC) || operation.equals(ASM_STMT_SETA) || operation.equals(ASM_STMT_SETAF) || operation.equals(ASM_STMT_SETB) || operation.equals(ASM_STMT_SETC) || operation.equals(ASM_STMT_SETCF);
    }

    private boolean isAsmDirective() {
        String frmt = ReservedWordsASM_optableUNI.get(this.operation);
        return frmt != null && frmt.equals("HLASM");
    }

    private boolean isAsmOpcode() {
        String frmt = ReservedWordsASM_optableUNI.get(this.operation);
        return frmt != null && !frmt.equals("HLASM");
    }

    private void clearRemarks() {
        if (this.remarks != null && this.remarks.size() != 0) {
            this.remarks.clear();
        }
    }

    private void collectRemarks(String wholeLine, String A_p_line) {
        int lineNumOffset;
        int endOfValidText;
        int checkForSeqNums = wholeLine.length();
        if (checkForSeqNums > 80) {
            return;
        }
        String remark = checkForSeqNums > 72 ? ((endOfValidText = checkForSeqNums - this.currentColumnNo - (lineNumOffset = checkForSeqNums - 72)) > -1 ? A_p_line.substring(0, endOfValidText) : A_p_line) : A_p_line;
        if (checkForSeqNums == 72) {
            remark = remark.substring(0, remark.length() - 1);
        }
        if ((remark = remark.trim()).length() != 0) {
            if (this.remarks == null) {
                this.remarks = new ArrayList<String>();
            }
            if (this.remarks.size() != 0) {
                this.remarks.add(" " + remark);
            } else {
                this.remarks.add(remark);
            }
        }
    }

    private void processScanStateLookingForName() {
        this.parenCount = 0;
        if (this.currentChar.equals(" ")) {
            this.operandIsContinued = 0;
            this.scanState = 3;
        } else {
            this.nameColumnNo = this.currentColumnNo;
            this.nameFileLineNo = this.currentFileLineNo;
            this.nameSourceLineNo = this.currentSourceLineNo;
            this.name = String.valueOf(this.name) + this.currentChar.toUpperCase();
            this.scanState = 7;
        }
    }

    private void processScanStateLookingForOperand() {
        if (this.currentColumnNo == 72) {
            this.stopScanningRecord = true;
            return;
        }
        if (this.currentChar.equals(" ")) {
            if (this.currentColumnNo == 71 && !this.nextChar.equals(" ")) {
                return;
            }
            if (this.literalContinued) {
                if (this.currentColumnNo > 15) {
                    this.operands = String.valueOf(this.operands) + this.currentChar;
                }
            } else if (this.operandIsContinued == 1 || this.operandIsContinued == 2) {
                if (this.currentColumnNo > 15) {
                    this.operands = String.valueOf(this.operands) + this.currentChar;
                }
            } else if (this.operands.length() != 0 && this.currentColumnNo > 15) {
                this.scanState = 4;
                return;
            }
            return;
        }
        this.operands = String.valueOf(this.operands) + this.currentChar.toUpperCase();
        if (this.currentChar.equals("'") || this.literalContinued) {
            this.literalContinued = false;
            this.scanState = 11;
            return;
        }
        if (this.operation.equals(ASM_STMT_AIF) || this.operation.equals(ASM_STMT_SETB) || this.operation.equals(ASM_STMT_SETC) || this.allowSpacesOnContinuedLine) {
            if (this.currentChar.equals("(")) {
                ++this.parenCount;
                this.scanState = 9;
                return;
            }
            if (this.currentChar.equals(")")) {
                --this.parenCount;
            }
        }
        this.scanState = 8;
    }

    private void processScanStateLookingForOperation() {
        if (this.currentColumnNo == 72) {
            this.stopScanningRecord = true;
        } else if (this.currentChar.equals(" ")) {
            if (!this.nextChar.equals(" ") && this.nonBlankCol72 && this.name.length() == 0 && this.operation.length() == 0) {
                if (this.currentColumnNo > 16) {
                    this.scanState = 4;
                    this.nonBlankCol72 = false;
                }
            } else {
                this.operandIsContinued = 0;
            }
        } else if (this.currentColumnNo == 16 && !this.currentChar.equals(" ") && this.previousChar.equals(" ") && this.nonBlankCol72 && this.name.length() == 0 && this.operation.length() == 0) {
            this.operandIsContinued = 1;
            this.operands = String.valueOf(this.operands) + this.currentChar;
            this.scanState = 2;
        } else {
            this.operationColumnNo = this.currentColumnNo;
            this.operationFileLineNo = this.currentFileLineNo;
            this.operationSourceLineNo = this.currentSourceLineNo;
            this.operation = String.valueOf(this.operation) + this.currentChar.toUpperCase();
            this.scanState = 10;
        }
    }

    private void processScanStateLookingForRemarks(String A_p_line, String wholeLine) {
        if (this.currentColumnNo < 72) {
            if (!this.currentChar.equals(" ")) {
                if (this.currentChar.equals(",")) {
                    if (!this.nextChar.equals(" ")) {
                        this.nonBlankCol72 = ParserAsmStatement.checkIfContinuationLine(wholeLine);
                        this.collectRemarks(wholeLine, A_p_line);
                        this.scanState = 1;
                        this.stopScanningRecord = true;
                    }
                } else {
                    this.nonBlankCol72 = ParserAsmStatement.checkIfContinuationLine(wholeLine);
                    this.collectRemarks(wholeLine, A_p_line);
                    if (!this.nonBlankCol72) {
                        this.scanState = 1;
                    }
                    this.stopScanningRecord = true;
                }
            }
        } else if (this.currentColumnNo == 72) {
            this.currentChar.equals(" ");
            this.stopScanningRecord = true;
        } else {
            this.scanState = 1;
            this.stopScanningRecord = true;
        }
    }

    private void processScanStateLookingForRemarksWithComma(String A_p_line, String wholeLine) {
        if (this.currentColumnNo < 72 && this.currentChar.equals(" ")) {
            return;
        }
        if (this.currentColumnNo == 72) {
            this.currentChar.equals(" ");
        } else if (!this.currentChar.equals(" ")) {
            this.collectRemarks(wholeLine, A_p_line);
        }
        this.scanState = 2;
        if (this.operandIsContinued != 2) {
            this.operandIsContinued = 1;
        }
        this.stopScanningRecord = true;
    }

    private void processScanStateScanningExec(String wholeLine) {
        if (this.currentColumnNo == 72) {
            this.stopScanningRecord = true;
        } else if (this.skipCicsCommand) {
            if (!ParserAsmStatement.checkIfContinuationLine(wholeLine)) {
                this.skipCicsCommand = false;
                this.scanState = 1;
                this.stopScanningRecord = true;
            }
        } else if (this.currentChar.equals(" ")) {
            if (this.operands.equals("CICS")) {
                this.skipCicsCommand = true;
            }
        } else {
            this.operands = String.valueOf(this.operands) + this.currentChar;
        }
    }

    private void processScanStateScanningName() {
        if (this.currentChar.equals(" ") || this.name.length() == 63) {
            this.operandIsContinued = 0;
            this.scanState = 3;
        } else {
            this.name = String.valueOf(this.name) + this.currentChar.toUpperCase();
        }
    }

    private void processScanStateScanningOperand(String wholeLine) {
        if (this.operands.length() >= 8192) {
            this.stopScanningRecord = true;
        } else if (this.currentChar.equals(" ")) {
            if (this.operandIsContinued == 0) {
                if (this.previousChar.equals(",")) {
                    this.scanState = 5;
                } else if (this.hasAlternativeStatementFormat(this.operation)) {
                    this.scanState = 4;
                } else if (ParserAsmStatement.checkIfContinuationLine(wholeLine)) {
                    this.operandIsContinued = 2;
                    this.operands = String.valueOf(this.operands) + ",";
                    this.scanState = 5;
                } else {
                    this.scanState = 4;
                }
            }
        } else if (this.currentColumnNo == 72) {
            if (!this.currentChar.equals(" ")) {
                this.operandIsContinued = 1;
            }
            this.stopScanningRecord = true;
        } else {
            this.prevOperands = this.operands;
            this.operands = String.valueOf(this.operands) + this.currentChar.toUpperCase();
            if (this.currentColumnNo == 71) {
                if (!this.nextChar.equals(" ")) {
                    this.operandIsContinued = 1;
                }
                this.stopScanningRecord = true;
            } else if (!(!this.currentChar.equals("'") || this.prevOperands.endsWith("K") || this.prevOperands.endsWith("L") || this.prevOperands.endsWith("N") || this.prevOperands.endsWith("T"))) {
                this.literalContinued = false;
                this.scanState = 11;
            }
        }
    }

    private void processScanStateScanningOperandWithSpaces() {
        if (this.operands.length() >= 8192) {
            this.stopScanningRecord = true;
            return;
        }
        this.prevOperands = this.operands;
        this.operands = String.valueOf(this.operands) + this.currentChar.toUpperCase();
        if (this.currentColumnNo == 71) {
            if (!this.nextChar.equals(" ")) {
                this.operandIsContinued = 1;
            }
            if (this.parenCount != 0) {
                this.allowSpacesOnContinuedLine = true;
            }
            this.stopScanningRecord = true;
            return;
        }
        if (this.currentChar.equals("'")) {
            if (!this.prevOperands.endsWith("K") && !this.prevOperands.endsWith("L") && !this.prevOperands.endsWith("N") && !this.prevOperands.endsWith("T") || !this.nextChar.equals("&") && !this.previousPreviousChar.equals("+")) {
                this.scanState = 11;
            }
        } else if (this.currentChar.equals("(")) {
            ++this.parenCount;
        } else if (this.currentChar.equals(")")) {
            --this.parenCount;
            if (this.parenCount == 0) {
                this.allowSpacesOnContinuedLine = false;
                this.scanState = 8;
            }
        }
    }

    private void processScanStateScanningOperation() {
        if (this.currentChar.equals(" ") || this.operation.length() >= 63) {
            this.operandIsContinued = 0;
            this.clearRemarks();
            this.scanState = this.operation.equals(ASM_STMT_ANOP) || this.operation.equals("CSECT") ? 4 : (this.operation.equals("EXEC") ? 6 : 2);
        } else if (this.currentChar.equals(",")) {
            this.operandIsContinued = 0;
            this.clearRemarks();
            this.scanState = 4;
        } else {
            this.operation = String.valueOf(this.operation) + this.currentChar.toUpperCase();
        }
    }

    private void processScanStateScanningQuotedString() {
        if (this.operands.length() >= 8192) {
            this.stopScanningRecord = true;
        } else if (this.currentColumnNo == 72) {
            if (!this.currentChar.equals(" ")) {
                this.literalContinued = true;
                this.operandIsContinued = 1;
            }
            this.stopScanningRecord = true;
        } else {
            this.operands = String.valueOf(this.operands) + this.currentChar;
            if (this.currentChar.equals("'")) {
                this.scanState = this.operation.equals(ASM_STMT_AIF) || this.operation.equals(ASM_STMT_SETB) || this.allowSpacesOnContinuedLine ? 9 : 8;
            }
        }
    }

    private void setup() {
        this.allowSpacesOnContinuedLine = false;
        this.literalContinued = false;
        this.name = "";
        this.nameColumnNo = 0;
        this.nameFileLineNo = 0;
        this.nameSourceLineNo = 0;
        this.operandIsContinued = 0;
        this.operands = "";
        this.operation = "";
        this.operationColumnNo = 0;
        this.operationFileLineNo = 0;
        this.operationSourceLineNo = 0;
        this.previousChar = "";
        this.previousPreviousChar = "";
        this.prevOperands = "";
        this.clearRemarks();
    }

    public int validateNames() {
        int validOperation = this.checkOperation();
        if (validOperation == 12) {
            return this.checkName();
        }
        if (validOperation == 11) {
            return 11;
        }
        if (validOperation == 10) {
            int validName = this.checkName();
            if (validName == 1) {
                return 1;
            }
            if (validName == 2) {
                return 3;
            }
            return 7;
        }
        int validName = this.checkName();
        if (this.isAsmDirective() || this.isAsmOpcode()) {
            if (validName == 1) {
                return 1;
            }
            if (validName == 2) {
                return 5;
            }
            return 9;
        }
        if (validName == 2) {
            return 4;
        }
        if (validName == 1) {
            return 14;
        }
        return 8;
    }
}

