/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.utils;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class LocaleMgr {
    private static LocaleMgr localeMgr = new LocaleMgr();

    public static String getExternalDefaultEncoding() {
        String fileEncoding = System.getProperty("externalFileEncoding");
        if (fileEncoding != null && !fileEncoding.trim().equals("")) {
            return fileEncoding;
        }
        String os = System.getProperty("os.name");
        if (os.startsWith("OS/390") || os.startsWith("z/OS")) {
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            if (language.equals("ja") || country.equals("JP")) {
                return "Cp939";
            }
            return "Cp1047";
        }
        return "UTF-8";
    }

    public static String getLocaleSpecificPath(String filePath, Locale locale) {
        String path;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        char fsc = File.separatorChar;
        filePath = filePath.replace('\\', fsc).replace('/', fsc);
        String directory = filePath.substring(0, filePath.lastIndexOf(fsc));
        String fileName = filePath.substring(filePath.lastIndexOf(fsc) + 1);
        String base = fileName.substring(0, fileName.lastIndexOf(46));
        String extension = fileName.substring(fileName.lastIndexOf(46));
        String localeString = "_" + locale.toString() + "_";
        while (localeString.length() > 0) {
            localeString = localeString.substring(0, localeString.lastIndexOf(95));
            path = String.valueOf(directory) + fsc + base + localeString + extension;
            if (!new File(path).exists()) continue;
            return path;
        }
        directory = String.valueOf(directory) + fsc + "i18n";
        localeString = "_" + locale.toString() + "_";
        while (localeString.length() > 0) {
            localeString = localeString.substring(0, localeString.lastIndexOf(95));
            path = String.valueOf(directory) + fsc + base + localeString + extension;
            if (!new File(path).exists()) continue;
            return path;
        }
        return null;
    }

    public static URL getLocaleSpecificClasspathFile(String fileName, Locale locale) {
        URL url;
        String testFile;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String base = fileName.substring(0, fileName.lastIndexOf(46));
        String extension = fileName.substring(fileName.lastIndexOf(46));
        String localeString = "_" + locale.toString() + "_";
        while (localeString.length() > 0) {
            localeString = localeString.substring(0, localeString.lastIndexOf(95));
            testFile = "/" + base + localeString + extension;
            url = localeMgr.getClass().getResource(testFile);
            if (url == null) continue;
            return url;
        }
        localeString = "_" + locale.toString() + "_";
        while (localeString.length() > 0) {
            localeString = localeString.substring(0, localeString.lastIndexOf(95));
            testFile = "/i18n/" + base + localeString + extension;
            url = localeMgr.getClass().getResource(testFile);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public static ResourceBundle getResourceBundle(String filePath, Locale locale) throws IOException {
        String path = LocaleMgr.getLocaleSpecificPath(filePath = String.valueOf(filePath.substring(0, filePath.lastIndexOf(46))) + ".properties", locale);
        if (path == null) {
            return null;
        }
        return new PropertyResourceBundle(new FileInputStream(new File(path)));
    }

    public static Locale getLocale(String localeString) {
        String[] s = StringUtils.split(localeString, '_');
        if (s.length == 0) {
            return null;
        }
        if (s.length == 1) {
            return new Locale(s[0], "");
        }
        if (s.length == 2) {
            return new Locale(s[0], s[1]);
        }
        return new Locale(s[0], s[1], s[2]);
    }
}

