/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.utils;

import java.util.Map;
import java.util.Set;

public class FileTypeClassification {
    public static final String METADATA_ATTCLIST = "attcList";
    public static final String METADATA_ATTNLIST = "attnList";
    public static final String METADATA_CONTAINER_ID = "containerId";
    public static final String METADATA_FILE_ID = "fileId";
    public static final String METADATA_INCLLIST = "inclList";
    public static final String METADATA_INCLUDED_FILE_CONTAINS_ENTRY = "includedFileContainsEntry";
    public static final String METADATA_PLX_IS_MAIN = "plxIsMain";
    public static final String METADATA_SEARCHED = "searched";
    public static final String METADATA_USED_AS_PROC = "usedAsProc";
    private final Map<String, Object> filesMetadata;
    private String fileTypeCd;
    private final String languageCd;

    public FileTypeClassification(String languageCd, Map<String, Object> filesMetadata) {
        this.filesMetadata = filesMetadata;
        this.languageCd = languageCd;
        this.fileTypeCd = null;
    }

    private void classifyAsm() {
        Map inclList;
        Map attnList = (Map)this.filesMetadata.get(METADATA_ATTNLIST);
        if (attnList != null) {
            if (attnList.containsKey(39) && (Integer)attnList.get(39) == 0) {
                this.fileTypeCd = attnList.containsKey(40) && (Integer)attnList.get(40) != 0 ? "MAIN" : "MAC";
                return;
            }
            if (attnList.containsKey(65)) {
                this.fileTypeCd = "MAP";
                return;
            }
            if (attnList.containsKey(87)) {
                this.fileTypeCd = "MFS";
                return;
            }
        }
        if ((inclList = (Map)this.filesMetadata.get(METADATA_INCLLIST)) != null && inclList.containsKey(8)) {
            Map inclNameMap = (Map)inclList.get(8);
            Set inclNames = inclNameMap.keySet();
            if (inclNames.contains("DBDGEN")) {
                this.fileTypeCd = "DBD";
                return;
            }
            if (inclNames.contains("PSBGEN")) {
                this.fileTypeCd = "PSB";
                return;
            }
        }
        if (FileTypeClassification.fileContainsEntry(attnList, inclList)) {
            this.fileTypeCd = "MAIN";
            return;
        }
        Boolean includedFileContainsEntry = (Boolean)this.filesMetadata.get(METADATA_INCLUDED_FILE_CONTAINS_ENTRY);
        this.fileTypeCd = includedFileContainsEntry != false ? "MAIN" : "INCL";
    }

    private void classifyCobol() {
        Map attnList = (Map)this.filesMetadata.get(METADATA_ATTNLIST);
        if (attnList != null && attnList.containsKey(34)) {
            this.fileTypeCd = "MAIN";
            return;
        }
        this.fileTypeCd = "INCL";
    }

    private void classifyEasytrieve() {
        Map attnList = (Map)this.filesMetadata.get(METADATA_ATTNLIST);
        if (attnList != null && attnList.containsKey(39) && (Integer)attnList.get(39) == 0) {
            this.fileTypeCd = "MAC";
            return;
        }
        this.fileTypeCd = "UNKN";
    }

    private void classifyJcl() {
        Boolean usedAsProc;
        Map attnList = (Map)this.filesMetadata.get(METADATA_ATTNLIST);
        if (attnList != null) {
            Integer value;
            if (attnList.containsKey(39) && (value = (Integer)attnList.get(39)) == 0) {
                this.fileTypeCd = "PROC";
                return;
            }
            if (attnList.containsKey(52)) {
                this.fileTypeCd = "MAIN";
                return;
            }
        }
        this.fileTypeCd = (usedAsProc = (Boolean)this.filesMetadata.get(METADATA_USED_AS_PROC)) != false ? "PROC" : "INCL";
    }

    private void classifyPli() {
        Map attnList = (Map)this.filesMetadata.get(METADATA_ATTNLIST);
        this.fileTypeCd = attnList != null && (attnList.containsKey(37) || attnList.containsKey(60)) && !attnList.containsKey(39) ? "MAIN" : "INCL";
    }

    private void classifyPlx() {
        Map attnList = (Map)this.filesMetadata.get(METADATA_ATTNLIST);
        if (attnList != null && attnList.containsKey(37)) {
            this.fileTypeCd = "MAIN";
            return;
        }
        Boolean plxIsMain = (Boolean)this.filesMetadata.get(METADATA_PLX_IS_MAIN);
        if (plxIsMain.booleanValue()) {
            this.fileTypeCd = "MAIN";
            return;
        }
        this.fileTypeCd = "INCL";
    }

    private void classifyText() {
        Map attnList = (Map)this.filesMetadata.get(METADATA_ATTNLIST);
        if (attnList != null && attnList.containsKey(810)) {
            this.fileTypeCd = "CSD";
            return;
        }
        this.fileTypeCd = "";
    }

    public static boolean fileContainsEntry(Map<Integer, Integer> iAttnList, Map<Integer, Map<String, Integer>> iInclList) {
        if (iAttnList != null && (iAttnList.containsKey(46) || iAttnList.containsKey(57) || iAttnList.containsKey(47) || iAttnList.containsKey(82) || iAttnList.containsKey(84) || iAttnList.containsKey(85) || iAttnList.containsKey(86) || iAttnList.containsKey(58))) {
            return true;
        }
        if (iInclList != null && iInclList.containsKey(8)) {
            Set<String> includedMacros = iInclList.get(8).keySet();
            return includedMacros.contains("DFHEIENT");
        }
        return false;
    }

    public String getFileTypeCd() {
        if (this.fileTypeCd == null) {
            this.run();
        }
        return this.fileTypeCd;
    }

    private void run() {
        if (this.languageCd.equals("ASM")) {
            this.classifyAsm();
        } else if (this.languageCd.equals("C") || this.languageCd.equals("CPP")) {
            this.fileTypeCd = "INCL";
        } else if (this.languageCd.equals("COB")) {
            this.classifyCobol();
        } else if (this.languageCd.equals("EASY")) {
            this.classifyEasytrieve();
        } else if (this.languageCd.equals("JCL")) {
            this.classifyJcl();
        } else if (this.languageCd.equals("PLI")) {
            this.classifyPli();
        } else if (this.languageCd.equals("PLX")) {
            this.classifyPlx();
        } else if (this.languageCd.equals("REXX")) {
            this.fileTypeCd = "MAIN";
        } else if (this.languageCd.equals("SORT") || this.languageCd.equals("ZBND")) {
            this.fileTypeCd = "";
        } else if (this.languageCd.equals("TEXT")) {
            this.classifyText();
        } else {
            this.fileTypeCd = "UNKN";
        }
    }
}

