/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.utils;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class FileHandler {
    private static final int SZLIBN = 230;
    private static final int SZLIBM = 254;
    private final String containerName;
    private String containerNameNoQuotes;
    private final String fileName;
    private String fileNameNoQuotes;
    private final String localName;
    private String rmDDName;
    private String rmType;

    public FileHandler(String iContainerName, String iFileName, String iLocalName) {
        this.containerName = iContainerName;
        this.containerNameNoQuotes = null;
        this.fileName = iFileName;
        this.fileNameNoQuotes = null;
        this.localName = iLocalName;
        this.rmDDName = "";
        this.rmType = null;
    }

    private String fileSpec(String iContainerName, String iFileName) {
        return String.valueOf(iContainerName) + File.separator + iFileName;
    }

    public String getFileContent(String iPathName, String codePage) {
        if (iPathName == null) {
            return null;
        }
        FileInputStream fis = null;
        String fileContents = null;
        try {
            fis = new FileInputStream(iPathName);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        try {
            fileContents = FileHandler.readInputStream(fis, codePage);
            fis.close();
        }
        catch (IOException e) {
            return null;
        }
        return fileContents;
    }

    public String getFileToOpen() {
        return this.setupFileSpecForOpen();
    }

    public String getRmType() {
        if (this.rmType == null) {
            this.setRmType("");
        }
        return this.rmType;
    }

    public String getNormalizedContainerName() {
        if (this.containerNameNoQuotes == null) {
            this.containerNameNoQuotes = this.normalizeName(this.containerName, 230, true, true);
        }
        return this.containerNameNoQuotes;
    }

    public String getNormalizedFileName() {
        if (this.fileNameNoQuotes == null) {
            this.fileNameNoQuotes = this.normalizeName(this.fileName, 254, true, true);
        }
        return this.fileNameNoQuotes;
    }

    private String normalizeName(String iName, int iMaxNameLength, boolean stripLeadingBlanks, boolean stripTrailingBlanks) {
        int length;
        String workName1 = "";
        String workName2 = "";
        String workName3 = "";
        if (iName.length() == 0) {
            return workName3;
        }
        if (iMaxNameLength > 1024) {
            iMaxNameLength = 1024;
            workName1 = iName.substring(0, iMaxNameLength);
        } else {
            workName1 = iName;
        }
        String pCharStart = workName1;
        if (pCharStart.charAt(0) == '\"') {
            pCharStart = StringUtils.strip(workName1, "\"");
        }
        workName2 = pCharStart;
        if (stripLeadingBlanks) {
            workName3 = workName2;
            length = workName3.length();
            pCharStart = workName3;
            int i = 0;
            while (i < length) {
                if (pCharStart.charAt(0) != ' ') break;
                pCharStart = pCharStart.substring(1);
                ++i;
            }
            workName2 = "";
            workName2 = pCharStart;
            workName3 = "";
        }
        length = workName2.length();
        workName3 = workName2;
        if (stripTrailingBlanks) {
            while (workName3.charAt(length - 1) == ' ') {
                workName3 = workName3.substring(0, length - 1);
                --length;
            }
        }
        return workName3;
    }

    public static String readInputStream(InputStream readStream, String codePage) throws IOException {
        String contents;
        int BUFF_SIZE = 4096;
        ByteArrayOutputStream accumulator = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int currentSize = 0;
        int readSize = readStream.read(buffer, 0, 4096);
        while (readSize >= 0) {
            accumulator.write(buffer, 0, readSize);
            currentSize += readSize;
            readSize = readStream.read(buffer, 0, 4096);
        }
        if (codePage == null) {
            return accumulator.toString();
        }
        try {
            contents = accumulator.toString(codePage);
        }
        catch (UnsupportedEncodingException e) {
            contents = accumulator.toString();
        }
        return contents;
    }

    public void setRmDDName(String iRmDDName) {
        this.rmDDName = this.getRmType().equals("PAN") ? (iRmDDName == null || iRmDDName.length() == 0 ? "PANDD1" : iRmDDName) : "";
    }

    public void setRmType(String iRmType) {
        this.rmType = iRmType == null || iRmType.length() == 0 ? "NTFS" : iRmType;
    }

    private String setupFileSpecForOpen() {
        String localFileNoQuotes = this.normalizeName(this.localName, 230, true, true);
        if (this.localName.length() != 0) {
            return localFileNoQuotes;
        }
        return this.fileSpec(this.getNormalizedContainerName(), this.getNormalizedFileName());
    }
}

