/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.reservedWords.ReservedWordsZBND;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierByRecord;

public class ClassifierZBND
extends ClassifierByRecord {
    private static final int OPERANDS_LENGTH = 8192;
    private static final int OPERATION_LENGTH = 63;
    private static final int SCAN_STATE_Initial = 1;
    private static final int SCAN_STATE_LookingForOperation = 2;
    private static final int SCAN_STATE_ScanningOperation = 3;
    private static final int SCAN_STATE_LookingForOperands = 4;
    private static final int SCAN_STATE_ScanningOperands = 5;
    private static final int SCAN_STATE_ScanningQuotedString = 6;
    private static final int SCAN_STATE_QuoteFoundInString = 7;
    private static final int SCAN_STATE_OperandsComplete = 8;
    private static final String standardCharSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz@$#_0123456789+-,=.*()'/& ";
    private boolean continuationLine;
    private boolean literalContinued;
    private boolean processingComment;
    private int scanState;
    private String operands;
    private String operandsContinued;
    private String operation;

    public ClassifierZBND(ScanProperties scanProperties) {
        super(scanProperties);
        this.initializeInstanceVariables();
    }

    private int calculateSLOC(int lineCount) {
        return lineCount - this.blankLineCount - this.getCommentCount();
    }

    private boolean checkFirstColumn(String inputRecord) {
        if (inputRecord.charAt(0) == '*') {
            this.processingComment = true;
            this.increaseScore(5);
            this.metaData.incrementCommentLines();
            this.continuationLine = ClassifierZBND.checkIfContinuationLine(inputRecord);
            return true;
        }
        if (this.processingComment && this.continuationLine) {
            this.continuationLine = ClassifierZBND.checkIfContinuationLine(inputRecord);
            return true;
        }
        this.processingComment = false;
        if (inputRecord.charAt(0) != ' ') {
            this.rejectThisLanguageCd();
            return true;
        }
        return false;
    }

    private static boolean checkIfContinuationLine(String inputRecord) {
        if (inputRecord.length() < 72) {
            return false;
        }
        return inputRecord.charAt(71) != ' ';
    }

    private boolean checkStandardCharacterSet(char currentChar) {
        return standardCharSet.indexOf(currentChar) != -1;
    }

    private void clearTokenFields() {
        this.operands = "";
        this.operandsContinued = "";
        this.operation = "";
    }

    private void completeAStatement() {
        if (ReservedWordsZBND.contains(this.operation.toUpperCase())) {
            this.increaseScore(100);
        } else {
            this.rejectThisLanguageCd();
        }
    }

    @Override
    public String getLanguageCd() {
        return "ZBND";
    }

    @Override
    public String getLanguageDescription() {
        return "zOS Binder control statements";
    }

    @Override
    public int getLanguageId() {
        return 24;
    }

    private boolean getOperationOperands(String inputRecord) {
        boolean invalidChar = false;
        boolean stopScanningRecord = false;
        this.columnCurrentRecord = 1;
        this.ircaIndex = 0;
        char[] inputRecordCharArray = inputRecord.toCharArray();
        while (this.ircaIndex < inputRecordCharArray.length) {
            char currentChar = inputRecordCharArray[this.ircaIndex];
            switch (this.scanState) {
                case 1: {
                    if (currentChar == ' ') {
                        this.scanState = 2;
                        break;
                    }
                    invalidChar = true;
                    break;
                }
                case 2: {
                    if (this.columnCurrentRecord == 72) {
                        stopScanningRecord = true;
                        break;
                    }
                    if (currentChar == ' ') break;
                    if (this.checkStandardCharacterSet(currentChar)) {
                        this.operation = String.valueOf(this.operation) + currentChar;
                        this.scanState = 3;
                        break;
                    }
                    invalidChar = true;
                    break;
                }
                case 3: {
                    if (currentChar == ' ' || this.operation.length() >= 63) {
                        this.scanState = 4;
                        break;
                    }
                    if (this.checkStandardCharacterSet(currentChar)) {
                        this.operation = String.valueOf(this.operation) + currentChar;
                        break;
                    }
                    invalidChar = true;
                    break;
                }
                case 4: {
                    if (this.columnCurrentRecord == 72) {
                        stopScanningRecord = true;
                        break;
                    }
                    if (currentChar == ' ') break;
                    if (this.operandsContinued.length() != 0) {
                        this.operandsContinued = String.valueOf(this.operandsContinued) + currentChar;
                    } else {
                        this.operands = String.valueOf(this.operands) + currentChar;
                    }
                    if (currentChar == '\'' || this.literalContinued) {
                        this.scanState = 6;
                        break;
                    }
                    this.scanState = 5;
                    break;
                }
                case 5: {
                    if (this.operands.length() >= 8192) {
                        stopScanningRecord = true;
                        break;
                    }
                    if (currentChar == ' ') {
                        this.scanState = 8;
                        stopScanningRecord = true;
                        break;
                    }
                    String prevOperand = this.operands;
                    this.operands = String.valueOf(this.operands) + currentChar;
                    if (this.columnCurrentRecord == 71) {
                        stopScanningRecord = true;
                        break;
                    }
                    if (currentChar != '\'' || prevOperand.endsWith("L")) break;
                    this.scanState = 6;
                    break;
                }
                case 6: {
                    this.literalContinued = false;
                    if (this.operands.length() >= 8192) {
                        stopScanningRecord = true;
                        break;
                    }
                    if (this.columnCurrentRecord == 72) {
                        this.literalContinued = true;
                        stopScanningRecord = true;
                        break;
                    }
                    this.operands = String.valueOf(this.operands) + currentChar;
                    if (currentChar != '\'') break;
                    this.scanState = 7;
                    break;
                }
                case 7: {
                    if (currentChar == ' ' || this.operands.length() >= 8192) {
                        this.scanState = 8;
                        stopScanningRecord = true;
                        break;
                    }
                    this.operands = String.valueOf(this.operands) + currentChar;
                    if (currentChar == '\'') {
                        this.scanState = 6;
                        break;
                    }
                    this.scanState = 5;
                    break;
                }
                case 8: {
                    stopScanningRecord = true;
                    break;
                }
            }
            if (invalidChar || stopScanningRecord) break;
            this.moveToNextCharOnRecord();
        }
        return !invalidChar;
    }

    private void initializeInstanceVariables() {
        this.continuationLine = false;
        this.literalContinued = false;
        this.processingComment = false;
        this.scanState = 1;
        this.clearTokenFields();
    }

    @Override
    public void isScoreBad(int lineCount, String languageHint) {
        if (lineCount == this.getCommentCount()) {
            this.score = 0;
        }
    }

    @Override
    public ClassifierMetaData processEndOfFile(int lineCount) {
        this.metaData.setBlanklines(this.blankLineCount);
        this.metaData.setNonCommentLines(this.calculateSLOC(lineCount));
        this.metaData.setTotalLines(lineCount);
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        this.initializeInstanceVariables();
        this.identifierMode = (char)85;
        this.metaData = new ClassifierMetaData();
    }

    @Override
    public void processOneRecord(int recordCount, String literalRecord, String inputRecord, String languageHint) {
        if (this.checkFirstColumn(inputRecord)) {
            return;
        }
        if (this.continuationLine) {
            this.continuationLine = ClassifierZBND.checkIfContinuationLine(inputRecord);
            if (this.scanState != 8) {
                this.scanState = 4;
            }
        } else {
            this.continuationLine = ClassifierZBND.checkIfContinuationLine(inputRecord);
            this.clearTokenFields();
            this.scanState = 1;
        }
        if (!this.getOperationOperands(inputRecord)) {
            return;
        }
        if (this.continuationLine) {
            return;
        }
        this.completeAStatement();
    }
}

