/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierByString;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.IClassifierByString;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ClassifierXML
extends ClassifierByString
implements IClassifierByString {
    private static Pattern docTypePattern = Pattern.compile("\\<\\!DOCTYPE[^\\>]*\\>");

    public ClassifierXML(ScanProperties scanProperties) {
        super(scanProperties);
    }

    @Override
    public String getLanguageCd() {
        return "XML";
    }

    @Override
    public boolean checkString(String iFileContent) {
        block4: {
            if (iFileContent != null && iFileContent.startsWith("<")) break block4;
            return false;
        }
        try {
            Matcher m = docTypePattern.matcher(iFileContent);
            iFileContent = m.replaceFirst("");
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            SAXHandler handler = new SAXHandler();
            StringReader reader = new StringReader(iFileContent);
            InputSource inputSource = new InputSource(reader);
            saxParser.parse(inputSource, (DefaultHandler)handler);
            return handler.isValid;
        }
        catch (SAXException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    private static class SAXHandler
    extends DefaultHandler {
        boolean isValid = true;

        private SAXHandler() {
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.isValid = false;
        }
    }
}

