/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierReservedWord;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.reservedWords.ReservedWordsSORT;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierASM;

public class ClassifierSORT
extends ClassifierASM {
    int countOfVerbs = 0;

    public ClassifierSORT(ScanProperties scanProperties) {
        super(scanProperties);
    }

    @Override
    public String getLanguageCd() {
        return "SORT";
    }

    @Override
    public String getLanguageDescription() {
        return "Sort control";
    }

    @Override
    public int getLanguageId() {
        return 19;
    }

    @Override
    public void isScoreBad(int lineCount, String languageHint) {
        if (this.countOfVerbs == 0) {
            this.score = 0;
        }
    }

    @Override
    public ClassifierMetaData processEndOfFile(int lineCount) {
        this.metaData.clearInclList();
        this.metaData.setTotalLines(lineCount);
        this.metaData.setBlanklines(this.blankLineCount);
        this.metaData.setNonCommentLines(lineCount - this.blankLineCount - this.getCommentCount());
        return this.metaData;
    }

    @Override
    public void processOneRecord(int recordCount, String literalRecord, String record, String languageHint) {
        super.processOneRecord(recordCount, literalRecord, record, languageHint);
        String name = this.parserAsmStatement.getName();
        if (name.length() != 0) {
            this.rejectThisLanguageCd();
            return;
        }
        String operation = this.parserAsmStatement.getOperation();
        String value = ReservedWordsSORT.get(operation);
        if (value == null) {
            this.rejectThisLanguageCd();
            return;
        }
        ClassifierReservedWord rw = this.allocateReserveWord(operation, value);
        int tokenWordType = rw.getTokenWordType();
        switch (tokenWordType) {
            case 3: {
                ++this.countOfVerbs;
                this.score += 1000;
                break;
            }
            default: {
                this.score += 100;
            }
        }
    }
}

