/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.reservedWords.ReservedWordsREXX;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierByRecord;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassifierREXX
extends ClassifierByRecord {
    private static Pattern inclPattern = Pattern.compile("\\/\\*%INCLUDE\\s*([a-zA-Z0-9\\$@%]{1,8})\\s*\\*\\/", 2);
    private static Pattern inclDDPattern = Pattern.compile("\\/\\*%INCLUDE\\s*([a-zA-Z0-9\\$@%]{1,8})\\(([a-zA-Z0-9\\$@%]{1,8})\\)\\s*\\*\\/", 2);
    private static final String APOSTROPHE = "'";
    private static final String QUOTE = "\"";
    private static final int TOKEN_STATE_BLANK = 1;
    private static final int TOKEN_STATE_EMBEDDED_QUOTE = 2;
    private static final int TOKEN_STATE_HEX_LITERAL = 3;
    private static final int TOKEN_STATE_INITIAL = 4;
    private static final int TOKEN_STATE_LITERAL = 5;
    private static final int TOKEN_STATE_NORMAL = 6;
    private static final String BRACKET_CHARS = "{[()]}";
    private static final String COLON = ":";
    private static final String COMMENT_END = "*/";
    private static final String COMMENT_START = "/*";
    private static final String OPERATOR_CHARS = "-+*/<>!~%^&|=";
    private static final String SEMI_COLON = ";";
    private static final String SEQUENCE_CHARS = ",";
    private int tokenState = 4;
    private String currentChar = "";
    private String inComment = null;

    public ClassifierREXX(ScanProperties scanProperties) {
        super(scanProperties);
    }

    protected void AccumulatePointsForTheScore() {
        if (this.EXEC_CICS_flag || this.EXEC_SQL_flag) {
            return;
        }
        this.score += 60;
        ++this.reserveWordCount;
    }

    private void addToCurrentToken() {
        this.currentToken = String.valueOf(this.currentToken) + this.currentChar;
    }

    private int calculateSLOC(int lineCount) {
        return lineCount - this.blankLineCount - this.getCommentCount();
    }

    private void checkForIncludes(String line) {
        Matcher inclMatcher = inclPattern.matcher(line);
        while (inclMatcher.find()) {
            String result = inclMatcher.group(1);
            if (this.debug != 0) {
                System.out.println("include found : " + result);
            }
            if (result == null) continue;
            this.metaData.captureInclude(3, result);
            this.score += 250;
        }
        Matcher inclDDMatcher = inclDDPattern.matcher(line);
        while (inclDDMatcher.find()) {
            String ddName = inclDDMatcher.group(1);
            String ddMember = inclDDMatcher.group(2);
            if (ddName == null || ddMember == null) continue;
            this.metaData.captureInclude(ddMember, ddName, this.debug);
            this.score += 250;
        }
    }

    private boolean checkIfReservedWord() {
        return ReservedWordsREXX.contains(this.currentToken);
    }

    private void CompleteToken(int recordCount) {
        this.tokenNumberOnLine = (short)(this.tokenNumberOnLine + 1);
        this.debugReportCompletedToken(recordCount, this.tokenNumberOnLine, this.currentToken);
        this.scoreCompletedToken();
        this.previousToken = this.currentToken;
        this.currentToken = "";
        this.tokenState = 4;
    }

    @Override
    public String getLanguageCd() {
        return "REXX";
    }

    @Override
    public String getLanguageDescription() {
        return "REXX";
    }

    @Override
    public int getLanguageId() {
        return 18;
    }

    @Override
    public boolean getIgnoreCase() {
        return false;
    }

    @Override
    public void isScoreBad(int lineCount, String languageHint) {
        if (this.identifierMode == 'R') {
            this.score = 0;
        }
    }

    private void parseSpecificStatements() {
        this.processState_normalToken();
    }

    @Override
    public ClassifierMetaData processEndOfFile(int lineCount) {
        this.metaData.setBlanklines(this.blankLineCount);
        this.metaData.setNonCommentLines(this.calculateSLOC(lineCount));
        this.metaData.setTotalLines(lineCount);
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        this.identifierMode = (char)85;
        this.metaData = new ClassifierMetaData(this.scanProperties.getCaptureComments(), this.scanProperties.getCaptureEntryPoints(), this.scanProperties.getCaptureExecStatements(), this.scanProperties.getCaptureLiterals(), this.scanProperties.getCapturePictures(), this.scanProperties.getCaptureSymbolsReserved(), this.scanProperties.getCaptureSymbolsUserDefined());
    }

    private void processNonReservedWord() {
        this.metaData.addSymbolUserDefined(this.currentToken);
    }

    private void processReservedWord() {
        this.metaData.addSymbolReserved(this.currentToken);
        this.AccumulatePointsForTheScore();
    }

    private void processState_normalToken() {
    }

    @Override
    public void processOneRecord(int recordCount, String literalRecord, String record, String languageHint) {
        String stringDelimiter = null;
        boolean newLine = true;
        this.tokenNumberOnLine = 0;
        record = record.trim();
        while (record.length() != 0) {
            this.currentChar = record.substring(0, 1);
            if (this.inComment != null) {
                if (this.inComment.equals(COMMENT_START)) {
                    if (record.startsWith(COMMENT_END)) {
                        record = record.substring(COMMENT_END.length());
                        this.inComment = COMMENT_END;
                        continue;
                    }
                    record = record.substring(1);
                    continue;
                }
                if (!this.inComment.equals(COMMENT_END)) {
                    record = record.substring(1);
                    continue;
                }
            } else if (record.startsWith(COMMENT_START)) {
                this.inComment = COMMENT_START;
                record = record.substring(COMMENT_START.length());
                continue;
            }
            boolean isDelimiter = BRACKET_CHARS.contains(this.currentChar) || COLON.contains(this.currentChar) || OPERATOR_CHARS.contains(this.currentChar) || SEMI_COLON.contains(this.currentChar) || SEQUENCE_CHARS.contains(this.currentChar);
            boolean tokenComplete = false;
            switch (this.tokenState) {
                case 1: {
                    if (!newLine && this.currentChar.equals(" ")) break;
                    tokenComplete = true;
                    break;
                }
                case 6: {
                    if (newLine) {
                        tokenComplete = true;
                        break;
                    }
                    if (this.currentChar.equals(" ")) {
                        this.tokenState = 1;
                        break;
                    }
                    if (isDelimiter) {
                        tokenComplete = true;
                        break;
                    }
                    this.addToCurrentToken();
                    break;
                }
                case 2: {
                    if (this.currentChar.equals(stringDelimiter)) {
                        this.tokenState = 5;
                        break;
                    }
                    tokenComplete = true;
                    break;
                }
                case 5: {
                    if (this.currentChar.equals(stringDelimiter)) {
                        this.tokenState = 2;
                    }
                    this.addToCurrentToken();
                    break;
                }
                case 4: {
                    if (this.currentChar.equals("X")) {
                        this.currentToken = String.valueOf(this.currentToken) + record.substring(0, 1);
                        this.tokenState = 3;
                        break;
                    }
                    if (this.currentChar.equals(APOSTROPHE) || this.currentChar.equals(QUOTE)) {
                        stringDelimiter = this.currentChar;
                        this.addToCurrentToken();
                        this.tokenState = 5;
                        break;
                    }
                    if (this.currentChar.equals(" ")) break;
                    this.addToCurrentToken();
                    if (isDelimiter) {
                        record = record.substring(1);
                        tokenComplete = true;
                        break;
                    }
                    this.tokenState = 6;
                    break;
                }
                case 3: {
                    if (this.currentChar.equals(" ")) {
                        this.tokenState = 1;
                        break;
                    }
                    if (this.currentChar.equals(APOSTROPHE) || this.currentChar.equals(QUOTE)) {
                        stringDelimiter = this.currentChar;
                        this.addToCurrentToken();
                        this.tokenState = 5;
                        break;
                    }
                    if (isDelimiter) {
                        tokenComplete = true;
                        break;
                    }
                    this.addToCurrentToken();
                    this.tokenState = 6;
                    break;
                }
            }
            if (tokenComplete || this.currentToken.length() >= 255) {
                this.CompleteToken(recordCount);
                if (this.identifierMode == 'R') {
                    break;
                }
            } else {
                if (record.length() == 0) break;
                record = record.substring(1);
            }
            newLine = false;
        }
        if (this.identifierMode == 'R') {
            return;
        }
        if (this.inComment != null) {
            if (this.tokenNumberOnLine == 0 && (this.tokenState == 2 || this.tokenState == 3 || this.tokenState == 4 || this.tokenState == 5)) {
                this.metaData.incrementCommentLines();
                this.score += 5;
                if (recordCount == 1) {
                    String recordTrimmed = literalRecord.trim();
                    recordTrimmed = recordTrimmed.substring(2);
                    recordTrimmed = recordTrimmed.trim();
                    if ((recordTrimmed = recordTrimmed.toUpperCase()).indexOf("REXX") > -1) {
                        this.identifierMode = (char)67;
                        this.score += 1000;
                    } else {
                        this.identifierMode = (char)82;
                        return;
                    }
                }
                String literalRecordTrimmed = literalRecord.trim();
                this.metaData.addComment(literalRecordTrimmed);
                this.checkForIncludes(literalRecordTrimmed);
            }
            if (this.inComment == COMMENT_END) {
                this.inComment = null;
            }
        }
        if (recordCount == 1 && this.identifierMode == 'U') {
            this.identifierMode = (char)82;
        } else if (this.tokenState != 4) {
            this.CompleteToken(recordCount);
        }
    }

    private void scoreCompletedToken() {
        if (this.currentToken.startsWith(APOSTROPHE) || this.currentToken.startsWith(QUOTE)) {
            this.metaData.addLiteral(this.currentToken);
        } else if (this.currentToken.contains(BRACKET_CHARS) || this.currentToken.contains(COLON) || this.currentToken.contains(OPERATOR_CHARS) || this.currentToken.contains(SEMI_COLON)) {
            this.metaData.addSymbolReserved(this.currentToken);
        } else if (StringUtils.isNumeric(this.currentToken)) {
            this.metaData.addLiteral(this.currentToken);
        } else if (this.checkIfReservedWord()) {
            this.processReservedWord();
        } else {
            this.processNonReservedWord();
        }
        this.parseSpecificStatements();
    }
}

