/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierReservedWord;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.reservedWords.ReservedWordsPLI;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierASM;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierByRecordCobPliPlx;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierC;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierCOB;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierCPP;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierEASY;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierJCL;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierPLX;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;
import java.util.List;

public class ClassifierPLI
extends ClassifierByRecordCobPliPlx {
    protected static final int ANSWER_NO = 0;
    protected static final int ANSWER_MAYBE = 1;
    protected static final int ANSWER_YES = 2;
    protected static final int MARGIN_VALUE_1_DEFAULT = 2;
    protected static final int MARGIN_VALUE_2_DEFAULT = 72;
    protected static final char TOKEN_STATE_IN_COMMENT = 'M';
    protected static final char TOKEN_STATE_IN_CONTINUE = 'C';
    protected static final char TOKEN_STATE_IN_EMBEDDED_QUOTE = 'E';
    protected static final char TOKEN_STATE_IN_HEX_LITERAL = 'X';
    protected static final char TOKEN_STATE_IN_LITERAL = 'Q';
    protected static final char TOKEN_STATE_ON_BLANK = 'B';
    protected static final char TOKEN_STATE_START = 'S';
    protected boolean foundAtLeastOne_DECLARE = false;
    protected boolean foundAtLeastOne_INCLUDE = false;
    protected boolean P_NewLine = false;
    protected boolean semicolonFound = false;
    protected char P_StringDelimiter = (char)32;
    protected char P_TokenState = (char)83;
    protected int dataDeclarationCount = 0;
    protected int lastTokenWeight = 0;
    protected int marginsValue1 = 2;
    protected int marginsValue2 = 72;
    protected int procedureIsSubroutineCount = 0;
    protected int sequentialCommentLines = 0;
    protected String ddName = "";
    private Boolean declareFoundFirst = null;
    private boolean inMacroDefinition = false;
    private boolean possibleHyphenFound = false;
    private int blankCount_PLI = 0;
    private int procedureIsFunctionCount = 0;
    private int reserveWordCount_COBOL = 0;
    private int reserveWordCount_C = 0;
    private int reserveWordCount_SQL = 0;
    private String firstTokenOfStmt = null;

    public ClassifierPLI(ScanProperties scanProperties) {
        super(scanProperties);
    }

    protected void AccumulatePointsForTheScore(ClassifierReservedWord iRw, char[] inputRecordCharArray) {
        if (this.EXEC_CICS_flag || this.EXEC_SQL_flag) {
            return;
        }
        int tokenWordType = iRw.getTokenWordType();
        int tokenWeight = iRw.getTokenWeight();
        switch (tokenWordType) {
            case 0: {
                if (this.currentToken.equalsIgnoreCase("%END") && this.inMacroDefinition) {
                    this.inMacroDefinition = false;
                }
                this.incrementReservedWordCount(1);
                break;
            }
            case 1: {
                if (this.ircaIndex < inputRecordCharArray.length && inputRecordCharArray[this.ircaIndex] == '-' || this.possibleHyphenFound || inputRecordCharArray[0] == '*' || inputRecordCharArray[0] == '&') break;
                if (this.currentToken.equalsIgnoreCase("BIN") || this.currentToken.equalsIgnoreCase("BINARY") || this.currentToken.equalsIgnoreCase("BIT") || this.currentToken.equalsIgnoreCase("CHAR") || this.currentToken.equalsIgnoreCase("CHARACTER") || this.currentToken.equalsIgnoreCase("DEC") || this.currentToken.equalsIgnoreCase("DECIMAL") || this.currentToken.equalsIgnoreCase("POINTER")) {
                    ++this.dataDeclarationCount;
                }
                if (this.currentToken.equalsIgnoreCase("CHAR")) {
                    if (this.ircaIndex < inputRecordCharArray.length && inputRecordCharArray[this.ircaIndex] != '(') {
                        ++this.reserveWordCount_C;
                    }
                } else if (this.currentToken.equalsIgnoreCase("COPY") || this.currentToken.equalsIgnoreCase("PIC") || this.currentToken.equalsIgnoreCase("PICTURE") || this.currentToken.equalsIgnoreCase("VALUE")) {
                    ++this.reserveWordCount_COBOL;
                    if (this.currentToken.equalsIgnoreCase("PIC") || this.currentToken.equalsIgnoreCase("PICTURE") && (this.declareFoundFirst == null || !this.declareFoundFirst.booleanValue())) {
                        --tokenWeight;
                    }
                } else if (this.currentToken.equalsIgnoreCase("DCL") || this.currentToken.equalsIgnoreCase("DECLARE")) {
                    if (!this.inMacroDefinition) {
                        this.checkDeclareFoundFirst(Boolean.TRUE);
                    }
                    if (this.tokenNumberOnLine == 1) {
                        this.foundAtLeastOne_DECLARE = true;
                    }
                    this.lastTokenWeight = tokenWeight;
                } else if (this.currentToken.equalsIgnoreCase("ENV") || this.currentToken.equalsIgnoreCase("RETCODE")) {
                    this.lastTokenWeight = tokenWeight;
                } else if (this.currentToken.equalsIgnoreCase("INT")) {
                    ++this.reserveWordCount_C;
                } else if (this.currentToken.equalsIgnoreCase("FROM") || this.currentToken.equalsIgnoreCase("SELECT")) {
                    ++this.reserveWordCount_SQL;
                }
                this.incrementReservedWordCount(tokenWeight);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.ircaIndex + 1 == inputRecordCharArray.length) {
                    this.incrementReservedWordCount(tokenWeight);
                    break;
                }
                if (!(!this.currentToken.equalsIgnoreCase("EXIT") && !this.currentToken.equalsIgnoreCase("PROC") || (this.ircaIndex >= inputRecordCharArray.length || inputRecordCharArray[this.ircaIndex] != '.' && inputRecordCharArray[this.ircaIndex] != '-') && !this.possibleHyphenFound)) break;
                this.incrementReservedWordCount(tokenWeight);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.incrementReservedWordCount(tokenWeight);
                break;
            }
        }
    }

    private int calculateSLOC(int lineCount) {
        return lineCount - (this.blankLineCount + this.blankCount_PLI) - this.getCommentCount();
    }

    private void checkDeclareFoundFirst(Boolean foundDeclare) {
        if (this.declareFoundFirst == null) {
            this.declareFoundFirst = foundDeclare;
        }
    }

    private void checkForReservedWord(char[] inputRecordCharArray) {
        String keyUC = this.previousToken.equals("%") && !this.currentToken.startsWith("%") ? String.valueOf(this.previousToken) + this.currentToken : this.currentToken;
        keyUC = keyUC.toUpperCase();
        ClassifierReservedWord rw = null;
        if (ReservedWordsPLI.containsKey(keyUC)) {
            String value = ReservedWordsPLI.get(keyUC);
            rw = this.allocateReserveWord(keyUC, value);
        }
        if (rw == null) {
            this.processNonReservedWord();
        } else {
            this.processReservedWord(rw, inputRecordCharArray);
        }
        this.possibleHyphenFound = false;
    }

    private void checkForSemicolon() {
        if (!this.semicolonFound) {
            this.score = 0;
            if (this.debug == 2) {
                System.out.println("*** PLI score set to 0 because no semicolons were found.");
            }
        }
    }

    private boolean checkPercentInclude() {
        if (this.currentToken.equalsIgnoreCase("%INCLUDE") || this.previousToken.equals("%") && this.currentToken.equalsIgnoreCase("INCLUDE")) {
            this.score += 25;
            this.ddName = "";
            this.foundAtLeastOne_INCLUDE = true;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean checkPlusPlusInclude(String inputRecord) {
        block7: {
            block6: {
                if (inputRecord.length() < 18) {
                    return false;
                }
                if (this.scanProperties.getAllowIncludeInAnyColumn()) break block6;
                if (!this.scanProperties.getExpandIncludeInComment()) {
                    s = inputRecord.substring(this.marginsValue1 - 1);
                    if ((s = s.trim()).length() == 0) {
                        return false;
                    }
                    if (s.startsWith("/*") || this.P_TokenState == 'M') {
                        return false;
                    }
                }
                s = inputRecord.substring(7);
                break block7;
            }
            s = inputRecord.substring(this.marginsValue1 - 1);
            if ((s = s.trim()).length() == 0) {
                return false;
            }
            if (!s.startsWith("/*") && this.P_TokenState != 'M' || this.scanProperties.getExpandIncludeInComment()) ** GOTO lbl20
            return false;
            while (!s.startsWith("++")) {
                s = s.substring(1);
lbl20:
                // 2 sources

                if (s.length() > 17) continue;
            }
        }
        return this.capturePlusPlusIncludeName(s, this.scanProperties.getTruncateFilenames());
    }

    private void checkSymanticState() {
        switch (this.syntaxState) {
            case 3: {
                this.processState_call();
                break;
            }
            case 4: {
                this.processState_mapOrMapset();
                break;
            }
            case 7: {
                this.processState_exec();
                break;
            }
            case 8: {
                this.processState_execCics();
                break;
            }
            case 9: {
                this.processState_execCicsReceiveOrSend();
                break;
            }
            case 10: {
                this.processState_execSql();
                break;
            }
            case 12: {
                this.processState_execSqlStmt();
                break;
            }
            case 11: {
                this.processState_execSqlClauseFrom();
                break;
            }
            case 13: {
                this.processState_execSqlStmtInclude();
                break;
            }
            case 15: {
                this.processState_execCicsLinkOrXctl();
                break;
            }
            case 17: {
                this.processState_pliInclude();
                break;
            }
            case 18: {
                this.processState_pliProc();
                break;
            }
            case 19: {
                this.processState_program();
                break;
            }
            default: {
                this.processState_normalToken();
            }
        }
    }

    @Override
    public String getLanguageCd() {
        return "PLI";
    }

    @Override
    public String getLanguageDescription() {
        return "PL/I";
    }

    @Override
    public int getLanguageId() {
        return 16;
    }

    private boolean hasProcedureFunctions() {
        return this.procedureIsFunctionCount != 0;
    }

    private boolean hasProcedureSubroutines() {
        return this.procedureIsSubroutineCount != 0;
    }

    @Override
    public boolean getIgnoreCase() {
        return false;
    }

    protected void incrementReservedWordCount(int scoreAdjustment) {
        ++this.reserveWordCount;
        this.increaseScore(scoreAdjustment);
    }

    private void isItReallyPLX(int lineCount, ClassifierPLX classifierPLX) {
        if (classifierPLX.getScore() == 0) {
            return;
        }
        if (classifierPLX.usesBexProductMacros()) {
            this.score = 0;
            if (this.debug == 2) {
                System.out.println("*** PLI score set to 0 because file uses Bex product macros.");
            }
        } else {
            int plxCommentCount = classifierPLX.getPlxCommentCount();
            int percentPlxComment = plxCommentCount / lineCount * 100;
            if (percentPlxComment > 5) {
                this.score = 0;
                if (this.debug == 2) {
                    System.out.println("*** PLI score set to 0 because % of PL/X comment was > 5.  It was: " + percentPlxComment);
                }
            }
        }
    }

    @Override
    public void isScoreBad(int lineCount, String languageHint) {
        switch (this.reserveWordCount) {
            case 0: {
                this.score = 0;
                if (this.debug != 2) break;
                System.out.println("*** PLI score set to 0 because no reserved words were found.");
                break;
            }
            case 1: {
                int SLOC = this.calculateSLOC(lineCount);
                if ((double)this.reserveWordCount < (double)SLOC * 0.25) {
                    this.score = 0;
                    if (this.debug != 2) break;
                    System.out.println("*** PLI score set to 0 because the reserved word count is < SLOC * .25.  Reserved word count: " + this.reserveWordCount + " SLOC: " + SLOC);
                    break;
                }
                this.checkForSemicolon();
                break;
            }
            default: {
                this.isScoreBadWithMoreThanOneReservedWord(lineCount);
            }
        }
    }

    private void isScoreBadWithMoreThanOneReservedWord(int lineCount) {
        int reserveWordDiff;
        if (!(this.foundAtLeastOne_DECLARE || this.foundAtLeastOne_INCLUDE || this.hasProcedureFunctions() || this.hasProcedureSubroutines())) {
            int SLOC = this.calculateSLOC(lineCount);
            if ((double)this.dataDeclarationCount > (double)SLOC * 0.8) {
                return;
            }
            if ((double)this.reserveWordCount > (double)SLOC * 1.3 || (double)this.reserveWordCount < (double)SLOC * 0.5) {
                this.score = 0;
                if (this.debug == 2) {
                    System.out.println("*** PLI score set to 0 because too many or too few reserved words relative to SLOC.  Reserved word count: " + this.reserveWordCount + " SLOC: " + SLOC);
                }
                return;
            }
            if ((double)this.score < (double)lineCount * 0.05) {
                this.score = 0;
                if (this.debug == 2) {
                    System.out.println("*** PLI score set to 0 because not 1 line in 20 were from PLI.  Score: " + this.score + " lineCount: " + lineCount);
                }
                return;
            }
        }
        if ((double)(reserveWordDiff = this.reserveWordCount - this.reserveWordCount_C) < (double)this.reserveWordCount * 0.05) {
            this.score = 0;
            if (this.debug == 2) {
                System.out.println("*** PLI score set to 0 because not enough PLI.  ReservedWordCount: " + this.reserveWordCount + " ReservedWordCount_C: " + this.reserveWordCount_C);
            }
            return;
        }
        reserveWordDiff = this.reserveWordCount - this.reserveWordCount_COBOL;
        if ((double)reserveWordDiff < (double)this.reserveWordCount * 0.05) {
            this.score = 0;
            if (this.debug == 2) {
                System.out.println("*** PLI score set to 0 because not enough PLI.  ReservedWordCount: " + this.reserveWordCount + " ReservedWordCount_COBOL: " + this.reserveWordCount_COBOL);
            }
            return;
        }
        reserveWordDiff = this.reserveWordCount - this.reserveWordCount_SQL;
        if ((double)reserveWordDiff < (double)this.reserveWordCount * 0.05) {
            this.score = 0;
            if (this.debug == 2) {
                System.out.println("*** PLI score set to 0 because not enough PLI.  ReservedWordCount: " + this.reserveWordCount + " ReservedWordCount_SQL: " + this.reserveWordCount_SQL);
            }
        }
    }

    @Override
    public void isScoreStillBad(int lineCount, ClassifierASM classifierASM, ClassifierC classifierC, ClassifierCOB classifierCOB, ClassifierCPP classifierCPP, ClassifierEASY classifierEASY, ClassifierJCL classifierJCL, ClassifierPLI classifierPLI, ClassifierPLX classifierPLX) {
        if (this.reserveWordCount >= this.calculateSLOC(lineCount) / 2) {
            int asmScore = classifierASM.getScore();
            int cblScore = classifierCOB.getScore();
            int easyScore = classifierEASY.getScore();
            int jclScore = classifierJCL.getScore();
            if (asmScore != 0 && classifierASM.getReserveWordCount() != 0) {
                if (this.score / 3 < asmScore) {
                    this.checkForSemicolon();
                }
            } else if (cblScore != 0 && (classifierCOB.getVerbCount() != 0 || classifierCOB.getPictureCount() != 0 || classifierCOB.getCompilerDirectingCount() != 0)) {
                if (this.score / 3 < cblScore) {
                    this.checkForSemicolon();
                }
            } else if (!(easyScore == 0 || classifierEASY.getReserveWordCount() == 0 && classifierEASY.getEasyMajorKeyWordFound())) {
                if (this.score / 3 < easyScore) {
                    this.checkForSemicolon();
                }
            } else if (jclScore != 0 && classifierJCL.getReserveWordCount() != 0 && this.score / 3 < jclScore) {
                this.checkForSemicolon();
            }
        }
        if (this.score != 0) {
            this.isItReallyPLX(lineCount, classifierPLX);
        }
    }

    private boolean isCharADelimiter(char iChar) {
        return iChar == ' ' || iChar == '&' || iChar == '\'' || iChar == ':' || iChar == ',' || iChar == '=' || iChar == '/' || iChar == '>' || iChar == '(' || iChar == '<' || iChar == '-' || iChar == '.' || iChar == '+' || iChar == ')' || iChar == ';';
    }

    protected void TokenComplete(char[] inputRecordCharArray) {
        this.P_TokenState = (char)83;
        if (this.currentToken.length() == 0) {
            return;
        }
        this.tokenNumberOnLine = (short)(this.tokenNumberOnLine + 1);
        if (this.firstTokenOfStmt == null) {
            this.firstTokenOfStmt = this.currentToken;
        }
        if (this.previousToken.equalsIgnoreCase("ENV") && !this.currentToken.equals("(")) {
            this.score -= this.lastTokenWeight;
        }
        if (this.currentToken.equals(";")) {
            this.score += 2;
            this.semicolonFound = true;
            if (this.syntaxState == 17 && this.ddName.length() != 0) {
                this.metaData.captureInclude(3, this.ddName.toUpperCase());
            }
            this.EXEC_CICS_flag = false;
            this.EXEC_SQL_flag = false;
            this.syntaxState = 16;
        } else if (this.currentToken.equals("(")) {
            if (this.previousToken.equalsIgnoreCase("DCL")) {
                this.score -= this.lastTokenWeight;
            }
            this.checkSymanticState();
        } else if (this.currentToken.equals(")")) {
            this.checkSymanticState();
        } else if (this.currentToken.length() == 1) {
            if (this.currentToken.equals("&") || this.currentToken.equals("'") || this.currentToken.equals("*") || this.currentToken.equals(":") || this.currentToken.equals(",") || this.currentToken.equals("=") || this.currentToken.equals("/") || this.currentToken.equals(">") || this.currentToken.equals("<") || this.currentToken.equals("+") || this.currentToken.equals(".")) {
                this.possibleHyphenFound = false;
            } else if (this.currentToken.equals("-")) {
                this.possibleHyphenFound = true;
            } else {
                this.checkForReservedWord(inputRecordCharArray);
                this.checkSymanticState();
            }
        } else {
            this.checkForReservedWord(inputRecordCharArray);
            this.checkSymanticState();
        }
        if (this.P_NewLine) {
            this.tokenNumberOnLine = 0;
        }
        this.resetToken();
    }

    private void processNonReservedWord() {
        if (this.currentToken.startsWith("\"") || this.currentToken.startsWith("'")) {
            this.metaData.addLiteral(this.currentToken);
        } else if (!(this.currentToken.equals("^") || this.EXEC_SQL_flag && this.currentToken.equalsIgnoreCase("NOT") || this.currentToken.equalsIgnoreCase("SMALLINT") || this.currentToken.equalsIgnoreCase("TABLE"))) {
            if (StringUtils.isNumeric(this.currentToken)) {
                this.metaData.addLiteral(this.currentToken);
            } else {
                this.metaData.addSymbolUserDefined(this.currentToken);
            }
        }
    }

    private void processReservedWord(ClassifierReservedWord rw, char[] inputRecordCharArray) {
        this.metaData.addSymbolReserved(rw.getToken());
        this.AccumulatePointsForTheScore(rw, inputRecordCharArray);
    }

    protected void resetToken() {
        if (this.currentToken.equals(";")) {
            this.firstTokenOfStmt = null;
        }
        this.previousPreviousToken = this.previousToken;
        this.previousToken = this.currentToken;
        this.currentToken = "";
    }

    private void processState_call() {
        if (this.currentToken.equalsIgnoreCase("AIBTDLI")) {
            this.metaData.incrementNumValue(43);
        } else if (this.currentToken.equalsIgnoreCase("ASMTDLI")) {
            this.metaData.incrementNumValue(42);
        } else if (this.currentToken.equalsIgnoreCase("PLITDLI")) {
            this.metaData.incrementNumValue(41);
            if (this.identifierMode == 'U') {
                this.identifierMode = (char)67;
            }
        }
        this.syntaxState = 16;
    }

    private void processState_normalToken() {
        if (this.checkPercentInclude()) {
            this.syntaxState = 17;
        } else if (this.currentToken.equalsIgnoreCase("CALL")) {
            this.syntaxState = 3;
        } else if (this.currentToken.equalsIgnoreCase("END-EXEC")) {
            this.EXEC_CICS_flag = false;
            this.EXEC_SQL_flag = false;
        } else if (this.currentToken.equalsIgnoreCase("EXEC") || this.currentToken.equalsIgnoreCase("EXECUTE")) {
            this.syntaxState = 7;
        } else if (this.currentToken.equalsIgnoreCase("%XINCLUDE") || this.previousToken.equals("%") && this.currentToken.equalsIgnoreCase("XINCLUDE")) {
            if (this.identifierMode == 'U') {
                this.identifierMode = (char)67;
            }
            this.score += 25;
            this.ddName = "";
            this.foundAtLeastOne_INCLUDE = true;
            this.syntaxState = 17;
        } else if (this.currentToken.equalsIgnoreCase("PACKAGE")) {
            this.checkDeclareFoundFirst(Boolean.FALSE);
        } else if (this.currentToken.equalsIgnoreCase("PROC") || this.currentToken.equalsIgnoreCase("PROCEDURE")) {
            List<String> entryPoints;
            if (this.firstTokenOfStmt.startsWith("%")) {
                this.inMacroDefinition = true;
                return;
            }
            if (!this.previousToken.equals(":")) {
                return;
            }
            this.checkDeclareFoundFirst(Boolean.FALSE);
            if (this.declareFoundFirst.equals(Boolean.FALSE) && ((entryPoints = this.metaData.getEntryPoints()) == null || entryPoints.size() == 0)) {
                this.metaData.addEntryPoint(this.previousPreviousToken);
            }
            ++this.procedureIsSubroutineCount;
            this.syntaxState = 18;
        }
    }

    private void processState_pliInclude() {
        if (this.currentToken.equals(")")) {
            this.ddName = "";
        } else if (this.currentToken.equals("(")) {
            if (this.ddName.length() == 0) {
                this.ddName = "SYSLIB";
            }
        } else if (this.ddName.length() == 0 && !this.previousToken.equals("(")) {
            this.ddName = this.currentToken;
        } else if (this.previousToken.equals(",")) {
            this.metaData.captureInclude(3, this.ddName.toUpperCase());
            this.ddName = this.currentToken;
        } else if (this.previousToken.equals("(")) {
            this.metaData.captureInclude(this.currentToken, this.ddName.toUpperCase(), this.debug);
        } else {
            this.metaData.captureInclude(3, this.ddName.toUpperCase());
        }
    }

    private void processState_pliProc() {
        if (this.currentToken.equals("(")) {
            if (this.previousToken.equalsIgnoreCase("RETURNS")) {
                --this.procedureIsSubroutineCount;
                ++this.procedureIsFunctionCount;
            }
        } else if (this.checkPercentInclude()) {
            this.syntaxState = 17;
        }
    }

    @Override
    public ClassifierMetaData processEndOfFile(int lineCount) {
        if (this.declareFoundFirst != null && this.declareFoundFirst.equals(Boolean.TRUE)) {
            this.metaData.setNonCommentBefore1st(0);
        }
        if (this.procedureIsFunctionCount != 0) {
            this.metaData.addNumValue(60, this.procedureIsFunctionCount);
        }
        if (this.procedureIsSubroutineCount != 0) {
            this.metaData.addNumValue(37, this.procedureIsSubroutineCount);
        }
        this.metaData.setBlanklines(this.blankLineCount + this.blankCount_PLI);
        this.metaData.setNonCommentLines(this.calculateSLOC(lineCount));
        this.metaData.setTotalLines(lineCount);
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        this.blankCount_PLI = 0;
        this.currentToken = "";
        this.ddName = "";
        this.declareFoundFirst = null;
        this.EXEC_CICS_flag = false;
        this.EXEC_SQL_flag = false;
        this.firstTokenOfStmt = null;
        this.inMacroDefinition = false;
        this.P_TokenState = (char)83;
        this.previousPreviousToken = "";
        this.previousToken = "";
        this.procedureIsFunctionCount = 0;
        this.procedureIsSubroutineCount = 0;
        this.reserveWordCount = 0;
        this.reserveWordCount_C = 0;
        this.reserveWordCount_COBOL = 0;
        this.reserveWordCount_SQL = 0;
        this.semicolonFound = false;
        this.sequentialCommentLines = 0;
        this.syntaxState = 16;
        this.identifierMode = (char)85;
        this.metaData = new ClassifierMetaData(this.scanProperties.getCaptureComments(), this.scanProperties.getCaptureEntryPoints(), this.scanProperties.getCaptureExecStatements(), this.scanProperties.getCaptureLiterals(), this.scanProperties.getCapturePictures(), this.scanProperties.getCaptureSymbolsReserved(), this.scanProperties.getCaptureSymbolsUserDefined());
    }

    protected boolean ProcessFunctionCode(char[] inputRecordCharArray, String languageHint) {
        if (this.identifierMode == 'U') {
            if (!languageHint.equals("PLI") && (inputRecordCharArray[0] == '/' && inputRecordCharArray[1] == '/' || inputRecordCharArray[0] == '>')) {
                this.rejectThisLanguageCd();
                return true;
            }
            return false;
        }
        return this.identifierMode != 'C';
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void processOneRecord(int recordCount, String literalRecord, String inputRecord, String languageHint) {
        inputRecordCharArray = inputRecord.toCharArray();
        if (inputRecordCharArray.length < this.marginsValue2) {
            inputRecord = String.valueOf(inputRecord) + StringUtils.repeat(" ", this.marginsValue2 - inputRecordCharArray.length);
            inputRecordCharArray = inputRecord.toCharArray();
        }
        if (this.checkAlternateFormsOfCopy(inputRecord)) {
            return;
        }
        if (this.ProcessFunctionCode(inputRecordCharArray, languageHint)) {
            return;
        }
        if (this.P_TokenState != 'Q' && (inputRecordTrimmed = StringUtils.trimEnd(inputRecord)).length() < this.marginsValue1) {
            if (this.P_TokenState == 'M') {
                this.metaData.incrementCommentLines();
            }
            return;
        }
        this.columnCurrentRecord = 1;
        this.ircaIndex = 0;
        if (this.marginsValue1 > 1 && (inputRecordCharArray[0] == '0' || inputRecordCharArray[0] == '-' || inputRecordCharArray[0] == '+' || inputRecordCharArray[0] == '1')) {
            inputRecordCharArray[0] = 32;
        }
        if ((inputRecordCharArray[0] != '*' && inputRecordCharArray[0] != '%' || this.columnCurrentRecord != 1) && this.P_TokenState != 'Q') {
            if (inputRecordCharArray[0] == ' ' || this.marginsValue1 == 1) {
                this.skipToFirstPLIcharacter(inputRecordCharArray);
            } else if ((this.P_TokenState != 'S' || inputRecordCharArray[0] != '/' || inputRecordCharArray[1] != '*') && this.P_TokenState != 'M') {
                if (this.marginsValue1 == 2) {
                    inputRecordCharArray[0] = 32;
                } else {
                    this.rejectThisLanguageCd();
                    return;
                }
            }
        }
        if (this.columnCurrentRecord <= this.marginsValue2 || this.ircaIndex + 1 != inputRecordCharArray.length && inputRecordCharArray[this.ircaIndex] != '\n') ** GOTO lbl30
        return;
lbl-1000:
        // 1 sources

        {
            this.moveToNextCharOnRecord();
lbl30:
            // 2 sources

            ** while (this.ircaIndex < inputRecordCharArray.length && this.columnCurrentRecord <= this.marginsValue2 && inputRecordCharArray[this.ircaIndex] == ' ' && inputRecordCharArray[this.ircaIndex] != '\n' && this.P_TokenState != 'Q')
        }
lbl31:
        // 1 sources

        if (this.ircaIndex == inputRecordCharArray.length || this.columnCurrentRecord > this.marginsValue2 || inputRecordCharArray[this.ircaIndex] == '\n') {
            ++this.blankCount_PLI;
            return;
        }
        completeRecordIsComment = true;
        P_IsDelimiter = false;
        returnNow = false;
        this.P_NewLine = true;
        if (this.P_TokenState == 'S') {
            this.tokenNumberOnLine = 0;
        }
        while (this.ircaIndex < inputRecordCharArray.length && this.columnCurrentRecord <= this.marginsValue2) {
            if (this.P_TokenState != 'M') {
                if (inputRecordCharArray[this.ircaIndex] == '*') {
                    if (this.columnCurrentRecord == 1 && this.ircaIndex + 8 < inputRecordCharArray.length && inputRecordCharArray[this.ircaIndex] == '*' && inputRecordCharArray[this.ircaIndex + 1] == 'P' && inputRecordCharArray[this.ircaIndex + 2] == 'R' && inputRecordCharArray[this.ircaIndex + 3] == 'O' && inputRecordCharArray[this.ircaIndex + 4] == 'C' && inputRecordCharArray[this.ircaIndex + 5] == 'E' && inputRecordCharArray[this.ircaIndex + 6] == 'S' && inputRecordCharArray[this.ircaIndex + 7] == 'S' && inputRecordCharArray[this.ircaIndex + 8] == ' ') {
                        inputRecordCharArray[this.ircaIndex] = 37;
                    } else {
                        P_IsDelimiter = true;
                    }
                } else {
                    P_IsDelimiter = this.isCharADelimiter(inputRecordCharArray[this.ircaIndex]);
                }
                if (inputRecordCharArray[this.ircaIndex] == '/' && this.ircaIndex + 1 < inputRecordCharArray.length && inputRecordCharArray[this.ircaIndex + 1] == '*' && this.P_TokenState != 'Q') {
                    this.P_TokenState = (char)77;
                    this.moveToNextCharOnRecord();
                    this.moveToNextCharOnRecord();
                    if (this.ircaIndex == inputRecordCharArray.length) break;
                }
                if (completeRecordIsComment && this.P_TokenState != 'M' && inputRecordCharArray[this.ircaIndex] != ' ') {
                    completeRecordIsComment = false;
                }
            }
            block0 : switch (this.P_TokenState) {
                case 'B': {
                    if (this.P_NewLine) {
                        this.TokenComplete(inputRecordCharArray);
                        break;
                    }
                    if (inputRecordCharArray[this.ircaIndex] == ' ') {
                        this.moveToNextCharOnRecord();
                        break;
                    }
                    this.TokenComplete(inputRecordCharArray);
                    break;
                }
                case 'C': {
                    if (this.P_NewLine) {
                        this.TokenComplete(inputRecordCharArray);
                        break;
                    }
                    if (inputRecordCharArray[this.ircaIndex] == ' ') {
                        this.P_TokenState = (char)66;
                        this.moveToNextCharOnRecord();
                        break;
                    }
                    if (P_IsDelimiter) {
                        this.TokenComplete(inputRecordCharArray);
                        break;
                    }
                    this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[this.ircaIndex];
                    this.moveToNextCharOnRecord();
                    break;
                }
                case 'E': {
                    if (inputRecordCharArray[this.ircaIndex] == this.P_StringDelimiter) {
                        this.moveToNextCharOnRecord();
                        this.P_TokenState = (char)81;
                        break;
                    }
                    this.TokenComplete(inputRecordCharArray);
                    break;
                }
                case 'M': {
                    if (inputRecordCharArray[this.ircaIndex] == '*' && this.ircaIndex + 1 < inputRecordCharArray.length && inputRecordCharArray[this.ircaIndex + 1] == '/') {
                        this.score += 5;
                        this.moveToNextCharOnRecord();
                        this.moveToNextCharOnRecord();
                        this.TokenComplete(inputRecordCharArray);
                        this.sequentialCommentLines = 0;
                        break;
                    }
                    this.moveToNextCharOnRecord();
                    break;
                }
                case 'Q': {
                    if (inputRecordCharArray[this.ircaIndex] == this.P_StringDelimiter) {
                        this.P_TokenState = (char)69;
                    }
                    if (this.ircaIndex + 1 >= this.marginsValue1) {
                        this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[this.ircaIndex];
                    }
                    this.moveToNextCharOnRecord();
                    break;
                }
                case 'S': {
                    switch (inputRecordCharArray[this.ircaIndex]) {
                        case ' ': {
                            this.moveToNextCharOnRecord();
                            break block0;
                        }
                        case 'X': {
                            this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[this.ircaIndex];
                            this.moveToNextCharOnRecord();
                            this.P_TokenState = (char)88;
                            break block0;
                        }
                        case '\"': 
                        case '\'': {
                            this.P_StringDelimiter = inputRecordCharArray[this.ircaIndex];
                            this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[this.ircaIndex];
                            this.moveToNextCharOnRecord();
                            this.P_TokenState = (char)81;
                            break block0;
                        }
                    }
                    if (P_IsDelimiter) {
                        this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[this.ircaIndex];
                        this.moveToNextCharOnRecord();
                        this.TokenComplete(inputRecordCharArray);
                        break;
                    }
                    this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[this.ircaIndex];
                    this.moveToNextCharOnRecord();
                    this.P_TokenState = (char)67;
                    break;
                }
                case 'X': {
                    if (inputRecordCharArray[this.ircaIndex] == ' ') {
                        this.moveToNextCharOnRecord();
                        this.P_TokenState = (char)66;
                        break;
                    }
                    if (inputRecordCharArray[this.ircaIndex] == '\"' || inputRecordCharArray[this.ircaIndex] == '\'') {
                        this.P_StringDelimiter = inputRecordCharArray[this.ircaIndex];
                        this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[this.ircaIndex];
                        this.moveToNextCharOnRecord();
                        this.P_TokenState = (char)81;
                        break;
                    }
                    if (P_IsDelimiter) {
                        this.TokenComplete(inputRecordCharArray);
                        break;
                    }
                    this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[this.ircaIndex];
                    this.moveToNextCharOnRecord();
                    this.P_TokenState = (char)67;
                    break;
                }
            }
            if (returnNow) break;
            if (this.currentToken.length() >= 1024) {
                this.TokenComplete(inputRecordCharArray);
            }
            this.P_NewLine = false;
        }
        if (returnNow) {
            return;
        }
        if (completeRecordIsComment) {
            ++this.sequentialCommentLines;
            this.score += 5;
            this.metaData.incrementCommentLines();
        }
    }

    private void skipToFirstPLIcharacter(char[] inputRecordCharArray) {
        while (this.ircaIndex < inputRecordCharArray.length && this.columnCurrentRecord < this.marginsValue1 && this.columnCurrentRecord <= this.marginsValue2 && inputRecordCharArray[this.ircaIndex] != '\n') {
            this.moveToNextCharOnRecord();
        }
    }

    @Override
    protected boolean checkForBlankLine(String iRecord) {
        if (this.P_TokenState != 'Q') {
            return super.checkForBlankLine(iRecord);
        }
        return false;
    }
}

