/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.reservedWords.ReservedWordsJAVA;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierByRecord;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;

public class ClassifierJava
extends ClassifierByRecord {
    private static final char CHAR_START = '\'';
    private static final char STRING_START = '\"';
    private static final int TOKEN_STATE_BLANK = 1;
    private static final int TOKEN_STATE_EMBEDDED_QUOTE = 2;
    private static final int TOKEN_STATE_HEX_LITERAL = 3;
    private static final int TOKEN_STATE_INITIAL = 4;
    private static final int TOKEN_STATE_LITERAL = 5;
    private static final int TOKEN_STATE_NORMAL = 6;
    private static final String BRACKET_CHARS = "{[()]}";
    private static final String COMMENT_END = "*/";
    private static final String COMMENT_START = "/*";
    private static final String OPERATOR_CHARS = "-+*/<>!~%^&|=";
    private static final String SEMI_COLON = ";";
    private static final String SEQUENCE_CHARS = ",";
    private static final String SINGLE_COMMENT = "//";
    private boolean newLine = false;
    private boolean packageFound = false;
    private int tokenState = 4;
    private String currentChar = "";
    private String inComment = "";
    private String stringDelimiter = "";

    public ClassifierJava(ScanProperties scanProperties) {
        super(scanProperties);
    }

    private void AccumulatePointsForTheScore() {
        ++this.score;
        ++this.reserveWordCount;
    }

    private void addToCurrentToken() {
        this.currentToken = String.valueOf(this.currentToken) + this.currentChar;
    }

    private void CompleteToken() {
        this.tokenNumberOnLine = (short)(this.tokenNumberOnLine + 1);
        this.scoreCompletedToken();
        this.previousToken = this.currentToken;
        this.currentToken = "";
        this.tokenState = 4;
    }

    @Override
    protected String getEndExecToken() {
        return SEMI_COLON;
    }

    @Override
    public String getLanguageCd() {
        return "JAVA";
    }

    @Override
    public String getLanguageDescription() {
        return "Java";
    }

    @Override
    public int getLanguageId() {
        return 13;
    }

    @Override
    public void isScoreBad(int iLineCount, String languageHint) {
        if (!this.packageFound) {
            this.score = 0;
        }
    }

    private void scoreCompletedToken() {
        if (this.currentToken.charAt(0) == '\'' || this.currentToken.charAt(0) == '\"' || this.currentToken.equals("true") || this.currentToken.equals("false") || this.currentToken.equals("null") || StringUtils.isNumeric(this.currentToken) && !this.currentToken.equals("-")) {
            this.metaData.addLiteral(this.currentToken);
        } else if (!(this.currentToken.contains(BRACKET_CHARS) || this.currentToken.contains(OPERATOR_CHARS) || this.currentToken.contains(SEMI_COLON))) {
            if (ReservedWordsJAVA.contains(this.currentToken)) {
                this.processReservedWord();
            } else {
                this.processNonReservedWord();
            }
        }
    }

    private void processNonReservedWord() {
        this.metaData.addSymbolUserDefined(this.currentToken);
        if (this.previousToken.equals("import")) {
            this.metaData.captureInclude(12, this.currentToken);
        }
    }

    private void processReservedWord() {
        this.metaData.addSymbolReserved(this.currentToken);
        this.AccumulatePointsForTheScore();
        if (this.currentToken.equals("package")) {
            this.packageFound = true;
        }
    }

    @Override
    public boolean getIgnoreCase() {
        return false;
    }

    @Override
    public ClassifierMetaData processEndOfFile(int iLineCount) {
        this.metaData.setTotalLines(iLineCount);
        this.metaData.setBlanklines(this.blankLineCount);
        this.metaData.setNonCommentLines(iLineCount - this.blankLineCount - this.getCommentCount());
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        this.currentToken = "";
        this.identifierMode = (char)85;
        this.inComment = null;
        this.metaData = new ClassifierMetaData(this.scanProperties.getCaptureComments(), this.scanProperties.getCaptureEntryPoints(), this.scanProperties.getCaptureExecStatements(), this.scanProperties.getCaptureLiterals(), this.scanProperties.getCapturePictures(), this.scanProperties.getCaptureSymbolsReserved(), this.scanProperties.getCaptureSymbolsUserDefined());
        this.previousToken = "";
        this.reserveWordCount = 0;
        this.syntaxState = 16;
        this.tokenState = 4;
    }

    @Override
    public void processOneRecord(int iInputRecordCount, String literalRecord, String record, String languageHint) {
        while (record.length() != 0) {
            this.currentChar = record.substring(0, 1);
            if (!this.currentChar.equals(" ") && !this.currentChar.equals("\t")) break;
            record = record.substring(1);
        }
        if (record.length() == 0) {
            return;
        }
        this.newLine = true;
        this.tokenNumberOnLine = 0;
        while (record.length() != 0) {
            this.currentChar = record.substring(0, 1);
            if (this.inComment != null) {
                if (this.inComment.equals(COMMENT_START)) {
                    if (record.startsWith(COMMENT_END)) {
                        record = record.substring(COMMENT_END.length());
                        this.inComment = COMMENT_END;
                        continue;
                    }
                    record = record.substring(1);
                    continue;
                }
                if (!this.inComment.equals(COMMENT_END)) {
                    record = record.substring(1);
                    continue;
                }
            } else {
                if (record.startsWith(COMMENT_START)) {
                    this.inComment = COMMENT_START;
                    record = record.substring(COMMENT_START.length());
                    continue;
                }
                if (record.startsWith(SINGLE_COMMENT)) {
                    this.inComment = SINGLE_COMMENT;
                    record = record.substring(SINGLE_COMMENT.length());
                    continue;
                }
            }
            boolean isDelimiter = BRACKET_CHARS.contains(this.currentChar) || OPERATOR_CHARS.contains(this.currentChar) || SEMI_COLON.contains(this.currentChar) || SEQUENCE_CHARS.contains(this.currentChar) || this.currentChar.equals(".") && !this.previousToken.equals("import") && !this.previousToken.equals("package");
            boolean tokenComplete = false;
            switch (this.tokenState) {
                case 1: {
                    if (!this.newLine && this.currentChar.equals(" ") && this.currentChar.equals("\t")) break;
                    tokenComplete = true;
                    break;
                }
                case 6: {
                    if (this.newLine) {
                        tokenComplete = true;
                        break;
                    }
                    if (this.currentChar.equals(" ") || this.currentChar.equals("\t")) {
                        this.tokenState = 1;
                        break;
                    }
                    if (isDelimiter) {
                        tokenComplete = true;
                        break;
                    }
                    this.addToCurrentToken();
                    break;
                }
                case 2: {
                    if (this.currentChar.equals(this.stringDelimiter)) {
                        this.tokenState = 5;
                        break;
                    }
                    tokenComplete = true;
                    break;
                }
                case 5: {
                    if (this.currentChar.equals(this.stringDelimiter)) {
                        this.tokenState = 2;
                    }
                    this.addToCurrentToken();
                    break;
                }
                case 4: {
                    if (this.currentChar.equals("X")) {
                        this.currentToken = String.valueOf(this.currentToken) + record.substring(0, 1);
                        this.tokenState = 3;
                        break;
                    }
                    if (this.currentChar.charAt(0) == '\'' || this.currentChar.charAt(0) == '\"') {
                        this.stringDelimiter = this.currentChar;
                        this.addToCurrentToken();
                        this.tokenState = 5;
                        break;
                    }
                    if (this.currentChar.equals(" ") || this.currentChar.equals("\t")) break;
                    this.addToCurrentToken();
                    if (isDelimiter) {
                        record = record.substring(1);
                        tokenComplete = true;
                        break;
                    }
                    this.tokenState = 6;
                    break;
                }
                case 3: {
                    if (this.currentChar.equals(" ") || this.currentChar.equals("\t")) {
                        this.tokenState = 1;
                        break;
                    }
                    if (this.currentChar.equals(Character.valueOf('\'')) || this.currentChar.equals(Character.valueOf('\"'))) {
                        this.stringDelimiter = this.currentChar;
                        this.addToCurrentToken();
                        this.tokenState = 5;
                        break;
                    }
                    if (isDelimiter) {
                        tokenComplete = true;
                        break;
                    }
                    this.addToCurrentToken();
                    this.tokenState = 6;
                    break;
                }
            }
            if (tokenComplete || this.currentToken.length() >= 255) {
                this.CompleteToken();
                if (this.identifierMode == 'R') {
                    break;
                }
            } else {
                if (record.length() == 0) break;
                record = record.substring(1);
            }
            this.newLine = false;
        }
        if (this.identifierMode == 'R') {
            return;
        }
        if (this.inComment != null) {
            if (this.tokenNumberOnLine == 0 && (this.tokenState == 2 || this.tokenState == 3 || this.tokenState == 4 || this.tokenState == 5)) {
                this.metaData.incrementCommentLines();
                this.score += 5;
            }
            if (this.inComment == COMMENT_END || this.inComment == SINGLE_COMMENT) {
                this.inComment = null;
            }
        }
        if (this.tokenState != 4) {
            this.CompleteToken();
        }
    }
}

